/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.Padding;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class SSL3Padding
extends Padding {
    public static final String ALGORITHM_NAME = "SSL3Padding";

    public SSL3Padding(int n) throws NoSuchPaddingException {
        super(ALGORITHM_NAME, n);
        if (n < 1 || n > 255) {
            throw new NoSuchPaddingException("Invalid block size");
        }
    }

    public int pad(byte[] byArray, int n, int n2) throws ShortBufferException {
        int n3 = this.if - n2 % this.if;
        if (byArray.length - (n += n2) < n3) {
            throw new ShortBufferException("Output buffer is too small");
        }
        byte by = (byte)(n3 - 1);
        for (int k = 0; k < n3; ++k) {
            byArray[n + k] = by;
        }
        return n3;
    }

    public int unpad(byte[] byArray, int n, int n2) throws BadPaddingException, ShortBufferException {
        if (n2 == 0) {
            return 0;
        }
        int n3 = (byArray[n + n2 - 1] & 0xFF) + 1;
        if (n3 < 1 || n3 > this.if) {
            throw new BadPaddingException("Invalid pad size");
        }
        if (n2 < n3) {
            throw new ShortBufferException("Output buffer too small");
        }
        byte by = (byte)(n3 - 1);
        for (int k = n + n2 - n3; k < n + n2; ++k) {
            if (byArray[k] == by) continue;
            throw new BadPaddingException("Invalid pad data");
        }
        return n3;
    }
}

