/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import java.util.Arrays;

public class DESXKeySpec
implements KeySpec,
Zeroizeable {
    private byte[] D;
    private static final int F = 24;
    private boolean E = false;

    public DESXKeySpec(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESXKeySpec(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null) {
            throw new InvalidKeyException("Need key data");
        }
        if (byArray.length - n < 24) {
            throw new InvalidKeyException("DESX key too short");
        }
        this.D = new byte[24];
        System.arraycopy(byArray, n, this.D, 0, 24);
    }

    public byte[] getKey() {
        byte[] byArray = new byte[24];
        System.arraycopy(this.D, 0, byArray, 0, 24);
        return byArray;
    }

    public boolean isZeroized() {
        return this.E;
    }

    public boolean testZeroizationState() {
        return this.E;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.D, (byte)0);
        this.E = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return Conversion.OS2Hex((byte[])this.D, (int)2);
    }
}

