/*
 * Decompiled with CFR 0.152.
 */
package javax.security.spec;

import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class SharedInfoParameterSpec
implements AlgorithmParameterSpec,
Zeroizeable {
    private byte[][] B = null;
    private boolean C = false;

    public SharedInfoParameterSpec(byte[][] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        this.B = new byte[byArray.length][];
        for (int k = 0; k < byArray.length; ++k) {
            if (byArray[k] == null) continue;
            this.B[k] = new byte[byArray[k].length];
            System.arraycopy(byArray[k], 0, this.B[k], 0, byArray[k].length);
        }
    }

    public SharedInfoParameterSpec(byte[][] byArray, int[] nArray, int[] nArray2) {
        if (byArray == null || nArray == null || nArray2 == null) {
            throw new IllegalArgumentException("sharedInfo is null.");
        }
        if (byArray.length != nArray.length || nArray.length != nArray2.length) {
            throw new IllegalArgumentException("different length arguments");
        }
        this.B = new byte[byArray.length][];
        for (int k = 0; k < byArray.length; ++k) {
            if (byArray[k] == null) continue;
            if (nArray[k] + nArray2[k] > byArray[k].length) {
                throw new IllegalArgumentException("wrong length arguments.");
            }
            this.B[k] = new byte[byArray[k].length];
            System.arraycopy(byArray[k], nArray[k], this.B[k], 0, nArray2[k]);
        }
    }

    public byte[][] getSharedInfo() {
        byte[][] byArrayArray = new byte[this.B.length][];
        for (int k = 0; k < this.B.length; ++k) {
            if (this.B[k] == null) continue;
            byArrayArray[k] = new byte[this.B[k].length];
            System.arraycopy(this.B[k], 0, byArrayArray[k], 0, byArrayArray[k].length);
        }
        return byArrayArray;
    }

    public byte[] getSharedInfo(int n) {
        if (n < 0 || n > this.B.length) {
            throw new IllegalArgumentException("index incorrect.");
        }
        if (this.B[n] == null) {
            return null;
        }
        byte[] byArray = new byte[this.B[n].length];
        System.arraycopy(this.B[n], 0, byArray, 0, byArray.length);
        return byArray;
    }

    public boolean isZeroized() {
        return this.C;
    }

    public boolean testZeroizationState() {
        return this.C;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        for (int k = 0; k < this.B.length; ++k) {
            if (this.B[k] == null) continue;
            Arrays.fill(this.B[k], (byte)0);
        }
        this.C = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        for (int k = 0; k < this.B.length; ++k) {
            stringBuffer.append(Integer.toString(k)).append(" = ");
            if (this.B[k] != null) {
                stringBuffer.append(Conversion.OS2Hex((byte[])this.B[k], (int)2)).append(" ");
                continue;
            }
            stringBuffer.append("null ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

