/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.tds.DataFormat;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.tds.Token;
import com.sybase.jdbc4.utils.Debug;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowFormatToken
extends Token
implements ResultSetMetaData {
    public static final int IMAGE_COLUMN_DISPLAY_SIZE = 1;
    protected int _numColumns;
    protected long _length;
    protected int _numUserColumns;
    protected int[] _userColumnMap;
    protected DataFormat[] _column;
    protected TdsProtocolContext _tpc = null;

    public RowFormatToken(int n2) throws SQLException {
        this._numUserColumns = this._numColumns = n2;
        this._column = new DataFormat[this._numColumns];
    }

    public RowFormatToken() {
        this._numColumns = 0;
        this._column = new DataFormat[this._numColumns];
    }

    public RowFormatToken(TdsInputStream tdsInputStream) throws IOException {
        this.readLength(tdsInputStream);
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public RowFormatToken(TdsInputStream tdsInputStream, long l2) throws IOException {
        this._length = l2;
        this._numColumns = tdsInputStream.readShort();
        this.addDataFormats(tdsInputStream, this._numColumns);
    }

    public long getRowFmtLength() {
        return this._length;
    }

    public void addDataFormats(TdsInputStream tdsInputStream, int n2) throws IOException {
        this._column = new DataFormat[n2];
        this._numUserColumns = 0;
        this.prepareUserColMap(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this._column[i2] = this.dataFormatFactory(tdsInputStream);
            if ((this._column[i2]._status & 1) != 0) continue;
            this._userColumnMap[this._numUserColumns] = i2;
            ++this._numUserColumns;
        }
    }

    protected DataFormat dataFormatFactory(TdsInputStream tdsInputStream) throws IOException {
        return new DataFormat(tdsInputStream);
    }

    protected long readLength(TdsInputStream tdsInputStream) throws IOException {
        long l2;
        this._length = l2 = (long)tdsInputStream.readShort();
        return l2;
    }

    protected void prepareUserColMap(int n2) {
        this._userColumnMap = new int[n2];
    }

    protected DataFormat getDataFormat(int n2) throws SQLException {
        return this._column[n2];
    }

    protected String getName(int n2) throws SQLException {
        return this.getDataFormat(n2).getName();
    }

    protected String getLabel(int n2) throws SQLException {
        return this.getName(n2);
    }

    protected int getStatus(int n2) throws SQLException {
        return this.getDataFormat((int)n2)._status;
    }

    protected int getDatatype(int n2) throws SQLException {
        return this.getDataFormat((int)n2)._datatype;
    }

    public int getLength(int n2) throws SQLException {
        return this.getDataFormat((int)n2)._length;
    }

    private boolean v() throws SQLException {
        SybProperty sybProperty = ((Tds)this._tpc._protocol).getSybProperty();
        return sybProperty.getBoolean(39);
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        switch (this.getDataFormat((int)n3)._datatype) {
            case 48: {
                return 3;
            }
            case 52: 
            case 65: {
                return 5;
            }
            case 56: 
            case 66: {
                return 10;
            }
            case 67: {
                return 20;
            }
            case 191: {
                return 19;
            }
            case 38: 
            case 68: {
                switch (this.getDataFormat((int)n3)._length) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 5;
                    }
                    case 4: {
                        return 10;
                    }
                    case 8: {
                        if (this.getDataFormat((int)n3)._datatype == 38) {
                            return 19;
                        }
                        return 20;
                    }
                }
                return 10;
            }
            case 59: {
                return 7;
            }
            case 62: {
                return 15;
            }
            case 109: {
                switch (this.getDataFormat((int)n3)._length) {
                    case 4: {
                        return 7;
                    }
                    case 8: {
                        return 15;
                    }
                }
                return 7;
            }
            case 122: {
                return 10;
            }
            case 60: {
                return 19;
            }
            case 110: {
                switch (this.getDataFormat((int)n3)._length) {
                    case 4: {
                        return 10;
                    }
                    case 8: {
                        return 19;
                    }
                }
                return 19;
            }
            case 51: 
            case 61: 
            case 147: {
                return 3;
            }
            case 187: 
            case 188: {
                return 6;
            }
            case 111: {
                if (this.getDataFormat((int)n3)._length == 8 && this.getDataFormat((int)n3)._usertype != 50) {
                    return 3;
                }
                return 0;
            }
        }
        return this.getDataFormat((int)n3)._precision;
    }

    @Override
    public int getScale(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        return this.getDataFormat((int)n3)._scale;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this._numUserColumns;
    }

    @Override
    public boolean isAutoIncrement(int n2) throws SQLException {
        return (this.getDataFormat((int)this.mapColumn((int)n2))._status & 0x40) != 0;
    }

    @Override
    public boolean isCaseSensitive(int n2) throws SQLException {
        return ((SybDatabaseMetaData)this._tpc._conn.getMetaData()).isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int n2) throws SQLException {
        Object var2_2 = null;
        Object var3_3 = null;
        int n3 = RowFormatToken.sqlTypeToJdbcType(this.getDataFormat(--n2), false);
        return ((Tds)this._tpc._protocol).isTypeSearchable(n3);
    }

    @Override
    public boolean isCurrency(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        switch (this.getDataFormat((int)n3)._datatype) {
            case 60: 
            case 110: 
            case 122: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        return (this.getDataFormat((int)n3)._status & 0x20) == 0 ? 0 : 1;
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        switch (this.getDataFormat((int)n3)._datatype) {
            case 38: 
            case 48: 
            case 52: 
            case 56: 
            case 59: 
            case 60: 
            case 62: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 122: 
            case 191: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getColumnDisplaySize(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        switch (this.getDataFormat((int)n3)._datatype) {
            case 48: {
                return 3;
            }
            case 52: 
            case 65: {
                return 6;
            }
            case 56: 
            case 66: {
                return 11;
            }
            case 67: 
            case 191: {
                return 20;
            }
            case 38: 
            case 68: {
                switch (this.getDataFormat((int)n3)._length) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 6;
                    }
                    case 4: {
                        return 11;
                    }
                    case 8: {
                        return 20;
                    }
                }
                return 11;
            }
            case 59: {
                return 46;
            }
            case 62: {
                return 85;
            }
            case 109: {
                switch (this.getDataFormat((int)n3)._length) {
                    case 4: {
                        return 46;
                    }
                    case 8: {
                        return 85;
                    }
                }
                return 46;
            }
            case 58: 
            case 61: 
            case 111: {
                return 25;
            }
            case 187: {
                return 29;
            }
            case 188: {
                return 15;
            }
            case 49: 
            case 123: {
                return 10;
            }
            case 51: 
            case 147: {
                return 8;
            }
            case 122: {
                return 12;
            }
            case 60: {
                return 21;
            }
            case 110: {
                switch (this.getDataFormat((int)n3)._length) {
                    case 4: {
                        return 12;
                    }
                    case 8: {
                        return 21;
                    }
                }
                return 21;
            }
            case 106: 
            case 108: {
                return this.getDataFormat((int)n3)._precision + 2;
            }
            case 37: 
            case 45: {
                return this.getDataFormat((int)n3)._length * 2;
            }
            case 225: {
                if (this.getDataFormat((int)n3)._usertype == 34 || this.getDataFormat((int)n3)._usertype == 35) {
                    return this.getDataFormat((int)n3)._length / 2;
                }
                return this.getDataFormat((int)n3)._length * 2;
            }
            case 34: 
            case 36: {
                return 1;
            }
            case 35: 
            case 39: 
            case 47: 
            case 50: 
            case 103: 
            case 104: 
            case 175: {
                return this.getDataFormat((int)n3)._length;
            }
            case 174: {
                return this.getDataFormat((int)n3)._length / 2;
            }
        }
        ErrorMessage.raiseError("JZ0P4");
        return -1;
    }

    @Override
    public String getColumnLabel(int n2) throws SQLException {
        return this.getColumnName(n2);
    }

    @Override
    public String getColumnName(int n2) throws SQLException {
        return this.getName(this.mapColumn(n2));
    }

    @Override
    public String getSchemaName(int n2) throws SQLException {
        this.mapColumn(n2);
        if (!this.v()) {
            Debug.notImplemented(this, "getSchemaName");
        }
        return "";
    }

    @Override
    public String getTableName(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        switch (this.getDataFormat((int)n3)._datatype) {
            case 34: 
            case 35: 
            case 174: {
                return this.getDataFormat((int)n3)._tableName;
            }
        }
        if (!this.v()) {
            Debug.notImplemented(this, "getTableName");
        }
        return "";
    }

    @Override
    public String getCatalogName(int n2) throws SQLException {
        this.mapColumn(n2);
        if (!this.v()) {
            Debug.notImplemented(this, "getCatalogName");
        }
        return "";
    }

    @Override
    public int getColumnType(int n2) throws SQLException {
        return RowFormatToken.sqlTypeToJdbcType(this.getDataFormat(this.mapColumn(n2)), false);
    }

    @Override
    public String getColumnTypeName(int n2) throws SQLException {
        int n3 = this.mapColumn(n2);
        int n4 = this.getDataFormat((int)n3)._datatype;
        n4 = this.getColumnDataType(n4, n3);
        return ((Tds)this._tpc._protocol).getColumnTypeName(n4, this._column[n3]._usertype);
    }

    protected int getColumnDataType(int n2, int n3) throws SQLException {
        switch (n2) {
            case 37: 
            case 38: 
            case 39: 
            case 68: 
            case 109: 
            case 110: 
            case 111: 
            case 175: 
            case 225: {
                n2 = RowFormatToken.sqlTypeToJdbcType(this._column[n3], true);
                break;
            }
        }
        return n2;
    }

    @Override
    public boolean isReadOnly(int n2) throws SQLException {
        return (this.getDataFormat((int)this.mapColumn((int)n2))._status & 0x10) == 0;
    }

    @Override
    public boolean isWritable(int n2) throws SQLException {
        return (this.getDataFormat((int)this.mapColumn((int)n2))._status & 0x10) != 0;
    }

    @Override
    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.mapColumn(n2);
        return false;
    }

    @Override
    public String getColumnClassName(int n2) throws SQLException {
        return this._column[this.mapColumn((int)n2)]._className;
    }

    protected int mapColumn(int n2) throws SQLException {
        if (n2 > this._numUserColumns || n2 < 1) {
            ErrorMessage.raiseError("JZ008", "" + n2);
        }
        return this._userColumnMap[--n2];
    }

    protected static int sqlTypeToJdbcType(DataFormat dataFormat, boolean bl) {
        switch (dataFormat._datatype) {
            case 50: {
                return -7;
            }
            case 68: {
                switch (dataFormat._length) {
                    case 1: {
                        return bl ? 48 : -6;
                    }
                    case 2: {
                        return bl ? 65 : 5;
                    }
                    case 4: {
                        return bl ? 66 : 4;
                    }
                    case 8: {
                        return bl ? 67 : -5;
                    }
                }
                return 1111;
            }
            case 38: {
                switch (dataFormat._length) {
                    case 1: {
                        if (dataFormat._usertype == 16) {
                            return bl ? 50 : -7;
                        }
                        return bl ? 48 : -6;
                    }
                    case 2: {
                        return bl ? 52 : 5;
                    }
                    case 4: {
                        return bl ? 56 : 4;
                    }
                    case 8: {
                        return bl ? 191 : -5;
                    }
                }
                return 1111;
            }
            case 48: {
                return -6;
            }
            case 52: 
            case 65: {
                return 5;
            }
            case 56: 
            case 66: {
                return 4;
            }
            case 67: 
            case 191: {
                return -5;
            }
            case 109: {
                switch (dataFormat._length) {
                    case 4: {
                        return bl ? 59 : 7;
                    }
                    case 8: {
                        return bl ? 62 : 8;
                    }
                }
                return 1111;
            }
            case 59: {
                return 7;
            }
            case 62: {
                return 8;
            }
            case 60: 
            case 110: 
            case 122: {
                if (bl) {
                    return dataFormat._length == 4 ? 122 : 60;
                }
                return 3;
            }
            case 106: 
            case 108: {
                if (dataFormat._usertype == 26) {
                    return 3;
                }
                return 2;
            }
            case 39: {
                if (dataFormat._usertype == 1) {
                    return bl ? 47 : 1;
                }
                if (dataFormat._usertype == 25) {
                    return bl ? 39 : -9;
                }
                return bl ? 39 : 12;
            }
            case 47: {
                return dataFormat._usertype == 24 ? -15 : 1;
            }
            case 175: {
                return bl ? 39 : -1;
            }
            case 35: 
            case 174: {
                return -1;
            }
            case 111: {
                switch (dataFormat._length) {
                    case 4: {
                        return bl ? 58 : 93;
                    }
                    case 8: {
                        return bl ? 61 : 93;
                    }
                }
                return 1111;
            }
            case 58: 
            case 61: 
            case 187: {
                return 93;
            }
            case 49: 
            case 123: {
                return 91;
            }
            case 51: 
            case 147: 
            case 188: {
                return 92;
            }
            case 45: {
                return -2;
            }
            case 37: {
                if (dataFormat._usertype == 3) {
                    return bl ? 45 : -2;
                }
                return bl ? 37 : -3;
            }
            case 225: {
                if (dataFormat._usertype == 34) {
                    return 1;
                }
                if (dataFormat._usertype == 35) {
                    return 12;
                }
                return bl ? 37 : -4;
            }
            case 34: {
                return -4;
            }
            case 31: 
            case 103: 
            case 104: {
                return 1111;
            }
            case 36: 
            case 255: {
                switch (dataFormat._blobType) {
                    case 1: 
                    case 2: {
                        return 2000;
                    }
                    case 3: 
                    case 5: {
                        return -1;
                    }
                    case 4: {
                        return -4;
                    }
                }
            }
        }
        return 1111;
    }

    protected void setPc(TdsProtocolContext tdsProtocolContext) {
        this._tpc = tdsProtocolContext;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    public Object unwrap(Class clazz) throws SQLException {
        Object var2_2 = null;
        try {
            var2_2 = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName());
        }
        return var2_2;
    }
}

