/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.discovery;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.Socket;
import java.rmi.MarshalledObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.jini.core.lookup.ServiceRegistrar;

public class LookupLocator
implements Serializable {
    private static final long serialVersionUID = 1448769379829432795L;
    private static final short discoveryPort = 4160;
    private static final int protoVersion = 1;
    protected String host;
    protected int port;
    static final int defaultTimeout = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            int n = 60000;
            try {
                return Integer.getInteger("net.jini.discovery.timeout", n);
            }
            catch (SecurityException securityException) {
                return new Integer(n);
            }
        }
    });

    public LookupLocator(String string) throws MalformedURLException {
        block8: {
            if (!string.toLowerCase().startsWith("jini://")) {
                throw new MalformedURLException("not a jini-scheme URL");
            }
            int n = string.length();
            char c = '\u0000';
            int n2 = 7;
            while (n2 < n && (c = string.charAt(n2)) != ':' && c != '/') {
                ++n2;
            }
            if (n2 == 7) {
                throw new MalformedURLException("empty hostname");
            }
            this.host = string.substring(7, n2);
            if (c == ':') {
                int n3 = n2 + 1;
                while (n3 < n && (c = string.charAt(n3)) != '/') {
                    ++n3;
                }
                try {
                    this.port = Integer.parseInt(string.substring(n2 + 1, n3));
                    if (this.port <= 0 || this.port >= 65536) {
                        throw new MalformedURLException("port number out of range");
                    }
                    break block8;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new MalformedURLException("malformed port number");
                }
            }
            this.port = 4160;
        }
    }

    public LookupLocator(String string, int n) {
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (n <= 0 || n >= 65536) {
            throw new IllegalArgumentException("port number out of range");
        }
        this.host = string;
        this.port = n;
    }

    public boolean equals(Object object) {
        if (object instanceof LookupLocator) {
            LookupLocator lookupLocator = (LookupLocator)object;
            return this.port == lookupLocator.port && this.host.equalsIgnoreCase(lookupLocator.host);
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServiceRegistrar getRegistrar() throws IOException, ClassNotFoundException {
        return this.getRegistrar(defaultTimeout);
    }

    public ServiceRegistrar getRegistrar(int n) throws IOException, ClassNotFoundException {
        ServiceRegistrar serviceRegistrar;
        Socket socket = new Socket(this.host, this.port);
        try {
            socket.setSoTimeout(n);
            DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
            dataOutputStream.writeInt(1);
            dataOutputStream.flush();
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            ServiceRegistrar serviceRegistrar2 = (ServiceRegistrar)((MarshalledObject)objectInputStream.readObject()).get();
            int n2 = objectInputStream.readInt();
            while (--n2 >= 0) {
                objectInputStream.readUTF();
            }
            serviceRegistrar = serviceRegistrar2;
            Object var5_8 = null;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {}
        return serviceRegistrar;
    }

    public int hashCode() {
        return this.host.toLowerCase().hashCode() ^ this.port;
    }

    public String toString() {
        if (this.port != 4160) {
            return "jini://" + this.host + ":" + this.port + "/";
        }
        return "jini://" + this.host + "/";
    }
}

