/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.MLLogFileViewerMessages;
import com.sybase.util.CollapsiblePanel;
import com.sybase.util.FontHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

abstract class BasePanel
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener,
ComponentListener,
DocumentListener {
    private static boolean _reportBadLogFiles = true;
    protected ResourceBundle _bundle = MLLogFileViewerMessages.getInstance();
    private CollapsiblePanel _cp = new CollapsiblePanel(this._bundle.getString("1"), null);
    private SybCheckBox _showErrors;
    private SybCheckBox _showWarnings;
    private SybCheckBox _showInformation;
    private SybCheckBox _startAt;
    private JSpinner _startTime;
    private SybCheckBox _endAt;
    private JSpinner _endTime;
    private JTextField _remoteID;
    private JTextField _userName;
    private JTextField _containing;
    private SybButton _apply;

    BasePanel(File[] fileArray) {
        this._cp.add((JComponent)this.createFilterPanel());
        JPanel jPanel = this.createContentPanel(fileArray);
        JPanel jPanel2 = UIUtils.createExplorerBar();
        jPanel2.setLayout(new GridBagLayout());
        this.setInitialValues();
        this.enableControls();
        this.installEventListeners();
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(new GridBagLayout());
        jPanel2.add((Component)this._cp, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 10, 10, 10), 0, 0));
        jPanel2.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, insets, 0, 0));
    }

    protected abstract JPanel createContentPanel(File[] var1);

    private JPanel createFilterPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Insets insets = new Insets(0, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 5, 0);
        Insets insets3 = new Insets(0, 5, 5, 0);
        this._showErrors = new SybCheckBox(this._bundle.getString("2"));
        this._showWarnings = new SybCheckBox(this._bundle.getString("3"));
        this._showInformation = new SybCheckBox(this._bundle.getString("4"));
        this._showErrors.setOpaque(false);
        this._showWarnings.setOpaque(false);
        this._showInformation.setOpaque(false);
        jPanel.add((Component)this._showErrors, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this._showWarnings, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this._showInformation, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this._startAt = new SybCheckBox(this._bundle.getString("6"));
        this._startTime = new JSpinner(new SpinnerDateModel());
        this._startTime.setEditor(new JSpinner.DateEditor(this._startTime, "yyyy-MM-dd HH:mm:ss"));
        this._endAt = new SybCheckBox(this._bundle.getString("7"));
        this._endTime = new JSpinner(new SpinnerDateModel());
        this._endTime.setEditor(new JSpinner.DateEditor(this._endTime, "yyyy-MM-dd HH:mm:ss"));
        this._startAt.setOpaque(false);
        this._endAt.setOpaque(false);
        jPanel.add((Component)this._startAt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this._startTime, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this._endAt, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        jPanel.add((Component)this._endTime, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this._containing = new JTextField(20);
        new FontHelper((JTextComponent)this._containing);
        SybLabel sybLabel = new SybLabel(this._bundle.getString("18"));
        sybLabel.setLabelFor((Component)this._containing);
        jPanel.add((Component)sybLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.add((Component)this._containing, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 21, 2, insets3, 0, 0));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this._remoteID = new JTextField(20);
        new FontHelper((JTextComponent)this._remoteID);
        sybLabel = new SybLabel(this._bundle.getString("16"));
        sybLabel.setLabelFor((Component)this._remoteID);
        jPanel2.add((Component)sybLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, 0, 0));
        jPanel2.add((Component)this._remoteID, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 21, 2, insets3, 0, 0));
        this._userName = new JTextField(20);
        new FontHelper((JTextComponent)this._userName);
        sybLabel = new SybLabel(this._bundle.getString("17"));
        sybLabel.setLabelFor((Component)this._userName);
        jPanel2.add((Component)sybLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        jPanel2.add((Component)this._userName, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 21, 2, insets3, 0, 0));
        jPanel2.setOpaque(false);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 3, 5, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this._apply = new SybButton(this._bundle.getString("5"));
        this._apply.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add((Component)this._apply);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.setOpaque(false);
        jPanel.add((Component)jPanel3, new GridBagConstraints(5, 0, 1, 0, 0.0, 1.0, 21, 3, new Insets(0, 10, 0, 0), 0, 0));
        jPanel.setOpaque(false);
        return jPanel;
    }

    private void setInitialValues() {
        this._showInformation.setSelected(true);
        this._showWarnings.setSelected(true);
        this._showErrors.setSelected(true);
    }

    private void installEventListeners() {
        this.setKeyboardAction(this._containing);
        this.setKeyboardAction(this._remoteID);
        this.setKeyboardAction(this._userName);
        this.addComponentListener(this);
        this._apply.addActionListener((ActionListener)this);
        this._showErrors.addItemListener((ItemListener)this);
        this._showWarnings.addItemListener((ItemListener)this);
        this._showInformation.addItemListener((ItemListener)this);
        this._startAt.addItemListener((ItemListener)this);
        this._endAt.addItemListener((ItemListener)this);
        this._startTime.addChangeListener(this);
        this.installDocumentListener(this._startTime);
        this._endTime.addChangeListener(this);
        this.installDocumentListener(this._endTime);
        this._remoteID.getDocument().addDocumentListener(this);
        this._userName.getDocument().addDocumentListener(this);
        this._containing.getDocument().addDocumentListener(this);
    }

    private void installDocumentListener(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            defaultEditor.getTextField().getDocument().addDocumentListener(this);
        }
    }

    private void removeDocumentListener(JSpinner jSpinner) {
        JComponent jComponent = jSpinner.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)jComponent;
            defaultEditor.getTextField().getDocument().removeDocumentListener(this);
        }
    }

    private void setKeyboardAction(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        String string = "Apply";
        MyAction myAction = new MyAction();
        jTextField.getInputMap().put(keyStroke, string);
        jTextField.getActionMap().put(string, myAction);
    }

    protected boolean shouldReportBadLogFiles() {
        return _reportBadLogFiles;
    }

    protected void disableBadLogFileReporting() {
        _reportBadLogFiles = false;
    }

    private void uninstallEventListeners() {
        this.removeComponentListener(this);
        this._apply.removeActionListener((ActionListener)this);
        this._showErrors.removeItemListener((ItemListener)this);
        this._showWarnings.removeItemListener((ItemListener)this);
        this._showInformation.removeItemListener((ItemListener)this);
        this._startAt.removeItemListener((ItemListener)this);
        this._endAt.removeItemListener((ItemListener)this);
        this._startTime.removeChangeListener(this);
        this.removeDocumentListener(this._startTime);
        this._endTime.removeChangeListener(this);
        this.removeDocumentListener(this._endTime);
        this._remoteID.getDocument().removeDocumentListener(this);
        this._userName.getDocument().removeDocumentListener(this);
        this._containing.getDocument().removeDocumentListener(this);
    }

    void destroy() {
        this.uninstallEventListeners();
        this._apply = null;
        this._showErrors = null;
        this._showWarnings = null;
        this._showInformation = null;
        this._startAt = null;
        this._startTime = null;
        this._endAt = null;
        this._endTime = null;
        this._cp.releaseResources();
        this._cp = null;
        this._remoteID = null;
        this._userName = null;
        this._containing = null;
        this._bundle = null;
        this.removeAll();
    }

    private void setSpinnerTime(JSpinner jSpinner, Date date) {
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)jSpinner.getModel();
        spinnerDateModel.setValue(date);
    }

    private Date getSpinnerTime(JSpinner jSpinner) {
        try {
            jSpinner.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        SpinnerDateModel spinnerDateModel = (SpinnerDateModel)jSpinner.getModel();
        Date date = spinnerDateModel.getDate();
        return date;
    }

    protected abstract void setFilter(boolean var1, boolean var2, boolean var3, Date var4, Date var5, String var6, String var7, String var8);

    private void refresh() {
        String string;
        String string2;
        Date date = this._startAt.isSelected() ? this.getSpinnerTime(this._startTime) : null;
        Date date2 = this._endAt.isSelected() ? this.getSpinnerTime(this._endTime) : null;
        String string3 = this._remoteID.getText().trim();
        if (string3.length() == 0) {
            string3 = null;
        }
        if ((string2 = this._userName.getText().trim()).length() == 0) {
            string2 = null;
        }
        if ((string = this._containing.getText().trim()).length() == 0) {
            string = null;
        }
        this.setFilter(this._showInformation.isSelected(), this._showWarnings.isSelected(), this._showErrors.isSelected(), date, date2, string3, string2, string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._apply.setEnabled(false);
        this.refresh();
    }

    private void enableControls() {
        boolean bl = this._startAt.isSelected();
        this._startTime.setEnabled(bl);
        bl = this._endAt.isSelected();
        this._endTime.setEnabled(bl);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this._apply.setEnabled(true);
        this.enableControls();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.removeComponentListener(this);
        this.refresh();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.handleDocumentEvent();
    }

    private void handleDocumentEvent() {
        this._apply.setEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this._apply.setEnabled(true);
        this.enableControls();
    }

    class MyAction
    extends AbstractAction {
        MyAction() {
            super("Apply");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasePanel.this._apply.isEnabled()) {
                BasePanel.this.actionPerformed(actionEvent);
            }
        }
    }
}

