/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.IndexerClient;
import com.ianywhere.mllv.LogLineParser;
import com.ianywhere.mllv.MultiRandomAccessFile;
import com.sybase.util.Dbg;
import com.sybase.util.FileUtil;
import com.sybase.util.Platform;
import com.sybase.util.win32.Win32Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.WeakHashMap;

class Indexer
implements Runnable {
    public static final int IX_CHRONOLOGICAL = 1;
    public static final int IX_SESSION = 2;
    private static final int UNKNOWN = -1;
    protected IndexerClient _client;
    protected boolean _indexIsBuilt = false;
    protected Thread _workerThread = null;
    private File _indexFile;
    private File[] _logFileNames;
    private MultiRandomAccessFile _logFile;
    private String _fileEncoding = null;
    private OutputStream _out = null;
    private IOException _ioException = null;
    private Hashtable<String, SyncIDEntry> _syncIDTable = new Hashtable();
    private LogLineParser _parser = new LogLineParser();
    private LogLineParser _headerParser = new LogLineParser();
    private int _lastLineByteOffset;
    private StringBuilder _lastLine = new StringBuilder();
    protected boolean _isValid;
    private IntBuffer _cindex = null;
    private RandomAccessFile _cindexRAF = null;
    private int _indexType;
    private int _rowCount;
    protected WeakHashMap<Integer, WeakReference<String>> _lineCache = null;

    Indexer(File[] fileArray) throws IOException {
        int n;
        this._logFileNames = fileArray;
        this._logFile = new MultiRandomAccessFile(this._logFileNames);
        if (Platform.isWindows() && Win32Util.isInstalled() && (n = Win32Util.getANSICodePage()) == 936) {
            this._fileEncoding = "Cp936";
        }
    }

    private BufferedReader createBufferedReaderForLogFile() {
        InputStreamReader inputStreamReader;
        if (this._fileEncoding == null) {
            inputStreamReader = new InputStreamReader(this._logFile);
        } else {
            try {
                inputStreamReader = new InputStreamReader((InputStream)this._logFile, this._fileEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(this._logFile);
            }
        }
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        return bufferedReader;
    }

    void close() {
        if (this._cindexRAF != null) {
            try {
                this._cindexRAF.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._cindexRAF = null;
        }
        this._cindex = null;
        if (this._logFile != null) {
            try {
                this._logFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._logFile = null;
        }
        this.closeIndexFile();
        this._indexFile = null;
        this._client = null;
        this._lastLine = null;
        this._logFileNames = null;
        this._parser = null;
        if (this._syncIDTable != null) {
            this._syncIDTable.clear();
            this._syncIDTable = null;
        }
        if (this._lineCache != null) {
            this._lineCache.clear();
        }
    }

    void destroy() {
        this.close();
        this._workerThread = null;
    }

    void createIndex(IndexerClient indexerClient) throws IOException {
        if (this._workerThread != null) {
            this._workerThread.interrupt();
            try {
                this._workerThread.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._indexFile = FileUtil.createSecureTempFile((String)"mllog", (String)".cix");
        this._indexFile.deleteOnExit();
        if (this._lineCache != null) {
            this._lineCache.clear();
        }
        this._syncIDTable.clear();
        this._lastLineByteOffset = 0;
        this._lastLine.setLength(0);
        this._indexType = -1;
        this._indexIsBuilt = false;
        if (this._cindexRAF != null) {
            try {
                this._cindexRAF.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._cindexRAF = null;
        }
        this._isValid = true;
        this._client = indexerClient;
        this._workerThread = new Thread((Runnable)this, "MobiLink log file indexer");
        this._workerThread.start();
    }

    void interrupt() {
        if (this._workerThread != null) {
            this._workerThread.interrupt();
        }
    }

    void open(int n) throws IOException {
        if (this._cindexRAF == null) {
            this._cindexRAF = new RandomAccessFile(this._indexFile, "r");
            this._cindex = this._cindexRAF.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._cindexRAF.length()).asIntBuffer();
        }
        if (n != this._indexType) {
            this._rowCount = -1;
            if (this._lineCache != null) {
                this._lineCache.clear();
            } else {
                this._lineCache = new WeakHashMap();
            }
            this._indexType = n;
        }
    }

    boolean isIndexCreated() {
        return this._indexIsBuilt;
    }

    int getLineCount() {
        if (this._rowCount == -1) {
            try {
                if (this._cindexRAF == null) {
                    throw new IllegalStateException("Attempted to get line count before opening");
                }
                this._rowCount = (int)(this._cindexRAF.length() / 8L);
            }
            catch (IOException iOException) {
                this._rowCount = 0;
            }
        }
        return this._rowCount;
    }

    LogLineParser getLine(int n) throws ParseException {
        LogLineParser logLineParser;
        if (n < 0 || n > this._rowCount) {
            throw new IllegalArgumentException("Line number " + n + " out of bounds");
        }
        Integer n2 = n;
        String string = null;
        WeakReference<String> weakReference = this._lineCache.get(n2);
        if (weakReference != null) {
            string = (String)weakReference.get();
        }
        try {
            if (string == null) {
                string = this.readLineFromLogFile(n);
                this._lineCache.put(n2, new WeakReference<String>(string));
            }
            logLineParser = this._parser;
            logLineParser.parse(string);
        }
        catch (IOException iOException) {
            logLineParser = null;
        }
        return logLineParser;
    }

    boolean isLogFileValid() {
        return this._isValid;
    }

    private String readLineFromLogFile(int n) throws IOException {
        String string = null;
        int n2 = this._cindex.get(n * 2 + 1);
        string = this.readLineAtOffset(n2);
        return string;
    }

    protected String readLineAtOffset(int n) throws IOException {
        String string = null;
        this._logFile.seek(n);
        BufferedReader bufferedReader = this.createBufferedReaderForLogFile();
        StringBuilder stringBuilder = new StringBuilder(4096);
        while ((string = bufferedReader.readLine()) != null) {
            if (stringBuilder.length() > 0) {
                if (string.length() > 24) {
                    if (string.charAt(0) != ' ') break;
                    stringBuilder.append('\n');
                    stringBuilder.append(string.substring(24));
                    continue;
                }
                stringBuilder.append('\n');
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(string);
        }
        string = stringBuilder.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanLog() throws IOException, InterruptedException {
        block16: {
            String string;
            Charset charset;
            int n = 0;
            boolean bl = false;
            long l = 0L;
            boolean bl2 = true;
            if (this._fileEncoding == null) {
                charset = Charset.defaultCharset();
                string = charset.name();
            } else {
                try {
                    charset = Charset.forName(this._fileEncoding);
                    string = charset.name();
                }
                catch (Exception exception) {
                    charset = Charset.defaultCharset();
                    string = charset.name();
                }
            }
            CharsetDecoder charsetDecoder = charset.newDecoder();
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetDecoder.onMalformedInput(CodingErrorAction.REPLACE);
            long l2 = System.nanoTime();
            long l3 = Runtime.getRuntime().totalMemory();
            byte[] byArray = new byte[8192];
            ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
            try {
                this._logFile.seek(0L);
                while (true) {
                    String string2;
                    CharBuffer charBuffer;
                    int n2;
                    if ((n2 = this._logFile.read(byArray)) == -1) {
                        byteBuffer.flip();
                        if (byteBuffer.limit() > 0) {
                            ++n;
                            charBuffer = charsetDecoder.decode(byteBuffer);
                            string2 = charBuffer.toString();
                            this.processLine(string2, (int)l, true);
                            l += (long)byteBuffer.limit();
                        } else {
                            this.processLine(null, 0, true);
                        }
                        break;
                    }
                    if (this._workerThread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    int n3 = 0;
                    for (int i = 0; i < n2; ++i) {
                        if (byArray[i] != 10) continue;
                        ++n;
                        byteBuffer.put(byArray, n3, i - n3 + 1);
                        n3 = i + 1;
                        byteBuffer.flip();
                        charsetDecoder.reset();
                        charBuffer = charsetDecoder.decode(byteBuffer);
                        string2 = charBuffer.toString();
                        bl2 = this.processLine(string2, (int)l, false);
                        if (!bl2) {
                            break block16;
                        }
                        l += (long)byteBuffer.limit();
                        byteBuffer.clear();
                    }
                    if (n3 >= n2) continue;
                    byteBuffer.put(byArray, n3, n2 - n3);
                }
            }
            catch (CharacterCodingException characterCodingException) {
            }
            finally {
                this._syncIDTable.clear();
            }
        }
    }

    private boolean processLine(String string, int n, boolean bl) throws IOException {
        boolean bl2 = true;
        if (string == null && bl && this._lastLine.length() > 0) {
            bl2 = this.processAndCheckForError(this._lastLine.toString(), this._lastLineByteOffset);
            return bl2;
        }
        if (string.charAt(0) != ' ' || bl) {
            if (this._lastLine.length() > 0) {
                bl2 = this.processAndCheckForError(this._lastLine.toString(), this._lastLineByteOffset);
                this._lastLine.setLength(0);
            }
            if (!bl) {
                this._lastLine.append(string);
                this._lastLineByteOffset = n;
            } else {
                bl2 = this.processAndCheckForError(string, n);
            }
        } else {
            this._lastLine.append('\n');
            this._lastLine.append(string.trim());
        }
        return bl2;
    }

    private boolean processAndCheckForError(String string, int n) throws IOException {
        boolean bl;
        if (string.length() < 24) {
            this._isValid = false;
            bl = false;
        } else {
            bl = this.processLine2(string, n);
        }
        return bl;
    }

    protected boolean processLine2(String string, int n) throws IOException {
        try {
            this._parser.parse(string);
        }
        catch (ParseException parseException) {
            return true;
        }
        String string2 = this._parser.getIdentifier();
        if (string2 == null) {
            string2 = "";
        } else if (string2.equalsIgnoreCase("Main")) {
            this._syncIDTable.clear();
        }
        SyncIDEntry syncIDEntry = this._syncIDTable.get(string2);
        if (syncIDEntry == null) {
            syncIDEntry = new SyncIDEntry(string2, n, string);
            this._syncIDTable.put(string2, syncIDEntry);
        }
        if (this._client != null) {
            int n2;
            String string3 = syncIDEntry.getHeaderLine();
            if (string3 != null && !this._headerParser.parsedLine(string3)) {
                try {
                    this._headerParser.parse(string3);
                }
                catch (ParseException parseException) {
                    return true;
                }
            }
            if ((n2 = this._client.accept(this._parser, string3 == null ? null : this._headerParser)) == 2) {
                return true;
            }
            if (n2 == 3) {
                return false;
            }
        }
        this.writeInt(syncIDEntry.getIdentifier());
        this.writeInt(n);
        return true;
    }

    private void writeInt(int n) throws IOException {
        this._out.write(n >>> 24 & 0xFF);
        this._out.write(n >>> 16 & 0xFF);
        this._out.write(n >>> 8 & 0xFF);
        this._out.write(n & 0xFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        this._out = null;
        try {
            this._out = new BufferedOutputStream(new FileOutputStream(this._indexFile));
            this.scanLog();
            this.closeIndexFile();
            this._indexIsBuilt = true;
            if (this._client != null) {
                this._client.notifyIndexCreated(1);
            }
        }
        catch (InterruptedException interruptedException) {
            bl = true;
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this._out != null) {
                this.closeIndexFile();
                this._out = null;
            }
            if (bl) {
                this._indexFile.delete();
            }
            this._workerThread = null;
        }
    }

    private void closeIndexFile() {
        if (this._out != null) {
            try {
                this._out.close();
                this._out = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean dbgEnabled() {
        return Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }

    static class SyncIDEntry {
        private static final int NO_IDENTIFIER = 0;
        private static final int MAIN = -1;
        private int _identifier;
        private int _byteOffset;
        private WeakReference<String> _headerLine;

        SyncIDEntry(String string, int n, String string2) {
            if (string == null || string.length() == 0) {
                this._identifier = 0;
            } else if (string.equalsIgnoreCase("MAIN")) {
                this._identifier = -1;
            } else {
                try {
                    this._identifier = Integer.decode(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this._identifier = 0;
                }
            }
            this._byteOffset = n;
            this._headerLine = new WeakReference<String>(string2);
        }

        int getByteOffset() {
            return this._byteOffset;
        }

        int getIdentifier() {
            return this._identifier;
        }

        String getHeaderLine() {
            String string = (String)this._headerLine.get();
            return string;
        }
    }
}

