/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.LogFilePanel;
import com.ianywhere.mllv.MLLogFileViewerMessages;
import com.ianywhere.mllv.SummaryPanel;
import com.ianywhere.mllv.SyncPanel;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LogFileDialog
extends JDialog
implements ActionListener,
ChangeListener,
ComponentListener,
Runnable,
WindowListener,
Comparator<File> {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String F1_KEY = "F1_KEY";
    private static final String SETTINGS_FILE = ".mllv11";
    private static final String LOG_FILE_DIR_SETTING = "LogFileDir";
    private static final String WINDOW_SIZE_SETTING = "WindowSize";
    private static boolean _loadSettings = true;
    private static Rectangle _savedBounds = null;
    private static File _savedLogFileFolder = null;
    private static ResourceBundle _bundle;
    private JTabbedPane _tabbedPane;
    private SybButton _close;
    private SybButton _help;
    private Dimension _minimumSize = null;
    private static HelpViewer _helpViewer;
    private static String _helpFolder;
    private static String _helpPrefix;
    private static String _helpSuffix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSettings() {
        BufferedInputStream bufferedInputStream = null;
        if (_loadSettings) {
            _loadSettings = false;
            String string = Platform.getUserConfigurationDirectory(null) + SETTINGS_FILE;
            Properties properties = new Properties();
            try {
                String[] stringArray;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
                properties.loadFromXML(bufferedInputStream);
                _savedBounds = null;
                String string2 = properties.getProperty(WINDOW_SIZE_SETTING);
                if (string2 != null && string2.length() > 0 && (stringArray = string2.split(" ")).length == 4) {
                    try {
                        int n = Integer.decode(stringArray[0]);
                        int n2 = Integer.decode(stringArray[1]);
                        int n3 = Integer.decode(stringArray[2]);
                        int n4 = Integer.decode(stringArray[3]);
                        _savedBounds = new Rectangle(n, n2, n3, n4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (!((string2 = properties.getProperty(LOG_FILE_DIR_SETTING)) == null || string2.length() <= 0 || (_savedLogFileFolder = new File(string2)).exists() && _savedLogFileFolder.isDirectory())) {
                    _savedLogFileFolder = null;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSettings() {
        FilterOutputStream filterOutputStream = null;
        String string = Platform.getUserConfigurationDirectory(null) + SETTINGS_FILE;
        Properties properties = new Properties();
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            if (_savedBounds != null) {
                String string2 = Integer.toString(LogFileDialog._savedBounds.x) + " " + Integer.toString(LogFileDialog._savedBounds.y) + " " + Integer.toString(LogFileDialog._savedBounds.width) + " " + Integer.toString(LogFileDialog._savedBounds.height);
                properties.setProperty(WINDOW_SIZE_SETTING, string2);
            }
            if (_savedLogFileFolder != null) {
                properties.setProperty(LOG_FILE_DIR_SETTING, _savedLogFileFolder.getAbsolutePath());
            }
            properties.storeToXML(filterOutputStream, null);
        }
        catch (IOException iOException) {
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File[] browseForFiles(Window window) {
        File[] fileArray = null;
        if (_bundle == null) {
            _bundle = MLLogFileViewerMessages.getInstance();
        }
        LogFileDialog.loadSettings();
        SybFileChooser sybFileChooser = new SybFileChooser(529);
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[]{new SybFileFilter("log", _bundle.getString("15")), SybFileFilter.getAllFilesFilter()};
        File file = _savedLogFileFolder;
        if (sybFileChooser.showDialog(window, null, file) && (fileArray = sybFileChooser.getSelectedFiles()).length > 0) {
            _savedLogFileFolder = fileArray[0].getParentFile();
        }
        return fileArray;
    }

    public LogFileDialog(JFrame jFrame, File[] fileArray) {
        super((Frame)jFrame, false);
        LogFileDialog.loadSettings();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (_bundle == null) {
            _bundle = MLLogFileViewerMessages.getInstance();
        }
        Arrays.sort(fileArray, this);
        this._tabbedPane = new JTabbedPane();
        this._tabbedPane.setTabLayoutPolicy(1);
        this._tabbedPane.addTab(_bundle.getString("19"), new SyncPanel(fileArray));
        this._tabbedPane.addTab(_bundle.getString("10"), new LogFilePanel(fileArray));
        this._tabbedPane.addTab(_bundle.getString("30"), new SummaryPanel(fileArray));
        this._close = new SybButton(_bundle.getString("9"));
        this._close.addActionListener((ActionListener)this);
        this._help = new SybButton(_bundle.getString("56"));
        this._help.addActionListener((ActionListener)this);
        this._help.setEnabled(false);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._close, this._help});
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._close);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._help);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)this._tabbedPane, "Center");
        jPanel.add((Component)jPanel2, "South");
        this.getContentPane().add(jPanel);
        this.setTitle(SybMessageFormat.format((String)_bundle.getString("8"), (Object[])new Object[]{fileArray[0].getName()}));
        this.setResizable(true);
        this.pack();
        this.pack();
        this._minimumSize = this.getSize();
        this.setVisible(true);
        if (_savedBounds != null) {
            this.setBounds(_savedBounds);
            UIUtils.ensureWindowIsVisible((Window)this);
        } else {
            this.setLocationRelativeTo(jFrame);
        }
        this.addComponentListener(this);
        this.addWindowListener(this);
        this._tabbedPane.addChangeListener(this);
        this.getRootPane().registerKeyboardAction(this, F1_KEY, KeyStroke.getKeyStroke(112, 0, true), 2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
    }

    private void destroy() {
        this.removeComponentListener(this);
        this.removeWindowListener(this);
        _savedBounds = this.getBounds();
        for (int i = 0; i < this._tabbedPane.getTabCount(); ++i) {
            Component component = this._tabbedPane.getComponentAt(i);
            if (component instanceof LogFilePanel) {
                ((LogFilePanel)component).destroy();
                continue;
            }
            if (component instanceof SyncPanel) {
                ((SyncPanel)component).destroy();
                continue;
            }
            if (!(component instanceof SummaryPanel)) continue;
            ((SummaryPanel)component).destroy();
        }
        this._tabbedPane.removeChangeListener(this);
        this._tabbedPane.removeAll();
        this._tabbedPane = null;
        this._close.removeActionListener((ActionListener)this);
        this._close = null;
        this._help.removeActionListener((ActionListener)this);
        this._help = null;
        _helpViewer = null;
        DialogUtils.removeComponents((Container)this);
        LogFileDialog.saveSettings();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._close) {
            this._close.setEnabled(false);
            this.setVisible(false);
            this.destroy();
        } else if ((object == this._help || actionEvent.getActionCommand().equals(F1_KEY)) && this._help.isEnabled()) {
            this._help.setEnabled(false);
            this.handleHelp();
            this._help.setEnabled(true);
        }
    }

    private void handleHelp() {
        this.updateHelpWindow(false);
    }

    public void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpPrefix = string2;
        _helpSuffix = string3;
        this._help.setEnabled(true);
    }

    void updateHelpWindow(boolean bl) {
        Component component;
        if (_helpViewer == null) {
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)_helpFolder, (String)_helpPrefix, (String)_helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        String string = (component = this._tabbedPane.getSelectedComponent()) instanceof SummaryPanel ? "HELP_MLLV_SUMMARY_TAB" : (component instanceof SyncPanel ? "HELP_MLLV_SYNCHRONIZATIONS_TAB" : "HELP_MLLV_MESSAGES_TAB");
        if (_helpViewer != null) {
            if (bl) {
                _helpViewer.turnPageSilent(string, (Window)this);
            } else {
                _helpViewer.turnPage(string, (Window)this);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this._minimumSize != null) {
            Rectangle rectangle = this.getBounds();
            if (rectangle.width < this._minimumSize.width || rectangle.height < this._minimumSize.height) {
                SwingUtilities.invokeLater(this);
            }
        }
    }

    @Override
    public void run() {
        boolean bl = false;
        Rectangle rectangle = this.getBounds();
        if (rectangle.width < this._minimumSize.width) {
            rectangle.width = this._minimumSize.width;
            bl = true;
        }
        if (rectangle.height < this._minimumSize.height) {
            rectangle.height = this._minimumSize.height;
            bl = true;
        }
        if (bl) {
            this.setBounds(rectangle);
        }
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.destroy();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateHelpWindow(true);
    }

    @Override
    public int compare(File file, File file2) {
        long l = file.lastModified() - file2.lastModified();
        return l < 0L ? -1 : (l > 0L ? 1 : 0);
    }

    static {
        _helpViewer = null;
        _helpFolder = null;
    }
}

