/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.BaseTable;
import com.ianywhere.mllv.LogFileTableModel;
import com.sybase.util.FontHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class LogFileTable
extends BaseTable {
    LogFileTable() {
        this.setDefaultRenderer(Object.class, new VariableHeightRenderer());
        this.setDefaultRenderer(Date.class, new DateRenderer());
    }

    void setLogFiles(File[] fileArray) {
        try {
            LogFileTableModel logFileTableModel = new LogFileTableModel(fileArray, this);
            this.setModel(logFileTableModel);
            this.setColumnWidths();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void setFilter(boolean bl, boolean bl2, boolean bl3, Date date, Date date2, String string, String string2, String string3) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof LogFileTableModel) {
            LogFileTableModel logFileTableModel = (LogFileTableModel)tableModel;
            logFileTableModel.setFilter(bl, bl2, bl3, date, date2, string, string2, string3);
        }
    }

    Date getFirstDate() throws ParseException {
        TableModel tableModel;
        Date date = null;
        if (this.getRowCount() > 0 && (tableModel = this.getModel()) instanceof LogFileTableModel) {
            LogFileTableModel logFileTableModel = (LogFileTableModel)tableModel;
            date = logFileTableModel.getDateForRow(0);
        }
        return date;
    }

    Date getLastDate() throws ParseException {
        TableModel tableModel;
        Date date = null;
        int n = this.getRowCount();
        if (n > 0 && (tableModel = this.getModel()) instanceof LogFileTableModel) {
            LogFileTableModel logFileTableModel = (LogFileTableModel)tableModel;
            date = logFileTableModel.getDateForRow(n - 1);
        }
        return date;
    }

    boolean logFilesAreBad() {
        boolean bl = false;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof LogFileTableModel) {
            LogFileTableModel logFileTableModel = (LogFileTableModel)tableModel;
            bl = !logFileTableModel.getIndexer().isLogFileValid();
        }
        return bl;
    }

    @Override
    public void destroy() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof LogFileTableModel) {
            LogFileTableModel logFileTableModel = (LogFileTableModel)tableModel;
            logFileTableModel.destroy();
        }
        super.destroy();
    }

    static class DateRenderer
    implements TableCellRenderer,
    MeasuringRenderer {
        private static SimpleDateFormat DefaultFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        private static final Border EmptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private JPanel _panel;
        private DefaultTableCellRenderer _label;
        protected SimpleDateFormat _formatter = DefaultFormatter;

        DateRenderer() {
            this._panel = new JPanel();
            this._panel.setLayout(new BoxLayout(this._panel, 1));
            this._label = new DefaultTableCellRenderer();
            this._label.setText(" ");
            this._panel.add(this._label);
            this._panel.add(Box.createVerticalGlue());
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this._panel.setForeground(jTable.getSelectionForeground());
                this._panel.setBackground(jTable.getSelectionBackground());
            } else {
                this._panel.setForeground(jTable.getForeground());
                this._panel.setBackground(jTable.getBackground());
            }
            if (bl2) {
                this._panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this._panel.setBorder(EmptyBorder);
            }
            if (object == null) {
                this._label.setText(" ");
            } else {
                this._label.setText(this._formatter.format(object));
            }
            return this._panel;
        }

        @Override
        public int getPreferredWidth(Object object) {
            String string = object == null ? " " : this._formatter.format(object);
            this._label.setText(string);
            return this._label.getPreferredSize().width;
        }
    }

    static class VariableHeightRenderer
    implements TableCellRenderer,
    MeasuringRenderer {
        private static final Border EmptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private JPanel _panel = new JPanel();
        private Font _defaultFont = null;

        VariableHeightRenderer() {
            this._panel.setLayout(new BoxLayout(this._panel, 1));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this._panel.setForeground(jTable.getSelectionForeground());
                this._panel.setBackground(jTable.getSelectionBackground());
            } else {
                this._panel.setForeground(jTable.getForeground());
                this._panel.setBackground(jTable.getBackground());
            }
            if (bl2) {
                this._panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this._panel.setBorder(EmptyBorder);
            }
            this._panel.removeAll();
            if (object == null) {
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                defaultTableCellRenderer.setText(" ");
                this._panel.add(defaultTableCellRenderer);
            } else {
                String string = object.toString();
                String[] stringArray = string.split("[\\n\\r]");
                for (int i = 0; i < stringArray.length; ++i) {
                    DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                    defaultTableCellRenderer.setText(stringArray[i]);
                    if (bl) {
                        ((JComponent)defaultTableCellRenderer).setForeground(jTable.getSelectionForeground());
                    }
                    if (this._defaultFont == null) {
                        this._defaultFont = defaultTableCellRenderer.getFont();
                    }
                    if (this._defaultFont.canDisplayUpTo(string) == -1) {
                        defaultTableCellRenderer.setFont(this._defaultFont);
                    } else {
                        FontHelper.setFontForString((Component)defaultTableCellRenderer, (Font)this._defaultFont, (String)string);
                    }
                    this._panel.add(defaultTableCellRenderer);
                }
                this._panel.add(Box.createVerticalGlue());
            }
            this._panel.validate();
            Dimension dimension = this._panel.getPreferredSize();
            if (jTable.getRowHeight(n) < dimension.height) {
                JTable jTable2;
                JViewport jViewport;
                jTable.setRowHeight(n, dimension.height);
                JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, jTable);
                if (jScrollPane != null && (jViewport = jScrollPane.getRowHeader()) != null && (jTable2 = (JTable)jViewport.getView()) != null) {
                    jTable2.setRowHeight(n, dimension.height);
                }
            }
            return this._panel;
        }

        @Override
        public int getPreferredWidth(Object object) {
            String string = object == null ? " " : object.toString();
            String[] stringArray = string.split("[\\n\\r]");
            int n = 0;
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= n) continue;
                n2 = i;
                n = stringArray[i].length();
            }
            if (n2 != -1) {
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                defaultTableCellRenderer.setText(stringArray[n2]);
                n = defaultTableCellRenderer.getPreferredSize().width;
            } else {
                n = 0;
            }
            return n;
        }
    }

    static interface MeasuringRenderer {
        public int getPreferredWidth(Object var1);
    }
}

