/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.Indexer;
import com.ianywhere.mllv.IndexerClient;
import com.ianywhere.mllv.LogFileTable;
import com.ianywhere.mllv.LogLineParser;
import com.ianywhere.mllv.MLLogFileViewerMessages;
import com.sybase.util.Dbg;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableRowSorter;

class LogFileTableModel
extends AbstractTableModel
implements IndexerClient,
Runnable {
    private static boolean _iconsLoaded = false;
    private static ImageIcon ErrorIcon;
    private static ImageIcon WarningIcon;
    private ResourceBundle _bundle;
    private Indexer _ix;
    private boolean _showInformation = false;
    private boolean _showWarnings = false;
    private boolean _showErrors = false;
    private Date _startDate = null;
    private Date _endDate = null;
    private String _remoteID = null;
    private String _userName = null;
    private String _containing = null;
    private boolean _waitingForIndexer = false;
    private LogFileTable _table;

    LogFileTableModel(File[] fileArray, LogFileTable logFileTable) throws IOException {
        this._table = logFileTable;
        this._bundle = MLLogFileViewerMessages.getInstance();
        this._ix = new Indexer(fileArray);
        if (!_iconsLoaded) {
            _iconsLoaded = true;
            JTable jTable = new JTable();
            int n = jTable.getRowHeight() - jTable.getRowMargin();
            Icon icon = UIManager.getIcon("OptionPane.errorIcon");
            if (icon != null) {
                ErrorIcon = this.makeImageIcon(icon, n);
            }
            if ((icon = UIManager.getIcon("OptionPane.warningIcon")) != null) {
                WarningIcon = this.makeImageIcon(icon, n);
            }
        }
    }

    private ImageIcon makeImageIcon(Icon icon, int n) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(new JPanel(), graphics2D, 0, 0);
        graphics2D.dispose();
        Image image = bufferedImage.getScaledInstance(n, n, 4);
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    Indexer getIndexer() {
        return this._ix;
    }

    void destroy() {
        if (this._ix != null) {
            this._ix.interrupt();
            this._ix.close();
            this._ix = null;
        }
        this._table = null;
        this._bundle = null;
    }

    void setFilter(boolean bl, boolean bl2, boolean bl3, Date date, Date date2, String string, String string2, String string3) {
        this._showInformation = bl;
        this._showWarnings = bl2;
        this._showErrors = bl3;
        this._startDate = date;
        this._endDate = date2;
        this._remoteID = string;
        this._userName = string2;
        this._containing = string3;
        int n = this.getRowCount();
        if (n > 0) {
            this.fireTableRowsDeleted(0, this.getRowCount() - 1);
            this._table.setRowSorter(null);
        }
        this._waitingForIndexer = true;
        try {
            this._ix.createIndex(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Date getDateForRow(int n) throws ParseException {
        Date date = null;
        if (!this._waitingForIndexer) {
            LogLineParser logLineParser = this._ix.getLine(n);
            date = logLineParser.getDate();
        }
        return date;
    }

    @Override
    public void run() {
        block5: {
            this._waitingForIndexer = false;
            if (this._ix.isLogFileValid()) {
                try {
                    this._table.setRowSorter(new TableRowSorter<LogFileTableModel>(this));
                    this._ix.open(1);
                    int n = this._ix.getLineCount();
                    if (n > 0) {
                        this.fireTableRowsInserted(0, n - 1);
                        break block5;
                    }
                    this.fireTableDataChanged();
                }
                catch (IOException iOException) {
                    Dbg.printlnEx((Throwable)iOException, (String)"Could not open index");
                }
            } else {
                this.fireTableRowsInserted(-1, -1);
            }
        }
    }

    @Override
    public int accept(LogLineParser logLineParser, LogLineParser logLineParser2) {
        Date date = null;
        char c = logLineParser.getType();
        if (!(this._showInformation && c == 'I' || this._showWarnings && c == 'W' || this._showErrors && c == 'E')) {
            return 2;
        }
        if (this._startDate != null) {
            try {
                date = logLineParser.getDate();
                if (date.compareTo(this._startDate) < 0) {
                    return 2;
                }
            }
            catch (ParseException parseException) {
                return 3;
            }
        }
        if (this._endDate != null) {
            if (date == null) {
                try {
                    date = logLineParser.getDate();
                }
                catch (ParseException parseException) {
                    return 3;
                }
            }
            if (date.compareTo(this._endDate) > 0) {
                return 3;
            }
        }
        if (!(this._remoteID == null || logLineParser2 != null && this._remoteID.equals(logLineParser2.getRemoteID()))) {
            return 2;
        }
        if (!(this._userName == null || logLineParser2 != null && this._userName.equals(logLineParser2.getUserName()))) {
            return 2;
        }
        if (this._containing != null) {
            String string = logLineParser.getMessage();
            if (string == null || string.length() == 0) {
                return 2;
            }
            if (!string.contains(this._containing)) {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public void notifyIndexCreated(int n) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public int getRowCount() {
        int n = this._waitingForIndexer || this._ix == null ? 0 : this._ix.getLineCount();
        return n;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public Class getColumnClass(int n) {
        Class clazz = n == 0 ? ImageIcon.class : (n == 1 ? Date.class : (n == 2 ? String.class : String.class));
        return clazz;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            String string = "11";
            return " ";
        }
        String string = n == 1 ? "12" : (n == 2 ? "13" : "14");
        String string2 = this._bundle.getString(string);
        return string2;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (!this._waitingForIndexer) {
            LogLineParser logLineParser;
            try {
                logLineParser = this._ix.getLine(n);
            }
            catch (ParseException parseException) {
                return null;
            }
            if (n2 == 0) {
                switch (logLineParser.getType()) {
                    case 'W': {
                        object = WarningIcon;
                        break;
                    }
                    case 'E': {
                        object = ErrorIcon;
                        break;
                    }
                    default: {
                        object = null;
                        break;
                    }
                }
            } else if (n2 == 1) {
                try {
                    object = logLineParser.getDate();
                }
                catch (ParseException parseException) {
                    object = null;
                }
            } else if (n2 == 2) {
                object = logLineParser.getIdentifier();
            } else if (n2 == 3) {
                object = logLineParser.getMessage();
            }
        }
        return object;
    }

    private boolean dbgEnabled() {
        return Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }
}

