/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.sybase.util.Platform;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogLineParser {
    static final char UNKNOWN_TYPE = '?';
    static final char INFORMATION = 'I';
    static final char WARNING = 'W';
    static final char ERROR = 'E';
    private static SimpleDateFormat _dateParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String _line;
    private char _type;
    private String _message;
    private Date _date;
    private String _identifier;
    private String _clientType;
    private String _remoteID;
    private String _userName;
    private String _version;
    static final Pattern _dePattern = Pattern.compile("Anforderung von \"([^\"]+)\" f\u00fcr: Entfernte ID: ([^,]+), Benutzername: ([^,]+), Version: (.*)[\\r\\n]*");
    static final Pattern _enPattern = Pattern.compile("Request from \"([^\"]+)\" for: remote ID: ([^ ,]+), user name: ([^ ]+), version: (.*)[\\r\\n]*");
    static final Pattern _frPattern = Pattern.compile("Demande transmise par \"([^\"]+)\" pour : ID distant : ([^,]+), nom d'utilisateur : ([^,]+), version : ([^,]*)[\\r\\n]*");
    static final Pattern _jaPattern = Pattern.compile("\"([^\"]+)\" \u304b\u3089\u8981\u6c42\u3055\u308c\u307e\u3057\u305f\u3002\u8981\u6c42\u5bfe\u8c61 : \u30ea\u30e2\u30fc\u30c8 ID(?:[ ]?+): ([^ ]+)\u3001\u30e6\u30fc\u30b6\u540d : ([^ ]+)\u3001\u30d0\u30fc\u30b8\u30e7\u30f3 : ([^ ]*)[\\r\\n]*");
    static final Pattern _zhPattern = Pattern.compile("\u6765\u81ea \"([^\"]+)\" \u7684\u8bf7\u6c42\uff0c\u8bf7\u6c42\u5185\u5bb9: \u8fdc\u7a0b ID:(.+)\uff0c\u7528\u6237\u540d: (.+)\uff0c\u7248\u672c: (.*)[\\r\\n]*");
    private Pattern _pattern = null;

    LogLineParser() {
    }

    static char getType(String string) {
        int n = string.charAt(0);
        if (n != 73 && n != 87 && n != 69) {
            n = 73;
        }
        return (char)n;
    }

    void parse(String string) throws ParseException {
        if (string.length() < 24) {
            throw new ParseException("Line is too short to be valid", 0);
        }
        this._line = string;
        this._date = null;
        this._remoteID = null;
        this._clientType = null;
        this._remoteID = null;
        this._userName = null;
        this._type = string.charAt(0);
        if (this._type != 'I' && this._type != 'W' && this._type != 'E') {
            throw new ParseException("Invalid line: " + string, 0);
        }
        if (string.length() > 24) {
            if (string.charAt(24) == '<') {
                int n = string.indexOf(62, 25);
                if (n != -1) {
                    this._identifier = string.substring(25, n);
                    this._message = string.length() > n + 2 ? string.substring(n + 2) : "";
                } else {
                    this._identifier = null;
                    this._message = string.substring(24, string.length());
                }
            } else {
                this._identifier = null;
                this._message = string.substring(24, string.length());
            }
        } else {
            this._identifier = null;
            this._message = null;
        }
    }

    boolean parsedLine(String string) {
        return string != null && string.equals(this._line);
    }

    String getMessage() {
        return this._message;
    }

    Date getDate() throws ParseException {
        if (this._date == null) {
            String string = this.getDateAsString();
            this._date = LogLineParser.getDateFromString(string);
        }
        return this._date;
    }

    String getDateAsString() {
        return this._line.substring(3, 22);
    }

    static Date getDateFromString(String string) throws ParseException {
        Date date = null;
        try {
            date = _dateParser.parse(string);
            if (date == null) {
                throw new ParseException("Malformed timestamp: " + string, 0);
            }
        }
        catch (ParseException parseException) {
            throw new ParseException("Malformed timestamp: " + string, 0);
        }
        return date;
    }

    char getType() {
        return this._type;
    }

    String getIdentifier() {
        return this._identifier;
    }

    String getRemoteID() {
        if (this._remoteID == null) {
            this.parseSyncHeaderLine();
        }
        return this._remoteID;
    }

    String getClientType() {
        if (this._clientType == null) {
            this.parseSyncHeaderLine();
        }
        return this._clientType;
    }

    String getUserName() {
        if (this._userName == null) {
            this.parseSyncHeaderLine();
        }
        return this._userName;
    }

    String getVersion() {
        if (this._version == null) {
            this.parseSyncHeaderLine();
        }
        return this._version;
    }

    private void parseSyncHeaderLine() {
        Matcher matcher;
        if (this._pattern == null) {
            String string = Locale.getDefault().getLanguage();
            this._pattern = !Platform.isWindows() && !Platform.isLinux() ? _enPattern : (string.equals("fr") && !Platform.isLinux() ? _frPattern : (string.equals("de") ? _dePattern : (string.equals("ja") ? _jaPattern : (string.equals("zh") ? _zhPattern : _enPattern))));
        }
        if ((matcher = this._pattern.matcher(this._message)).matches()) {
            this._clientType = matcher.group(1);
            this._remoteID = matcher.group(2);
            this._userName = matcher.group(3);
            this._version = matcher.group(4);
        } else {
            this._clientType = null;
            this._remoteID = null;
            this._userName = null;
            this._version = null;
        }
    }

    static class LocaleTokens {
        String lang;
        String[] token;
        int[] tokenPos;
        int[] parmPos;

        LocaleTokens(String string, String[] stringArray, int[] nArray, int[] nArray2) {
            this.lang = string;
            this.token = stringArray;
            this.tokenPos = nArray;
            this.parmPos = nArray2;
        }
    }
}

