/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class MultiRandomAccessFile
extends InputStream {
    private RandomAccessFile[] _files;
    private long[] _lengths;
    private long[] _startingPositions;
    private int _currentFile;
    private MappedByteBuffer[] _byteBuffers;
    private long _totalLength;
    private byte[] _oneByteArray = new byte[1];
    private long _position;
    private long _mark;

    public MultiRandomAccessFile(File[] fileArray) throws FileNotFoundException, IOException {
        int n = fileArray.length;
        this._files = new RandomAccessFile[n];
        this._lengths = new long[n];
        this._startingPositions = new long[n];
        this._totalLength = 0L;
        for (int i = 0; i < n; ++i) {
            this._files[i] = new RandomAccessFile(fileArray[i], "r");
            this._startingPositions[i] = i == 0 ? 0L : this._startingPositions[i - 1] + this._files[i - 1].length();
            this._lengths[i] = this._files[i].length();
            this._totalLength += this._lengths[i];
        }
        this._currentFile = 0;
        this._mark = 0L;
        this._position = 0L;
        this._byteBuffers = new MappedByteBuffer[n];
    }

    public long getLength() {
        return this._totalLength;
    }

    public long getFilePointer() throws IOException {
        long l = this._startingPositions[this._currentFile];
        if (this._byteBuffers[this._currentFile] != null) {
            l += (long)this._byteBuffers[this._currentFile].position();
        }
        return l;
    }

    public void seek(long l) throws IOException {
        for (int i = 0; i < this._startingPositions.length; ++i) {
            if (l < this._startingPositions[i]) continue;
            if (l < this._startingPositions[i] + this._lengths[i]) {
                this._currentFile = i;
                if (this._byteBuffers[i] != null) {
                    this._byteBuffers[i].position((int)(l - this._startingPositions[i]));
                }
                this._position = l;
                continue;
            }
            if (this._byteBuffers[i] == null) continue;
            this._byteBuffers[i].position(0);
        }
    }

    @Override
    public int available() {
        return (int)(this._totalLength - this._position);
    }

    @Override
    public void close() throws IOException {
        if (this._files != null) {
            for (int i = 0; i < this._files.length; ++i) {
                this._files[i].close();
                this._files[i] = null;
                this._byteBuffers[i] = null;
            }
            this._files = null;
            this._byteBuffers = null;
            this._totalLength = 0L;
            this._position = 0L;
            this._mark = 0L;
        }
        System.gc();
    }

    @Override
    public void mark(int n) {
        this._mark = this._position;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int n = this.read(this._position, this._oneByteArray, 0, 1);
        if (n > 0) {
            ++this._position;
            int n2 = this._oneByteArray[0];
            int n3 = n2 < 0 ? 256 + n2 : n2;
            return n3;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n = this.read(this._position, byArray, 0, byArray.length);
        if (n > 0) {
            this._position += (long)n;
            return n;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.read(this._position, byArray, n, n2);
        if (n3 > 0) {
            this._position += (long)byArray.length;
            return n3;
        }
        return -1;
    }

    @Override
    public void reset() {
        this._position = this._mark;
    }

    @Override
    public long skip(long l) {
        long l2;
        this._position += l;
        if (this._position >= this._totalLength) {
            l2 = this._totalLength - this._position;
            this._position = this._totalLength;
        } else {
            l2 = l;
        }
        return l2;
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException {
        boolean bl = false;
        if (l < this._startingPositions[this._currentFile]) {
            this._currentFile = 0;
        }
        for (int i = this._currentFile; i < this._startingPositions.length; ++i) {
            if (l < this._startingPositions[i] || l >= this._startingPositions[i] + this._lengths[i]) continue;
            this._currentFile = i;
            bl = true;
            break;
        }
        if (!bl) {
            return 0;
        }
        int n3 = 0;
        int n4 = n2;
        while (n4 > 0) {
            int n5 = (int)(this._lengths[this._currentFile] - (l - this._startingPositions[this._currentFile]));
            int n6 = Math.min(n4, n5);
            if (this._byteBuffers[this._currentFile] == null) {
                this._byteBuffers[this._currentFile] = this._files[this._currentFile].getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this._lengths[this._currentFile]);
            }
            this._byteBuffers[this._currentFile].position((int)(l - this._startingPositions[this._currentFile]));
            this._byteBuffers[this._currentFile].get(byArray, n + n3, n6);
            n3 += n6;
            n4 -= n6;
            l += (long)n6;
            if (n6 != n5) continue;
            if (this._currentFile >= this._files.length - 1) break;
            ++this._currentFile;
        }
        return n3;
    }
}

