/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.BaseTable;
import com.ianywhere.mllv.LogLineParser;
import com.ianywhere.mllv.MLLogFileViewerMessages;
import com.ianywhere.mllv.SyncIndexer;
import com.ianywhere.mllv.SyncIndexerClient;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SummaryPanel
extends JPanel
implements ComponentListener,
SyncIndexerClient,
Runnable {
    private ResourceBundle _bundle;
    private File[] _files;
    private BaseTable _fileTable;
    private SummariesTable _summariesTable;
    private ClientSummariesTable _clientSummariesTable;
    private SyncIndexer _ix;

    SummaryPanel(File[] fileArray) {
        super(new GridBagLayout());
        this._files = fileArray;
        this._bundle = MLLogFileViewerMessages.getInstance();
        this.createUI();
        this.addComponentListener(this);
    }

    private void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Insets insets = new Insets(0, 0, 2, 0);
        Insets insets2 = new Insets(0, 0, 15, 0);
        SybLabel sybLabel = new SybLabel("X");
        Font font = sybLabel.getFont().deriveFont(1);
        sybLabel = new SybLabel(this._bundle.getString("31"));
        sybLabel.setFont(font);
        this.add((Component)sybLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        Object[][] objectArray = new Object[this._files.length][2];
        for (int i = 0; i < this._files.length; ++i) {
            objectArray[i][0] = this._files[i].getName();
            objectArray[i][1] = new Date(this._files[i].lastModified());
        }
        Object[] objectArray2 = new Object[]{this._bundle.getString("32"), this._bundle.getString("33")};
        this._fileTable = new FilesTable(objectArray, objectArray2);
        this.setColumnWidths(this._fileTable);
        sybLabel.setLabelFor(this._fileTable);
        JScrollPane jScrollPane = new JScrollPane(this._fileTable);
        this.setPreferredScrollPaneSize(jScrollPane, this._fileTable, 3);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, insets2, 0, 0));
        sybLabel = new SybLabel(this._bundle.getString("34"));
        sybLabel.setFont(font);
        this.add((Component)sybLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this._summariesTable = new SummariesTable();
        sybLabel.setLabelFor(this._summariesTable);
        jScrollPane = new JScrollPane(this._summariesTable);
        this.setPreferredScrollPaneSize(jScrollPane, this._summariesTable, 3);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, insets2, 0, 0));
        sybLabel = new SybLabel(this._bundle.getString("35"));
        sybLabel.setFont(font);
        this.add((Component)sybLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0));
        this._clientSummariesTable = new ClientSummariesTable();
        sybLabel.setLabelFor(this._clientSummariesTable);
        jScrollPane = new JScrollPane(this._clientSummariesTable);
        this.setPreferredScrollPaneSize(jScrollPane, this._clientSummariesTable, 8);
        this.add((Component)jScrollPane, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 21, 1, insets2, 0, 0));
    }

    void destroy() {
        this.removeComponentListener(this);
        if (this._ix != null) {
            this._ix.destroy();
            this._ix = null;
        }
        this._fileTable = null;
        this._summariesTable = null;
        this._clientSummariesTable = null;
    }

    private void refresh() {
        try {
            this._ix = new SyncIndexer(this._files, true);
            this._ix.createIndex(this);
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
        catch (IOException iOException) {
            String string = this._bundle.getString("36");
            String string2 = this._bundle.getString("37");
            String string3 = iOException.getLocalizedMessage();
            DetailsErrorDialog.showDialog((Component)this, (String)string, (String)string2, (String)string3, null);
        }
    }

    private void setColumnWidths(JTable jTable) {
        int n = jTable.getRowCount();
        JTableHeader jTableHeader = jTable.getTableHeader();
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getColumnCount();
        Dimension dimension = jTable.getIntercellSpacing();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getColumnName(i), false, false, 0, i);
            int n3 = component.getPreferredSize().width;
            TableCellRenderer tableCellRenderer2 = jTable.getCellRenderer(0, i);
            for (int j = 0; j < n; ++j) {
                Object object = jTable.getValueAt(j, i);
                component = tableCellRenderer2.getTableCellRendererComponent(jTable, object, false, false, j, i);
                Dimension dimension2 = component.getPreferredSize();
                n3 = Math.max(n3, dimension2.width + dimension.width);
            }
            tableColumn.setPreferredWidth(n3 += 4);
        }
        jTable.doLayout();
    }

    private void setPreferredScrollPaneSize(JScrollPane jScrollPane, JTable jTable, int n) {
        int n2 = jTable.getRowHeight() + jTable.getIntercellSpacing().height;
        n2 = n2 * n + n2 * 3 / 2;
        Dimension dimension = jTable.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(400, n2);
        } else {
            if (dimension.width == 0) {
                dimension.width = 400;
            }
            dimension.height = n2;
        }
        jScrollPane.setPreferredSize(dimension);
        dimension = jTable.getMinimumSize();
        if (dimension == null) {
            dimension = new Dimension(400, n2);
        } else {
            if (dimension.width == 0) {
                dimension.width = 400;
            }
            dimension.height = n2;
        }
        jScrollPane.setMinimumSize(dimension);
    }

    @Override
    public int accept(LogLineParser logLineParser, LogLineParser logLineParser2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int accept(LogLineParser logLineParser, SyncIndexer.Sync sync) {
        return 1;
    }

    @Override
    public void notifyIndexCreated(int n) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public void run() {
        this.setCursor(null);
        this._summariesTable.setModel(new SummariesModel());
        this.setColumnWidths(this._summariesTable);
        this._clientSummariesTable.setModel(new ClientSummariesModel());
        this.setColumnWidths(this._clientSummariesTable);
        this.validate();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.removeComponentListener(this);
        this.refresh();
    }

    class ClientSummariesModel
    extends AbstractTableModel {
        private String[] _columnNames;
        private Object[][] _rowData;

        ClientSummariesModel() {
            this._columnNames = new String[]{SummaryPanel.this._bundle.getString("43"), SummaryPanel.this._bundle.getString("44"), SummaryPanel.this._bundle.getString("45"), SummaryPanel.this._bundle.getString("46"), SummaryPanel.this._bundle.getString("47")};
            int n = SummaryPanel.this._ix.getUserCount();
            this._rowData = new Object[n][this._columnNames.length];
            for (int i = 0; i < n; ++i) {
                SyncIndexer.ClientStats clientStats = SummaryPanel.this._ix.getClientStats(i);
                String string = clientStats.name;
                if (string == null) {
                    string = SummaryPanel.this._bundle.getString("48");
                }
                this._rowData[i][0] = string;
                this._rowData[i][1] = clientStats.syncCount;
                this._rowData[i][3] = clientStats.errCount;
                if (clientStats.syncCount == 0) {
                    this._rowData[i][2] = 0;
                    this._rowData[i][4] = 0;
                    continue;
                }
                this._rowData[i][2] = clientStats.syncTime / clientStats.syncCount;
                this._rowData[i][4] = clientStats.errCount * 100 / clientStats.syncCount;
            }
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this._rowData[n][n2];
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return String.class;
            }
            return Integer.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class ClientSummariesTable
    extends BaseTable {
        ClientSummariesTable() {
        }
    }

    class SummariesModel
    extends AbstractTableModel {
        private String[] _columnNames;
        private String[][] _rowData;

        SummariesModel() {
            this._columnNames = new String[]{SummaryPanel.this._bundle.getString("38"), SummaryPanel.this._bundle.getString("39")};
            this._rowData = new String[][]{{SummaryPanel.this._bundle.getString("40"), Integer.toString(SummaryPanel.this._ix.getSyncCount())}, {SummaryPanel.this._bundle.getString("41"), Integer.toString(SummaryPanel.this._ix.getUserCount())}, {SummaryPanel.this._bundle.getString("42"), Integer.toString(SummaryPanel.this._ix.getMaxSimultaneousSyncs())}};
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this._rowData[n][n2];
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class SummariesTable
    extends BaseTable {
        SummariesTable() {
        }
    }

    class FilesTable
    extends BaseTable {
        FilesTable(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
            this.setShowGrid(false);
        }
    }
}

