/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.Indexer;
import com.ianywhere.mllv.LogLineParser;
import com.ianywhere.mllv.SyncIndexerClient;
import com.sybase.util.Dbg;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeSet;

class SyncIndexer
extends Indexer {
    private boolean _generateStatistics;
    private Hashtable<String, Sync> _syncIDTable;
    private Sync[] _syncList;
    private LogLineParser _parser = new LogLineParser();
    private LogLineParser _headerParser = new LogLineParser();
    private int _subsection;
    private String _lastSyncID;
    private ClientStats[] _stats = null;
    private int _maxSimultaneousSyncs = -1;

    SyncIndexer(File[] fileArray, boolean bl) throws IOException {
        super(fileArray);
        this._generateStatistics = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._syncList = null;
        this._syncIDTable = new Hashtable();
        this._subsection = 1;
        this._lastSyncID = null;
        try {
            this.scanLog();
            Enumeration<String> enumeration = this._syncIDTable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Sync sync = this._syncIDTable.get(string);
                if (sync.isAccepted()) continue;
                sync.destroy();
                this._syncIDTable.remove(string);
            }
            this._syncList = new Sync[this._syncIDTable.size()];
            int n = 0;
            enumeration = this._syncIDTable.keys();
            while (enumeration.hasMoreElements()) {
                this._syncList[n] = this._syncIDTable.get(enumeration.nextElement());
                ++n;
            }
            Arrays.sort(this._syncList, new Comparator<Sync>(){

                @Override
                public int compare(Sync sync, Sync sync2) {
                    try {
                        Date date = sync.getStartTime();
                        Date date2 = sync2.getStartTime();
                        return date.compareTo(date2);
                    }
                    catch (ParseException parseException) {
                        return 0;
                    }
                }
            });
            if (this._generateStatistics) {
                this.generateStatistics();
            }
            this._syncIDTable.clear();
            this._syncIDTable = null;
            this._indexIsBuilt = true;
            if (this._client != null) {
                this._client.notifyIndexCreated(2);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
        }
        catch (Throwable throwable) {
        }
        finally {
            this._workerThread = null;
        }
    }

    @Override
    protected boolean processLine2(String string, int n) {
        try {
            this._parser.parse(string);
        }
        catch (ParseException parseException) {
            return true;
        }
        String string2 = this._parser.getIdentifier();
        if (string2 == null || string2.isEmpty()) {
            this._lastSyncID = string2;
            return true;
        }
        if (string2.equals("Main")) {
            if (!string2.equals(this._lastSyncID)) {
                ++this._subsection;
            }
            this._lastSyncID = string2;
            return true;
        }
        this._lastSyncID = string2;
        String string3 = string2 + "-" + Integer.toString(this._subsection);
        Sync sync = this._syncIDTable.get(string3);
        if (sync == null) {
            sync = new Sync(string3, string);
            this._syncIDTable.put(string3, sync);
        }
        if (this._client != null) {
            int n2 = ((SyncIndexerClient)this._client).accept(this._parser, sync);
            if (n2 == 3) {
                return false;
            }
            if (n2 == 1) {
                sync.setAccepted();
            }
        }
        sync.add(n, this._parser);
        return true;
    }

    int getSyncCount() {
        int n = 0;
        if (this._syncList != null) {
            n = this._syncList.length;
        }
        return n;
    }

    int getSyncStatus(int n) {
        return this._syncList[n].getStatus();
    }

    Date getSyncStartTime(int n) throws ParseException {
        return this._syncList[n].getStartTime();
    }

    Date getSyncEndTime(int n) throws ParseException {
        return this._syncList[n].getEndTime();
    }

    String getSyncRemoteID(int n) {
        return this._syncList[n].getRemoteID();
    }

    String getSyncUserName(int n) {
        return this._syncList[n].getUserName();
    }

    String[] getSyncMessages(int n) throws IOException {
        ArrayList<Integer> arrayList = this._syncList[n].getMessageOffsets();
        int n2 = arrayList.size();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = this.readLineAtOffset(arrayList.get(i));
        }
        return stringArray;
    }

    int getSyncMessageCount(int n) {
        return this._syncList[n].getMessageOffsets().size();
    }

    String getSyncMessage(int n, int n2) throws IOException {
        ArrayList<Integer> arrayList = this._syncList[n].getMessageOffsets();
        String string = this.readLineAtOffset(arrayList.get(n2));
        return string;
    }

    int getSyncDuration(int n) throws ParseException {
        return this._syncList[n].getDuration();
    }

    private void generateStatistics() {
        Object object2;
        String string;
        int n;
        int n2 = this.getSyncCount();
        ClientStats clientStats = new ClientStats();
        Hashtable<String, ClientStats> hashtable = new Hashtable<String, ClientStats>();
        TreeSet<Long> treeSet = new TreeSet<Long>();
        for (n = 0; n < n2; ++n) {
            string = this._syncList[n].getUserName();
            if (string == null) continue;
            ClientStats clientStats2 = (ClientStats)hashtable.get(string);
            if (clientStats2 == null) {
                clientStats2 = new ClientStats();
                clientStats2.name = string;
                hashtable.put(string, clientStats2);
            }
            ++clientStats2.syncCount;
            ++clientStats.syncCount;
            if (this._syncList[n].getStatus() == 'E') {
                ++clientStats2.errCount;
                ++clientStats.errCount;
            }
            try {
                clientStats2.syncTime += this._syncList[n].getDuration();
                clientStats.syncTime += this._syncList[n].getDuration();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                treeSet.add(this._syncList[n].getStartTimeMillis());
                treeSet.add(this._syncList[n].getEndTimeMillis());
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        int n3 = hashtable.size();
        this._stats = new ClientStats[n3 + 1];
        this._stats[0] = clientStats;
        n = 1;
        for (Object object2 : hashtable.values()) {
            this._stats[n++] = object2;
        }
        Object[] objectArray = new Long[treeSet.size()];
        treeSet.toArray(objectArray);
        object2 = new int[treeSet.size()];
        for (n = 0; n < n2; ++n) {
            string = this._syncList[n].getUserName();
            if (string == null) continue;
            try {
                int n4 = Arrays.binarySearch(objectArray, (Object)this._syncList[n].getStartTimeMillis());
                do {
                    Object object3 = object2;
                    int n5 = n4++;
                    object3[n5] = object3[n5] + true;
                } while (n4 != ((Object)object2).length && (Long)objectArray[n4] < this._syncList[n].getEndTimeMillis());
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this._maxSimultaneousSyncs = 0;
        for (n = 0; n < ((Object)object2).length - 1; ++n) {
            this._maxSimultaneousSyncs = Math.max(this._maxSimultaneousSyncs, (int)object2[n]);
        }
        hashtable.clear();
        treeSet.clear();
    }

    int getUserCount() {
        int n = this._stats == null ? 0 : this._stats.length;
        return n;
    }

    int getMaxSimultaneousSyncs() {
        return this._maxSimultaneousSyncs;
    }

    ClientStats getClientStats(int n) {
        return this._stats[n];
    }

    @Override
    void destroy() {
        if (this._syncIDTable != null) {
            this._syncIDTable.clear();
            this._syncIDTable = null;
        }
        if (this._syncList != null) {
            for (int i = 0; i < this._syncList.length; ++i) {
                this._syncList[i].destroy();
            }
            Arrays.fill(this._syncList, null);
            this._syncList = null;
        }
        this._parser = null;
        this._headerParser = null;
        super.destroy();
    }

    private boolean dbgEnabled() {
        return Dbg.isMessageTypeEnabled((String)this.getClass().getName());
    }

    static class ClientStats {
        String name;
        int syncCount;
        int errCount;
        int syncTime;

        ClientStats() {
        }
    }

    class Sync {
        private String _id;
        private char _status = (char)73;
        private boolean _accepted;
        private ArrayList<Integer> _msgOffsets;
        private long _startTime = -1L;
        private int _duration = -1;
        private String _line = null;
        private WeakReference<SyncMetaData> _metaData;

        Sync(String string, String string2) {
            this._id = string;
            this._accepted = false;
            this._msgOffsets = new ArrayList();
            this._line = string2;
        }

        boolean isAccepted() {
            return this._accepted;
        }

        void setAccepted() {
            this._accepted = true;
        }

        void add(int n, LogLineParser logLineParser) {
            this._msgOffsets.add(n);
            char c = logLineParser.getType();
            switch (c) {
                case 'E': {
                    this._status = c;
                    break;
                }
                case 'W': {
                    if (this._status != 'I') break;
                    this._status = c;
                }
            }
        }

        char getStatus() {
            return this._status;
        }

        Date getStartTime() throws ParseException {
            if (this._startTime == -1L) {
                SyncIndexer.this._parser.parse(this._line);
                this._startTime = SyncIndexer.this._parser.getDate().getTime();
            }
            Date date = new Date(this._startTime);
            return date;
        }

        Date getEndTime() throws ParseException {
            long l = this.getStartTime().getTime();
            long l2 = l + (long)(this.getDuration() * 1000);
            Date date = new Date(l2);
            return date;
        }

        long getStartTimeMillis() throws ParseException {
            if (this._startTime == -1L) {
                SyncIndexer.this._parser.parse(this._line);
                this._startTime = SyncIndexer.this._parser.getDate().getTime();
            }
            return this._startTime;
        }

        long getEndTimeMillis() throws ParseException {
            return this.getStartTimeMillis() + (long)this.getDuration();
        }

        int getDuration() throws ParseException {
            if (this._duration == -1) {
                if (this._startTime == -1L) {
                    SyncIndexer.this._parser.parse(this._line);
                    this._startTime = SyncIndexer.this._parser.getDate().getTime();
                }
                try {
                    String string = SyncIndexer.this.readLineAtOffset(this._msgOffsets.get(this._msgOffsets.size() - 1));
                    SyncIndexer.this._parser.parse(string);
                    long l = SyncIndexer.this._parser.getDate().getTime();
                    this._duration = (int)(l - this._startTime) / 1000;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this._duration;
        }

        String getRemoteID() {
            SyncMetaData syncMetaData = this.getSyncMetaData();
            String string = syncMetaData != null ? syncMetaData.remoteID : null;
            return string;
        }

        String getUserName() {
            SyncMetaData syncMetaData = this.getSyncMetaData();
            String string = syncMetaData != null ? syncMetaData.userName : null;
            return string;
        }

        ArrayList<Integer> getMessageOffsets() {
            return this._msgOffsets;
        }

        private SyncMetaData getSyncMetaData() {
            SyncMetaData syncMetaData = this._metaData != null ? (SyncMetaData)this._metaData.get() : null;
            if (syncMetaData == null) {
                try {
                    SyncIndexer.this._parser.parse(this._line);
                }
                catch (ParseException parseException) {
                    return null;
                }
                syncMetaData = new SyncMetaData();
                syncMetaData.userName = SyncIndexer.this._parser.getUserName();
                syncMetaData.remoteID = SyncIndexer.this._parser.getRemoteID();
                this._metaData = new WeakReference<SyncMetaData>(syncMetaData);
            }
            return syncMetaData;
        }

        void destroy() {
            this._msgOffsets.clear();
            this._msgOffsets = null;
            if (this._metaData != null) {
                this._metaData.clear();
                this._metaData = null;
            }
        }
    }

    static class SyncMetaData {
        String userName;
        String remoteID;

        SyncMetaData() {
        }
    }
}

