/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.BasePanel;
import com.ianywhere.mllv.LogFileTable;
import com.ianywhere.mllv.LogLineParser;
import com.ianywhere.mllv.SyncIndexer;
import com.ianywhere.mllv.SyncTable;
import com.ianywhere.mllv.SyncTableModel;
import com.sybase.util.FontHelper;
import com.sybase.util.LabelBar;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRowHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

class SyncPanel
extends BasePanel
implements TableModelListener,
ListSelectionListener {
    private SyncTable _table;
    private JPanel _detailsPanel;
    private boolean _installTableModelListener = true;

    SyncPanel(File[] fileArray) {
        super(fileArray);
    }

    @Override
    protected JPanel createContentPanel(File[] fileArray) {
        this._table = new SyncTable(fileArray);
        SybRowHeader sybRowHeader = new SybRowHeader((JTable)this._table);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.setRowHeaderView((Component)sybRowHeader);
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(this);
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        LabelBar labelBar = new LabelBar(this._bundle.getString("49"));
        labelBar.putClientProperty((Object)"jsyblib.preservecolor", (Object)"1");
        jPanel2.add((Component)labelBar, "North");
        jPanel2.add(jScrollPane);
        this._detailsPanel = new JPanel(new GridBagLayout());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel2, this._detailsPanel);
        jPanel.add((Component)jSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    @Override
    void destroy() {
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table.getModel().removeTableModelListener(this);
        this._table.destroy();
        this._table = null;
        super.destroy();
    }

    @Override
    protected void setFilter(boolean bl, boolean bl2, boolean bl3, Date date, Date date2, String string, String string2, String string3) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._detailsPanel.removeAll();
        this._detailsPanel.validate();
        this._detailsPanel.repaint();
        this._table.setFilter(bl, bl2, bl3, date, date2, string, string2, string3);
        if (this._installTableModelListener) {
            this._installTableModelListener = false;
            this._table.getModel().addTableModelListener(this);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            int n = this._table.getSelectedRow();
            this._detailsPanel.removeAll();
            if (n >= 0) {
                this.buildDetailsPanelForRow(n);
            }
            this._detailsPanel.validate();
        }
    }

    private void buildDetailsPanelForRow(int n) {
        String string;
        Date date;
        int n2 = 1;
        this._detailsPanel.add((Component)new LabelBar(this._bundle.getString("50")), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        n = this._table.convertRowIndexToModel(n);
        SyncIndexer syncIndexer = ((SyncTableModel)this._table.getModel()).getIndexer();
        Font font = UIManager.getDefaults().getFont("Label.font");
        font = font.deriveFont(1);
        try {
            date = syncIndexer.getSyncStartTime(n);
            string = SyncTable.DateRenderer.format(date);
        }
        catch (ParseException parseException) {
            string = this._bundle.getString("55");
        }
        this.addLabelAndValue(jPanel, 0, n2, "26", font, string);
        try {
            date = syncIndexer.getSyncEndTime(n);
            string = SyncTable.DateRenderer.format(date);
        }
        catch (ParseException parseException) {
            string = this._bundle.getString("55");
        }
        this.addLabelAndValue(jPanel, 2, n2, "27", font, string);
        ++n2;
        try {
            string = SyncTable.DurationRenderer.format(syncIndexer.getSyncDuration(n));
        }
        catch (ParseException parseException) {
            string = this._bundle.getString("55");
        }
        this.addLabelAndValue(jPanel, 0, n2, "28", font, string);
        string = syncIndexer.getSyncUserName(n);
        this.addLabelAndValue(jPanel, 0, ++n2, "24", font, string);
        string = syncIndexer.getSyncRemoteID(n);
        this.addLabelAndValue(jPanel, 2, n2, "25", font, string);
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, ++n2, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._detailsPanel.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        MyTable myTable = new MyTable(new SyncMessagesTableModel(syncIndexer, n));
        JScrollPane jScrollPane = new JScrollPane(myTable);
        SybRowHeader sybRowHeader = new SybRowHeader((JTable)myTable);
        jScrollPane.setRowHeaderView((Component)sybRowHeader);
        this._detailsPanel.add((Component)jScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void addLabelAndValue(JPanel jPanel, int n, int n2, String string, Font font, String string2) {
        SybLabel sybLabel = new SybLabel(this._bundle.getString(string));
        sybLabel.setFont(font);
        if (string2 == null) {
            string2 = " ";
        }
        SybLabel sybLabel2 = new SybLabel(string2);
        new FontHelper((JLabel)sybLabel2);
        jPanel.add((Component)sybLabel, new GridBagConstraints(n, n2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, n == 0 ? 0 : 10, 0, 5), 0, 0));
        jPanel.add((Component)sybLabel2, new GridBagConstraints(n + 1, n2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.setCursor(null);
        if (this.shouldReportBadLogFiles() && this._table.logFilesAreBad()) {
            this.disableBadLogFileReporting();
            SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getString("53"), (String)this._bundle.getString("54"), (int)0);
        }
        if (this._table.getRowCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SyncPanel.this._table.getRowCount() > 0) {
                        SyncPanel.this._table.setRowSelectionInterval(0, 0);
                    }
                }
            });
        } else {
            SybOptionPane.showMessageDialog((Component)this, (Object)this._bundle.getString("58"), (String)this._bundle.getString("54"), (int)0);
        }
    }

    static class MyTableModel
    extends AbstractTableModel {
        Object[][] _rowData;
        Object[] _columnNames;

        MyTableModel(Object[][] objectArray, Object[] objectArray2) {
            this._rowData = objectArray;
            this._columnNames = objectArray2;
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n].toString();
        }

        @Override
        public int getRowCount() {
            return this._rowData.length;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this._rowData[n][n2];
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return ImageIcon.class;
            }
            if (n == 1) {
                return Date.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    static class MyTable
    extends JTable {
        MyTable(TableModel tableModel) {
            super(tableModel);
            this.getTableHeader().setReorderingAllowed(false);
            this.setAutoResizeMode(0);
            this.setDefaultRenderer(Object.class, new LogFileTable.VariableHeightRenderer());
            this.setDefaultRenderer(Date.class, new DateRenderer());
            long l = System.nanoTime();
            this.setColumnWidths();
            long l2 = System.nanoTime();
        }

        private void setColumnWidths() {
            TableColumn tableColumn;
            int n;
            int n2 = this.getRowCount();
            if (n2 > 100) {
                n2 = 100;
            }
            JTableHeader jTableHeader = this.getTableHeader();
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n3 = tableColumnModel.getColumnCount();
            int[] nArray = new int[n3];
            for (n = 0; n < n3; ++n) {
                tableColumn = tableColumnModel.getColumn(n);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                if (tableCellRenderer == null) {
                    tableCellRenderer = jTableHeader.getDefaultRenderer();
                }
                Component component = tableCellRenderer.getTableCellRendererComponent(this, this.getColumnName(n), false, false, 0, n);
                nArray[n] = component.getPreferredSize().width;
            }
            for (int i = 0; i < n2; ++i) {
                for (n = 0; n < n3; ++n) {
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(i, n);
                    if (!(tableCellRenderer instanceof LogFileTable.MeasuringRenderer)) continue;
                    Object object = this.getValueAt(i, n);
                    nArray[n] = Math.max(nArray[n], ((LogFileTable.MeasuringRenderer)((Object)tableCellRenderer)).getPreferredWidth(object));
                }
            }
            int n4 = 0;
            for (n = 0; n < n3; ++n) {
                int n5 = n;
                nArray[n5] = nArray[n5] + 4;
                n4 += nArray[n];
                tableColumn = tableColumnModel.getColumn(n);
                tableColumn.setPreferredWidth(nArray[n]);
            }
            this.doLayout();
        }

        static class DateRenderer
        extends LogFileTable.DateRenderer {
            private static SimpleDateFormat DefaultFormatter;

            DateRenderer() {
                if (DefaultFormatter == null) {
                    DefaultFormatter = new SimpleDateFormat("HH:mm:ss");
                }
                this._formatter = DefaultFormatter;
            }
        }
    }

    class SyncMessagesTableModel
    extends AbstractTableModel {
        private int _rowCount;
        private SyncIndexer _indexer;
        private int _syncIndex;
        private WeakReference[] _messages;
        private String[] _columnNames;

        SyncMessagesTableModel(SyncIndexer syncIndexer, int n) {
            this._columnNames = new String[]{" ", SyncPanel.this._bundle.getString("52"), SyncPanel.this._bundle.getString("51")};
            this._indexer = syncIndexer;
            this._syncIndex = n;
            this._rowCount = syncIndexer.getSyncMessageCount(n);
            this._messages = new WeakReference[this._rowCount];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object[] objectArray = this._messages[n] != null ? (Object[])this._messages[n].get() : null;
            if (objectArray == null) {
                objectArray = new Object[3];
                try {
                    String string = this._indexer.getSyncMessage(this._syncIndex, n);
                    LogLineParser logLineParser = new LogLineParser();
                    logLineParser.parse(string);
                    switch (logLineParser.getType()) {
                        case 'E': {
                            objectArray[0] = SyncTableModel.ErrorIcon;
                            break;
                        }
                        case 'W': {
                            objectArray[0] = SyncTableModel.WarningIcon;
                            break;
                        }
                        default: {
                            objectArray[0] = null;
                        }
                    }
                    try {
                        objectArray[1] = logLineParser.getDate();
                    }
                    catch (ParseException parseException) {
                        objectArray[1] = null;
                    }
                    objectArray[2] = logLineParser.getMessage();
                }
                catch (IOException iOException) {
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this._messages[n] = new WeakReference<Object[]>(objectArray);
            }
            if (n2 == 0) {
                return objectArray[0];
            }
            if (n2 == 1) {
                return objectArray[1];
            }
            return objectArray[2];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return ImageIcon.class;
            }
            if (n == 1) {
                return Date.class;
            }
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._rowCount;
        }
    }
}

