/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.mllv;

import com.ianywhere.mllv.BaseTable;
import com.ianywhere.mllv.SyncTableModel;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

class SyncTable
extends BaseTable {
    SyncTable(File[] fileArray) {
        try {
            SyncTableModel syncTableModel = new SyncTableModel(fileArray, this);
            this.setModel(syncTableModel);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setDefaultRenderer(Date.class, new DateRenderer());
        this.setDefaultRenderer(SyncTableModel.Duration.class, new DurationRenderer());
        this.setColumnWidths();
    }

    boolean logFilesAreBad() {
        boolean bl = false;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof SyncTableModel) {
            SyncTableModel syncTableModel = (SyncTableModel)tableModel;
            bl = !syncTableModel.getIndexer().isLogFileValid();
        }
        return bl;
    }

    void setFilter(boolean bl, boolean bl2, boolean bl3, Date date, Date date2, String string, String string2, String string3) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof SyncTableModel) {
            SyncTableModel syncTableModel = (SyncTableModel)tableModel;
            syncTableModel.setFilter(bl, bl2, bl3, date, date2, string, string2, string3);
        }
    }

    @Override
    public void destroy() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof SyncTableModel) {
            SyncTableModel syncTableModel = (SyncTableModel)tableModel;
            syncTableModel.destroy();
        }
        super.destroy();
    }

    static class DurationRenderer
    extends DefaultTableCellRenderer {
        private static SimpleDateFormat _formatter = new SimpleDateFormat("HH:mm:ss");

        DurationRenderer() {
        }

        @Override
        public void setValue(Object object) {
            if (object == null || !(object instanceof Integer)) {
                this.setText("");
            } else {
                int n = (Integer)object;
                this.setText(DurationRenderer.format(n));
            }
        }

        static String format(int n) {
            int n2 = n / 3600;
            int n3 = (n - n2 * 3600) / 60;
            int n4 = n - n2 * 3600 - n3 * 60;
            String string = String.format("%02d:%02d:%02d", n2, n3, n4);
            return string;
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        private static SimpleDateFormat _formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        DateRenderer() {
        }

        @Override
        public void setValue(Object object) {
            this.setText(object == null ? "" : DateRenderer.format(object));
        }

        static String format(Object object) {
            return _formatter.format(object);
        }
    }
}

