/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.textCompleter;

import com.ianywhere.textCompleter.TCParserTokenManager;
import com.ianywhere.textCompleter.TextCompleterClient;
import com.ianywhere.textCompleter.TextCompleterResourcesBase;
import com.ianywhere.textCompleter.Token;
import com.ianywhere.textCompleter.TokenMgrError;
import com.ianywhere.textCompleter.UCode_CharStream;
import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.FontHelper;
import com.sybase.util.ImageLoader;
import com.sybase.util.Platform;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class TextCompleter
implements DocumentListener,
KeyListener,
WindowListener,
ComponentListener,
MouseListener {
    public static final int SHOW_TABLES = 1;
    public static final int SHOW_PROCEDURES = 2;
    public static final int SHOW_COLUMNS = 4;
    public static final int SHOW_BIFS = 8;
    public static final int SHOW_SYSTEM_OBJECTS = 16;
    public static final int COMPLETE_IF_SINGLE_MATCH = 32;
    public static final int QUOTE_NAMES = 64;
    public static final int SHOW_OWNER_NAMES = 128;
    public static final int SHOW_TOOLTIPS = 256;
    public static final int DEFAULT_SETTINGS = 271;
    private static final String SLK_SETTINGS = "Settings";
    private static boolean _defShowTablesAndViews = true;
    private static boolean _defShowProcedures = true;
    private static boolean _defShowColumns = true;
    private static boolean _defShowBIFs = true;
    private static boolean _defShowSystemObjects = false;
    private static boolean _defQuoteNames = false;
    private static boolean _defShowOwnerNames = true;
    private static boolean _defCompleteIfSingleMatch = false;
    private static boolean _defShowToolTips = true;
    private static boolean _loadSettings = true;
    private static boolean _saveSettings = false;
    private boolean _showTables = true;
    private boolean _showViews = true;
    private boolean _showProcedures = true;
    private boolean _showColumns = true;
    private boolean _showBIFs = true;
    private boolean _showSystemObjects = false;
    private boolean _quoteNames = false;
    private boolean _showOwnerNames = true;
    private boolean _completeIfSingleMatch = false;
    private boolean _showToolTips = true;
    private JEditorPane _editor = null;
    private KeyListener[] _editorListeners = null;
    private TextCompletionList _list = null;
    private JDialog _listDialog = null;
    private TextCompleterClient _client = null;
    private boolean _quoteNextSelection = false;
    private boolean _quotePrecedesText = false;
    private boolean _isClosing = false;
    private int _userTypeOverrideInEffect = 0;
    private int _settingsBeforeOverride = 0;
    private Object[] _fullListData = null;
    private Object[] _smartListData = null;
    private boolean _showFullList = false;
    private static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(32, 2);
    private static final KeyStroke ALT_KEY_STROKE = KeyStroke.getKeyStroke(32, 3);
    private static HelpViewer _helpViewer = null;
    private static String _helpFolder = null;
    private static String _helpPrefix;
    private static String _helpSuffix;

    public TextCompleter(JEditorPane jEditorPane, TextCompleterClient textCompleterClient) {
        this._editor = jEditorPane;
        this._client = textCompleterClient;
        if (_loadSettings) {
            TextCompleter.loadSettings();
            _loadSettings = false;
        }
        InputMap inputMap = jEditorPane.getInputMap();
        inputMap.put(DEFAULT_KEY_STROKE, "openTextCompleter");
        inputMap.put(ALT_KEY_STROKE, "openTextCompleter");
        AbstractAction abstractAction = new AbstractAction("openTextCompleter"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextCompleter.this.openCompleter();
            }
        };
        ActionMap actionMap = jEditorPane.getActionMap();
        actionMap.put("openTextCompleter", abstractAction);
    }

    public TextCompleterClient getTextCompleterClient() {
        return this._client;
    }

    public static void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpPrefix = string2;
        _helpSuffix = string3;
    }

    static void updateHelpWindow(String string, Window window, boolean bl) {
        if (_helpViewer == null) {
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)_helpFolder, (String)_helpPrefix, (String)_helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        if (_helpViewer != null) {
            if (bl) {
                _helpViewer.turnPageSilent(string, window);
            } else {
                _helpViewer.turnPage(string, window);
            }
        }
    }

    public static void setSettings(int n) {
        _defShowTablesAndViews = (n & 1) != 0;
        _defShowColumns = (n & 4) != 0;
        _defShowProcedures = (n & 2) != 0;
        _defShowBIFs = (n & 8) != 0;
        _defShowSystemObjects = (n & 0x10) != 0;
        _defQuoteNames = (n & 0x40) != 0;
        _defShowOwnerNames = (n & 0x80) != 0;
        _defShowToolTips = (n & 0x100) != 0;
        _defCompleteIfSingleMatch = (n & 0x20) != 0;
        _saveSettings = true;
    }

    public static int getSettings() {
        int n = 0;
        if (_defShowTablesAndViews) {
            ++n;
        }
        if (_defShowColumns) {
            n += 4;
        }
        if (_defShowProcedures) {
            n += 2;
        }
        if (_defShowBIFs) {
            n += 8;
        }
        if (_defShowSystemObjects) {
            n += 16;
        }
        if (_defQuoteNames) {
            n += 64;
        }
        if (_defShowOwnerNames) {
            n += 128;
        }
        if (_defShowToolTips) {
            n += 256;
        }
        if (_defCompleteIfSingleMatch) {
            n += 32;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSettings() {
        FilterOutputStream filterOutputStream = null;
        Properties properties = new Properties();
        properties.setProperty(SLK_SETTINGS, Integer.toString(TextCompleter.getSettings()));
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(TextCompleter.getSettingsFileName()));
            properties.store(filterOutputStream, "");
        }
        catch (IOException iOException) {
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        _saveSettings = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSettings() {
        BufferedInputStream bufferedInputStream = null;
        TextCompleter.setSettings(271);
        Properties properties = new Properties();
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(TextCompleter.getSettingsFileName()));
            properties.load(bufferedInputStream);
            String string = properties.getProperty(SLK_SETTINGS);
            if (string != null && string.length() != 0) {
                try {
                    int n = Integer.parseInt(string);
                    TextCompleter.setSettings(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        _saveSettings = false;
    }

    protected static String getSettingsFileName() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(Platform.getUserConfigurationDirectory());
        stringBuffer.append(".textCompleter");
        stringBuffer.append(Integer.toString(11));
        stringBuffer.append(Integer.toString(0));
        return stringBuffer.toString();
    }

    static boolean getShowTablesAndViews() {
        return _defShowTablesAndViews;
    }

    static void setShowTablesAndViews(boolean bl) {
        _defShowTablesAndViews = bl;
        _saveSettings = true;
    }

    static boolean getShowProcedures() {
        return _defShowProcedures;
    }

    static void setShowProcedures(boolean bl) {
        _defShowProcedures = bl;
        _saveSettings = true;
    }

    static boolean getShowColumns() {
        return _defShowColumns;
    }

    static void setShowColumns(boolean bl) {
        _defShowColumns = bl;
        _saveSettings = true;
    }

    static boolean getShowBIFs() {
        return _defShowBIFs;
    }

    static void setShowBIFs(boolean bl) {
        _defShowBIFs = bl;
        _saveSettings = true;
    }

    static boolean getShowSystemObjects() {
        return _defShowSystemObjects;
    }

    static void setShowSystemObjects(boolean bl) {
        _saveSettings = true;
    }

    static boolean getQuoteNames() {
        return _defQuoteNames;
    }

    static void setQuoteNames(boolean bl) {
        _defQuoteNames = bl;
        _saveSettings = true;
    }

    static boolean getShowOwnerNames() {
        return _defShowOwnerNames;
    }

    static void setShowOwnerNames(boolean bl) {
        _defShowOwnerNames = bl;
        _saveSettings = true;
    }

    static boolean getCompleteIfSingleMatch() {
        return _defCompleteIfSingleMatch;
    }

    static void setCompleteIfSingleMatch(boolean bl) {
        _defCompleteIfSingleMatch = bl;
        _saveSettings = true;
    }

    private void closeCompleter() {
        if (this._listDialog != null) {
            this._listDialog.setVisible(false);
            this._listDialog.dispose();
            this._listDialog = null;
        }
        if (this._list != null) {
            this._list.removeKeyListener(this);
            this._list = null;
        }
        this._smartListData = null;
        this._fullListData = null;
        if (this._userTypeOverrideInEffect != 0) {
            this._userTypeOverrideInEffect = 0;
            TextCompleter.setSettings(this._settingsBeforeOverride);
        }
    }

    public void destroy() {
        this.closeCompleter();
        this._editor = null;
        if (_saveSettings) {
            TextCompleter.saveSettings();
        }
    }

    private String getEditorText() {
        return this.getEditorText(true, true);
    }

    private String getEditorText(boolean bl, boolean bl2) {
        String string;
        block8: {
            this._quotePrecedesText = false;
            string = null;
            int n = this._editor.getCaretPosition();
            if (n > 0) {
                int n2 = n - 512;
                if (n2 < 0) {
                    n2 = 0;
                }
                int n3 = n - n2;
                try {
                    String string2 = string = this._editor.getText(n2, n3);
                    if (string.length() <= 0) break block8;
                    for (int i = string.length() - 1; i >= 0; --i) {
                        char c = string.charAt(i);
                        if (!bl && Character.isWhitespace(c) || !bl2 && c == '.' || (Character.isJavaIdentifierPart(c) || (long)c >= 57344L) && c != '\"') continue;
                        string = string.substring(i + 1);
                        int n4 = string2.lastIndexOf(10, i);
                        if (n4 == -1) {
                            n4 = 0;
                        }
                        boolean bl3 = false;
                        while (n4 <= i) {
                            if (string2.charAt(n4) == '\"') {
                                bl3 = !bl3;
                            }
                            ++n4;
                        }
                        this._quotePrecedesText = bl3;
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return string;
    }

    private void openCompleter() {
        TextCompletionListItem textCompletionListItem;
        Frame frame = null;
        Dialog dialog = null;
        Window window = null;
        if (this._listDialog != null) {
            return;
        }
        this._showTables = _defShowTablesAndViews;
        this._showViews = _defShowTablesAndViews;
        this._showProcedures = _defShowProcedures;
        this._showColumns = _defShowColumns;
        this._showBIFs = _defShowBIFs;
        this._showSystemObjects = _defShowSystemObjects;
        this._quoteNames = _defQuoteNames;
        this._showOwnerNames = _defShowOwnerNames;
        this._completeIfSingleMatch = _defCompleteIfSingleMatch;
        this._showToolTips = _defShowToolTips;
        this._showFullList = false;
        String string = this.getEditorText();
        if (this._list == null) {
            this._list = new TextCompletionList(this._showToolTips);
            this._list.addKeyListener(this);
        }
        this.setListData();
        if (this._completeIfSingleMatch && this._list.getModel().getSize() == 1 && !((textCompletionListItem = (TextCompletionListItem)this._list.getModel().getElementAt(0)) instanceof NoMatchesTextCompletionListItem)) {
            String string2 = this.getQualifiedItemText(textCompletionListItem, this._list.getModel());
            string = this.getReplacableSuffix(textCompletionListItem);
            int n = this._editor.getCaretPosition() - string.length();
            this._editor.moveCaretPosition(n);
            this._editor.replaceSelection(string2);
            this._smartListData = null;
            this._fullListData = null;
            return;
        }
        window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._editor);
        if (window != null) {
            if (window instanceof Frame) {
                frame = (Frame)window;
            } else if (window instanceof Dialog) {
                dialog = (Dialog)window;
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this._list, 22, 30);
        this._listDialog = frame != null ? new JDialog(frame) : new JDialog(dialog);
        this._listDialog.setUndecorated(true);
        this._listDialog.getRootPane().getContentPane().add(jScrollPane);
        this._listDialog.pack();
        this.setListDialogPosition();
        this._listDialog.setVisible(true);
        this.selectListItemFromEditorText();
        this._editor.getDocument().addDocumentListener(this);
        this._editor.addMouseListener(this);
        this._list.addMouseListener(this);
        window.addWindowListener(this);
        window.addComponentListener(this);
        this._editorListeners = this._editor.getKeyListeners();
        for (int i = 0; i < this._editorListeners.length; ++i) {
            this._editor.removeKeyListener(this._editorListeners[i]);
        }
        this._editor.addKeyListener(this);
        this._editor.requestFocus();
    }

    private void setListData() {
        Object e = this._list.getSelectedValue();
        if (this._showFullList) {
            if (this._fullListData == null) {
                this.buildFullListData();
            }
            this._list.setListData(this._fullListData);
        } else {
            if (this._smartListData == null) {
                this.buildSmartListData();
            }
            this._list.setListData(this._smartListData);
        }
        if (e != null && !(e instanceof NoMatchesTextCompletionListItem)) {
            this._list.setSelectedValue(e, true);
        }
    }

    private Point getCaretLineAndColumn() {
        Point point;
        int n = this._editor.getCaretPosition();
        try {
            Rectangle rectangle = this._editor.modelToView(n);
            FontMetrics fontMetrics = this._editor.getFontMetrics(this._editor.getFont());
            int n2 = fontMetrics.getHeight();
            int n3 = rectangle.y / n2 + 1;
            int n4 = this._editor.viewToModel(new Point(0, rectangle.y));
            int n5 = n - n4 + 1;
            point = new Point(n5, n3);
        }
        catch (BadLocationException badLocationException) {
            point = null;
        }
        return point;
    }

    private ArrayList<Token> getCurrentStatement(Point point) {
        boolean bl = false;
        int n = point.x;
        int n2 = point.y;
        ArrayList<Token> arrayList = new ArrayList<Token>();
        try {
            StringBuilder stringBuilder = new StringBuilder(this._editor.getText());
            stringBuilder.append(" ");
            StringReader stringReader = new StringReader(stringBuilder.toString());
            UCode_CharStream uCode_CharStream = new UCode_CharStream(stringReader, 1, 1);
            TCParserTokenManager tCParserTokenManager = new TCParserTokenManager(uCode_CharStream);
            long l = System.currentTimeMillis();
            while (true) {
                Token token = tCParserTokenManager.getNextToken();
                if (token.kind == 0 || token.kind == 9 || token.kind == 15 || token.kind == 16 || token.kind == 17) {
                    if (!bl && token.kind == 0 && token.specialToken != null) {
                        boolean bl2 = bl = token.specialToken.beginLine > n2 || token.specialToken.beginLine == n2 && token.specialToken.endColumn >= n - 1;
                    }
                    if (bl) break;
                    arrayList.clear();
                    if (token.kind != 0) continue;
                    break;
                }
                bl = bl || token.beginLine > n2 || token.beginLine == n2 && token.endColumn >= n - 1;
                arrayList.add(token);
            }
            long l2 = System.currentTimeMillis();
            stringReader.close();
        }
        catch (TokenMgrError tokenMgrError) {
            // empty catch block
        }
        if (arrayList.size() > 0) {
            while (arrayList.get((int)0).kind == 11 && arrayList.get((int)(arrayList.size() - 1)).kind == 12) {
                arrayList.remove(arrayList.size() - 1);
                arrayList.remove(0);
                if (arrayList.size() != 0) continue;
            }
            if (arrayList.size() > 0) {
                while (arrayList.get((int)0).kind == 11) {
                    arrayList.remove(0);
                    if (arrayList.size() != 0) continue;
                    break;
                }
            }
        }
        return arrayList;
    }

    private ArrayList<TextCompletionListItem> buildListGivenContext(ArrayList<Token> arrayList, Point point) {
        ArrayList<TextCompletionListItem> arrayList2 = null;
        Token token = arrayList.get(0);
        if (token.kind == 18) {
            arrayList2 = this.buildListForSelect(arrayList, point);
        } else if (token.kind == 26) {
            arrayList2 = this.buildListForInsert(arrayList, point);
        } else if (token.kind == 29) {
            arrayList2 = this.buildListForUpdate(arrayList, point);
        } else if (token.kind == 33) {
            arrayList2 = this.buildListForDelete(arrayList, point);
        } else if (token.kind == 34) {
            arrayList2 = this.buildListForDescribe(arrayList, point);
        }
        if (arrayList2 != null) {
            if (arrayList2.size() > 0) {
                Collections.sort(arrayList2);
            } else {
                arrayList2 = null;
            }
        }
        return arrayList2;
    }

    private String stripQuotes(String string) {
        if (string != null && string.length() > 2) {
            char c = string.charAt(0);
            char c2 = string.charAt(string.length() - 1);
            if (c == '\"' && c2 == '\"' || c == '[' && c2 == ']') {
                string = string.substring(1, string.length() - 1);
            }
        }
        return string;
    }

    private ArrayList<TextCompletionListItem> buildListForInsert(ArrayList<Token> arrayList, Point point) {
        String string;
        boolean bl;
        boolean bl2;
        Token token;
        int n;
        ArrayList<TextCompletionListItem> arrayList2 = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        String string2 = null;
        String string3 = null;
        int n2 = -1;
        int n3 = point.y;
        int n4 = point.x;
        ArrayList<Token> arrayList3 = new ArrayList<Token>();
        int n5 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (n5 == 0) {
                if (token.kind != 26 && token.kind != 27) {
                    arrayList3.add(token);
                    n5 = 1;
                }
                token2 = token;
                token3 = token;
                n2 = 0;
                continue;
            }
            if (n5 == 1) {
                if (token.kind == 11) {
                    n5 = 2;
                    token4 = token;
                    n2 = 1;
                    continue;
                }
                if (token.kind == 28) {
                    token6 = token;
                    break;
                }
                arrayList3.add(token);
                token3 = token;
                continue;
            }
            if (n5 == 2) {
                if (token.kind != 12) continue;
                token5 = token;
                n5 = 3;
                n2 = -1;
                continue;
            }
            if (n5 != 3 || token.kind != 28) continue;
            token6 = token;
            break;
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.endColumn != n4 - 1 || token.endLine != n3) continue;
            for (int i = n; i >= 0; --i) {
                token = arrayList.get(i);
                if (token.kind == 13) {
                    if (vector.size() != 0) continue;
                    vector.add("");
                    continue;
                }
                if (token.kind == 49) {
                    vector.add(this.stripQuotes(token.image));
                    if (token.specialToken == null) continue;
                    break;
                }
                if (token.kind != 63) break;
                vector.add(token.image.substring(1));
                if (token.specialToken != null) break;
            }
            if (vector.size() >= 2) break;
            vector.clear();
            break;
        }
        if (vector.size() == 2) {
            if (this.isSchemaName((String)vector.elementAt(1))) {
                arrayList2 = new ArrayList();
                this.addTablesToCompletionList(arrayList2, (String)vector.elementAt(1), (String)vector.elementAt(0), 1);
            } else if (this.isTableName((String)vector.elementAt(1))) {
                arrayList2 = new ArrayList();
                this.addColumnsToCompletionList(arrayList2, null, (String)vector.elementAt(1), null, (String)vector.elementAt(0), 2);
            }
        } else if (vector.size() == 3) {
            arrayList2 = new ArrayList<TextCompletionListItem>();
            this.addColumnsToCompletionList(arrayList2, (String)vector.elementAt(2), (String)vector.elementAt(1), null, (String)vector.elementAt(0), 3);
        }
        if (arrayList2 != null) {
            return arrayList2;
        }
        if (arrayList3.size() == 1) {
            if (((Token)arrayList3.get((int)0)).kind == 49) {
                string2 = null;
                string3 = this.stripQuotes(((Token)arrayList3.get((int)0)).image);
            }
        } else if (arrayList3.size() == 2) {
            if (((Token)arrayList3.get((int)0)).kind == 49 && ((Token)arrayList3.get((int)1)).kind == 13) {
                string2 = this.stripQuotes(((Token)arrayList3.get((int)0)).image);
            }
        } else if (arrayList3.size() == 3 && ((Token)arrayList3.get((int)0)).kind == 49 && ((Token)arrayList3.get((int)1)).kind == 13 && ((Token)arrayList3.get((int)2)).kind == 49) {
            string2 = this.stripQuotes(((Token)arrayList3.get((int)0)).image);
            string3 = this.stripQuotes(((Token)arrayList3.get((int)2)).image);
        }
        arrayList3.clear();
        boolean bl3 = this._showTables | this._showViews;
        boolean bl4 = this._showProcedures;
        boolean bl5 = this._showColumns;
        boolean bl6 = this._showBIFs;
        if (token2 != null) {
            bl2 = n3 < token2.beginLine || n3 == token2.beginLine && n4 < token2.beginColumn;
            boolean bl7 = bl = token3 != null && (n3 > token3.endLine || n3 == token3.endLine && n4 > token3.endColumn);
            if (!(bl2 || bl && n2 != 0)) {
                bl4 = false;
                bl5 = false;
                bl6 = false;
            }
        }
        if (token4 != null) {
            bl2 = n3 < token4.beginLine || n3 == token4.beginLine && n4 < token4.beginColumn;
            boolean bl8 = bl = token5 != null && (n3 > token5.endLine || n3 == token5.endLine && n4 > token5.endColumn);
            if (!(bl2 || bl && n2 != 1)) {
                bl3 = false;
                bl4 = false;
                bl6 = false;
            }
        }
        if ((string = this.getEditorText()) != null) {
            string = string.trim();
        }
        arrayList2 = new ArrayList();
        if (bl3) {
            if (string != null && string.endsWith(".")) {
                this.addTablesToCompletionList(arrayList2, string2, null, 0);
            } else {
                this.addTablesToCompletionList(arrayList2, string2, string, 0);
            }
        }
        if (bl4) {
            this.addProceduresToCompletionList(arrayList2, null, string, 0);
        }
        if (bl5) {
            this.addColumnsToCompletionList(arrayList2, string2, string3, null, string, 3);
        }
        if (bl6) {
            this.addBIFsToCompletionList(arrayList2, string);
        }
        return arrayList2;
    }

    private ArrayList<TextCompletionListItem> buildListForSelect(ArrayList<Token> arrayList, Point point) {
        String string;
        Token token;
        int n;
        ArrayList<TextCompletionListItem> arrayList2 = null;
        Token token2 = null;
        Token token3 = null;
        Object var14_6 = null;
        String string2 = null;
        OwnerAndTable ownerAndTable = null;
        int n2 = point.y;
        int n3 = point.x;
        Hashtable<String, OwnerAndTable> hashtable = new Hashtable<String, OwnerAndTable>();
        int n4 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (n4 == 0) {
                if (token.kind != 19) continue;
                n4 = 1;
                token2 = token;
                continue;
            }
            if (token.kind == 21 || token.kind == 22 || token.kind == 23 || token.kind == 24 || token.kind == 25) {
                token3 = token;
                break;
            }
            if (n4 == 1) {
                if (token.kind != 49) continue;
                ownerAndTable = new OwnerAndTable(null, token.image);
                string2 = var14_6;
                n4 = 2;
                continue;
            }
            if (n4 == 2) {
                if (token.kind == 14) {
                    if (ownerAndTable != null) {
                        string2 = ownerAndTable.table;
                        hashtable.put(this.stripQuotes(string2), ownerAndTable);
                        string2 = null;
                        ownerAndTable = null;
                    }
                    n4 = 1;
                    continue;
                }
                if (token.kind == 13) {
                    if (ownerAndTable == null) continue;
                    string2 = null;
                    ownerAndTable.owner = ownerAndTable.table;
                    ownerAndTable.table = null;
                    n4 = 3;
                    continue;
                }
                if (token.kind != 49 || ownerAndTable == null) continue;
                string2 = token.image;
                hashtable.put(this.stripQuotes(string2), ownerAndTable);
                string2 = null;
                ownerAndTable = null;
                continue;
            }
            if (n4 != 3) continue;
            if (token.kind == 14) {
                hashtable.put(this.stripQuotes(ownerAndTable.table), ownerAndTable);
                string2 = null;
                ownerAndTable = null;
                n4 = 1;
                continue;
            }
            if (token.kind != 49) continue;
            ownerAndTable.table = token.image;
            n4 = 2;
        }
        if (ownerAndTable != null && ownerAndTable.table != null) {
            if (string2 == null) {
                string2 = ownerAndTable.table;
            }
            hashtable.put(this.stripQuotes(string2), ownerAndTable);
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.endColumn != n3 - 1 || token.endLine != n2) continue;
            for (int i = n; i >= 0; --i) {
                token = arrayList.get(i);
                if (token.kind == 13) {
                    if (vector.size() != 0) continue;
                    vector.add("");
                    continue;
                }
                if (token.kind == 49) {
                    vector.add(this.stripQuotes(token.image));
                    if (token.specialToken == null) continue;
                    break;
                }
                if (token.kind != 63) break;
                vector.add(token.image.substring(1));
                if (token.specialToken != null) break;
            }
            if (vector.size() >= 2) break;
            vector.clear();
            break;
        }
        if (vector.size() != 0) {
            if (vector.size() == 3) {
                arrayList2 = new ArrayList<TextCompletionListItem>();
                this.addColumnsToCompletionList(arrayList2, (String)vector.elementAt(2), (String)vector.elementAt(1), null, (String)vector.elementAt(0), 3);
            } else if (vector.size() == 2) {
                if (this.isSchemaName((String)vector.elementAt(1))) {
                    String string3 = (String)vector.elementAt(1);
                    String string4 = (String)vector.elementAt(0);
                    arrayList2 = new ArrayList();
                    this.addTablesToCompletionList(arrayList2, string3, string4, 1);
                    this.addProceduresToCompletionList(arrayList2, string3, string4, 1);
                } else {
                    ownerAndTable = this.resolveTableName((String)vector.elementAt(1), hashtable);
                    if (ownerAndTable != null) {
                        arrayList2 = new ArrayList();
                        boolean bl = !((String)vector.elementAt(1)).equalsIgnoreCase(ownerAndTable.table);
                        string2 = bl ? (String)vector.elementAt(1) : null;
                        this.addColumnsToCompletionList(arrayList2, ownerAndTable.owner, ownerAndTable.table, string2, (String)vector.elementAt(0));
                    }
                }
            }
        }
        if (arrayList2 != null) {
            return arrayList2;
        }
        boolean bl = this._showTables | this._showViews;
        boolean bl2 = this._showProcedures;
        boolean bl3 = this._showColumns;
        boolean bl4 = this._showBIFs;
        if (token2 != null && (bl3 || bl4)) {
            boolean bl5;
            boolean bl6 = n2 < token2.beginLine || n2 == token2.beginLine && n3 < token2.beginColumn;
            boolean bl7 = bl5 = token3 != null && (n2 > token3.endLine || n2 == token3.endLine && n3 > token3.endColumn);
            if (!bl6 && !bl5) {
                bl3 = false;
                bl4 = false;
            }
        }
        if ((string = this.getEditorText()) != null) {
            string = string.trim();
        }
        arrayList2 = new ArrayList();
        if (bl) {
            this.addTablesToCompletionList(arrayList2, null, string, 0);
        }
        if (bl2) {
            this.addProceduresToCompletionList(arrayList2, null, string, 0);
        }
        if (bl3) {
            if (hashtable.isEmpty()) {
                this.addColumnsToCompletionList(arrayList2, null, null, null, string, 0);
            } else {
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement();
                    OwnerAndTable ownerAndTable2 = hashtable.get(string5);
                    string2 = string5.equals(ownerAndTable2.table) ? null : string5;
                    this.addColumnsToCompletionList(arrayList2, ownerAndTable2.owner, ownerAndTable2.table, string2, string);
                }
            }
        }
        if (bl4) {
            this.addBIFsToCompletionList(arrayList2, string);
        }
        return arrayList2;
    }

    private ArrayList<TextCompletionListItem> buildListForUpdate(ArrayList<Token> arrayList, Point point) {
        String string;
        boolean bl;
        boolean bl2;
        Token token;
        int n;
        ArrayList<TextCompletionListItem> arrayList2 = null;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Token token7 = null;
        Object var22_10 = null;
        String string2 = null;
        int n2 = -1;
        OwnerAndTable ownerAndTable = null;
        int n3 = point.y;
        int n4 = point.x;
        Hashtable<String, OwnerAndTable> hashtable = new Hashtable<String, OwnerAndTable>();
        int n5 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.kind == 29) {
                if (token2 == null) {
                    token2 = token;
                    token3 = token;
                    n2 = 0;
                }
            } else if (token.kind == 32) {
                n5 = 3;
                token4 = token5 = token;
                n2 = 1;
            } else if (token.kind == 19) {
                n5 = 0;
                token6 = token7 = token;
                n2 = 2;
            } else if (token.kind == 21 || token.kind == 25) break;
            if (n5 == 0) {
                if (n2 == 0 && (token.kind == 31 || token.kind == 30)) {
                    if (n >= arrayList.size() - 1 || arrayList.get((int)(n + 1)).kind != 42) continue;
                    ++n;
                    continue;
                }
                if (token.kind != 49) continue;
                ownerAndTable = new OwnerAndTable(null, token.image);
                string2 = token.image;
                n5 = 1;
                continue;
            }
            if (n5 == 1) {
                if (token.kind == 14) {
                    if (ownerAndTable != null) {
                        string2 = ownerAndTable.table;
                        hashtable.put(this.stripQuotes(string2), ownerAndTable);
                        string2 = null;
                        ownerAndTable = null;
                    }
                    n5 = 0;
                    continue;
                }
                if (token.kind == 13) {
                    if (ownerAndTable == null) continue;
                    string2 = null;
                    ownerAndTable.owner = ownerAndTable.table;
                    ownerAndTable.table = null;
                    n5 = 2;
                    continue;
                }
                if (token.kind != 49 || ownerAndTable == null) continue;
                string2 = token.image;
                hashtable.put(this.stripQuotes(string2), ownerAndTable);
                string2 = null;
                ownerAndTable = null;
                continue;
            }
            if (n5 == 2) {
                if (token.kind == 14) {
                    hashtable.put(this.stripQuotes(ownerAndTable.table), ownerAndTable);
                    string2 = null;
                    ownerAndTable = null;
                    n5 = 0;
                    continue;
                }
                if (token.kind != 49) continue;
                ownerAndTable.table = token.image;
                n5 = 1;
                continue;
            }
            if (n5 != 3) continue;
            token5 = token;
        }
        if (ownerAndTable != null && ownerAndTable.table != null) {
            if (string2 == null) {
                string2 = ownerAndTable.table;
            }
            hashtable.put(this.stripQuotes(string2), ownerAndTable);
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.endColumn != n4 - 1 || token.endLine != n3) continue;
            for (int i = n; i >= 0; --i) {
                token = arrayList.get(i);
                if (token.kind == 13) {
                    if (vector.size() != 0) continue;
                    vector.add("");
                    continue;
                }
                if (token.kind == 49) {
                    vector.add(this.stripQuotes(token.image));
                    if (token.specialToken == null) continue;
                    break;
                }
                if (token.kind != 63) break;
                vector.add(token.image.substring(1));
                if (token.specialToken != null) break;
            }
            if (vector.size() >= 2) break;
            vector.clear();
            break;
        }
        if (vector.size() != 0) {
            if (vector.size() == 3) {
                arrayList2 = new ArrayList<TextCompletionListItem>();
                this.addColumnsToCompletionList(arrayList2, (String)vector.elementAt(2), (String)vector.elementAt(1), null, (String)vector.elementAt(0));
            } else if (vector.size() == 2) {
                if (this.isSchemaName((String)vector.elementAt(1))) {
                    String string3 = (String)vector.elementAt(1);
                    String string4 = (String)vector.elementAt(0);
                    arrayList2 = new ArrayList();
                    this.addTablesToCompletionList(arrayList2, string3, string4, 1);
                    this.addProceduresToCompletionList(arrayList2, string3, string4, 1);
                } else {
                    ownerAndTable = this.resolveTableName((String)vector.elementAt(1), hashtable);
                    if (ownerAndTable != null) {
                        arrayList2 = new ArrayList();
                        boolean bl3 = !((String)vector.elementAt(1)).equalsIgnoreCase(ownerAndTable.table);
                        string2 = bl3 ? (String)vector.elementAt(1) : null;
                        this.addColumnsToCompletionList(arrayList2, ownerAndTable.owner, ownerAndTable.table, string2, (String)vector.elementAt(0));
                    }
                }
            }
        }
        if (arrayList2 != null) {
            return arrayList2;
        }
        boolean bl4 = this._showTables | this._showViews;
        boolean bl5 = this._showProcedures;
        boolean bl6 = this._showColumns;
        boolean bl7 = this._showBIFs;
        int n6 = 0;
        if (token2 != null) {
            bl2 = n3 < token2.beginLine || n3 == token2.beginLine && n4 < token2.beginColumn;
            boolean bl8 = bl = token3 != null && (n3 > token3.endLine || n3 == token3.endLine && n4 > token3.endColumn);
            if (!(bl2 || bl && n2 != 0)) {
                bl6 = false;
                bl7 = false;
                bl5 = false;
            }
        }
        if (token6 != null) {
            bl2 = n3 < token6.beginLine || n3 == token6.beginLine && n4 < token6.beginColumn;
            boolean bl9 = bl = token7 != null && (n3 > token7.endLine || n3 == token7.endLine && n4 > token7.endColumn);
            if (!(bl2 || bl && n2 != 2)) {
                bl6 = false;
                bl7 = false;
            }
        }
        if (token4 != null) {
            bl2 = n3 < token4.beginLine || n3 == token4.beginLine && n4 < token4.beginColumn;
            boolean bl10 = bl = token5 != null && (n3 > token5.endLine || n3 == token5.endLine && n4 > token5.endColumn);
            if (!(bl2 || bl && n2 != 1)) {
                bl4 = false;
                bl5 = false;
                n6 = 3;
            }
        }
        if ((string = this.getEditorText()) != null) {
            string = string.trim();
        }
        arrayList2 = new ArrayList();
        if (bl4) {
            this.addTablesToCompletionList(arrayList2, null, string, 0);
        }
        if (bl5) {
            this.addProceduresToCompletionList(arrayList2, null, string, 0);
        }
        if (bl6) {
            if (hashtable.isEmpty()) {
                this.addColumnsToCompletionList(arrayList2, null, null, null, string, n6);
            } else {
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement();
                    OwnerAndTable ownerAndTable2 = hashtable.get(string5);
                    string2 = string5.equals(ownerAndTable2.table) ? null : string5;
                    this.addColumnsToCompletionList(arrayList2, ownerAndTable2.owner, ownerAndTable2.table, string2, string, n6);
                }
            }
        }
        if (bl7) {
            this.addBIFsToCompletionList(arrayList2, string);
        }
        return arrayList2;
    }

    private ArrayList<TextCompletionListItem> buildListForDelete(ArrayList<Token> arrayList, Point point) {
        String string;
        Token token;
        int n;
        ArrayList<TextCompletionListItem> arrayList2 = null;
        Token token2 = null;
        Token token3 = null;
        Object var16_6 = null;
        String string2 = null;
        int n2 = -1;
        OwnerAndTable ownerAndTable = null;
        int n3 = point.y;
        int n4 = point.x;
        Hashtable<String, OwnerAndTable> hashtable = new Hashtable<String, OwnerAndTable>();
        int n5 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (n5 == 0) {
                if (token.kind == 33 || token.kind == 30) continue;
                if (token.kind == 31) {
                    if (n >= arrayList.size() - 1 || arrayList.get((int)(n + 1)).kind != 42) continue;
                    ++n;
                    continue;
                }
                if (token.kind != 19) continue;
                n5 = 1;
                token2 = token3 = token;
                n2 = 0;
                continue;
            }
            if (token.kind == 19) {
                n5 = 1;
                if (token2 == null) {
                    token2 = token3 = token;
                }
                n2 = 0;
                continue;
            }
            if (token.kind == 21) {
                n2 = -1;
                break;
            }
            if (n5 == 1) {
                if (token.kind != 49) continue;
                ownerAndTable = new OwnerAndTable(null, token.image);
                string2 = token.image;
                n5 = 2;
                continue;
            }
            if (n5 == 2) {
                if (token.kind == 14) {
                    if (ownerAndTable != null) {
                        string2 = ownerAndTable.table;
                        hashtable.put(this.stripQuotes(string2), ownerAndTable);
                        string2 = null;
                        ownerAndTable = null;
                    }
                    n5 = 1;
                    continue;
                }
                if (token.kind == 13) {
                    string2 = null;
                    ownerAndTable.owner = ownerAndTable.table;
                    ownerAndTable.table = null;
                    n5 = 3;
                    continue;
                }
                if (token.kind != 49 || token.image.equalsIgnoreCase("AS")) continue;
                string2 = token.image;
                hashtable.put(this.stripQuotes(string2), ownerAndTable);
                string2 = null;
                ownerAndTable = null;
                n5 = 0;
                continue;
            }
            if (n5 != 3) continue;
            if (token.kind == 14) {
                hashtable.put(this.stripQuotes(ownerAndTable.table), ownerAndTable);
                string2 = null;
                ownerAndTable = null;
                n5 = 1;
                continue;
            }
            if (token.kind != 49) continue;
            ownerAndTable.table = token.image;
            n5 = 2;
        }
        if (ownerAndTable != null && ownerAndTable.table != null) {
            if (string2 == null) {
                string2 = ownerAndTable.table;
            }
            hashtable.put(this.stripQuotes(string2), ownerAndTable);
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.endColumn != n4 - 1 || token.endLine != n3) continue;
            for (int i = n; i >= 0; --i) {
                token = arrayList.get(i);
                if (token.kind == 13) {
                    if (vector.size() != 0) continue;
                    vector.add("");
                    continue;
                }
                if (token.kind == 49) {
                    vector.add(this.stripQuotes(token.image));
                    if (token.specialToken == null) continue;
                    break;
                }
                if (token.kind != 63) break;
                vector.add(token.image.substring(1));
                if (token.specialToken != null) break;
            }
            if (vector.size() >= 2) break;
            vector.clear();
            break;
        }
        if (vector.size() != 0) {
            if (vector.size() == 3) {
                arrayList2 = new ArrayList<TextCompletionListItem>();
                this.addColumnsToCompletionList(arrayList2, (String)vector.elementAt(2), (String)vector.elementAt(1), null, (String)vector.elementAt(0));
            } else if (vector.size() == 2) {
                if (this.isSchemaName((String)vector.elementAt(1))) {
                    String string3 = (String)vector.elementAt(1);
                    String string4 = (String)vector.elementAt(0);
                    arrayList2 = new ArrayList();
                    this.addTablesToCompletionList(arrayList2, string3, string4, 1);
                    this.addProceduresToCompletionList(arrayList2, string3, string4, 1);
                } else {
                    ownerAndTable = this.resolveTableName((String)vector.elementAt(1), hashtable);
                    if (ownerAndTable != null) {
                        boolean bl = !((String)vector.elementAt(1)).equalsIgnoreCase(ownerAndTable.table);
                        string2 = bl ? (String)vector.elementAt(1) : null;
                        arrayList2 = new ArrayList();
                        this.addColumnsToCompletionList(arrayList2, ownerAndTable.owner, ownerAndTable.table, string2, (String)vector.elementAt(0));
                    }
                }
            }
        }
        if (arrayList2 != null) {
            return arrayList2;
        }
        boolean bl = this._showTables | this._showViews;
        boolean bl2 = this._showProcedures;
        boolean bl3 = this._showColumns;
        boolean bl4 = this._showBIFs;
        if (token2 != null) {
            boolean bl5;
            boolean bl6 = n3 < token2.beginLine || n3 == token2.beginLine && n4 < token2.beginColumn;
            boolean bl7 = bl5 = token3 != null && (n3 > token3.endLine || n3 == token3.endLine && n4 > token3.endColumn);
            if (!(bl6 || bl5 && n2 != 0)) {
                bl3 = false;
                bl4 = false;
                bl2 = false;
            }
        }
        if ((string = this.getEditorText()) != null) {
            string = string.trim();
        }
        arrayList2 = new ArrayList();
        if (bl) {
            this.addTablesToCompletionList(arrayList2, null, string, 0);
        }
        if (bl2) {
            this.addProceduresToCompletionList(arrayList2, null, string, 0);
        }
        if (bl3) {
            if (hashtable.isEmpty()) {
                this.addColumnsToCompletionList(arrayList2, null, null, null, string);
            } else {
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string5 = enumeration.nextElement();
                    OwnerAndTable ownerAndTable2 = hashtable.get(string5);
                    string2 = string5.equals(ownerAndTable2.table) ? null : string5;
                    this.addColumnsToCompletionList(arrayList2, ownerAndTable2.owner, ownerAndTable2.table, string2, string, 0);
                }
            }
        }
        if (bl4) {
            this.addBIFsToCompletionList(arrayList2, string);
        }
        return arrayList2;
    }

    private ArrayList<TextCompletionListItem> buildListForDescribe(ArrayList<Token> arrayList, Point point) {
        Token token;
        int n;
        ArrayList<TextCompletionListItem> arrayList2 = null;
        boolean bl = true;
        boolean bl2 = true;
        int n2 = point.x;
        int n3 = point.y;
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.kind == 35 || token.kind == 37) {
                bl2 = false;
                break;
            }
            if (token.kind != 36) continue;
            bl = false;
            break;
        }
        Vector<String> vector = new Vector<String>();
        for (n = 0; n < arrayList.size(); ++n) {
            token = arrayList.get(n);
            if (token.endColumn != n2 - 1 || token.endLine != n3) continue;
            for (int i = n; i >= 0; --i) {
                token = arrayList.get(i);
                if (token.kind == 13) {
                    if (vector.size() != 0) continue;
                    vector.add("");
                    continue;
                }
                if (token.kind == 49) {
                    vector.add(this.stripQuotes(token.image));
                    if (token.specialToken == null) continue;
                    break;
                }
                if (token.kind != 63) break;
                vector.add(token.image.substring(1));
                if (token.specialToken != null) break;
            }
            if (vector.size() >= 2) break;
            vector.clear();
            break;
        }
        if (vector.size() == 2 && this.isSchemaName((String)vector.elementAt(1))) {
            String string = (String)vector.elementAt(1);
            String string2 = (String)vector.elementAt(0);
            arrayList2 = new ArrayList();
            if (bl) {
                this.addTablesToCompletionList(arrayList2, string, string2, 1);
            }
            if (bl2) {
                this.addProceduresToCompletionList(arrayList2, string, string2, 5);
            }
        }
        if (arrayList2 == null) {
            String string = this.getEditorText();
            if (string != null) {
                string = string.trim();
            }
            arrayList2 = new ArrayList<TextCompletionListItem>();
            if (bl) {
                this.addTablesToCompletionList(arrayList2, null, string, 0);
            }
            if (bl2) {
                this.addProceduresToCompletionList(arrayList2, null, string, 4);
            }
        }
        return arrayList2;
    }

    private OwnerAndTable getFromHashtable(Hashtable<String, OwnerAndTable> hashtable, String string) {
        OwnerAndTable ownerAndTable = null;
        ownerAndTable = hashtable.get(string);
        if (ownerAndTable == null) {
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (!string2.equalsIgnoreCase(string)) continue;
                ownerAndTable = hashtable.get(string2);
                break;
            }
        }
        return ownerAndTable;
    }

    private OwnerAndTable resolveTableName(String string, Hashtable<String, OwnerAndTable> hashtable) {
        OwnerAndTable ownerAndTable = null;
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            ownerAndTable = hashtable.get(string2);
            break;
        }
        return ownerAndTable;
    }

    private boolean isTableName(String string) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this._client.getTables(null, string, this._showTables, this._showViews, this._showSystemObjects, vector, vector2, vector3);
        boolean bl = this.isNameInList(string, vector2);
        return bl;
    }

    private boolean isSchemaName(String string) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        this._client.getTables(string, null, this._showTables, this._showViews, this._showSystemObjects, vector, vector2, vector3);
        boolean bl = this.isNameInList(string, vector);
        if (!bl) {
            vector.clear();
            vector2.clear();
            this._client.getProcedures(string, null, this._showSystemObjects, vector, vector2);
            bl = this.isNameInList(string, vector);
        }
        return bl;
    }

    private boolean isNameInList(String string, Vector<String> vector) {
        String string2;
        boolean bl = false;
        for (int i = 0; i < vector.size() && (string2 = vector.get(i)) != null; ++i) {
            if (!string2.equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void buildSmartListData() {
        ArrayList<Object> arrayList = null;
        Point point = this.getCaretLineAndColumn();
        ArrayList<Token> arrayList2 = this.getCurrentStatement(point);
        if (arrayList2 != null && arrayList2.size() > 0) {
            arrayList = this.buildListGivenContext(arrayList2, point);
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
            String string = this.getEditorText();
            if (string != null) {
                string = string.trim();
            }
            this.buildListData(arrayList, string);
        }
        this._smartListData = new Object[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this._smartListData[i] = arrayList.get(i);
        }
        if (arrayList.size() == 0) {
            this._smartListData = new Object[]{new NoMatchesTextCompletionListItem()};
        }
    }

    private void buildFullListData() {
        ArrayList<TextCompletionListItem> arrayList = new ArrayList<TextCompletionListItem>();
        this.buildListData(arrayList, null);
        this._fullListData = new Object[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            this._fullListData[i] = arrayList.get(i);
        }
    }

    private void buildListData(ArrayList<TextCompletionListItem> arrayList, String string) {
        String string2 = null;
        this.addTablesToCompletionList(arrayList, string2, string, 0);
        this.addProceduresToCompletionList(arrayList, string2, string, 0);
        this.addBIFsToCompletionList(arrayList, string);
        this.addColumnsToCompletionList(arrayList, string2, null, null, string);
        Collections.sort(arrayList);
    }

    private void addBIFsToCompletionList(ArrayList<TextCompletionListItem> arrayList, String string) {
        if (this._showBIFs) {
            Vector<String> vector = new Vector<String>();
            this._client.getBuiltInFunctions(string, vector);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                TextCompletionListItem textCompletionListItem = new TextCompletionListItem(6, "", vector.get(i).toString(), 0);
                arrayList.add(textCompletionListItem);
            }
        }
    }

    private void addProceduresToCompletionList(ArrayList<TextCompletionListItem> arrayList, String string, String string2, int n) {
        if (this._showProcedures) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            this._client.getProcedures(string, string2, this._showSystemObjects, vector, vector2);
            int n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                String string3 = vector.get(i) == null ? "" : vector.get(i).toString();
                String string4 = vector2.get(i).toString();
                TextCompletionListItem textCompletionListItem = new TextCompletionListItem(0, string3, string4, n);
                arrayList.add(textCompletionListItem);
            }
        }
    }

    private void addTablesToCompletionList(ArrayList<TextCompletionListItem> arrayList, String string, String string2, int n) {
        if (this._showTables | this._showViews) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            this._client.getTables(string, string2, this._showTables, this._showViews, this._showSystemObjects, vector, vector2, vector3);
            int n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                String string3 = vector.get(i) == null ? "" : vector.get(i).toString();
                String string4 = vector2.get(i).toString();
                String string5 = vector3.get(i).toString().toLowerCase();
                int n3 = string5.equals("view") ? 4 : (string5.equals("materialized view") ? 5 : (string5.equals("global temporary") ? 2 : (string5.equals("system table") ? 3 : (string5.equals("system view") ? 8 : 1))));
                TextCompletionListItem textCompletionListItem = new TextCompletionListItem(n3, string3, string4, n);
                arrayList.add(textCompletionListItem);
            }
        }
    }

    private void addColumnsToCompletionList(ArrayList<TextCompletionListItem> arrayList, String string, String string2, String string3, String string4) {
        int n = 0;
        if (string != null) {
            n = 1;
        }
        if (string2 != null) {
            n |= 2;
            n |= 1;
        }
        this.addColumnsToCompletionList(arrayList, string, string2, string3, string4, n);
    }

    private void addColumnsToCompletionList(ArrayList<TextCompletionListItem> arrayList, String string, String string2, String string3, String string4, int n) {
        if (this._showColumns) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<String> vector3 = new Vector<String>();
            Vector<String> vector4 = new Vector<String>();
            this._client.getColumns(string, string2, string4, this._showSystemObjects, vector, vector2, vector3, vector4);
            int n2 = vector3.size();
            for (int i = 0; i < n2; ++i) {
                String string5 = vector.get(i) == null ? "" : vector.get(i);
                String string6 = vector2.get(i);
                String string7 = vector3.get(i);
                ColumnTextCompletionListItem columnTextCompletionListItem = new ColumnTextCompletionListItem(string5, string6, string3, string7, vector4.get(i), n);
                arrayList.add(columnTextCompletionListItem);
            }
        }
    }

    private void setListDialogPosition() {
        try {
            Rectangle rectangle = this._editor.modelToView(this._editor.getCaretPosition());
            Font font = this._editor.getFont();
            FontMetrics fontMetrics = this._editor.getFontMetrics(font);
            rectangle.y += fontMetrics.getHeight();
            Point point = new Point(rectangle.x, rectangle.y);
            SwingUtilities.convertPointToScreen(point, this._editor);
            this._listDialog.setLocation(point);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private String getReplacableSuffix(TextCompletionListItem textCompletionListItem) {
        String string;
        boolean bl;
        String string2 = this.getQualifiedItemText(textCompletionListItem, this._list.getModel()).trim();
        int n = string2.length();
        boolean bl2 = string2.indexOf(32) != -1;
        String string3 = this.getEditorText(!bl2, !(bl = string2.indexOf(46) != -1));
        if (string3 != null) {
            int n2 = string3.length();
            string = string3;
            for (int i = n2 - 1; i >= 0; --i) {
                char c = string3.charAt(i);
                if (c == ' ' && bl2 || c == '.' && bl || !TextCompleter.isIdentifierSeparatingCharacter(c)) continue;
                string = string3.substring(i + 1);
                break;
            }
        } else {
            string = "";
        }
        return string;
    }

    private static boolean isIdentifierSeparatingCharacter(char c) {
        return !Character.isLetter(c) && !Character.isDigit(c) && c != '@' && c != '_' && c != '$' && c != '#';
    }

    private String getQualifiedItemText(TextCompletionListItem textCompletionListItem, ListModel listModel) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = textCompletionListItem.getType();
        String string = textCompletionListItem.getName();
        String string2 = textCompletionListItem.getOwner();
        String string3 = this._client.getCurrentUser();
        string2 = textCompletionListItem.getOwner();
        if (string2 != null && string2.length() != 0 && !string2.equalsIgnoreCase(string3)) {
            bl2 = true;
        }
        if (n == 7) {
            String string4 = ((ColumnTextCompletionListItem)textCompletionListItem).getTableAlias();
            if (string4 != null) {
                return string4 + "." + string;
            }
            if (bl2) {
                bl3 = true;
            } else {
                for (int i = 0; i < listModel.getSize(); ++i) {
                    TextCompletionListItem textCompletionListItem2 = (TextCompletionListItem)listModel.getElementAt(i);
                    if (textCompletionListItem == textCompletionListItem2 || textCompletionListItem2.getType() != n || !textCompletionListItem2.getName().equals(string)) continue;
                    bl3 = true;
                    break;
                }
            }
        }
        if (n == 0 || n == 1 || n == 4) {
            // empty if block
        }
        if (bl2 && !textCompletionListItem.shouldAddOwner()) {
            bl2 = false;
        }
        if (bl3 && !textCompletionListItem.shouldAddTable()) {
            bl3 = false;
        }
        boolean bl4 = bl = this._quotePrecedesText || this._quoteNames || this._quoteNextSelection;
        if (bl3) {
            String string5 = ((ColumnTextCompletionListItem)textCompletionListItem).getTableName();
            string = bl ? string5 + "\".\"" + string : string5 + "." + string;
        }
        if (bl2) {
            string = bl ? string2 + "\".\"" + string : string2 + "." + string;
        }
        if (this._quotePrecedesText) {
            string = string + "\"";
        } else if (this._quoteNames || this._quoteNextSelection) {
            string = "\"" + string + "\"";
        }
        if ((n == 6 || n == 0) && textCompletionListItem.shouldAddParentheses()) {
            string = string + "()";
        }
        return string;
    }

    private void closeCompleter(boolean bl) {
        if (this._listDialog != null) {
            TextCompletionListItem textCompletionListItem;
            this._list.removeMouseListener(this);
            this._editor.getDocument().removeDocumentListener(this);
            this._editor.removeKeyListener(this);
            this._editor.removeMouseListener(this);
            for (int i = 0; i < this._editorListeners.length; ++i) {
                this._editor.addKeyListener(this._editorListeners[i]);
            }
            this._editorListeners = null;
            Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._editor);
            if (window != null) {
                window.removeWindowListener(this);
                window.removeComponentListener(this);
            }
            if (bl && (textCompletionListItem = (TextCompletionListItem)this._list.getSelectedValue()) != null && textCompletionListItem.getType() != -1) {
                String string = this.getQualifiedItemText(textCompletionListItem, this._list.getModel());
                String string2 = this.getReplacableSuffix(textCompletionListItem);
                int n = this._editor.getCaretPosition() - (string2 == null ? 0 : string2.length());
                this._editor.moveCaretPosition(n);
                this._editor.replaceSelection(string);
            }
            this.closeCompleter();
        }
        this._quoteNextSelection = false;
        this._isClosing = false;
    }

    private void selectListItemFromEditorText() {
        String string = this.getEditorText();
        if (string != null) {
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            this._list.selectMatchFor(string);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.deferredSelectListItemFromEditorText();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.deferredSelectListItemFromEditorText();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.deferredSelectListItemFromEditorText();
    }

    private void deferredSelectListItemFromEditorText() {
        if (!this._isClosing) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TextCompleter.this._listDialog != null) {
                        TextCompleter.access$202(TextCompleter.this, null);
                        TextCompleter.this.setListData();
                        TextCompleter.this._listDialog.pack();
                        TextCompleter.this.selectListItemFromEditorText();
                    }
                }
            });
        }
    }

    private void moveListSelection(int n) {
        int n2 = this._list.getSelectedIndex() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this._list.getModel().getSize()) {
            n2 = this._list.getModel().getSize() - 1;
        }
        this._list.setSelectedIndex(n2);
        this._list.ensureIndexIsVisible(n2);
    }

    private void insertColumnList(TextCompletionListItem textCompletionListItem, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        this._client.getColumns(textCompletionListItem.getOwner(), textCompletionListItem.getName(), null, this._showSystemObjects, null, null, vector, vector2);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this._quoteNames || this._quoteNextSelection) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(vector.elementAt(i).toString());
            if (this._quoteNames || this._quoteNextSelection) {
                stringBuffer.append("\"");
            }
            if (!bl) continue;
            stringBuffer.append(" ");
            stringBuffer.append(vector2.elementAt(i).toString());
        }
        String string = this.getEditorText();
        if (string != null) {
            this._editor.moveCaretPosition(this._editor.getCaretPosition() - string.length() - (this._quotePrecedesText ? 1 : 0));
        }
        this._editor.replaceSelection(stringBuffer.toString());
    }

    private void insertParameterList(TextCompletionListItem textCompletionListItem, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this._quoteNames || this._quoteNextSelection) && !this._quotePrecedesText) {
            stringBuffer.append("\"");
        }
        stringBuffer.append(textCompletionListItem.getName());
        if (this._quoteNames || this._quoteNextSelection) {
            stringBuffer.append("\"");
        }
        stringBuffer.append("( ");
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        this._client.getParameters(textCompletionListItem.getOwner(), textCompletionListItem.getName(), vector, vector2);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            if (this._quoteNames || this._quoteNextSelection) {
                stringBuffer.append("\"");
            }
            stringBuffer.append(vector.elementAt(i).toString());
            if (this._quoteNames || this._quoteNextSelection) {
                stringBuffer.append("\"");
            }
            if (!bl) continue;
            stringBuffer.append(" ");
            stringBuffer.append(vector2.elementAt(i).toString());
        }
        stringBuffer.append(" )");
        String string = this.getEditorText();
        if (string != null) {
            this._editor.moveCaretPosition(this._editor.getCaretPosition() - string.length());
        }
        this._editor.replaceSelection(stringBuffer.toString());
    }

    private void insertBIFParameterList(TextCompletionListItem textCompletionListItem, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this._quoteNames || this._quoteNextSelection) && !this._quotePrecedesText) {
            stringBuffer.append("\"");
        }
        stringBuffer.append(textCompletionListItem.getName());
        if (this._quoteNames || this._quoteNextSelection) {
            stringBuffer.append("\"");
        }
        stringBuffer.append("()");
        String string = this.getEditorText();
        if (string != null) {
            this._editor.moveCaretPosition(this._editor.getCaretPosition() - string.length());
        }
        this._editor.replaceSelection(stringBuffer.toString());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        switch (n) {
            case 27: {
                this.closeCompleter(false);
                keyEvent.consume();
                break;
            }
            case 10: 
            case 32: {
                this.closeCompleter(true);
                keyEvent.consume();
                break;
            }
            case 38: {
                this.moveListSelection(-1);
                keyEvent.consume();
                break;
            }
            case 40: {
                this.moveListSelection(1);
                keyEvent.consume();
                break;
            }
            case 33: {
                this.moveListSelection(-this._list.getVisibleRowCount());
                keyEvent.consume();
                break;
            }
            case 34: {
                this.moveListSelection(this._list.getVisibleRowCount());
                keyEvent.consume();
                break;
            }
            case 36: {
                this.moveListSelection(-this._list.getModel().getSize());
                keyEvent.consume();
                break;
            }
            case 35: {
                this.moveListSelection(this._list.getModel().getSize());
                keyEvent.consume();
                break;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 61440: 
            case 61441: 
            case 61442: 
            case 61443: 
            case 61444: 
            case 61445: 
            case 61446: 
            case 61447: 
            case 61448: 
            case 61449: 
            case 61450: 
            case 61451: {
                keyEvent.consume();
                break;
            }
        }
        if (!keyEvent.isConsumed()) {
            int n2 = 128;
            int n3 = 832;
            if ((keyEvent.getModifiersEx() & (n2 | n3)) == n2) {
                if (n == 84 || n == 67 || n == 80 || n == 83 || n == 86 || n == 70) {
                    if (this._userTypeOverrideInEffect == n) {
                        TextCompleter.setSettings(this._settingsBeforeOverride);
                        this._userTypeOverrideInEffect = 0;
                    } else {
                        this._settingsBeforeOverride = TextCompleter.getSettings();
                        if (n == 83) {
                            this._showSystemObjects = !this._showSystemObjects;
                        } else {
                            this._showTables = n == 84;
                            this._showViews = n == 86;
                            this._showColumns = n == 67;
                            this._showProcedures = n == 80;
                            this._showBIFs = n == 70;
                            this._userTypeOverrideInEffect = n;
                        }
                    }
                    this._smartListData = null;
                    this._fullListData = null;
                    Object e = this._list.getSelectedValue();
                    this.setListData();
                    if (e != null) {
                        this._list.setSelectedValue(e, true);
                    }
                    if (this._list.getSelectedIndex() == -1) {
                        this.selectListItemFromEditorText();
                    }
                    this._listDialog.pack();
                }
                keyEvent.consume();
                return;
            }
            switch (c) {
                case '\t': {
                    this._showFullList = !this._showFullList;
                    this.setListData();
                    if (this._list.getSelectedIndex() == -1) {
                        this.selectListItemFromEditorText();
                    }
                    this._listDialog.pack();
                    keyEvent.consume();
                    break;
                }
                case '\"': {
                    this._quoteNextSelection = true;
                    this._isClosing = true;
                    keyEvent.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextCompleter.this.closeCompleter(true);
                        }
                    });
                    break;
                }
                case '*': 
                case '+': {
                    this._isClosing = true;
                    TextCompletionListItem textCompletionListItem = (TextCompletionListItem)this._list.getSelectedValue();
                    if (textCompletionListItem != null) {
                        if (textCompletionListItem.getType() == 1) {
                            this.insertColumnList(textCompletionListItem, c == '*');
                        } else if (textCompletionListItem.getType() == 0) {
                            this.insertParameterList(textCompletionListItem, c == '*');
                        } else if (textCompletionListItem.getType() == 6) {
                            this.insertBIFParameterList(textCompletionListItem, c == '*');
                        }
                    }
                    keyEvent.consume();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TextCompleter.this.closeCompleter(false);
                        }
                    });
                    break;
                }
                default: {
                    if (keyEvent.getSource() != this._list) break;
                    Document document = this._editor.getDocument();
                    try {
                        int n4 = this._editor.getCaretPosition();
                        if (c == '\b') {
                            if (n4 > 0) {
                                document.remove(n4 - 1, 1);
                            }
                        } else if (c == '\u007f') {
                            Toolkit.getDefaultToolkit().beep();
                        } else if (Character.isDefined(c)) {
                            document.insertString(n4, new String(new char[]{c}), null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    this._editor.requestFocus();
                    keyEvent.consume();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        switch (c) {
            case '\"': 
            case '*': 
            case '+': {
                keyEvent.consume();
            }
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.closeCompleter(false);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.closeCompleter(false);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.closeCompleter(false);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.closeCompleter(false);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this._listDialog != null) {
            this.setListDialogPosition();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.closeCompleter(false);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this._editor) {
            this.closeCompleter(false);
        } else if (mouseEvent.getSource() == this._list && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.closeCompleter(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static /* synthetic */ Object[] access$202(TextCompleter textCompleter, Object[] objectArray) {
        textCompleter._smartListData = objectArray;
        return objectArray;
    }

    static class NoMatchesTextCompletionListItem
    extends TextCompletionListItem {
        NoMatchesTextCompletionListItem() {
            super(-1, null, null, 0);
            TextCompleterResourcesBase textCompleterResourcesBase = TextCompleterResourcesBase.getBundle();
            this._displayText = textCompleterResourcesBase.get("EMPTY_LIST_ITEM");
        }

        @Override
        ImageIcon getIcon() {
            return null;
        }
    }

    static class ColumnTextCompletionListItem
    extends TextCompletionListItem {
        private String _tableName;
        private String _displayType;
        private String _tableAlias;

        ColumnTextCompletionListItem(String string, String string2, String string3, String string4, String string5, int n) {
            super(7, string, string4, n);
            this._tableName = string2;
            this._tableAlias = string3;
            this._displayType = string5;
            TextCompleterResourcesBase textCompleterResourcesBase = TextCompleterResourcesBase.getBundle();
            this._displayText = string3 != null ? textCompleterResourcesBase.getFormatted("OBJECT_WITH_TABLE_ALIAS_AND_TABLE_NAME", this._name, string3, string2) : (TextCompleter.getShowOwnerNames() && string != null && string.length() != 0 ? textCompleterResourcesBase.getFormatted("OBJECT_WITH_DOTTED_QUALIFIER", this._name, string, string2) : textCompleterResourcesBase.getFormatted("OBJECT_WITH_QUALIFIER", this._name, string2));
        }

        String getTableName() {
            return this._tableName;
        }

        String getDisplayType() {
            return this._displayType;
        }

        String getTableAlias() {
            return this._tableAlias;
        }
    }

    static class TextCompletionListItem
    implements Comparable<TextCompletionListItem> {
        static final int NO_MATCHES = -1;
        static final int PROCEDURE = 0;
        static final int TABLE = 1;
        static final int GLOBAL_TEMPORARY_TABLE = 2;
        static final int SYSTEM_TABLE = 3;
        static final int VIEW = 4;
        static final int MATERIALIZED_VIEW = 5;
        static final int BUILT_IN_FUNCTION = 6;
        static final int COLUMN = 7;
        static final int SYSTEM_VIEW = 8;
        static final int DONT_ADD_OWNER = 1;
        static final int DONT_ADD_TABLE = 2;
        static final int DONT_ADD_PARENTHESES = 4;
        private static ImageIcon[] _icons = null;
        private static String[] _iconTags = new String[]{"proc", "table", "gbltemptable", "table", "view", "matview", null, "column", "view"};
        protected String _owner;
        protected String _name;
        protected String _displayText;
        protected int _type;
        private int _options;

        TextCompletionListItem(int n, String string, String string2, int n2) {
            this._type = n;
            this._owner = string;
            this._name = string2;
            this._options = n2;
            if (this._type != 7) {
                if (TextCompleter.getShowOwnerNames() && string != null && string.length() != 0) {
                    TextCompleterResourcesBase textCompleterResourcesBase = TextCompleterResourcesBase.getBundle();
                    this._displayText = textCompleterResourcesBase.getFormatted("OBJECT_WITH_QUALIFIER", string2, string);
                } else {
                    this._displayText = string2;
                }
            }
            if (_icons == null) {
                _icons = new ImageIcon[_iconTags.length];
            }
        }

        ImageIcon getIcon() {
            if (_icons[this._type] == null) {
                TextCompletionListItem._icons[this._type] = this._type == 6 ? ImageLoader.getImageIcon(this.getClass(), (String)"bif16", (int)1006) : ASAComponentsImageLoader.getImageIcon(_iconTags[this._type], 1001);
            }
            return _icons[this._type];
        }

        String getDisplayText() {
            return this._displayText;
        }

        String getName() {
            return this._name;
        }

        String getOwner() {
            return this._owner;
        }

        int getType() {
            return this._type;
        }

        @Override
        public int compareTo(TextCompletionListItem textCompletionListItem) {
            TextCompletionListItem textCompletionListItem2 = textCompletionListItem;
            Collator collator = Collator.getInstance();
            String string = this.getDisplayText();
            String string2 = textCompletionListItem2.getDisplayText();
            int n = collator.compare(string, string2);
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof TextCompletionListItem) {
                return this.equals((TextCompletionListItem)object);
            }
            return false;
        }

        public boolean equals(TextCompletionListItem textCompletionListItem) {
            boolean bl = false;
            if (this._type == textCompletionListItem._type && this._owner.equals(textCompletionListItem._owner) && this._name.equals(textCompletionListItem._name)) {
                bl = true;
            }
            return bl;
        }

        boolean shouldAddOwner() {
            return (this._options & 1) == 0;
        }

        boolean shouldAddTable() {
            return (this._options & 2) == 0;
        }

        boolean shouldAddParentheses() {
            return (this._options & 4) == 0;
        }
    }

    static class TextCompletionListRenderer
    extends DefaultListCellRenderer {
        private Border _noFocusBorder = null;
        private Font _defaultFont = null;

        TextCompletionListRenderer() {
            if (this._noFocusBorder == null) {
                this._noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            }
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            TextCompletionListItem textCompletionListItem = (TextCompletionListItem)object;
            String string = textCompletionListItem.getDisplayText();
            this.setText(string);
            this.setIcon(textCompletionListItem.getIcon());
            if (string != null && string.length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = this.getFont();
                }
                if (this._defaultFont.canDisplayUpTo(string) == -1) {
                    this.setFont(this._defaultFont);
                } else {
                    FontHelper.setFontForString((Component)this, (Font)this._defaultFont, (String)string);
                }
            }
            if (textCompletionListItem instanceof NoMatchesTextCompletionListItem) {
                this.setForeground(SystemColor.textInactiveText);
                this.setBackground(jList.getBackground());
                return this;
            }
            if (bl) {
                this.setBackground(SystemColor.textHighlight);
                this.setForeground(SystemColor.textHighlightText);
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (bl2) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(this._noFocusBorder);
            }
            return this;
        }
    }

    class TextCompletionList
    extends JList
    implements ListSelectionListener {
        JToolTip _toolTip = null;
        Popup _popup = null;

        TextCompletionList(boolean bl) {
            this.setVisibleRowCount(8);
            this.setCellRenderer(new TextCompletionListRenderer());
            this.setSelectionMode(0);
            this.setFocusTraversalKeys(0, new TreeSet());
            this.setFocusTraversalKeys(1, new TreeSet());
            if (bl) {
                this._toolTip = new JToolTip();
                new FontHelper(this._toolTip);
                this.addListSelectionListener(this);
            }
        }

        void close() {
            this.hidePopup();
            this.removeListSelectionListener(this);
        }

        void selectMatchFor(String string) {
            TextCompletionListItem textCompletionListItem;
            int n = string.length();
            ListModel listModel = this.getModel();
            int n2 = listModel.getSize();
            for (int i = 0; i < n2 && !((textCompletionListItem = (TextCompletionListItem)listModel.getElementAt(i)) instanceof NoMatchesTextCompletionListItem); ++i) {
                String string2 = textCompletionListItem.getName();
                if (!string2.regionMatches(true, 0, string, 0, n)) continue;
                this.setSelectedIndex(i);
                this.ensureIndexIsVisible(i);
                break;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = Math.max(dimension.width, 170);
            return dimension;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                TextCompletionListItem textCompletionListItem = (TextCompletionListItem)this.getSelectedValue();
                this.hidePopup();
                if (textCompletionListItem != null) {
                    this._toolTip.setTipText(this.getToolTipForItem(textCompletionListItem));
                    int n = this.getSelectedIndex();
                    Rectangle rectangle = this.getCellBounds(n, n);
                    JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                    Point point = jScrollPane.getLocationOnScreen();
                    int n2 = jScrollPane.getHeight();
                    JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
                    if (jScrollBar != null) {
                        point.x += jScrollBar.getWidth();
                    }
                    int n3 = point.x + rectangle.x + rectangle.width;
                    int n4 = point.y + Math.min(n2, rectangle.y);
                    PopupFactory popupFactory = PopupFactory.getSharedInstance();
                    this._popup = popupFactory.getPopup(this, this._toolTip, n3, n4);
                    this._popup.show();
                }
            }
        }

        private void hidePopup() {
            if (this._popup != null) {
                this._popup.hide();
                this._popup = null;
            }
        }

        private String getToolTipForItem(TextCompletionListItem textCompletionListItem) {
            int n;
            StringBuilder stringBuilder;
            String string;
            TextCompleterResourcesBase textCompleterResourcesBase = TextCompleterResourcesBase.getBundle();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = textCompletionListItem.getOwner();
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            switch (textCompletionListItem.getType()) {
                case 1: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("TABLE_OWNED_BY", string2));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.get("TABLE"));
                    break;
                }
                case 2: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("GLOBAL_TEMPORARY_TABLE_OWNED_BY", string2));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.get("GLOBAL_TEMPORARY_TABLE"));
                    break;
                }
                case 3: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("SYSTEM_TABLE_OWNED_BY", string2));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.get("SYSTEM_TABLE"));
                    break;
                }
                case 8: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("SYSTEM_VIEW_OWNED_BY", string2));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.get("SYSTEM_VIEW"));
                    break;
                }
                case 4: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("VIEW_OWNED_BY", string2));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.get("VIEW"));
                    break;
                }
                case 5: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("MATERIALIZED_VIEW_OWNED_BY", string2));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.get("MATERIALIZED_VIEW"));
                    break;
                }
                case 0: {
                    string = textCompletionListItem.getName();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("PROCEDURE_OWNED_BY", string2));
                    }
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(textCompletionListItem.getName());
                    stringBuilder.append("( ");
                    arrayList2.add(stringBuilder.toString());
                    Vector<String> vector = new Vector<String>();
                    Vector<String> vector2 = new Vector<String>();
                    TextCompleter.this._client.getParameters(string2, textCompletionListItem.getName(), vector, vector2);
                    for (n = 0; n < vector.size(); ++n) {
                        stringBuilder.setLength(0);
                        stringBuilder.append("    ");
                        stringBuilder.append(vector.elementAt(n));
                        stringBuilder.append(" ");
                        stringBuilder.append(vector2.elementAt(n));
                        if (n < vector.size() - 1) {
                            stringBuilder.append(", ");
                        }
                        arrayList2.add(stringBuilder.toString());
                    }
                    arrayList2.add(")");
                    break;
                }
                case 7: {
                    ColumnTextCompletionListItem columnTextCompletionListItem = (ColumnTextCompletionListItem)textCompletionListItem;
                    string = columnTextCompletionListItem.getName() + " " + columnTextCompletionListItem.getDisplayType();
                    if (string2 != null) {
                        arrayList.add(textCompleterResourcesBase.getFormatted("COLUMN_IN_TABLE_WITH_OWNER", string2, columnTextCompletionListItem.getTableName()));
                        break;
                    }
                    arrayList.add(textCompleterResourcesBase.getFormatted("COLUMN_IN_TABLE", columnTextCompletionListItem.getTableName()));
                    break;
                }
                case 6: {
                    string = textCompletionListItem.getName() + "()";
                    break;
                }
                case -1: {
                    return null;
                }
                default: {
                    return null;
                }
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("<html><body style=\"margin:4pt\">");
            stringBuilder.append("<table border=0 cellspacing=0 cellpadding=0>");
            if (string != null) {
                stringBuilder.append("<tr><td><b>");
                stringBuilder.append(this.escapeHTML(string));
                stringBuilder.append("</b></td></tr>");
            }
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append("<tr><td>");
                stringBuilder.append(this.escapeHTML((String)arrayList.get(n)));
                stringBuilder.append("</td></tr>");
            }
            if (arrayList2.size() > 0) {
                stringBuilder.append("<tr><td><pre>");
                for (n = 0; n < arrayList2.size(); ++n) {
                    stringBuilder.append(this.escapeHTML((String)arrayList2.get(n)));
                    stringBuilder.append("\n");
                }
                stringBuilder.append("</pre></td></tr>");
            }
            stringBuilder.append("</table>");
            stringBuilder.append("</body></html>");
            return stringBuilder.toString();
        }

        private String escapeHTML(String string) {
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 50);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '&') {
                    stringBuilder.append("&amp;");
                    continue;
                }
                if (c == '<') {
                    stringBuilder.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    stringBuilder.append("&gt;");
                    continue;
                }
                if (c == '\"') {
                    stringBuilder.append("&quot;");
                    continue;
                }
                if (c == ' ') {
                    stringBuilder.append("&nbsp;");
                    continue;
                }
                if (c <= '\u007f') {
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append("&#");
                stringBuilder.append(Integer.toString(c));
                stringBuilder.append(';');
            }
            return stringBuilder.toString();
        }
    }

    static class OwnerAndTable {
        String owner;
        String table;

        OwnerAndTable(String string, String string2) {
            this.owner = string;
            this.table = string2;
        }

        public String toString() {
            String string = this.owner != null ? this.owner + "." + this.table : this.table;
            return string;
        }
    }
}

