/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.textCompleter;

import com.ianywhere.textCompleter.TextCompleterClient;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public abstract class TextCompleterAdapter
implements TextCompleterClient {
    private static String[] SA10bifs = new String[]{"abs", "acos", "argn", "ascii", "asin", "atan", "atan2", "atn2", "avg", "base64_decode", "base64_encode", "bit_and", "bit_length", "bit_or", "bit_substr", "bit_xor", "byte_length", "byte_substr", "cast", "ceiling", "char", "charindex", "char_length", "coalesce", "compare", "compress", "connection_property", "conflict", "convert", "corr", "cos", "cot", "count", "count_set_bits", "covar_pop", "covar_samp", "csconvert", "cume_dist", "datalength", "date", "dateadd", "datediff", "dateformat", "datename", "datepart", "datetime", "day", "dayname", "days", "db_extended_property", "db_id", "db_name", "db_property", "decompress", "decrypt", "degrees", "dense_rank", "difference", "dow", "encrypt", "errormsg", "estimate", "estimate_source", "event_condition", "event_condition_name", "event_parameter", "exp", "experience_estimate", "explanation", "exprtype", "floor", "get_bit", "get_identity", "getdate", "graphical_plan", "greater", "grouping", "hash", "hextoint", "hour", "hours", "html_decode", "html_encode", "http_decode", "http_encode", "http_header", "http_variable", "identity", "ifnull", "index_enabled", "index_estimate", "insertstr", "inttohex", "isdate", "isnull", "isnumeric", "lcase", "left", "length", "lesser", "list", "locate", "log", "log10", "lower", "ltrim", "max", "min", "minute", "minutes", "mod", "month", "monthname", "months", "newid", "next_connection", "next_database", "next_http_header", "next_http_variable", "now", "nullif", "number", "patindex", "percent_rank", "pi", "plan", "power", "property", "property_description", "property_name", "property_number", "quarter", "radians", "rand", "rank", "regr_avgx", "regr_avgy", "regr_count", "regr_intercept", "regr_r2", "regr_slope", "regr_sxx", "regr_sxy", "regr_syy", "remainder", "repeat", "replace", "replicate", "reverse", "rewrite", "right", "round", "row_number", "rtrim", "second", "seconds", "set_bit", "set_bits", "sign", "similar", "sin", "sortkey", "soundex", "space", "sqldialect", "sqrt", "stddev", "stddev_pop", "stddev_samp", "str", "string", "strtouuid", "stuff", "substr", "substring", "sum", "tan", "textptr", "today", "traceback", "traced_plan", "transactsql", "trim", "truncnum", "ucase", "upper", "uuidtostr", "var_pop", "var_samp", "varexists", "variance", "watcomsql", "weeks", "xmlagg", "xmlconcat", "xmlelement", "xmlforest", "xmlgen", "year", "years", "ymd"};
    private static String[] SA11bifs = new String[]{"abs", "acos", "argn", "ascii", "asin", "atan", "atan2", "atn2", "avg", "base64_decode", "base64_encode", "bit_and", "bit_length", "bit_or", "bit_substr", "bit_xor", "byte_length", "byte_substr", "cast", "ceiling", "char", "charindex", "char_length", "coalesce", "compare", "compress", "connection_extended_property", "connection_property", "conflict", "convert", "corr", "cos", "cot", "count", "count_set_bits", "covar_pop", "covar_samp", "csconvert", "cume_dist", "datalength", "date", "dateadd", "datediff", "dateformat", "datename", "datepart", "datetime", "day", "dayname", "days", "db_extended_property", "db_id", "db_name", "db_property", "decompress", "decrypt", "degrees", "dense_rank", "difference", "dow", "encrypt", "errormsg", "estimate", "estimate_source", "event_condition", "event_condition_name", "event_parameter", "exp", "experience_estimate", "explanation", "exprtype", "first_value", "floor", "get_bit", "get_identity", "getdate", "graphical_plan", "greater", "grouping", "hash", "hextoint", "hour", "hours", "html_decode", "html_encode", "http_decode", "http_encode", "http_body", "http_header", "http_variable", "identity", "ifnull", "index_estimate", "insertstr", "inttohex", "isdate", "isnull", "isnumeric", "last_value", "lcase", "left", "length", "lesser", "list", "locate", "log", "log10", "lower", "ltrim", "max", "min", "minute", "minutes", "mod", "month", "monthname", "months", "newid", "next_connection", "next_database", "next_http_header", "next_http_variable", "now", "nullif", "number", "patindex", "percent_rank", "pi", "plan", "power", "property", "property_description", "property_name", "property_number", "quarter", "radians", "rand", "rank", "read_client_file", "regex_substr", "regr_avgx", "regr_avgy", "regr_count", "regr_intercept", "regr_r2", "regr_slope", "regr_sxx", "regr_sxy", "regr_syy", "remainder", "repeat", "replace", "replicate", "reverse", "rewrite", "right", "round", "rowid", "row_number", "rtrim", "second", "seconds", "set_bit", "set_bits", "sign", "similar", "sin", "soap_header", "sortkey", "soundex", "space", "sqldialect", "sqlflagger", "sqrt", "stddev", "stddev_pop", "stddev_samp", "str", "string", "strtouuid", "stuff", "substr", "substring", "sum", "suser_id", "suser_name", "tan", "textptr", "to_char", "to_nchar", "today", "traceback", "traced_plan", "transactsql", "trim", "truncnum", "ucase", "unicode", "unistr", "upper", "user_id", "user_name", "uuidtostr", "var_pop", "var_samp", "variance", "varexists", "watcomsql", "weeks", "write_client_file", "xmlagg", "xmlconcat", "xmlelement", "xmlforest", "xmlgen", "year", "years", "ymd"};

    protected abstract Connection getConnection();

    public void destroy() {
    }

    @Override
    public void getTables(String string, String string2, boolean bl, boolean bl2, boolean bl3, Vector<String> vector, Vector<String> vector2, Vector<String> vector3) {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        if (string2 == null) {
            string2 = "%";
        } else if (string2.indexOf("%") == -1) {
            string2 = string2 + "%";
        }
        try {
            String[] stringArray;
            String string3;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ArrayList<String> arrayList = new ArrayList<String>();
            ResultSet resultSet = databaseMetaData.getTableTypes();
            while (resultSet.next()) {
                string3 = resultSet.getString(1).trim();
                if (!bl3 && string3.toLowerCase().indexOf("system") != -1 || !bl && (string3.toLowerCase().indexOf("table") != -1 || string3.toLowerCase().indexOf("global temporary") != -1 || string3.toLowerCase().indexOf("system table") != -1) || !bl2 && (string3.toLowerCase().indexOf("view") != -1 || string3.toLowerCase().indexOf("materialized view") != -1) || string3.toLowerCase().equals("text") || string3.toLowerCase().equals("partition")) continue;
                arrayList.add(string3);
            }
            resultSet.close();
            if (!arrayList.isEmpty()) {
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            } else {
                stringArray = null;
            }
            resultSet = databaseMetaData.getTables(null, string, string2, stringArray);
            while (resultSet.next()) {
                String string4 = resultSet.getString(2);
                String string5 = resultSet.getString(3);
                string3 = resultSet.getString(4);
                if (!bl3 && (string4 != null && (string4.equalsIgnoreCase("sys") || string4.equalsIgnoreCase("dbo") || string4.equalsIgnoreCase("rs_systabgroup")) || string3.startsWith("SYSTEM "))) continue;
                vector.add(string4);
                vector2.add(string5);
                vector3.add(string3);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void getProcedures(String string, String string2, boolean bl, Vector<String> vector, Vector<String> vector2) {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        if (string2 == null) {
            string2 = "%";
        } else if (string2.indexOf("%") == -1) {
            string2 = string2 + "%";
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData.supportsStoredProcedures()) {
                ResultSet resultSet = databaseMetaData.getProcedures(null, string, string2);
                while (resultSet.next()) {
                    String string3 = resultSet.getString(2);
                    String string4 = resultSet.getString(3);
                    if (!bl && (string3.equalsIgnoreCase("sys") || string3.equalsIgnoreCase("rs_systabgroup") || string3.equalsIgnoreCase("dbo"))) continue;
                    vector.add(string3);
                    vector2.add(string4);
                }
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getParameters(String string, String string2, Vector<String> vector, Vector<String> vector2) {
        ResultSet resultSet = null;
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getProcedureColumns(null, string, string2, "%");
            while (resultSet.next()) {
                short s = resultSet.getShort(5);
                if (s == 5 || s == 3 || s == 0) continue;
                vector.add(resultSet.getString(4));
                int n = resultSet.getInt(6);
                String string3 = resultSet.getString(7);
                int n2 = resultSet.getInt(8);
                int n3 = resultSet.getInt(10);
                vector2.add(this.formatDataType(n, string3, n2, n3));
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
                resultSet = null;
            }
        }
    }

    protected String formatDataType(int n, String string, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        switch (n) {
            case -3: 
            case -2: 
            case 1: 
            case 6: 
            case 12: {
                stringBuffer.append("(");
                stringBuffer.append(Integer.toString(n2));
                stringBuffer.append(")");
                break;
            }
            case 2: 
            case 3: {
                stringBuffer.append("(");
                stringBuffer.append(Integer.toString(n2));
                stringBuffer.append(",");
                stringBuffer.append(Integer.toString(n3));
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void getBuiltInFunctions(String string, Vector<String> vector) {
        int n;
        String[] stringArray = null;
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string2 = databaseMetaData.getDatabaseProductName();
            String string3 = databaseMetaData.getDatabaseProductVersion();
            if (string2.equals("SQL Anywhere") && (n = string3.indexOf(46)) > 1) {
                try {
                    int n2 = Integer.parseInt(string3.substring(0, n));
                    if (n2 >= 11) {
                        stringArray = SA11bifs;
                    } else if (n2 == 10) {
                        stringArray = SA10bifs;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (stringArray == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                this.addStringToList(arrayList, databaseMetaData.getNumericFunctions());
                this.addStringToList(arrayList, databaseMetaData.getStringFunctions());
                this.addStringToList(arrayList, databaseMetaData.getSystemFunctions());
                this.addStringToList(arrayList, databaseMetaData.getTimeDateFunctions());
                stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (string != null && !string.regionMatches(true, 0, (String)stringArray[n], 0, string.length())) continue;
                vector.add((String)stringArray[n]);
            }
        }
    }

    private void addStringToList(ArrayList<String> arrayList, String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
        }
    }

    @Override
    public void getColumns(String string, String string2, String string3, boolean bl, Vector<String> vector, Vector<String> vector2, Vector<String> vector3, Vector<String> vector4) {
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string4 = databaseMetaData.getDatabaseProductName();
            if (string == null && string2 == null && string4.equalsIgnoreCase("UltraLite")) {
                this.slow_getColumns(databaseMetaData, string, string2, string3, bl, vector, vector2, vector3, vector4);
            } else {
                this.fast_getColumns(databaseMetaData, string, string2, string3, bl, vector, vector2, vector3, vector4);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void fast_getColumns(DatabaseMetaData databaseMetaData, String string, String string2, String string3, boolean bl, Vector<String> vector, Vector<String> vector2, Vector<String> vector3, Vector<String> vector4) throws SQLException {
        if (string3 == null) {
            string3 = "%";
        } else if (!string3.endsWith("%")) {
            string3 = string3 + "%";
        }
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, string3);
        while (resultSet.next()) {
            String string4 = resultSet.getString(2);
            if (string4 != null && !bl && (string4.equalsIgnoreCase("sys") || string4.equalsIgnoreCase("dbo"))) continue;
            if (vector != null) {
                vector.add(string4);
            }
            if (vector2 != null) {
                String string5 = resultSet.getString(3);
                vector2.add(string5);
            }
            String string6 = resultSet.getString(4);
            vector3.add(string6);
            if (vector4 == null) continue;
            int n = resultSet.getInt(5);
            String string7 = resultSet.getString(6);
            int n2 = resultSet.getInt(7);
            int n3 = resultSet.getInt(9);
            vector4.add(this.formatDataType(n, string7, n2, n3));
        }
        resultSet.close();
    }

    private void slow_getColumns(DatabaseMetaData databaseMetaData, String string, String string2, String string3, boolean bl, Vector<String> vector, Vector<String> vector2, Vector<String> vector3, Vector<String> vector4) throws SQLException {
        Vector<String> vector5 = new Vector<String>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        this.getTables("", "", true, true, bl, vector5, vector6, vector7);
        int n = vector6.size();
        for (int i = 0; i < n; ++i) {
            String string4 = vector5.get(i) == null ? "" : vector5.get(i).toString();
            String string5 = vector6.get(i).toString();
            this.fast_getColumns(databaseMetaData, string4, string5, string3, bl, vector, vector2, vector3, vector4);
        }
    }

    @Override
    public String getCurrentUser() {
        String string;
        Connection connection = this.getConnection();
        if (connection == null) {
            return null;
        }
        try {
            string = connection.getMetaData().getUserName();
        }
        catch (SQLException sQLException) {
            string = null;
        }
        return string;
    }
}

