/*
 * Decompiled with CFR 0.152.
 */
package com.ianywhere.textCompleter;

import com.ianywhere.textCompleter.TextCompleter;
import com.ianywhere.textCompleter.TextCompleterResourcesBase;
import com.sybase.customization.CustomizationPage;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybMultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TextCompleterCustomizationPage
extends JPanel
implements CustomizationPage {
    private int _settings = 0;
    private JCheckBox _showTablesAndViews = null;
    private JCheckBox _showProcedures = null;
    private JCheckBox _showColumns = null;
    private JCheckBox _showBIFs = null;
    private JCheckBox _showSystemObjects = null;
    private JCheckBox _showOwnerNames = null;
    private JCheckBox _showToolTips = null;
    private JCheckBox _completeIfSingleMatch = null;
    private JCheckBox _quoteNames = null;

    public TextCompleterCustomizationPage() {
        this.createUI();
    }

    public Component getComponent() {
        return this;
    }

    public void initialize() {
        int n = TextCompleter.getSettings();
        this._showTablesAndViews.setSelected((n & 1) != 0);
        this._showProcedures.setSelected((n & 2) != 0);
        this._showColumns.setSelected((n & 4) != 0);
        this._showBIFs.setSelected((n & 8) != 0);
        this._showSystemObjects.setSelected((n & 0x10) != 0);
        this._showOwnerNames.setSelected((n & 0x80) != 0);
        this._showToolTips.setSelected((n & 0x100) != 0);
        this._completeIfSingleMatch.setSelected((n & 0x20) != 0);
        this._quoteNames.setSelected((n & 0x40) != 0);
    }

    public int getSettings() {
        int n = 0;
        if (this._showTablesAndViews.isSelected()) {
            ++n;
        }
        if (this._showProcedures.isSelected()) {
            n += 2;
        }
        if (this._showColumns.isSelected()) {
            n += 4;
        }
        if (this._showBIFs.isSelected()) {
            n += 8;
        }
        if (this._showSystemObjects.isSelected()) {
            n += 16;
        }
        if (this._showOwnerNames.isSelected()) {
            n += 128;
        }
        if (this._showToolTips.isSelected()) {
            n += 256;
        }
        if (this._completeIfSingleMatch.isSelected()) {
            n += 32;
        }
        if (this._quoteNames.isSelected()) {
            n += 64;
        }
        return n;
    }

    public boolean validateChanges() {
        return true;
    }

    public String getTitle() {
        TextCompleterResourcesBase textCompleterResourcesBase = TextCompleterResourcesBase.getBundle();
        String string = textCompleterResourcesBase.get("CUSTOMIZER_TITLE");
        return string;
    }

    public void destroy() {
        this._showTablesAndViews = null;
        this._showProcedures = null;
        this._showColumns = null;
        this._showBIFs = null;
        this._showSystemObjects = null;
        this._showOwnerNames = null;
        this._showToolTips = null;
        this._completeIfSingleMatch = null;
        this._quoteNames = null;
        DialogUtils.removeComponents((Container)this);
    }

    public void showHelp() {
        TextCompleter.updateHelpWindow("HELP_TEXT_COMPLETER_CUSTOMIZATION", SwingUtilities.windowForComponent(this), false);
    }

    private void createUI() {
        Insets insets = new Insets(0, 0, 5, 0);
        TextCompleterResourcesBase textCompleterResourcesBase = TextCompleterResourcesBase.getBundle();
        this._showTablesAndViews = new SybCheckBox(textCompleterResourcesBase.get("TABLES_AND_VIEWS"));
        this._showColumns = new SybCheckBox(textCompleterResourcesBase.get("COLUMNS"));
        this._showProcedures = new SybCheckBox(textCompleterResourcesBase.get("STORED_PROCEDURES"));
        this._showBIFs = new SybCheckBox(textCompleterResourcesBase.get("FUNCTIONS"));
        this._showSystemObjects = new SybCheckBox(textCompleterResourcesBase.get("SHOW_SYSTEM_OBJECTS"));
        this._showOwnerNames = new SybCheckBox(textCompleterResourcesBase.get("SHOW_OWNER_NAMES"));
        this._showToolTips = new SybCheckBox(textCompleterResourcesBase.get("SHOW_TOOLTIPS"));
        this._quoteNames = new SybCheckBox(textCompleterResourcesBase.get("QUOTE_IDENTIFIERS"));
        this._completeIfSingleMatch = new SybCheckBox(textCompleterResourcesBase.get("AUTOMATICALLY_COMPLETE_TEXT"));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        String string = System.getProperty("user.language");
        int n = string.equals("ja") || string.equals("ko") || string.equals("zh") ? 3 : 2;
        String string2 = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (string2 == null) {
            string2 = "+";
        }
        String string3 = KeyEvent.getKeyModifiersText(n) + string2 + KeyEvent.getKeyText(32);
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(SybMessageFormat.format((String)textCompleterResourcesBase.get("INTRODUCTION"), (Object[])new Object[]{string3}));
        this.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(textCompleterResourcesBase.get("WHAT_OBJECTS_DO_YOU_WANT")), BorderFactory.createEmptyBorder(0, 10, 0, 10)));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this._showTablesAndViews);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._showColumns);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._showProcedures);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._showBIFs);
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.add((Component)this._showSystemObjects, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.add((Component)this._showOwnerNames, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.add((Component)this._showToolTips, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.add((Component)this._quoteNames, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        this.add((Component)this._completeIfSingleMatch, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
        sybMultiLineLabel = new SybMultiLineLabel(textCompleterResourcesBase.get("ABOUT_AUTOMATICALLY_COMPLETE_TEXT"));
        this.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 8, 1, 1, 0.0, 1.0, 21, 1, insets, 0, 0));
    }
}

