/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.ConnectionComponent;
import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.InnerPanel;
import com.sybase.JGraph.PropertyListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;

abstract class AbstractGrabHandle
extends JComponent {
    protected ConnectionComponent _connectionComp;
    private Point _initialPosition;
    private InnerPanel _parent;
    private boolean _mouseOver;
    private ConnectionComponent _movingConnectionComponent;
    private Point _originalPoint;
    private Color _lineColor;
    private FocusListener _movingFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AbstractGrabHandle.this.stopKeybMoving();
        }
    };
    private PropertyListener _propertyListener = new PropertyListener(){

        @Override
        public void propertyChanged(String string) {
            if (string.equals(GraphProperties.ColorName.LINE + "")) {
                AbstractGrabHandle.this._lineColor = GraphProperties.getColor(GraphProperties.ColorName.LINE);
                AbstractGrabHandle.this.repaint();
            }
        }
    };

    public AbstractGrabHandle(ConnectionComponent connectionComponent, InnerPanel innerPanel) {
        this._connectionComp = connectionComponent;
        this._parent = innerPanel;
        Point point = this.getPosition();
        this.setBounds(AbstractGrabHandle.bounds(point));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                AbstractGrabHandle.this._mouseOver = true;
                AbstractGrabHandle.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                AbstractGrabHandle.this._mouseOver = false;
                AbstractGrabHandle.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    AbstractGrabHandle.this._initialPosition = mouseEvent.getPoint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                AbstractGrabHandle.this.setCursor(null);
                if (mouseEvent.getButton() == 1) {
                    AbstractGrabHandle.this._initialPosition = null;
                } else if (mouseEvent.isPopupTrigger()) {
                    AbstractGrabHandle.this._connectionComp.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (AbstractGrabHandle.this._initialPosition != null) {
                    Component component = (Component)mouseEvent.getSource();
                    AbstractGrabHandle.this.setCursor(((AbstractGrabHandle)AbstractGrabHandle.this)._parent._movingCursor);
                    int n = InnerPanel.SELECTION_GRAB_HANDLE_WIDTH;
                    Point point = component.getLocation();
                    int n2 = (int)point.getX() + n;
                    int n3 = (int)point.getY() + n;
                    Point point2 = new Point(n2, n3);
                    int n4 = (int)point2.getX() + mouseEvent.getX() - (int)AbstractGrabHandle.this._initialPosition.getX();
                    int n5 = (int)point2.getY() + mouseEvent.getY() - (int)AbstractGrabHandle.this._initialPosition.getY();
                    Point point3 = new Point(n4, n5);
                    AbstractGrabHandle.this.changePosition(point3);
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (AbstractGrabHandle.this._movingConnectionComponent != null) {
                    Point point = AbstractGrabHandle.this.getPosition();
                    int n = (int)point.getX();
                    int n2 = (int)point.getY();
                    Point point2 = null;
                    switch (keyEvent.getKeyCode()) {
                        case 27: {
                            AbstractGrabHandle.this.cancelKeybMoving();
                            AbstractGrabHandle.this._parent.requestFocus();
                            break;
                        }
                        case 10: {
                            AbstractGrabHandle.this.stopKeybMoving();
                            AbstractGrabHandle.this._parent.requestFocus();
                            break;
                        }
                        case 37: {
                            int n3;
                            if (keyEvent.isShiftDown()) {
                                n3 = 1;
                            } else {
                                AbstractGrabHandle.this._parent;
                                n3 = InnerPanel.MOVE_INCREMENT;
                            }
                            point2 = new Point(n -= n3, n2);
                            break;
                        }
                        case 39: {
                            int n4;
                            if (keyEvent.isShiftDown()) {
                                n4 = 1;
                            } else {
                                AbstractGrabHandle.this._parent;
                                n4 = InnerPanel.MOVE_INCREMENT;
                            }
                            point2 = new Point(n += n4, n2);
                            break;
                        }
                        case 38: {
                            int n5;
                            if (keyEvent.isShiftDown()) {
                                n5 = 1;
                            } else {
                                AbstractGrabHandle.this._parent;
                                n5 = InnerPanel.MOVE_INCREMENT;
                            }
                            point2 = new Point(n, n2 -= n5);
                            break;
                        }
                        case 40: {
                            int n6;
                            if (keyEvent.isShiftDown()) {
                                n6 = 1;
                            } else {
                                AbstractGrabHandle.this._parent;
                                n6 = InnerPanel.MOVE_INCREMENT;
                            }
                            point2 = new Point(n, n2 += n6);
                        }
                    }
                    if (point2 != null) {
                        AbstractGrabHandle.this.changePosition(point2);
                        keyEvent.consume();
                    }
                }
            }
        });
        this.addKeyListener(this._parent._functionKeyHandler);
        this._lineColor = GraphProperties.getColor(GraphProperties.ColorName.LINE);
        GraphProperties.addPropertyListener(this._propertyListener);
    }

    public void destroy() {
        GraphProperties.removePropertyListener(this._propertyListener);
    }

    public void startKeybMoving(ConnectionComponent connectionComponent) {
        this._movingConnectionComponent = connectionComponent;
        if (this._movingConnectionComponent != null) {
            this._originalPoint = this.getPosition();
            this.requestFocus();
            this._parent.startAnchorMoving();
            this.addFocusListener(this._movingFocusListener);
        }
    }

    private void stopKeybMoving() {
        if (this._movingConnectionComponent != null) {
            this.removeFocusListener(this._movingFocusListener);
        }
        this._movingConnectionComponent = null;
        this._originalPoint = null;
        this._parent.stopAnchorMoving();
    }

    private void cancelKeybMoving() {
        if (this._movingConnectionComponent != null) {
            this.changePosition(this._originalPoint);
        }
        this.stopKeybMoving();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this._lineColor);
        if (this._mouseOver) {
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            int n = InnerPanel.SELECTION_GRAB_HANDLE_WIDTH;
            graphics.fillRect(n / 2, n / 2, n, n);
        }
    }

    protected abstract Point getPosition();

    protected abstract void setPosition(Point var1);

    private void changePosition(Point point) {
        int n = InnerPanel.SELECTION_GRAB_HANDLE_WIDTH;
        this.setPosition(point);
        Point point2 = this.getPosition();
        int n2 = (int)point2.getX() - n;
        int n3 = (int)point2.getY() - n;
        this.setLocation(new Point(n2, n3));
        this._parent.repaint();
    }

    private static Rectangle bounds(Point point) {
        int n = InnerPanel.SELECTION_GRAB_HANDLE_WIDTH * 2;
        int n2 = (int)point.getX() - (int)Math.floor((double)n / 2.0);
        int n3 = (int)point.getY() - (int)Math.floor((double)n / 2.0);
        return new Rectangle(n2, n3, n, n);
    }
}

