/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.AbstractNodeComponent;
import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.Node;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractJTableNodeComponent
extends AbstractNodeComponent {
    public static int MIN_WIDTH = 100;
    public static int MIN_HEIGHT = 20;
    public static int MAX_WIDTH = 300;
    public static int MAX_HEIGHT = 150;
    public JScrollPane scrollPane;
    public JTable table;
    public JLabel label = new JLabel();
    public static Set<KeyStroke> FORWARD_TRAVERSAL_KEYSTROKES = new TreeSet<KeyStroke>();
    public static Set<KeyStroke> BACKWARD_TRAVERSAL_KEYSTROKES;

    public AbstractJTableNodeComponent(Node node) {
        super(node);
        this.label.setHorizontalAlignment(0);
        UIDefaults uIDefaults = UIManager.getDefaults();
        Object object = uIDefaults.get("InternalFrame.titleFont");
        if (object instanceof Font) {
            this.label.setFont((Font)object);
        }
        this.table = new JTable();
        this.table.setFocusTraversalKeys(0, FORWARD_TRAVERSAL_KEYSTROKES);
        this.table.setFocusTraversalKeys(1, BACKWARD_TRAVERSAL_KEYSTROKES);
        this.table.setTableHeader(null);
        this.table.setShowGrid(true);
        this.scrollPane = new JScrollPane(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "North");
        this.add((Component)this.scrollPane, "Center");
        this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.NODE_TEXT));
        this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
    }

    public void setFullJTableColumnWidths() {
        Dimension dimension = this.table.getPreferredSize();
        Dimension dimension2 = this.label.getPreferredSize();
        this._preferredSize = new Dimension(Math.min(dimension.width + 20, MAX_WIDTH), Math.min(dimension.height + dimension2.height + 10, MAX_HEIGHT));
        this._minSize = new Dimension(MIN_WIDTH, MIN_HEIGHT);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = this.table.getModel().getColumnCount();
        int n2 = this.table.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(0, i);
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                tableCellRenderer = this.table.getCellRenderer(j, i);
                Object object = this.table.getModel().getValueAt(j, i);
                if (object == null && j >= this.table.getRowCount()) break;
                int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this.table, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n3 = Math.max(n3, n4);
            }
            tableColumn.setPreferredWidth(n3 + 5);
        }
        this.table.setAutoResizeMode(0);
        this._preferredSize = new Dimension(Math.min(this.table.getPreferredSize().width + 25, MAX_WIDTH), Math.min(this.table.getPreferredSize().height + dimension2.height + 15, MAX_HEIGHT));
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.label != null) {
            this.label.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.label != null) {
            this.label.setBackground(color);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.scrollPane = null;
        if (this.table != null && this.table.getColumnModel().getColumnCount() > 0) {
            this.table.getColumnModel().getColumn(0).setCellRenderer(null);
        }
        this.table = null;
        this.label = null;
    }

    @Override
    protected void userObjectUpdated(Object object) {
    }

    static {
        FORWARD_TRAVERSAL_KEYSTROKES.add(KeyStroke.getKeyStroke(9, 0));
        BACKWARD_TRAVERSAL_KEYSTROKES = new TreeSet<KeyStroke>();
        BACKWARD_TRAVERSAL_KEYSTROKES.add(KeyStroke.getKeyStroke(9, 1));
    }
}

