/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.ModelEvent;
import com.sybase.JGraph.Node;
import com.sybase.JGraph.NodeComponent;
import com.sybase.JGraph.NodeComponentListener;
import com.sybase.JGraph.PropertyListener;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;

public abstract class AbstractNodeComponent
extends JPanel
implements NodeComponent {
    protected boolean isDestroyed;
    protected static final int MIN_WIDTH = 10;
    protected static final int MIN_HEIGHT = 10;
    protected Node _associatedNode;
    protected Dimension _preferredSize;
    protected Dimension _minSize;
    protected boolean _selected;
    protected JPopupMenu _popupMenu;
    private ArrayList<MouseListener> _mouseListeners = new ArrayList(2);
    private ArrayList<MouseMotionListener> _mouseMotionListeners = new ArrayList(2);
    private EventListenerList _listenerList = new EventListenerList();
    private EventListenerList _focusListenerList = new EventListenerList();
    private PropertyListener _propertyListener = new PropertyListener(){

        @Override
        public void propertyChanged(String string) {
            if (string.equals(GraphProperties.ColorName.NODE_BG + "") && !AbstractNodeComponent.this._selected) {
                AbstractNodeComponent.this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
            } else if (string.equals(GraphProperties.ColorName.SELECTED_BG + "") && AbstractNodeComponent.this._selected) {
                AbstractNodeComponent.this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.SELECTED_BG));
            } else if (string.equals(GraphProperties.ColorName.NODE_TEXT + "") && !AbstractNodeComponent.this._selected) {
                AbstractNodeComponent.this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.NODE_TEXT));
            } else if (string.equals(GraphProperties.ColorName.SELECTED_TEXT + "") && AbstractNodeComponent.this._selected) {
                AbstractNodeComponent.this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.SELECTED_TEXT));
            } else if (string.equals(GraphProperties.ColorName.LINE + "")) {
                AbstractNodeComponent.this.setBorder(BorderFactory.createLineBorder(GraphProperties.getColor(GraphProperties.ColorName.LINE)));
            }
        }
    };
    private ComponentListener _componentListener = new ComponentAdapter(){

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            AbstractNodeComponent.this.fireBoundsChanged();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            AbstractNodeComponent.this.boundsChanged();
            AbstractNodeComponent.this.fireBoundsChanged();
        }
    };
    private FocusListener _focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            AbstractNodeComponent.this.fireFocusGained();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            AbstractNodeComponent.this.fireFocusLost();
        }
    };

    public AbstractNodeComponent(Node node) {
        this._associatedNode = node;
        this._preferredSize = super.getPreferredSize();
        if (this._associatedNode != null) {
            this._associatedNode.addNodeListener(this);
        }
        this.setOpaque(true);
        this.addComponentListener(this._componentListener);
        this.addFocusListener(this._focusListener);
        this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
        this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.NODE_TEXT));
        this.setBorder(BorderFactory.createLineBorder(GraphProperties.getColor(GraphProperties.ColorName.LINE)));
        GraphProperties.addPropertyListener(this._propertyListener);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public Node getAssociatedNode() {
        return this._associatedNode;
    }

    @Override
    public Dimension getPreferredSize() {
        return this._preferredSize;
    }

    @Override
    public Dimension getMinSize() {
        return this._minSize;
    }

    @Override
    public void setSelected(boolean bl) {
        if (!this.isDestroyed) {
            this._selected = bl;
            if (bl) {
                this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.SELECTED_BG));
                this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.SELECTED_TEXT));
            } else {
                this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
                this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.NODE_TEXT));
            }
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void setPopup(JPopupMenu jPopupMenu) {
        this._popupMenu = jPopupMenu;
    }

    @Override
    public void showPopup(Component component, int n, int n2) {
        UIUtils.showJPopupMenu((JPopupMenu)this._popupMenu, (JComponent)((JComponent)component), (Point)new Point(n + 15, n2 + 15));
    }

    @Override
    public void disableMouseListeners() {
        int n;
        this._mouseListeners.addAll(Arrays.asList(this.getMouseListeners()));
        this._mouseMotionListeners.addAll(Arrays.asList(this.getMouseMotionListeners()));
        for (n = 0; n < this._mouseListeners.size(); ++n) {
            this.removeMouseListener(this._mouseListeners.get(n));
        }
        for (n = 0; n < this._mouseMotionListeners.size(); ++n) {
            this.removeMouseMotionListener(this._mouseMotionListeners.get(n));
        }
    }

    @Override
    public void reenableMouseListeners() {
        int n;
        for (n = 0; n < this._mouseListeners.size(); ++n) {
            this.addMouseListener(this._mouseListeners.get(n));
        }
        for (n = 0; n < this._mouseMotionListeners.size(); ++n) {
            this.addMouseMotionListener(this._mouseMotionListeners.get(n));
        }
        this._mouseListeners.clear();
        this._mouseMotionListeners.clear();
    }

    @Override
    public void addBoundListener(NodeComponentListener nodeComponentListener) {
        this._listenerList.add(NodeComponentListener.class, nodeComponentListener);
    }

    @Override
    public void removeBoundListener(NodeComponentListener nodeComponentListener) {
        if (this._listenerList != null) {
            this._listenerList.remove(NodeComponentListener.class, nodeComponentListener);
        }
    }

    @Override
    public void addFocusListener(NodeComponentListener nodeComponentListener) {
        this._focusListenerList.add(NodeComponentListener.class, nodeComponentListener);
    }

    @Override
    public void removeFocusListener(NodeComponentListener nodeComponentListener) {
        if (this._focusListenerList != null) {
            this._focusListenerList.remove(NodeComponentListener.class, nodeComponentListener);
        }
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void destroy() {
        if (!this.isDestroyed) {
            int n;
            this.isDestroyed = true;
            Object[] objectArray = this._listenerList.getListenerList();
            for (n = objectArray.length - 2; n >= 0; n -= 2) {
                this.removeBoundListener((NodeComponentListener)objectArray[n + 1]);
            }
            objectArray = this._focusListenerList.getListenerList();
            for (n = objectArray.length - 2; n >= 0; n -= 2) {
                this.removeFocusListener((NodeComponentListener)objectArray[n + 1]);
            }
            if (this._associatedNode != null) {
                this._associatedNode.removeNodeListener(this);
            }
            GraphProperties.removePropertyListener(this._propertyListener);
            this.removeComponentListener(this._componentListener);
            this.removeFocusListener(this._focusListener);
            this._mouseMotionListeners.clear();
            this._mouseListeners.clear();
            this._listenerList = null;
            this._focusListenerList = null;
            this._mouseMotionListeners = null;
            this._mouseListeners = null;
            this._propertyListener = null;
            this._componentListener = null;
            this._focusListener = null;
            this._associatedNode = null;
            this._popupMenu = null;
            this._minSize = null;
            this._preferredSize = null;
        }
    }

    @Override
    public void nodeChanged(ModelEvent modelEvent) {
        this.userObjectUpdated(((Node)modelEvent.getSource()).getUserObject());
        this.repaint();
    }

    protected void boundsChanged() {
        this.validateTree();
    }

    protected abstract void userObjectUpdated(Object var1);

    private void fireBoundsChanged() {
        Object[] objectArray = this._listenerList.getListenerList();
        EventObject eventObject = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeComponentListener.class) continue;
            if (eventObject == null) {
                eventObject = new EventObject(this);
            }
            ((NodeComponentListener)objectArray[i + 1]).boundsChanged(eventObject);
        }
    }

    private void fireFocusGained() {
        Object[] objectArray = this._focusListenerList.getListenerList();
        EventObject eventObject = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeComponentListener.class) continue;
            if (eventObject == null) {
                eventObject = new EventObject(this);
            }
            ((NodeComponentListener)objectArray[i + 1]).focusGained(eventObject);
        }
    }

    private void fireFocusLost() {
        Object[] objectArray = this._focusListenerList.getListenerList();
        EventObject eventObject = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeComponentListener.class) continue;
            if (eventObject == null) {
                eventObject = new EventObject(this);
            }
            ((NodeComponentListener)objectArray[i + 1]).focusLost(eventObject);
        }
    }
}

