/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.AbstractJTableNodeComponent;
import com.sybase.JGraph.DbColumnProperties;
import com.sybase.JGraph.DbTableProperties;
import com.sybase.JGraph.JGraphImageLoader;
import com.sybase.JGraph.Node;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class DbNodeComponent
extends AbstractJTableNodeComponent {
    public DbNodeComponent(Node node) {
        super(node);
        this.setToolTipText(((DbTableProperties)node.getUserObject()).getToolTipString());
        this.label.setText(((DbTableProperties)node.getUserObject()).getName());
        DbColumnProperties[] dbColumnPropertiesArray = ((DbTableProperties)node.getUserObject()).getDbColumnProperties();
        if (dbColumnPropertiesArray != null) {
            DefaultTableModel defaultTableModel = new DefaultTableModel(dbColumnPropertiesArray.length, 2){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            for (int i = 0; i < dbColumnPropertiesArray.length; ++i) {
                defaultTableModel.setValueAt(dbColumnPropertiesArray[i], i, 0);
                defaultTableModel.setValueAt(dbColumnPropertiesArray[i].getType(), i, 1);
            }
            this.table.setModel(defaultTableModel);
            this.table.getColumnModel().getColumn(0).setCellRenderer(new PKeyCellRenderer());
        }
        this.setFullJTableColumnWidths();
    }

    static final class PKeyCellRenderer
    extends DefaultTableCellRenderer {
        PKeyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null && object instanceof DbColumnProperties) {
                DbColumnProperties dbColumnProperties = (DbColumnProperties)object;
                if (dbColumnProperties.isInPrimaryKey()) {
                    this.setIcon(JGraphImageLoader.getImageIcon("pkey", 1001));
                } else {
                    this.setIcon(null);
                }
                this.setText(dbColumnProperties.getName());
            }
            return this;
        }
    }
}

