/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ConnectionListener;
import com.sybase.JGraph.ModelEvent;
import com.sybase.JGraph.Node;
import javax.swing.event.EventListenerList;

class DefaultConnection
implements Connection {
    protected boolean isDestroyed;
    protected Node _origin;
    protected Node _destination;
    protected Object _userObject;
    boolean _editable;
    protected EventListenerList _listenerList = new EventListenerList();

    DefaultConnection(Node node, Node node2) {
        this._origin = node;
        this._destination = node2;
    }

    DefaultConnection(Node node, Node node2, Object object) {
        this._origin = node;
        this._destination = node2;
        this._userObject = object;
    }

    @Override
    public void destroy() {
        if (!this.isDestroyed) {
            this.isDestroyed = true;
            Object[] objectArray = this._listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                this.removeConnectionListener((ConnectionListener)objectArray[i + 1]);
            }
            this._userObject = null;
            this._listenerList = null;
        }
    }

    public String toString() {
        return "'" + this._userObject + "' connection from " + this._origin + " to " + this._destination;
    }

    @Override
    public Node getOrigin() {
        return this._origin;
    }

    @Override
    public Node getDestination() {
        return this._destination;
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    @Override
    public Object getUserObject() {
        return this._userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this._userObject = object;
        this.fireConnectionChanged();
    }

    @Override
    public boolean isLoop() {
        return this._origin == this._destination;
    }

    @Override
    public String getUniqueID() {
        return this._userObject.toString();
    }

    @Override
    public void addConnectionListener(ConnectionListener connectionListener) {
        this._listenerList.add(ConnectionListener.class, connectionListener);
    }

    @Override
    public void removeConnectionListener(ConnectionListener connectionListener) {
        if (this._listenerList != null) {
            this._listenerList.remove(ConnectionListener.class, connectionListener);
        }
    }

    private void fireConnectionChanged() {
        Object[] objectArray = this._listenerList.getListenerList();
        ModelEvent modelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionListener.class) continue;
            if (modelEvent == null) {
                modelEvent = new ModelEvent(this);
            }
            ((ConnectionListener)objectArray[i + 1]).connectionChanged(modelEvent);
        }
    }
}

