/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ConnectionComponent;
import com.sybase.JGraph.ConnectionComponentListener;
import com.sybase.JGraph.ConnectionListener;
import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.ModelEvent;
import com.sybase.JGraph.NodeComponent;
import com.sybase.JGraph.PropertyListener;
import com.sybase.JGraph.Side;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public class DefaultConnectionComponent
implements ConnectionComponent {
    private boolean isDestroyed;
    private boolean _isOriginArrowDrawn = false;
    static double CONNECTION_ARROW_LENGTH = 10.0;
    static double CONNECTION_ARROW_WIDTH = 10.0;
    protected Connection _connection;
    protected Component _originComp;
    protected Component _destComp;
    protected Point _originPosition;
    protected Point _destPosition;
    protected Line2D.Double _line;
    protected Ellipse2D.Double _ellipse;
    protected Polygon _arrowHead1;
    protected Polygon _arrowHead2;
    protected Point _arrowTip1;
    protected JPopupMenu _popupMenu;
    protected JLabel _label;
    private ConnectionListener _listener = new ConnectionListener(){

        @Override
        public void connectionChanged(ModelEvent modelEvent) {
            DefaultConnectionComponent.this._label.setText(DefaultConnectionComponent.this._connection.getUserObject() + "");
            DefaultConnectionComponent.this.refreshLabel();
        }
    };
    private PropertyListener _propertyListener = new PropertyListener(){

        @Override
        public void propertyChanged(String string) {
            if (string.equals(GraphProperties.ColorName.BG + "")) {
                DefaultConnectionComponent.this._label.setBackground(GraphProperties.getColor(GraphProperties.ColorName.BG));
            } else if (string.equals(GraphProperties.ColorName.TEXT + "")) {
                DefaultConnectionComponent.this._label.setForeground(GraphProperties.getColor(GraphProperties.ColorName.TEXT));
            }
        }
    };
    private FocusListener _focusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent focusEvent) {
            DefaultConnectionComponent.this.fireFocusGained();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            DefaultConnectionComponent.this.fireFocusLost();
        }
    };
    protected EventListenerList _listenerList = new EventListenerList();
    private EventListenerList _focusListenerList = new EventListenerList();
    static final Font BOLD_LABEL_FONT = UIManager.getDefaults().getFont("InternalFrame.titleFont");
    static final Font LABEL_FONT = UIManager.getDefaults().getFont("Label.font");

    public DefaultConnectionComponent(Connection connection, Component component, Component component2) {
        this._connection = connection;
        this._originComp = component;
        this._destComp = component2;
        this.initializeAnchors();
        ((NodeComponent)((Object)this._originComp)).addBoundListener(this);
        ((NodeComponent)((Object)this._destComp)).addBoundListener(this);
        this._label = new JLabel(connection.getUserObject() + ""){

            @Override
            public boolean isFocusable() {
                return true;
            }
        };
        this._label.addFocusListener(this._focusListener);
        this._label.setOpaque(true);
        this._label.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
        this._label.setForeground(GraphProperties.getColor(GraphProperties.ColorName.TEXT));
        this._label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(GraphProperties.getColor(GraphProperties.ColorName.TEXT), 1), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.setShape();
        this._connection.addConnectionListener(this._listener);
        GraphProperties.addPropertyListener(this._propertyListener);
    }

    public String toString() {
        return "'" + this._label.getText() + "' connection component";
    }

    @Override
    public Connection getAssociatedConnection() {
        return this._connection;
    }

    @Override
    public Line2D getLine() {
        return this._line;
    }

    @Override
    public Ellipse2D getEllipse() {
        return this._ellipse;
    }

    @Override
    public Polygon getArrowHead1() {
        return this._arrowHead1;
    }

    @Override
    public Polygon getArrowHead2() {
        return this._arrowHead2;
    }

    @Override
    public Point2D getArrowTip1() {
        return new Point2D.Double((int)this._arrowTip1.getX(), (int)this._arrowTip1.getY());
    }

    @Override
    public JComponent getJComponent() {
        return this._label;
    }

    @Override
    public Point getAbsOriginPosition() {
        int n = this._originComp.getX() + (int)this._originPosition.getX();
        int n2 = this._originComp.getY() + (int)this._originPosition.getY();
        return new Point(n, n2);
    }

    @Override
    public Point getAbsDestPosition() {
        int n = this._destComp.getX() + (int)this._destPosition.getX();
        int n2 = this._destComp.getY() + (int)this._destPosition.getY();
        return new Point(n, n2);
    }

    @Override
    public Point getRelOriginPosition() {
        return this._originPosition;
    }

    @Override
    public Point getRelDestPosition() {
        return this._destPosition;
    }

    @Override
    public void setAbsOriginPosition(Point point) {
        int n = (int)point.getX() - this._originComp.getX();
        int n2 = (int)point.getY() - this._originComp.getY();
        this.setRelOriginPosition(new Point(n, n2));
    }

    @Override
    public void setAbsDestPosition(Point point) {
        int n = (int)point.getX() - this._destComp.getX();
        int n2 = (int)point.getY() - this._destComp.getY();
        this.setRelDestPosition(new Point(n, n2));
    }

    @Override
    public void setRelOriginPosition(Point point) {
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        int n3 = this._originComp.getWidth();
        int n4 = this._originComp.getHeight();
        if (n >= 0 && n2 >= 0 && n < n3 && n2 < n4) {
            this._originPosition = point;
        }
        this.setShape();
        this.fireAnchorsChanged();
    }

    @Override
    public void setRelDestPosition(Point point) {
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        int n3 = this._destComp.getWidth();
        int n4 = this._destComp.getHeight();
        if (n >= 0 && n2 >= 0 && n < n3 && n2 < n4) {
            this._destPosition = point;
        }
        this.setShape();
        this.fireAnchorsChanged();
    }

    @Override
    public void setSelected(boolean bl) {
        if (!this.isDestroyed) {
            if (bl) {
                if (BOLD_LABEL_FONT != null) {
                    this._label.setFont(BOLD_LABEL_FONT);
                }
                this._label.setBackground(GraphProperties.getColor(GraphProperties.ColorName.SELECTED_BG));
                this._label.setForeground(GraphProperties.getColor(GraphProperties.ColorName.SELECTED_TEXT));
            } else {
                if (LABEL_FONT != null) {
                    this._label.setFont(LABEL_FONT);
                }
                this._label.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
                this._label.setForeground(GraphProperties.getColor(GraphProperties.ColorName.TEXT));
            }
            this.refreshLabel();
        }
    }

    @Override
    public void open() {
    }

    @Override
    public void setPopup(JPopupMenu jPopupMenu) {
        this._popupMenu = jPopupMenu;
    }

    @Override
    public void showPopup(Component component, int n, int n2) {
        UIUtils.showJPopupMenu((JPopupMenu)this._popupMenu, (JComponent)((JComponent)component), (Point)new Point(n + 15, n2 + 15));
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this._label.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this._label.removeMouseListener(mouseListener);
    }

    @Override
    public void addAnchorListener(ConnectionComponentListener connectionComponentListener) {
        this._listenerList.add(ConnectionComponentListener.class, connectionComponentListener);
    }

    @Override
    public void removeAnchorListener(ConnectionComponentListener connectionComponentListener) {
        if (this._listenerList != null) {
            this._listenerList.remove(ConnectionComponentListener.class, connectionComponentListener);
        }
    }

    @Override
    public void addFocusListener(ConnectionComponentListener connectionComponentListener) {
        this._focusListenerList.add(ConnectionComponentListener.class, connectionComponentListener);
    }

    @Override
    public void removeFocusListener(ConnectionComponentListener connectionComponentListener) {
        if (this._focusListenerList != null) {
            this._focusListenerList.remove(ConnectionComponentListener.class, connectionComponentListener);
        }
    }

    @Override
    public void destroy() {
        if (!this.isDestroyed) {
            int n;
            this.isDestroyed = true;
            this._connection.removeConnectionListener(this._listener);
            GraphProperties.removePropertyListener(this._propertyListener);
            ((NodeComponent)((Object)this._originComp)).removeBoundListener(this);
            ((NodeComponent)((Object)this._destComp)).removeBoundListener(this);
            Object[] objectArray = this._listenerList.getListenerList();
            for (n = objectArray.length - 2; n >= 0; n -= 2) {
                this.removeAnchorListener((ConnectionComponentListener)objectArray[n + 1]);
            }
            objectArray = this._focusListenerList.getListenerList();
            for (n = objectArray.length - 2; n >= 0; n -= 2) {
                this.removeFocusListener((ConnectionComponentListener)objectArray[n + 1]);
            }
            this._label.removeFocusListener(this._focusListener);
            this._listenerList = null;
            this._focusListenerList = null;
            this._label = null;
            this._popupMenu = null;
            this._arrowTip1 = null;
            this._arrowHead1 = null;
            this._arrowHead2 = null;
            this._line = null;
            this._ellipse = null;
            this._connection = null;
            this._originComp = null;
            this._destComp = null;
            this._originPosition = null;
            this._destPosition = null;
            this._listener = null;
            this._propertyListener = null;
        }
    }

    @Override
    public void boundsChanged(EventObject eventObject) {
        int n = (int)this._originPosition.getX();
        int n2 = (int)this._originPosition.getY();
        if (n >= this._originComp.getWidth() || n2 >= this._originComp.getHeight()) {
            this._originPosition = this.defaultAnchorPosition(this._originComp);
        }
        int n3 = (int)this._destPosition.getX();
        int n4 = (int)this._destPosition.getY();
        if (n3 >= this._destComp.getWidth() || n4 >= this._destComp.getHeight()) {
            this._destPosition = this.defaultAnchorPosition(this._destComp);
        }
        this.setShape();
    }

    @Override
    public void focusGained(EventObject eventObject) {
    }

    @Override
    public void focusLost(EventObject eventObject) {
    }

    protected void setShape() {
        if (this._connection.isLoop()) {
            this._line = null;
            Point point = null;
            double d = 0.0;
            double d2 = 0.0;
            d = this._originPosition.getX() < (double)(this._originComp.getWidth() / 2) ? (double)this._originComp.getX() : (double)(this._originComp.getX() + this._originComp.getWidth());
            d2 = this._originPosition.getY() < (double)(this._originComp.getHeight() / 2) ? (double)this._originComp.getY() : (double)(this._originComp.getY() + this._originComp.getHeight());
            point = new Point((int)d, (int)d2);
            d = this._destPosition.getX() + (double)this._destComp.getX();
            d2 = this._destPosition.getY() + (double)this._destComp.getY();
            double d3 = point.getX() - Math.abs(point.getX() - d);
            double d4 = point.getY() - Math.abs(point.getY() - d2);
            double d5 = 2.0 * Math.abs(d - point.getX());
            double d6 = 2.0 * Math.abs(d2 - point.getY());
            this._ellipse = new Ellipse2D.Double(d3, d4, d5, d6);
            if (this._label != null) {
                int n = 0;
                n = this._originPosition.getX() < (double)(this._originComp.getWidth() / 2) ? (int)d3 : (int)(d3 + d5);
                int n2 = (int)(d4 + d6 / 2.0);
                int n3 = (int)this._label.getPreferredSize().getWidth();
                int n4 = (int)this._label.getPreferredSize().getHeight();
                this._label.setBounds(n - n3 / 2, n2 - n4 / 2, n3, n4);
            }
        } else {
            this._ellipse = null;
            Rectangle rectangle = this._originComp.getBounds();
            double d = rectangle.getX() + this._originPosition.getX();
            double d7 = rectangle.getY() + this._originPosition.getY();
            Point point = new Point((int)d, (int)d7);
            Rectangle rectangle2 = this._destComp.getBounds();
            double d8 = rectangle2.getX() + this._destPosition.getX();
            double d9 = rectangle2.getY() + this._destPosition.getY();
            Point point2 = new Point((int)d8, (int)d9);
            double d10 = d8 - d + 1.0;
            double d11 = d9 - d7 + 1.0;
            double d12 = d11 / d10;
            Line2D.Double double_ = new Line2D.Double(d, d7, d8, d9);
            Point point3 = this.getIntersectionPt(double_, rectangle, point, d12);
            Point point4 = this.getIntersectionPt(double_, rectangle2, point2, d12);
            if (point3 == null || point4 == null) {
                this._line = null;
            } else {
                this._line = new Line2D.Double(point3, point4);
                if (this._label != null) {
                    int n = (int)this._label.getPreferredSize().getWidth();
                    int n5 = (int)this._label.getPreferredSize().getHeight();
                    int n6 = point3.x > point4.x ? (point3.x - point4.x) / 2 + point4.x - n / 2 : (point4.x - point3.x) / 2 + point3.x - n / 2;
                    int n7 = point3.y > point4.y ? (point3.y - point4.y) / 2 + point4.y - n5 / 2 : (point4.y - point3.y) / 2 + point3.y - n5 / 2;
                    this._label.setBounds(n6, n7, n, n5);
                }
            }
        }
        this.setArrowHead1();
        this.setArrowHead2();
    }

    protected void setArrowHead1() {
        this._arrowHead1 = null;
        Polygon polygon = new Polygon();
        if (this._connection.isLoop() && this._ellipse != null) {
            if (this._ellipse.getHeight() > this._ellipse.getWidth()) {
                int n = (int)(CONNECTION_ARROW_WIDTH / 2.0);
                int n2 = 0;
                double d = 0.0;
                double d2 = 0.0;
                d = this._originPosition.getX() < (double)this._originComp.getWidth() / 2.0 ? this._ellipse.getX() + this._ellipse.getWidth() : this._ellipse.getX();
                if (this._originPosition.getY() < (double)this._originComp.getHeight() / 2.0) {
                    d2 = this._ellipse.getY() + this._ellipse.getHeight() / 2.0 + 1.0;
                    n2 = (int)(d2 - CONNECTION_ARROW_LENGTH + 1.0);
                } else {
                    d2 = this._ellipse.getY() + this._ellipse.getHeight() / 2.0 - 1.0;
                    n2 = (int)(d2 + CONNECTION_ARROW_LENGTH - 1.0);
                }
                this._arrowTip1 = new Point((int)d, (int)d2);
                polygon.addPoint((int)d, (int)d2);
                polygon.addPoint((int)d - n, n2);
                polygon.addPoint((int)d + n, n2);
            } else {
                int n = (int)(CONNECTION_ARROW_LENGTH / 2.0);
                int n3 = 0;
                double d = 0.0;
                double d3 = 0.0;
                if (this._originPosition.getX() < (double)this._originComp.getWidth() / 2.0) {
                    d = this._ellipse.getX() + this._ellipse.getWidth() / 2.0 + 1.0;
                    n3 = (int)(d - CONNECTION_ARROW_WIDTH + 1.0);
                } else {
                    d = this._ellipse.getX() + this._ellipse.getWidth() / 2.0 - 1.0;
                    n3 = (int)(d + CONNECTION_ARROW_WIDTH - 1.0);
                }
                d3 = this._originPosition.getY() < (double)this._originComp.getHeight() / 2.0 ? this._ellipse.getY() + this._ellipse.getHeight() : this._ellipse.getY();
                this._arrowTip1 = new Point((int)d, (int)d3);
                polygon.addPoint((int)d, (int)d3);
                polygon.addPoint(n3, (int)d3 - n);
                polygon.addPoint(n3, (int)d3 + n);
            }
        } else if (!this._connection.isLoop() && this._line != null) {
            double d = Math.sqrt(Math.pow(this._line.getX2() - this._line.getX1(), 2.0) + Math.pow(this._line.getY2() - this._line.getY1(), 2.0));
            double d4 = CONNECTION_ARROW_LENGTH / d * Math.abs(this._line.getX2() - this._line.getX1());
            double d5 = CONNECTION_ARROW_LENGTH / d * Math.abs(this._line.getY2() - this._line.getY1());
            double d6 = 1.5707963267948966 - Math.acos(d4 / CONNECTION_ARROW_LENGTH);
            double d7 = CONNECTION_ARROW_WIDTH / 2.0 * Math.cos(d6);
            double d8 = CONNECTION_ARROW_WIDTH / 2.0 * Math.sin(d6);
            this._arrowTip1 = new Point((int)this._line.getX2(), (int)this._line.getY2());
            polygon.addPoint((int)this._line.getX2(), (int)this._line.getY2());
            if (this._line.getX2() - this._line.getX1() > 0.0 && this._line.getY2() - this._line.getY1() > 0.0) {
                Point point = new Point((int)this._line.getX2() - (int)d4, (int)this._line.getY2() - (int)d5);
                polygon.addPoint((int)point.getX() - (int)d7, (int)point.getY() + (int)d8);
                polygon.addPoint((int)point.getX() + (int)d7, (int)point.getY() - (int)d8);
            } else if (this._line.getX2() - this._line.getX1() > 0.0 && this._line.getY2() - this._line.getY1() < 0.0) {
                Point point = new Point((int)this._line.getX2() - (int)d4, (int)this._line.getY2() + (int)d5);
                polygon.addPoint((int)point.getX() + (int)d7, (int)point.getY() + (int)d8);
                polygon.addPoint((int)point.getX() - (int)d7, (int)point.getY() - (int)d8);
            } else if (this._line.getX2() - this._line.getX1() < 0.0 && this._line.getY2() - this._line.getY1() < 0.0) {
                Point point = new Point((int)this._line.getX2() + (int)d4, (int)this._line.getY2() + (int)d5);
                polygon.addPoint((int)point.getX() - (int)d7, (int)point.getY() + (int)d8);
                polygon.addPoint((int)point.getX() + (int)d7, (int)point.getY() - (int)d8);
            } else if (this._line.getX2() - this._line.getX1() < 0.0 && this._line.getY2() - this._line.getY1() > 0.0) {
                Point point = new Point((int)this._line.getX2() + (int)d4, (int)this._line.getY2() - (int)d5);
                polygon.addPoint((int)point.getX() + (int)d7, (int)point.getY() + (int)d8);
                polygon.addPoint((int)point.getX() - (int)d7, (int)point.getY() - (int)d8);
            } else if (this._line.getX2() - this._line.getX1() == 0.0 && this._line.getY2() - this._line.getY1() > 0.0) {
                Point point = new Point((int)this._line.getX2(), (int)this._line.getY2() - (int)CONNECTION_ARROW_LENGTH + 1);
                polygon.addPoint((int)point.getX() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1, (int)point.getY());
                polygon.addPoint((int)point.getX() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1, (int)point.getY());
            } else if (this._line.getX2() - this._line.getX1() == 0.0 && this._line.getY2() - this._line.getY1() < 0.0) {
                Point point = new Point((int)this._line.getX2(), (int)this._line.getY2() + (int)CONNECTION_ARROW_LENGTH - 1);
                polygon.addPoint((int)point.getX() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1, (int)point.getY());
                polygon.addPoint((int)point.getX() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1, (int)point.getY());
            } else if (this._line.getX2() - this._line.getX1() < 0.0 && this._line.getY2() - this._line.getY1() == 0.0) {
                Point point = new Point((int)this._line.getX2() + (int)CONNECTION_ARROW_LENGTH - 1, (int)this._line.getY2());
                polygon.addPoint((int)point.getX(), (int)point.getY() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1);
                polygon.addPoint((int)point.getX(), (int)point.getY() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1);
            } else if (this._line.getX2() - this._line.getX1() > 0.0 && this._line.getY2() - this._line.getY1() == 0.0) {
                Point point = new Point((int)this._line.getX2() - (int)CONNECTION_ARROW_LENGTH + 1, (int)this._line.getY2());
                polygon.addPoint((int)point.getX(), (int)point.getY() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1);
                polygon.addPoint((int)point.getX(), (int)point.getY() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1);
            } else {
                return;
            }
        }
        this._arrowHead1 = polygon;
    }

    protected void setArrowHead2() {
        this._arrowHead2 = null;
        Polygon polygon = null;
        Point point = null;
        if (this._isOriginArrowDrawn && !this._connection.isLoop() && this._line != null) {
            polygon = new Polygon();
            double d = Math.sqrt(Math.pow(this._line.getX2() - this._line.getX1(), 2.0) + Math.pow(this._line.getY2() - this._line.getY1(), 2.0));
            double d2 = CONNECTION_ARROW_LENGTH / d * Math.abs(this._line.getX2() - this._line.getX1());
            double d3 = CONNECTION_ARROW_LENGTH / d * Math.abs(this._line.getY2() - this._line.getY1());
            double d4 = 1.5707963267948966 - Math.acos(d2 / CONNECTION_ARROW_LENGTH);
            double d5 = CONNECTION_ARROW_WIDTH / 2.0 * Math.cos(d4);
            double d6 = CONNECTION_ARROW_WIDTH / 2.0 * Math.sin(d4);
            polygon.addPoint((int)this._line.getX1(), (int)this._line.getY1());
            if (this._line.getX2() - this._line.getX1() > 0.0 && this._line.getY2() - this._line.getY1() > 0.0) {
                point = new Point((int)this._line.getX1() + (int)d2, (int)this._line.getY1() + (int)d3);
                polygon.addPoint((int)point.getX() - (int)d5, (int)point.getY() + (int)d6);
                polygon.addPoint((int)point.getX() + (int)d5, (int)point.getY() - (int)d6);
            } else if (this._line.getX2() - this._line.getX1() > 0.0 && this._line.getY2() - this._line.getY1() < 0.0) {
                point = new Point((int)this._line.getX1() + (int)d2, (int)this._line.getY1() - (int)d3);
                polygon.addPoint((int)point.getX() + (int)d5, (int)point.getY() + (int)d6);
                polygon.addPoint((int)point.getX() - (int)d5, (int)point.getY() - (int)d6);
            } else if (this._line.getX2() - this._line.getX1() < 0.0 && this._line.getY2() - this._line.getY1() < 0.0) {
                point = new Point((int)this._line.getX1() - (int)d2, (int)this._line.getY1() - (int)d3);
                polygon.addPoint((int)point.getX() - (int)d5, (int)point.getY() + (int)d6);
                polygon.addPoint((int)point.getX() + (int)d5, (int)point.getY() - (int)d6);
            } else if (this._line.getX2() - this._line.getX1() < 0.0 && this._line.getY2() - this._line.getY1() > 0.0) {
                point = new Point((int)this._line.getX1() - (int)d2, (int)this._line.getY1() + (int)d3);
                polygon.addPoint((int)point.getX() + (int)d5, (int)point.getY() + (int)d6);
                polygon.addPoint((int)point.getX() - (int)d5, (int)point.getY() - (int)d6);
            } else if (this._line.getX2() - this._line.getX1() == 0.0 && this._line.getY2() - this._line.getY1() > 0.0) {
                point = new Point((int)this._line.getX1(), (int)this._line.getY1() + (int)CONNECTION_ARROW_LENGTH);
                polygon.addPoint((int)point.getX() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1, (int)point.getY());
                polygon.addPoint((int)point.getX() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1, (int)point.getY());
            } else if (this._line.getX2() - this._line.getX1() == 0.0 && this._line.getY2() - this._line.getY1() < 0.0) {
                point = new Point((int)this._line.getX1(), (int)this._line.getY1() - (int)CONNECTION_ARROW_LENGTH);
                polygon.addPoint((int)point.getX() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1, (int)point.getY());
                polygon.addPoint((int)point.getX() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1, (int)point.getY());
            } else if (this._line.getX2() - this._line.getX1() < 0.0 && this._line.getY2() - this._line.getY1() == 0.0) {
                point = new Point((int)this._line.getX1() - (int)CONNECTION_ARROW_LENGTH + 1, (int)this._line.getY1());
                polygon.addPoint((int)point.getX(), (int)point.getY() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1);
                polygon.addPoint((int)point.getX(), (int)point.getY() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1);
            } else if (this._line.getX2() - this._line.getX1() > 0.0 && this._line.getY2() - this._line.getY1() == 0.0) {
                point = new Point((int)this._line.getX1() + (int)CONNECTION_ARROW_LENGTH, (int)this._line.getY1());
                polygon.addPoint((int)point.getX(), (int)point.getY() + (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) - 1);
                polygon.addPoint((int)point.getX(), (int)point.getY() - (int)Math.round(CONNECTION_ARROW_WIDTH / 2.0) + 1);
            } else {
                return;
            }
        }
        this._arrowHead2 = polygon;
    }

    public boolean isOriginArrowDrawn() {
        return this._isOriginArrowDrawn;
    }

    public void setOriginArrowDrawn(boolean bl) {
        this._isOriginArrowDrawn = bl;
        this.setShape();
    }

    private void initializeAnchors() {
        if (this._connection.isLoop()) {
            this._originPosition = new Point(0, 0);
            this._destPosition = this.defaultAnchorPosition(this._destComp);
        } else {
            this._originPosition = this.defaultAnchorPosition(this._originComp);
            this._destPosition = this.defaultAnchorPosition(this._destComp);
        }
    }

    private Point defaultAnchorPosition(Component component) {
        Rectangle rectangle = component.getBounds();
        int n = (int)(rectangle.getWidth() / 2.0);
        int n2 = (int)(rectangle.getHeight() / 2.0);
        return new Point(n, n2);
    }

    private boolean intersects(Line2D line2D, Side side, Rectangle rectangle) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (side == Side.NORTH) {
            d = rectangle.getX();
            d2 = rectangle.getY();
            d3 = rectangle.getX() + rectangle.getWidth();
            d4 = rectangle.getY();
        } else if (side == Side.SOUTH) {
            d = rectangle.getX();
            d2 = rectangle.getY() + rectangle.getHeight();
            d3 = rectangle.getX() + rectangle.getWidth();
            d4 = rectangle.getY() + rectangle.getHeight();
        } else if (side == Side.WEST) {
            d = rectangle.getX();
            d2 = rectangle.getY();
            d3 = rectangle.getX();
            d4 = rectangle.getY() + rectangle.getHeight();
        } else if (side == Side.EAST) {
            d = rectangle.getX() + rectangle.getWidth();
            d2 = rectangle.getY();
            d3 = rectangle.getX() + rectangle.getWidth();
            d4 = rectangle.getY() + rectangle.getHeight();
        }
        return line2D.intersectsLine(d, d2, d3, d4);
    }

    private Point getIntersectionPt(Line2D.Double double_, Rectangle rectangle, Point point, double d) {
        double d2;
        double d3;
        if (this.intersects(double_, Side.EAST, rectangle)) {
            double d4 = rectangle.getX() + rectangle.getWidth() - point.getX();
            d3 = point.getX() + d4;
            d2 = point.getY() + d4 * d;
        } else if (this.intersects(double_, Side.SOUTH, rectangle)) {
            double d5 = rectangle.getY() + rectangle.getHeight() - point.getY();
            d3 = point.getX() + d5 / d;
            d2 = point.getY() + d5;
        } else if (this.intersects(double_, Side.WEST, rectangle)) {
            double d6 = point.getX() - rectangle.getX();
            d3 = point.getX() - d6;
            d2 = point.getY() - d6 * d + 1.0;
        } else if (this.intersects(double_, Side.NORTH, rectangle)) {
            double d7 = point.getY() - rectangle.getY();
            d3 = point.getX() - d7 / d + 1.0;
            d2 = point.getY() - d7;
        } else {
            return null;
        }
        return new Point((int)d3, (int)d2);
    }

    private void refreshLabel() {
        this._label.setSize(this._label.getPreferredSize());
        this.setShape();
    }

    private void fireAnchorsChanged() {
        Object[] objectArray = this._listenerList.getListenerList();
        EventObject eventObject = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionComponentListener.class) continue;
            if (eventObject == null) {
                eventObject = new EventObject(this);
            }
            ((ConnectionComponentListener)objectArray[i + 1]).anchorsChanged(eventObject);
        }
    }

    private void fireFocusGained() {
        Object[] objectArray = this._focusListenerList.getListenerList();
        EventObject eventObject = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionComponentListener.class) continue;
            if (eventObject == null) {
                eventObject = new EventObject(this);
            }
            ((ConnectionComponentListener)objectArray[i + 1]).focusGained(eventObject);
        }
    }

    private void fireFocusLost() {
        Object[] objectArray = this._focusListenerList.getListenerList();
        EventObject eventObject = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ConnectionComponentListener.class) continue;
            if (eventObject == null) {
                eventObject = new EventObject(this);
            }
            ((ConnectionComponentListener)objectArray[i + 1]).focusLost(eventObject);
        }
    }
}

