/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.DefaultConnection;
import com.sybase.JGraph.DefaultNode;
import com.sybase.JGraph.Model;
import com.sybase.JGraph.ModelEvent;
import com.sybase.JGraph.ModelListener;
import com.sybase.JGraph.Node;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import javax.swing.event.EventListenerList;

public class DefaultModel
implements Model {
    protected ArrayList<Connection> _connections = new ArrayList();
    protected ArrayList<Node> _nodes = new ArrayList();
    protected EventListenerList _listenerList = new EventListenerList();

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("Nodes:\n");
        for (n = 0; n < this._nodes.size(); ++n) {
            stringBuffer.append(n + "- " + this._nodes.get(n) + "\n");
        }
        stringBuffer.append("Connections:\n");
        for (n = 0; n < this._connections.size(); ++n) {
            stringBuffer.append(n + "- " + this._connections.get(n) + "\n");
        }
        return stringBuffer + "";
    }

    public void destroy() {
        this.clear();
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            this.removeModelListener((ModelListener)objectArray[i + 1]);
        }
        this._connections = null;
        this._nodes = null;
        this._listenerList = null;
    }

    @Override
    public Connection getConnection(int n) {
        if (n < 0 || n >= this._connections.size()) {
            return null;
        }
        return this._connections.get(n);
    }

    @Override
    public Connection getConnection(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this._connections.size(); ++i) {
            Connection connection = this._connections.get(i);
            Object object2 = connection.getUserObject();
            if (!object.equals(object2)) continue;
            return connection;
        }
        return null;
    }

    @Override
    public int getConnectionCount() {
        return this._connections.size();
    }

    @Override
    public int getIndexOfConnection(Connection connection) {
        return this._connections.indexOf(connection);
    }

    @Override
    public Node getNode(int n) {
        if (n < 0 || n >= this._nodes.size()) {
            return null;
        }
        return this._nodes.get(n);
    }

    @Override
    public Node getNode(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this._nodes.size(); ++i) {
            Node node = this._nodes.get(i);
            Object object2 = node.getUserObject();
            if (!object.equals(object2)) continue;
            return node;
        }
        return null;
    }

    @Override
    public Node getNode(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this._nodes.size(); ++i) {
            Node node = this._nodes.get(i);
            Object object = node.getUserObject();
            if (!string.equals(object.toString())) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getNodeCount() {
        return this._nodes.size();
    }

    @Override
    public int getIndexOfNode(Node node) {
        return this._nodes.indexOf(node);
    }

    @Override
    public Node addNode(Object object) {
        DefaultNode defaultNode = new DefaultNode(object);
        this._nodes.add(defaultNode);
        this.fireNodedAdded(defaultNode);
        return defaultNode;
    }

    @Override
    public Node addNode() {
        return this.addNode(null);
    }

    @Override
    public void removeNode(int n) {
        this.removeNode(this.getNode(n));
    }

    @Override
    public void removeNode(Node node) {
        if (node == null) {
            return;
        }
        for (int i = node.getConnectionCount() - 1; i >= 0; --i) {
            this.removeConnection(node.getConnectionAt(i));
        }
        this._nodes.remove(node);
        node.destroy();
        this.fireNodeRemoved(node);
    }

    @Override
    public Connection addConnection(Node node, Node node2, Object object) {
        DefaultNode defaultNode = (DefaultNode)node;
        DefaultNode defaultNode2 = (DefaultNode)node2;
        if (!this._nodes.contains(defaultNode)) {
            throw new NoSuchElementException("Origin: " + node);
        }
        if (!this._nodes.contains(defaultNode2)) {
            throw new NoSuchElementException("Destination: " + node2);
        }
        DefaultConnection defaultConnection = new DefaultConnection(defaultNode, defaultNode2, object);
        this._connections.add(defaultConnection);
        defaultNode._connections.add(defaultConnection);
        if (defaultNode != defaultNode2) {
            defaultNode2._connections.add(defaultConnection);
        }
        this.fireConnectionAdded(defaultConnection);
        return defaultConnection;
    }

    @Override
    public Connection addConnection(Node node, Node node2) {
        return this.addConnection(node, node2, null);
    }

    @Override
    public void removeConnection(int n) {
        this.removeConnection(this.getConnection(n));
    }

    @Override
    public void removeConnection(Connection connection) {
        DefaultConnection defaultConnection = (DefaultConnection)connection;
        if (defaultConnection == null) {
            return;
        }
        DefaultNode defaultNode = (DefaultNode)defaultConnection._origin;
        DefaultNode defaultNode2 = (DefaultNode)defaultConnection._destination;
        if (defaultNode != null && defaultNode._connections != null) {
            defaultNode._connections.remove(defaultConnection);
        }
        if (defaultNode2 != null && defaultNode2._connections != null) {
            defaultNode2._connections.remove(defaultConnection);
        }
        this._connections.remove(connection);
        connection.destroy();
        this.fireConnectionRemoved(connection);
    }

    @Override
    public void setOrigin(Connection connection, Node node) {
        DefaultConnection defaultConnection = (DefaultConnection)connection;
        if (!this._connections.contains(defaultConnection)) {
            throw new NoSuchElementException("Connection: " + connection);
        }
        DefaultNode defaultNode = (DefaultNode)defaultConnection._origin;
        DefaultNode defaultNode2 = (DefaultNode)node;
        if (!this._nodes.contains(defaultNode2)) {
            throw new NoSuchElementException("Origin: " + node);
        }
        if (defaultNode2 == defaultNode) {
            return;
        }
        defaultNode._connections.remove(defaultConnection);
        defaultNode2._connections.add(defaultConnection);
        defaultConnection._origin = defaultNode2;
    }

    @Override
    public void setDestination(Connection connection, Node node) {
        DefaultConnection defaultConnection = (DefaultConnection)connection;
        if (!this._connections.contains(defaultConnection)) {
            throw new NoSuchElementException("Connection: " + connection);
        }
        DefaultNode defaultNode = (DefaultNode)defaultConnection._destination;
        DefaultNode defaultNode2 = (DefaultNode)node;
        if (!this._nodes.contains(defaultNode2)) {
            throw new NoSuchElementException("Destination: " + node);
        }
        if (defaultNode2 == defaultNode) {
            return;
        }
        defaultNode._connections.remove(defaultConnection);
        defaultNode2._connections.add(defaultConnection);
        defaultConnection._destination = defaultNode2;
    }

    @Override
    public void clear() {
        Object object;
        int n;
        for (n = 0; n < this._connections.size(); ++n) {
            object = this._connections.get(n);
            this.fireConnectionRemoved((Connection)object);
            object.destroy();
        }
        for (n = 0; n < this._nodes.size(); ++n) {
            object = this._nodes.get(n);
            this.fireNodeRemoved((Node)object);
            object.destroy();
        }
        this._connections.clear();
        this._nodes.clear();
    }

    @Override
    public void addModelListener(ModelListener modelListener) {
        this._listenerList.add(ModelListener.class, modelListener);
    }

    @Override
    public void removeModelListener(ModelListener modelListener) {
        if (this._listenerList != null) {
            this._listenerList.remove(ModelListener.class, modelListener);
        }
    }

    private void fireNodedAdded(Node node) {
        Object[] objectArray = this._listenerList.getListenerList();
        ModelEvent modelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelListener.class) continue;
            if (modelEvent == null) {
                modelEvent = new ModelEvent(node);
            }
            ((ModelListener)objectArray[i + 1]).nodeAdded(modelEvent);
        }
    }

    private void fireNodeRemoved(Node node) {
        Object[] objectArray = this._listenerList.getListenerList();
        ModelEvent modelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelListener.class) continue;
            if (modelEvent == null) {
                modelEvent = new ModelEvent(node);
            }
            ((ModelListener)objectArray[i + 1]).nodeRemoved(modelEvent);
        }
    }

    private void fireConnectionAdded(Connection connection) {
        Object[] objectArray = this._listenerList.getListenerList();
        ModelEvent modelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelListener.class) continue;
            if (modelEvent == null) {
                modelEvent = new ModelEvent(connection);
            }
            ((ModelListener)objectArray[i + 1]).connectionAdded(modelEvent);
        }
    }

    private void fireConnectionRemoved(Connection connection) {
        Object[] objectArray = this._listenerList.getListenerList();
        ModelEvent modelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ModelListener.class) continue;
            if (modelEvent == null) {
                modelEvent = new ModelEvent(connection);
            }
            ((ModelListener)objectArray[i + 1]).connectionRemoved(modelEvent);
        }
    }
}

