/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ModelEvent;
import com.sybase.JGraph.Node;
import com.sybase.JGraph.NodeListener;
import java.util.ArrayList;
import javax.swing.event.EventListenerList;

class DefaultNode
implements Node {
    protected ArrayList<Connection> _connections = new ArrayList();
    protected Object _userObject;
    boolean _editable;
    protected EventListenerList _listenerList = new EventListenerList();

    DefaultNode() {
    }

    DefaultNode(Object object) {
        this._userObject = object;
    }

    @Override
    public void destroy() {
        this._connections.clear();
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            this.removeNodeListener((NodeListener)objectArray[i + 1]);
        }
        this._userObject = null;
        this._listenerList = null;
        this._connections = null;
    }

    public String toString() {
        return "'" + this._userObject + "' node";
    }

    @Override
    public Connection getConnectionAt(int n) {
        return this._connections.get(n);
    }

    @Override
    public int getConnectionCount() {
        return this._connections.size();
    }

    @Override
    public int getIndex(Connection connection) {
        return this._connections.indexOf(connection);
    }

    @Override
    public boolean isEditable() {
        return this._editable;
    }

    @Override
    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    @Override
    public Object getUserObject() {
        return this._userObject;
    }

    @Override
    public void setUserObject(Object object) {
        this._userObject = object;
        this.fireNodeChanged();
    }

    @Override
    public String getUniqueID() {
        return this._userObject.toString();
    }

    @Override
    public void addNodeListener(NodeListener nodeListener) {
        this._listenerList.add(NodeListener.class, nodeListener);
    }

    @Override
    public void removeNodeListener(NodeListener nodeListener) {
        if (this._listenerList != null) {
            this._listenerList.remove(NodeListener.class, nodeListener);
        }
    }

    private void fireNodeChanged() {
        Object[] objectArray = this._listenerList.getListenerList();
        ModelEvent modelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != NodeListener.class) continue;
            if (modelEvent == null) {
                modelEvent = new ModelEvent(this);
            }
            ((NodeListener)objectArray[i + 1]).nodeChanged(modelEvent);
        }
    }
}

