/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.AbstractNodeComponent;
import com.sybase.JGraph.DefaultConnectionComponent;
import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.Node;
import com.sybase.JGraph.NodeComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;

public class DefaultNodeComponent
extends AbstractNodeComponent
implements NodeComponent {
    protected JLabel _label;

    public DefaultNodeComponent(Node node, Dimension dimension, Dimension dimension2) {
        super(node);
        this._preferredSize = dimension;
        int n = (int)dimension2.getWidth();
        int n2 = (int)dimension2.getHeight();
        this._minSize = new Dimension(n > 10 ? n : 10, n2 > 10 ? n2 : 10);
        this._label = new JLabel();
        this._label.setHorizontalAlignment(0);
        this.setLayout(new GridLayout(1, 1));
        this.add(this._label);
        this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.NODE_BG));
        this.setForeground(GraphProperties.getColor(GraphProperties.ColorName.NODE_TEXT));
        this.userObjectUpdated(node.getUserObject());
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (!this.isDestroyed) {
            if (bl) {
                if (DefaultConnectionComponent.BOLD_LABEL_FONT != null) {
                    this._label.setFont(DefaultConnectionComponent.BOLD_LABEL_FONT);
                }
            } else if (DefaultConnectionComponent.LABEL_FONT != null) {
                this._label.setFont(DefaultConnectionComponent.LABEL_FONT);
            }
        }
    }

    @Override
    protected void userObjectUpdated(Object object) {
        this._label.setText(object + "");
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._label != null) {
            this._label.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._label != null) {
            this._label.setBackground(color);
        }
    }
}

