/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.NodeComponent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;

final class FreeList {
    int CELL_HEIGHT = 10;
    int CELL_WIDTH = 10;
    int CELL_BORDER = 3;
    int _gridHeight;
    int _gridWidth;
    protected int _cellHeight;
    protected int _cellWidth;
    protected ArrayListOfNodeComponent[][] _cells;

    public FreeList() {
    }

    public FreeList(Dimension dimension) {
        this.setSize(dimension);
    }

    public void setSize(Dimension dimension) {
        this._gridWidth = (int)dimension.getWidth();
        this._gridHeight = (int)dimension.getHeight();
        this._cellWidth = (int)Math.round(Math.ceil(dimension.getWidth() / (double)this.CELL_WIDTH));
        this._cellHeight = (int)Math.round(Math.ceil(dimension.getHeight() / (double)this.CELL_HEIGHT));
        if (this._cells == null) {
            this._cells = new ArrayListOfNodeComponent[this._cellWidth][this._cellHeight];
        } else {
            int n = Math.max(this._cellWidth, this._cells.length);
            int n2 = Math.max(this._cellHeight, this._cells[0].length);
            if (this._cells.length < n || this._cells[0].length < n2) {
                ArrayListOfNodeComponent[][] arrayListOfNodeComponentArray = new ArrayListOfNodeComponent[n][n2];
                for (int i = 0; i < this._cells.length; ++i) {
                    System.arraycopy(this._cells[i], 0, arrayListOfNodeComponentArray[i], 0, this._cells[i].length);
                }
                this._cells = arrayListOfNodeComponentArray;
            }
        }
    }

    public Rectangle add(NodeComponent nodeComponent) {
        Dimension dimension = nodeComponent.getPreferredSize();
        if (dimension.getWidth() < 1.0 || dimension.getHeight() < 1.0) {
            return null;
        }
        int n = (int)dimension.getWidth() + 2 * this.CELL_BORDER * this.CELL_WIDTH;
        if (this._gridWidth < n) {
            this.setSize(new Dimension(n, this._gridHeight));
        }
        int n2 = (int)Math.round(Math.ceil(dimension.getHeight() / (double)this.CELL_HEIGHT)) + 2 * this.CELL_BORDER;
        Rectangle rectangle = this.add(nodeComponent, dimension, 0);
        if (rectangle == null) {
            int n3 = this._cellHeight - n2;
            this.growToAccomodate(dimension);
            rectangle = this.add(nodeComponent, dimension, n3 >= 0 ? n3 : 0);
        }
        return rectangle;
    }

    protected Rectangle add(NodeComponent nodeComponent, Dimension dimension, int n) {
        int n2 = (int)Math.round(Math.ceil(dimension.getHeight() / (double)this.CELL_HEIGHT)) + 2 * this.CELL_BORDER;
        int n3 = (int)Math.round(Math.ceil(dimension.getWidth() / (double)this.CELL_WIDTH)) + 2 * this.CELL_BORDER;
        int n4 = this._cellHeight - n2 + 1;
        int n5 = this._cellWidth - n3 + 1;
        if (n4 < 1 || n5 < 1) {
            return null;
        }
        for (int i = n; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                if (!this.isFree(j, i, n3, n2)) continue;
                Rectangle rectangle = new Rectangle(j, i, n3, n2);
                this.markCellsBorder(nodeComponent, rectangle);
                int n6 = (j + this.CELL_BORDER) * this.CELL_WIDTH;
                int n7 = (i + this.CELL_BORDER) * this.CELL_HEIGHT;
                int n8 = (int)dimension.getWidth();
                int n9 = (int)dimension.getHeight();
                return new Rectangle(n6, n7, n8, n9);
            }
        }
        return null;
    }

    void add(NodeComponent nodeComponent, Rectangle rectangle) {
        this.markCellsBorder(nodeComponent, this.getRect(rectangle));
    }

    public void remove(NodeComponent nodeComponent, Rectangle rectangle) {
        if (rectangle.getWidth() < 1.0 || rectangle.getHeight() < 1.0) {
            return;
        }
        this.unmarkCellsBorder(nodeComponent, this.getRect(rectangle));
    }

    public NodeComponent getNodeAt(Point point) {
        Point point2 = this.getCell(point);
        int n = (int)point2.getX();
        int n2 = (int)point2.getY();
        if (n >= this._cells.length || n2 >= this._cells[0].length) {
            return null;
        }
        ArrayListOfNodeComponent arrayListOfNodeComponent = this._cells[n][n2];
        if (arrayListOfNodeComponent == null) {
            return null;
        }
        for (int i = 0; i < arrayListOfNodeComponent.size(); ++i) {
            NodeComponent nodeComponent = (NodeComponent)arrayListOfNodeComponent.get(i);
            if (nodeComponent == null) continue;
            return nodeComponent;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer((this._cellHeight + 1) * (this._cellWidth + 1));
        for (int i = 0; i <= this._cellHeight; ++i) {
            for (int j = 0; j <= this._cellWidth; ++j) {
                if (j == 0) {
                    stringBuffer.append(i % 10);
                    continue;
                }
                if (i == 0) {
                    stringBuffer.append(j % 10);
                    continue;
                }
                ArrayListOfNodeComponent arrayListOfNodeComponent = this._cells[j - 1][i - 1];
                stringBuffer.append(arrayListOfNodeComponent != null ? arrayListOfNodeComponent.size() : 0);
            }
            stringBuffer.append('\n');
        }
        return stringBuffer + "";
    }

    private final void markCell(NodeComponent nodeComponent, int n, int n2) {
        if (n >= 0 && n2 >= 0 && n < this._cells.length && n2 < this._cells[0].length) {
            ArrayListOfNodeComponent arrayListOfNodeComponent = this._cells[n][n2];
            if (arrayListOfNodeComponent == null) {
                this._cells[n][n2] = arrayListOfNodeComponent = new ArrayListOfNodeComponent(1);
            }
            arrayListOfNodeComponent.add(nodeComponent);
        }
    }

    private final void unmarkCell(NodeComponent nodeComponent, int n, int n2) {
        ArrayListOfNodeComponent arrayListOfNodeComponent;
        if (n >= 0 && n2 >= 0 && n < this._cells.length && n2 < this._cells[0].length && (arrayListOfNodeComponent = this._cells[n][n2]) != null) {
            arrayListOfNodeComponent.remove(nodeComponent);
            if (arrayListOfNodeComponent.size() <= 0) {
                this._cells[n][n2] = null;
            }
        }
    }

    protected void growToAccomodate(Dimension dimension) {
        int n = this._gridHeight + (int)dimension.getHeight() + 3 * this.CELL_BORDER * this.CELL_HEIGHT;
        this.setSize(new Dimension(this._gridWidth, n));
    }

    private final boolean isFree(int n, int n2, int n3, int n4) {
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        for (int i = n2; i <= n6; ++i) {
            for (int j = n; j <= n5; ++j) {
                if (j >= this._cells.length || i >= this._cells[0].length) {
                    return false;
                }
                if (this._cells[j][i] == null) continue;
                return false;
            }
        }
        return true;
    }

    private void markCellsBorder(NodeComponent nodeComponent, Rectangle rectangle) {
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        int n3 = (int)rectangle.getWidth();
        int n4 = this.CELL_BORDER;
        this.markCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)rectangle.getX();
        n2 = (int)(rectangle.getY() + rectangle.getHeight() - (double)this.CELL_BORDER);
        n3 = (int)rectangle.getWidth();
        n4 = this.CELL_BORDER;
        this.markCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)rectangle.getX();
        n2 = (int)rectangle.getY() + this.CELL_BORDER;
        n3 = this.CELL_BORDER;
        n4 = (int)rectangle.getHeight() - 2 * this.CELL_BORDER;
        this.markCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)(rectangle.getX() + rectangle.getWidth() - (double)this.CELL_BORDER);
        n2 = (int)rectangle.getY() + this.CELL_BORDER;
        n3 = this.CELL_BORDER;
        n4 = (int)rectangle.getHeight() - 2 * this.CELL_BORDER;
        this.markCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)rectangle.getX() + this.CELL_BORDER;
        n2 = (int)rectangle.getY() + this.CELL_BORDER;
        n3 = (int)rectangle.getWidth() - 2 * this.CELL_BORDER;
        n4 = (int)rectangle.getHeight() - 2 * this.CELL_BORDER;
        this.markCells(nodeComponent, new Rectangle(n, n2, n3, n4));
    }

    private void markCells(NodeComponent nodeComponent, Rectangle rectangle) {
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getX() + (int)rectangle.getWidth() - 1;
        int n3 = (int)rectangle.getY();
        int n4 = (int)rectangle.getY() + (int)rectangle.getHeight() - 1;
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                this.markCell(nodeComponent, j, i);
            }
        }
    }

    private void unmarkCellsBorder(NodeComponent nodeComponent, Rectangle rectangle) {
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        int n3 = (int)rectangle.getWidth();
        int n4 = this.CELL_BORDER;
        this.unmarkCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)rectangle.getX();
        n2 = (int)(rectangle.getY() + rectangle.getHeight() - (double)this.CELL_BORDER);
        n3 = (int)rectangle.getWidth();
        n4 = this.CELL_BORDER;
        this.unmarkCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)rectangle.getX();
        n2 = (int)rectangle.getY() + this.CELL_BORDER;
        n3 = this.CELL_BORDER;
        n4 = (int)rectangle.getHeight() - 2 * this.CELL_BORDER;
        this.unmarkCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)(rectangle.getX() + rectangle.getWidth() - (double)this.CELL_BORDER);
        n2 = (int)rectangle.getY() + this.CELL_BORDER;
        n3 = this.CELL_BORDER;
        n4 = (int)rectangle.getHeight() - 2 * this.CELL_BORDER;
        this.unmarkCells(null, new Rectangle(n, n2, n3, n4));
        n = (int)rectangle.getX() + this.CELL_BORDER;
        n2 = (int)rectangle.getY() + this.CELL_BORDER;
        n3 = (int)rectangle.getWidth() - 2 * this.CELL_BORDER;
        n4 = (int)rectangle.getHeight() - 2 * this.CELL_BORDER;
        this.unmarkCells(nodeComponent, new Rectangle(n, n2, n3, n4));
    }

    private void unmarkCells(NodeComponent nodeComponent, Rectangle rectangle) {
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getX() + (int)rectangle.getWidth() - 1;
        int n3 = (int)rectangle.getY();
        int n4 = (int)rectangle.getY() + (int)rectangle.getHeight() - 1;
        for (int i = n3; i <= n4; ++i) {
            for (int j = n; j <= n2; ++j) {
                this.unmarkCell(nodeComponent, j, i);
            }
        }
    }

    private Point getCell(Point point) {
        int n = (int)point.getX();
        int n2 = (int)point.getY();
        int n3 = n <= 0 ? 1 : (n % this.CELL_WIDTH == 0 ? (int)Math.round(Math.ceil((double)(n + 1) / (double)this.CELL_WIDTH)) : (int)Math.round(Math.ceil((double)n / (double)this.CELL_WIDTH)));
        int n4 = n2 <= 0 ? 1 : (n2 % this.CELL_HEIGHT == 0 ? (int)Math.round(Math.ceil((double)(n2 + 1) / (double)this.CELL_HEIGHT)) : (int)Math.round(Math.ceil((double)n2 / (double)this.CELL_HEIGHT)));
        return new Point(n3 - 1, n4 - 1);
    }

    private Rectangle getRect(Rectangle rectangle) {
        Point point = this.getCell(new Point((int)rectangle.getX(), (int)rectangle.getY()));
        int n = (int)point.getX() - this.CELL_BORDER;
        int n2 = (int)point.getY() - this.CELL_BORDER;
        int n3 = (int)Math.round(Math.ceil(rectangle.getWidth() / (double)this.CELL_WIDTH)) + 2 * this.CELL_BORDER;
        int n4 = (int)Math.round(Math.ceil(rectangle.getHeight() / (double)this.CELL_HEIGHT)) + 2 * this.CELL_BORDER;
        return new Rectangle(n, n2, n3, n4);
    }

    int getDefaultCellHeight() {
        return this.CELL_HEIGHT;
    }

    void setDefaultCellHeight(int n) {
        this.CELL_HEIGHT = n;
    }

    int getDefaultCellWidth() {
        return this.CELL_WIDTH;
    }

    void setDefaultCellWidth(int n) {
        this.CELL_WIDTH = n;
    }

    int getDefaultCellBorder() {
        return this.CELL_BORDER;
    }

    void setDefaultCellBorder(int n) {
        this.CELL_BORDER = n;
    }

    static class ArrayListOfNodeComponent
    extends ArrayList<NodeComponent> {
        ArrayListOfNodeComponent(int n) {
            super(n);
        }
    }
}

