/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.PropertyListener;
import com.sybase.util.Platform;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.event.EventListenerList;

public final class GraphProperties {
    private static final String COLOR_SELECTED_BG = "JGraph.Color.Selected.Bg";
    private static final String COLOR_SELECTED_TEXT = "JGraph.Color.Selected.Text";
    private static final String COLOR_BG = "JGraph.Color.Background";
    private static final String COLOR_LINE = "JGraph.Color.Line";
    private static final String COLOR_TEXT = "JGraph.Color.Text";
    private static final String COLOR_NODE_BG = "JGraph.Color.Node.Bg";
    private static final String COLOR_NODE_TEXT = "JGraph.Color.Node.Text";
    private static final Color DEFAULT_SELECTED_BG_COLOR = SystemColor.textHighlight;
    private static final Color DEFAULT_SELECTED_TEXT_COLOR = SystemColor.textHighlightText;
    private static final Color DEFAULT_BG_COLOR = Color.WHITE;
    private static final Color DEFAULT_TEXT_COLOR = SystemColor.textText;
    private static final Color DEFAULT_LINE_COLOR = SystemColor.textText;
    private static final Color DEFAULT_NODE_BG_COLOR = SystemColor.window;
    private static final Color DEFAULT_NODE_TEXT_COLOR = SystemColor.textText;
    private static Color _selectedBgColor = DEFAULT_SELECTED_BG_COLOR;
    private static Color _selectedTextColor = DEFAULT_SELECTED_TEXT_COLOR;
    private static Color _bgColor = DEFAULT_BG_COLOR;
    private static Color _textColor = DEFAULT_TEXT_COLOR;
    private static Color _lineColor = DEFAULT_LINE_COLOR;
    private static Color _nodeBgColor = DEFAULT_NODE_BG_COLOR;
    private static Color _nodeTextColor = DEFAULT_NODE_TEXT_COLOR;
    private static String _propertyFileName = Platform.getUserConfigurationDirectory() + ".JGraph";
    private static boolean _dirty;
    private static boolean _loaded;
    protected static EventListenerList _listenerList;

    private GraphProperties() {
    }

    public static void load() {
        if (_loaded) {
            return;
        }
        _loaded = true;
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(new BufferedInputStream(new FileInputStream(_propertyFileName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
        GraphProperties.reset();
    }

    public static void store() {
        if (_dirty) {
            _dirty = false;
            try {
                System.setProperty(COLOR_BG, _bgColor.getRGB() + "");
                System.setProperty(COLOR_TEXT, _textColor.getRGB() + "");
                System.setProperty(COLOR_LINE, _lineColor.getRGB() + "");
                System.setProperty(COLOR_SELECTED_BG, _selectedBgColor.getRGB() + "");
                System.setProperty(COLOR_SELECTED_TEXT, _selectedTextColor.getRGB() + "");
                System.setProperty(COLOR_NODE_BG, _nodeBgColor.getRGB() + "");
                System.setProperty(COLOR_NODE_TEXT, _nodeTextColor.getRGB() + "");
                Properties properties = new Properties(System.getProperties());
                properties.setProperty(COLOR_BG, System.getProperty(COLOR_BG));
                properties.setProperty(COLOR_TEXT, System.getProperty(COLOR_TEXT));
                properties.setProperty(COLOR_LINE, System.getProperty(COLOR_LINE));
                properties.setProperty(COLOR_SELECTED_BG, System.getProperty(COLOR_SELECTED_BG));
                properties.setProperty(COLOR_SELECTED_TEXT, System.getProperty(COLOR_SELECTED_TEXT));
                properties.setProperty(COLOR_NODE_BG, System.getProperty(COLOR_NODE_BG));
                properties.setProperty(COLOR_NODE_TEXT, System.getProperty(COLOR_NODE_TEXT));
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFileName);
                properties.store(fileOutputStream, "JGraph user prefrerences");
                fileOutputStream.close();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void reset() {
        _bgColor = new Color(Integer.getInteger(COLOR_BG, Color.WHITE.getRGB()));
        _lineColor = new Color(Integer.getInteger(COLOR_LINE, SystemColor.textText.getRGB()));
        _textColor = new Color(Integer.getInteger(COLOR_TEXT, SystemColor.textText.getRGB()));
        _selectedBgColor = new Color(Integer.getInteger(COLOR_SELECTED_BG, SystemColor.textHighlight.getRGB()));
        _selectedTextColor = new Color(Integer.getInteger(COLOR_SELECTED_TEXT, SystemColor.textHighlightText.getRGB()));
        _nodeBgColor = new Color(Integer.getInteger(COLOR_NODE_BG, SystemColor.window.getRGB()));
        _nodeTextColor = new Color(Integer.getInteger(COLOR_NODE_TEXT, SystemColor.textText.getRGB()));
        _dirty = false;
    }

    public static void setDefaults() {
        _selectedBgColor = DEFAULT_SELECTED_BG_COLOR;
        _selectedTextColor = DEFAULT_SELECTED_TEXT_COLOR;
        _bgColor = DEFAULT_BG_COLOR;
        _textColor = DEFAULT_TEXT_COLOR;
        _lineColor = DEFAULT_LINE_COLOR;
        _nodeBgColor = DEFAULT_NODE_BG_COLOR;
        _nodeTextColor = DEFAULT_NODE_TEXT_COLOR;
        _dirty = true;
    }

    public static Color getColor(ColorName colorName) {
        if (colorName == ColorName.BG) {
            return _bgColor;
        }
        if (colorName == ColorName.TEXT) {
            return _textColor;
        }
        if (colorName == ColorName.LINE) {
            return _lineColor;
        }
        if (colorName == ColorName.SELECTED_BG) {
            return _selectedBgColor;
        }
        if (colorName == ColorName.SELECTED_TEXT) {
            return _selectedTextColor;
        }
        if (colorName == ColorName.NODE_BG) {
            return _nodeBgColor;
        }
        if (colorName == ColorName.NODE_TEXT) {
            return _nodeTextColor;
        }
        return null;
    }

    public static void setColor(ColorName colorName, Color color) {
        if (colorName == ColorName.BG) {
            _bgColor = color;
        } else if (colorName == ColorName.TEXT) {
            _textColor = color;
        } else if (colorName == ColorName.LINE) {
            _lineColor = color;
        } else if (colorName == ColorName.SELECTED_BG) {
            _selectedBgColor = color;
        } else if (colorName == ColorName.SELECTED_TEXT) {
            _selectedTextColor = color;
        } else if (colorName == ColorName.NODE_BG) {
            _nodeBgColor = color;
        } else if (colorName == ColorName.NODE_TEXT) {
            _nodeTextColor = color;
        } else {
            return;
        }
        GraphProperties.firePropertyChanged(colorName + "");
        _dirty = true;
    }

    public static void addPropertyListener(PropertyListener propertyListener) {
        _listenerList.add(PropertyListener.class, propertyListener);
    }

    public static void removePropertyListener(PropertyListener propertyListener) {
        _listenerList.remove(PropertyListener.class, propertyListener);
    }

    private static void firePropertyChanged(String string) {
        Object[] objectArray = _listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != PropertyListener.class) continue;
            ((PropertyListener)objectArray[i + 1]).propertyChanged(string);
        }
    }

    static {
        _listenerList = new EventListenerList();
    }

    public static final class ColorName {
        public static ColorName BG = new ColorName("bg_color");
        public static ColorName TEXT = new ColorName("text_color");
        public static ColorName LINE = new ColorName("line_color");
        public static ColorName SELECTED_BG = new ColorName("selected_bg_color");
        public static ColorName SELECTED_TEXT = new ColorName("selected_text_color");
        public static ColorName NODE_BG = new ColorName("node_bg_color");
        public static ColorName NODE_TEXT = new ColorName("node_text_color");
        private String _name;

        private ColorName(String string) {
            this._name = string;
        }

        public String toString() {
            return this._name;
        }
    }
}

