/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.AbstractGrabHandle;
import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ConnectionComponent;
import com.sybase.JGraph.ConnectionComponentListener;
import com.sybase.JGraph.DefaultGraphEditor;
import com.sybase.JGraph.DestinationGrabHandle;
import com.sybase.JGraph.GraphEditor;
import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.JGraph;
import com.sybase.JGraph.JGraphResourceConstants;
import com.sybase.JGraph.Layout;
import com.sybase.JGraph.Model;
import com.sybase.JGraph.NodeComponent;
import com.sybase.JGraph.NodeComponentListener;
import com.sybase.JGraph.OriginGrabHandle;
import com.sybase.JGraph.PropertyListener;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;

final class InnerPanel
extends JLayeredPane
implements NodeComponentListener,
ConnectionComponentListener,
JGraphResourceConstants {
    private boolean _ignoreFocusChanges = false;
    static int SELECTION_BORDER_WIDTH = 2;
    static int SELECTION_GRAB_HANDLE_WIDTH = 6;
    static int SELECTION_POINTER_WIDTH = 5;
    static int GROWTH_BORDER_WIDTH = 20;
    static int MOVE_INCREMENT = 10;
    static int RESIZE_INCREMENT = 10;
    private Layout _layout;
    private Model _model;
    private JGraph _jgraph;
    private JPopupMenu _popupMenuGlobal = null;
    private SybMenuItem[] _boundPopupMenuItems = null;
    private JPopupMenu _connectionPopup;
    ActionListener _customizeAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InnerPanel.this._jgraph.showCustomizeDialog(InnerPanel.this._jgraph);
        }
    };
    private SybMenuItem _itemCustomize;
    NodeComponent _selectedNodeComponent;
    private ConnectionComponent _selectedConnectionComponent;
    private ArrayList<AbstractGrabHandle> _connectionGrabHandles = new ArrayList(2);
    private MouseHandler _mouseHandler = new MouseHandler();
    KeyListener _keyHandler = new KeyHandler();
    private ArrayList<ConnectionComponent> _connections = new ArrayList();
    private Component _editorComp;
    private CellEditorListener _editorListener;
    private Connection _editingConnection;
    GraphEditor _editor = new DefaultGraphEditor();
    private NodeComponent _movingNodeComponent;
    private Rectangle _originalBounds;
    private FocusListener _movingFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            InnerPanel.this.stopKeybMoving();
        }
    };
    Cursor _movingCursor = new Cursor(13);
    private NodeComponent _resizingNodeComponent;
    private FocusListener _resizingFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            InnerPanel.this.stopKeybResizing();
        }
    };
    private Cursor _resizingCursor = new Cursor(5);
    private Color _lineColor;
    private boolean _anchorMoving;
    private boolean _hideGrabHandles;
    boolean _editable;
    KeyListener _functionKeyHandler = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 113 && InnerPanel.this._editable) {
                if (InnerPanel.this._selectedConnectionComponent != null) {
                    InnerPanel.this.startEditing(InnerPanel.this._mouseHandler, InnerPanel.this._selectedConnectionComponent.getJComponent().getBounds(), InnerPanel.this._selectedConnectionComponent.getAssociatedConnection().getUserObject());
                }
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
                if (InnerPanel.this._selectedConnectionComponent != null) {
                    JComponent jComponent = InnerPanel.this._selectedConnectionComponent.getJComponent();
                    InnerPanel.this.showPopup(InnerPanel.this, ((Component)jComponent).getX(), ((Component)jComponent).getY());
                } else {
                    InnerPanel.this.showPopup(InnerPanel.this, InnerPanel.this.getX(), InnerPanel.this.getY());
                }
                keyEvent.consume();
            } else if (keyEvent.getKeyCode() == 10 && InnerPanel.this._selectedConnectionComponent != null) {
                InnerPanel.this._selectedConnectionComponent.open();
            }
        }
    };
    private PropertyListener _propertyListener = new PropertyListener(){

        @Override
        public void propertyChanged(String string) {
            if (string.equals(GraphProperties.ColorName.BG + "")) {
                InnerPanel.this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.BG));
            } else if (string.equals(GraphProperties.ColorName.LINE + "")) {
                InnerPanel.this._lineColor = GraphProperties.getColor(GraphProperties.ColorName.LINE);
                InnerPanel.this.repaint();
            }
        }
    };
    private SybMenuItem _itemMoveOrigin;
    private SybMenuItem _itemMoveDest;
    private SybMenuItem _itemCustomizeConnection;
    private EditAction _editAction = new EditAction(this);
    private MoveOriginAction _moveOriginAction = new MoveOriginAction(this);
    private MoveDestAction _moveDestAction = new MoveDestAction(this);
    private CustomizeConnectionAction _customizeConnectionAction = new CustomizeConnectionAction(this);
    ArrayList<GrabHandleComponent> _grabHandleComponents = new ArrayList(8);
    protected HashMap<JComponent, ConnectionComponent> _connCompForJComp = new HashMap();
    private ConnMouseHandler _connMouseHandler = new ConnMouseHandler(this);

    public InnerPanel(Dimension dimension, Layout layout, Model model, JGraph jGraph) {
        GrabHandleComponent grabHandleComponent = null;
        this._layout = layout;
        this._model = model;
        this._layout.setSize(dimension);
        this._jgraph = jGraph;
        this.setOpaque(true);
        this.setLayout(null);
        this.setPreferredSize(dimension);
        this.revalidate();
        for (int i = 0; i < 8; ++i) {
            grabHandleComponent = new GrabHandleComponent();
            this.add(grabHandleComponent);
            this._grabHandleComponents.add(grabHandleComponent);
            grabHandleComponent.addMouseMotionListener(this._mouseHandler);
            grabHandleComponent.addMouseListener(this._mouseHandler);
        }
        this.addMouseMotionListener(this._mouseHandler);
        this.addMouseListener(this._mouseHandler);
        this.addKeyListener(this._keyHandler);
        this.addKeyListener(this._functionKeyHandler);
        this._lineColor = GraphProperties.getColor(GraphProperties.ColorName.LINE);
        this.setBackground(GraphProperties.getColor(GraphProperties.ColorName.BG));
        GraphProperties.addPropertyListener(this._propertyListener);
    }

    public void destroy() {
        GrabHandleComponent grabHandleComponent = null;
        this.setSelectedNodeComponent(null);
        this.setSelectedConnectionComponent(null);
        this.removeMouseMotionListener(this._mouseHandler);
        this.removeMouseListener(this._mouseHandler);
        this.removeKeyListener(this._keyHandler);
        this.removeKeyListener(this._functionKeyHandler);
        GraphProperties.removePropertyListener(this._propertyListener);
        if (JGraph.customizable) {
            this._itemCustomize.removeActionListener(this._customizeAction);
        }
        if (this._itemMoveOrigin != null) {
            this._itemMoveOrigin.removeActionListener((ActionListener)this._moveOriginAction);
        }
        if (this._itemMoveDest != null) {
            this._itemMoveDest.removeActionListener((ActionListener)this._moveDestAction);
        }
        if (JGraph.customizable) {
            this._itemCustomizeConnection.removeActionListener((ActionListener)this._customizeConnectionAction);
        }
        this._connCompForJComp = null;
        this._layout = null;
        this._model = null;
        this._jgraph = null;
        this._customizeAction = null;
        this._moveOriginAction = null;
        this._moveDestAction = null;
        this._customizeConnectionAction = null;
        this._mouseHandler = null;
        this._keyHandler = null;
        this._functionKeyHandler = null;
        this._propertyListener = null;
        this._editor = null;
        this._popupMenuGlobal = null;
        this._boundPopupMenuItems = null;
        this._movingFocusListener = null;
        this._resizingFocusListener = null;
        this._connMouseHandler = null;
        for (int i = 0; i < 8; ++i) {
            grabHandleComponent = this._grabHandleComponents.get(i);
            grabHandleComponent.removeMouseMotionListener(this._mouseHandler);
            grabHandleComponent.removeMouseListener(this._mouseHandler);
        }
        this._grabHandleComponents.clear();
    }

    public void setBoundPopupMenuItems(SybMenuItem[] sybMenuItemArray) {
        this._boundPopupMenuItems = sybMenuItemArray;
        this.popupMenuSetup();
    }

    void popupMenuSetup() {
        if (JGraph.customizable) {
            this._popupMenuGlobal = new JPopupMenu();
            if (this._itemCustomize == null) {
                this._itemCustomize = new SybMenuItem(JGraph.getI18NMessage("global_popup.customize_caption"));
            } else {
                this._itemCustomize.removeActionListener(this._customizeAction);
            }
            this._itemCustomize.addActionListener(this._customizeAction);
            this._popupMenuGlobal.add((JMenuItem)this._itemCustomize);
        } else if (this._boundPopupMenuItems != null && this._boundPopupMenuItems.length > 0) {
            this._popupMenuGlobal = new JPopupMenu();
            for (int i = 0; i < this._boundPopupMenuItems.length; ++i) {
                this._popupMenuGlobal.add((JMenuItem)this._boundPopupMenuItems[i]);
            }
        }
    }

    private final void setupConnectionPopup() {
        this._connectionPopup = new JPopupMenu();
        this._itemMoveOrigin = new SybMenuItem(JGraph.getI18NMessage("connection_popup.move_origin_caption"));
        this._itemMoveOrigin.addActionListener((ActionListener)this._moveOriginAction);
        this._itemMoveDest = new SybMenuItem(JGraph.getI18NMessage("connection_popup.move_destination_caption"));
        this._itemMoveDest.addActionListener((ActionListener)this._moveDestAction);
        if (JGraph.customizable) {
            this._itemCustomizeConnection = new SybMenuItem(JGraph.getI18NMessage("global_popup.customize_caption"));
            this._itemCustomizeConnection.addActionListener((ActionListener)this._customizeConnectionAction);
        }
        this._connectionPopup.add((JMenuItem)this._itemMoveOrigin);
        this._connectionPopup.add((JMenuItem)this._itemMoveDest);
        if (JGraph.customizable) {
            this._connectionPopup.add(new JPopupMenu.Separator());
            this._connectionPopup.add((JMenuItem)this._itemCustomizeConnection);
        }
    }

    public NodeComponent getSelectedNodeComponent() {
        return this._selectedNodeComponent;
    }

    public ConnectionComponent getSelectedConnectionComponent() {
        return this._selectedConnectionComponent;
    }

    public void moveToFront(Component component, Component component2) {
        GrabHandleComponent grabHandleComponent = null;
        this._ignoreFocusChanges = true;
        for (int i = 0; i < 8; ++i) {
            grabHandleComponent = this._grabHandleComponents.get(i);
            super.moveToFront(grabHandleComponent);
        }
        super.moveToFront(component);
        if (component2 != null) {
            component2.requestFocus();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InnerPanel.this._ignoreFocusChanges = false;
            }
        });
    }

    public void setSelectedNodeComponent(NodeComponent nodeComponent) {
        if (this._selectedNodeComponent != null) {
            this._selectedNodeComponent.removeBoundListener(this._mouseHandler);
            this._selectedNodeComponent.removeFocusListener(this._mouseHandler);
            this._selectedNodeComponent.setSelected(false);
        }
        if (nodeComponent != null) {
            this.setSelectedConnectionComponent(null);
            nodeComponent.setSelected(true);
            this.scrollRectToVisible(nodeComponent.getJComponent().getBounds());
            this.moveToFront(nodeComponent.getJComponent(), nodeComponent.getJComponent());
        }
        this._selectedNodeComponent = nodeComponent;
        this._mouseHandler.setComponentBounds();
        this.repaint();
        if (nodeComponent != null) {
            nodeComponent.addBoundListener(this._mouseHandler);
            nodeComponent.addFocusListener(this._mouseHandler);
        }
    }

    void maybeChangeSelectedConnectionComponent(Point point) {
        Object object;
        Object object2 = null;
        double d = SELECTION_POINTER_WIDTH;
        double d2 = point.getX() - Math.floor(d / 2.0);
        double d3 = point.getY() - Math.floor(d / 2.0);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3, d, d);
        if (this._selectedConnectionComponent != null) {
            Connection connection = this._selectedConnectionComponent.getAssociatedConnection();
            object = this._selectedConnectionComponent.getLine();
            Ellipse2D ellipse2D = this._selectedConnectionComponent.getEllipse();
            if (connection.isLoop() && ellipse2D.intersects(double_) || !connection.isLoop() && ((Line2D)object).intersects(double_)) {
                return;
            }
        }
        for (int i = 0; i < this._connections.size(); ++i) {
            object = this._connections.get(i);
            if (object.getAssociatedConnection().isLoop()) {
                if (object.getEllipse() == null || !object.getEllipse().intersects(double_)) continue;
                object2 = object;
                break;
            }
            if (object.getLine() == null || !object.getLine().intersects(double_)) continue;
            object2 = object;
            break;
        }
        this.setSelectedConnectionComponent((ConnectionComponent)object2);
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
        if (!bl) {
            this._editor.cancelCellEditing();
            this.removeEditor();
        }
    }

    public void addConnection(ConnectionComponent connectionComponent) {
        this._connections.add(connectionComponent);
        this._layout.addConnection(connectionComponent);
        connectionComponent.addFocusListener(this);
        JComponent jComponent = connectionComponent.getJComponent();
        this.add(jComponent);
        this.moveToBack(jComponent);
        connectionComponent.addMouseListener(this._connMouseHandler);
        this._connCompForJComp.put(jComponent, connectionComponent);
        this.repaint();
    }

    public void removeConnection(ConnectionComponent connectionComponent) {
        JComponent jComponent = connectionComponent.getJComponent();
        this.remove(jComponent);
        this._connCompForJComp.remove(jComponent);
        connectionComponent.removeFocusListener(this);
        this._connections.remove(connectionComponent);
        this._layout.removeConnection(connectionComponent);
        connectionComponent.removeMouseListener(this._connMouseHandler);
        connectionComponent.destroy();
        this.repaint();
    }

    public void addNode(NodeComponent nodeComponent) {
        Rectangle rectangle = this._layout.addNode(nodeComponent);
        JComponent jComponent = nodeComponent.getJComponent();
        this.add(jComponent);
        if (rectangle != null) {
            jComponent.setBounds(rectangle);
            this.growToAccomodate(rectangle);
            this.scrollRectToVisible(rectangle);
        } else {
            jComponent.setBounds(new Rectangle(0, 0, jComponent.getPreferredSize().width, jComponent.getPreferredSize().height));
        }
        nodeComponent.addBoundListener(this);
        nodeComponent.addFocusListener(this);
        jComponent.setCursor(null);
    }

    public void removeNode(NodeComponent nodeComponent) {
        nodeComponent.removeBoundListener(this);
        nodeComponent.removeFocusListener(this);
        this.remove(nodeComponent.getJComponent());
        this._layout.removeNode(nodeComponent.getAssociatedNode());
        nodeComponent.destroy();
        if (this._selectedNodeComponent == nodeComponent) {
            this.setSelectedNodeComponent(null);
        } else {
            this.repaint();
        }
    }

    public void startEditing(CellEditorListener cellEditorListener, Rectangle rectangle, Object object) {
        this._editor.cancelCellEditing();
        this.removeEditor();
        this._editorComp = this._editor.getGraphEditorComponent(object);
        this.add(this._editorComp);
        this.moveToFront(this._editorComp, null);
        this._editorComp.setBounds(rectangle);
        this._editorComp.requestFocus();
        this._editorListener = cellEditorListener;
        this._editor.addCellEditorListener(this._editorListener);
        if (this._selectedConnectionComponent != null) {
            this._editingConnection = this._selectedConnectionComponent.getAssociatedConnection();
        }
    }

    public void removeEditor() {
        if (this._editorComp != null) {
            this.remove(this._editorComp);
            this._editor.removeCellEditorListener(this._editorListener);
            this._editorListener = null;
            this._editingConnection = null;
            this.repaint();
        }
    }

    public void startKeybMoving(NodeComponent nodeComponent) {
        this._movingNodeComponent = nodeComponent;
        if (this._movingNodeComponent != null) {
            JComponent jComponent = this._movingNodeComponent.getJComponent();
            this._originalBounds = jComponent.getBounds();
            this.setCursor(this._movingCursor);
            jComponent.addFocusListener(this._movingFocusListener);
        }
    }

    private void stopKeybMoving() {
        this.setCursor(null);
        if (this._movingNodeComponent != null) {
            JComponent jComponent = this._movingNodeComponent.getJComponent();
            jComponent.removeFocusListener(this._movingFocusListener);
        }
        this._movingNodeComponent = null;
        this._originalBounds = null;
    }

    private void cancelKeybMoving() {
        if (this._movingNodeComponent != null) {
            this.setNodeBounds(this._movingNodeComponent, this._originalBounds, true);
        }
        this.stopKeybMoving();
    }

    public void startKeybResizing(NodeComponent nodeComponent) {
        this._resizingNodeComponent = nodeComponent;
        if (this._resizingNodeComponent != null) {
            JComponent jComponent = this._resizingNodeComponent.getJComponent();
            this._originalBounds = jComponent.getBounds();
            this.setCursor(this._resizingCursor);
            jComponent.addFocusListener(this._resizingFocusListener);
        }
    }

    private void stopKeybResizing() {
        this.setCursor(null);
        if (this._resizingNodeComponent != null) {
            JComponent jComponent = this._resizingNodeComponent.getJComponent();
            jComponent.removeFocusListener(this._resizingFocusListener);
        }
        this._resizingNodeComponent = null;
        this._originalBounds = null;
    }

    private void cancelKeybResizing() {
        if (this._resizingNodeComponent != null) {
            this.setNodeBounds(this._resizingNodeComponent, this._originalBounds, true);
        }
        this.stopKeybResizing();
    }

    public void startAnchorMoving() {
        this._anchorMoving = true;
        this.setCursor(this._movingCursor);
    }

    public void stopAnchorMoving() {
        this._anchorMoving = false;
        this.setCursor(null);
    }

    public boolean setNodeBounds(NodeComponent nodeComponent, Rectangle rectangle, boolean bl) {
        Dimension dimension = nodeComponent.getMinSize();
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        int n3 = (int)rectangle.getWidth();
        int n4 = (int)rectangle.getHeight();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((double)n3 >= dimension.getWidth() && (double)n4 >= dimension.getHeight()) {
            Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
            if (bl) {
                this._layout.setNodeBounds(nodeComponent, rectangle2);
            } else {
                nodeComponent.getJComponent().setBounds(rectangle2);
            }
            this.growToAccomodate(rectangle2);
            return true;
        }
        return false;
    }

    @Override
    public void boundsChanged(EventObject eventObject) {
        Rectangle rectangle = ((JComponent)eventObject.getSource()).getBounds();
        this.growToAccomodate(rectangle);
    }

    @Override
    public void anchorsChanged(EventObject eventObject) {
        if (eventObject.getSource() == this._selectedConnectionComponent) {
            this._layout.setSibblingConnections(this._selectedConnectionComponent);
        }
    }

    @Override
    public void focusGained(EventObject eventObject) {
        if (!this._ignoreFocusChanges) {
            Object object = eventObject.getSource();
            NodeComponent nodeComponent = this.getSelectedNodeComponent();
            ConnectionComponent connectionComponent = this.getSelectedConnectionComponent();
            if (object instanceof NodeComponent && (nodeComponent == null || nodeComponent.getAssociatedNode().getUserObject() != ((NodeComponent)object).getAssociatedNode().getUserObject())) {
                this.setSelectedNodeComponent((NodeComponent)object);
            } else if (object instanceof ConnectionComponent && (connectionComponent == null || connectionComponent.getAssociatedConnection().getUserObject() != ((ConnectionComponent)object).getAssociatedConnection().getUserObject())) {
                this.setSelectedConnectionComponent((ConnectionComponent)object);
            }
        }
    }

    @Override
    public void focusLost(EventObject eventObject) {
    }

    @Override
    protected void paintChildren(Graphics graphics) {
        Iterator<ConnectionComponent> iterator = null;
        ConnectionComponent connectionComponent2 = null;
        GrabHandleComponent grabHandleComponent = null;
        Ellipse2D ellipse2D = null;
        Line2D line2D = null;
        Polygon polygon = null;
        Polygon polygon2 = null;
        Rectangle rectangle = null;
        for (ConnectionComponent connectionComponent2 : this._connections) {
            graphics.setColor(this._lineColor);
            if (connectionComponent2.getAssociatedConnection().isLoop()) {
                ellipse2D = connectionComponent2.getEllipse();
                if (ellipse2D != null) {
                    graphics.drawOval((int)ellipse2D.getX(), (int)ellipse2D.getY(), (int)ellipse2D.getWidth(), (int)ellipse2D.getHeight());
                }
            } else {
                line2D = connectionComponent2.getLine();
                if (line2D != null) {
                    graphics.drawLine((int)line2D.getX1(), (int)line2D.getY1(), (int)line2D.getX2(), (int)line2D.getY2());
                }
            }
            if ((polygon = connectionComponent2.getArrowHead1()) != null) {
                graphics.fillPolygon(polygon);
            }
            if ((polygon2 = connectionComponent2.getArrowHead2()) == null) continue;
            graphics.fillPolygon(polygon2);
        }
        super.paintChildren(graphics);
        if (this._selectedNodeComponent != null) {
            int n;
            if (!this._hideGrabHandles) {
                for (n = 0; n < 8; ++n) {
                    grabHandleComponent = this._grabHandleComponents.get(n);
                    grabHandleComponent.paint(graphics);
                }
            }
            rectangle = this._selectedNodeComponent.getJComponent().getBounds();
            graphics.setColor(this._lineColor);
            for (n = 1; n <= SELECTION_BORDER_WIDTH; ++n) {
                graphics.drawRect((int)rectangle.getX() - n, (int)rectangle.getY() - n, (int)rectangle.getWidth() - 1 + 2 * n, (int)rectangle.getHeight() - 1 + 2 * n);
            }
        }
    }

    void setGrabHandlesVisible(boolean bl) {
        GrabHandleComponent grabHandleComponent = null;
        this._hideGrabHandles = !bl;
        for (int i = 0; i < 8; ++i) {
            grabHandleComponent = this._grabHandleComponents.get(i);
            grabHandleComponent.setVisible(bl);
        }
        if (bl) {
            this.repaint();
        }
    }

    void growToAccomodate(Rectangle rectangle) {
        Dimension dimension = this.getPreferredSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        int n3 = (int)rectangle.getX() + (int)rectangle.getWidth() - 1;
        int n4 = (int)rectangle.getY() + (int)rectangle.getHeight() - 1;
        boolean bl = false;
        int n5 = n2;
        int n6 = n;
        if (n3 >= n) {
            n6 += n3 - n + 1 + GROWTH_BORDER_WIDTH;
            bl = true;
        }
        if (n4 >= n2) {
            n5 += n4 - n2 + 1 + GROWTH_BORDER_WIDTH;
            bl = true;
        }
        if (bl) {
            this.setPreferredSize(new Dimension(n6, n5));
            this.revalidate();
        } else {
            this.setPreferredSize(new Dimension(10, 10));
            this.growToAccomodate(this.getMinimumBounds());
        }
    }

    private Rectangle getMinimumBounds() {
        Component[] componentArray = null;
        Point point = null;
        Dimension dimension = null;
        int n = 0;
        int n2 = 0;
        componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            point = componentArray[i].getLocation();
            dimension = componentArray[i].getSize();
            if (point.x + dimension.width > n) {
                n = point.x + dimension.width;
            }
            if (point.y + dimension.height <= n2) continue;
            n2 = point.y + dimension.height;
        }
        return new Rectangle(n, n2);
    }

    private void showPopup(Component component, int n, int n2) {
        if (this._selectedConnectionComponent != null) {
            this.setupConnectionPopup();
            this._selectedConnectionComponent.setPopup(this._connectionPopup);
            this._selectedConnectionComponent.showPopup(component, n, n2);
        } else if (this._popupMenuGlobal != null) {
            UIUtils.showJPopupMenu((JPopupMenu)this._popupMenuGlobal, (JComponent)((JComponent)component), (Point)new Point(n, n2));
        }
    }

    void updateGrabHandles() {
        if (this._selectedConnectionComponent != null) {
            this.setSelectedConnectionComponent(this._selectedConnectionComponent);
        }
    }

    public void setSelectedConnectionComponent(ConnectionComponent connectionComponent) {
        AbstractGrabHandle abstractGrabHandle;
        this.setSelectedNodeComponent(null);
        for (int i = 0; i < this._connectionGrabHandles.size(); ++i) {
            abstractGrabHandle = this._connectionGrabHandles.get(i);
            this.remove(abstractGrabHandle);
            abstractGrabHandle.destroy();
        }
        this._connectionGrabHandles.clear();
        if (this._selectedConnectionComponent != null) {
            this._selectedConnectionComponent.setSelected(false);
            this._selectedConnectionComponent.removeAnchorListener(this);
        }
        if (connectionComponent != null && connectionComponent.getJComponent() != null) {
            this.scrollRectToVisible(connectionComponent.getJComponent().getBounds());
            this._layout.setSibblingConnections(connectionComponent);
            OriginGrabHandle originGrabHandle = new OriginGrabHandle(connectionComponent, this);
            this._connectionGrabHandles.add(originGrabHandle);
            this.add(originGrabHandle);
            this.moveToFront(originGrabHandle, null);
            abstractGrabHandle = new DestinationGrabHandle(connectionComponent, this);
            this._connectionGrabHandles.add(abstractGrabHandle);
            this.add(abstractGrabHandle);
            this.moveToFront(abstractGrabHandle, connectionComponent.getJComponent());
            connectionComponent.setSelected(true);
            connectionComponent.addAnchorListener(this);
        }
        this._selectedConnectionComponent = connectionComponent;
        this.repaint();
    }

    private NodeComponent getDefaultNodeComp() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component component = this.getComponent(i);
            if (!(component instanceof NodeComponent)) continue;
            return (NodeComponent)((Object)component);
        }
        return null;
    }

    private class GrabHandleComponent
    extends JComponent {
        GrabHandleComponent() {
            this.setFocusable(false);
            this.setVisible(false);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Rectangle rectangle = this.getBounds();
            graphics.setColor(InnerPanel.this._lineColor);
            graphics.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
        }
    }

    private static final class ConnMouseHandler
    extends MouseAdapter {
        private InnerPanel _parent;

        public ConnMouseHandler(InnerPanel innerPanel) {
            this._parent = innerPanel;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1 && this._parent._selectedConnectionComponent != null) {
                if (this._parent._editable) {
                    this._parent.startEditing(this._parent._mouseHandler, this._parent._selectedConnectionComponent.getJComponent().getBounds(), this._parent._selectedConnectionComponent.getAssociatedConnection().getUserObject());
                } else {
                    this._parent._selectedConnectionComponent.open();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            ConnectionComponent connectionComponent = this._parent._connCompForJComp.get(jComponent);
            this._parent.setSelectedConnectionComponent(connectionComponent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this._parent.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }
    }

    private class CustomizeConnectionAction
    implements ActionListener {
        private InnerPanel _parent;

        public CustomizeConnectionAction(InnerPanel innerPanel2) {
            this._parent = innerPanel2;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            InnerPanel.this._jgraph.showCustomizeDialog(InnerPanel.this._jgraph);
        }
    }

    private static final class MoveDestAction
    implements ActionListener {
        private InnerPanel _parent;

        public MoveDestAction(InnerPanel innerPanel) {
            this._parent = innerPanel;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._parent._selectedConnectionComponent != null) {
                AbstractGrabHandle abstractGrabHandle = (AbstractGrabHandle)this._parent._connectionGrabHandles.get(1);
                abstractGrabHandle.startKeybMoving(this._parent._selectedConnectionComponent);
            }
        }
    }

    private static final class MoveOriginAction
    implements ActionListener {
        private InnerPanel _parent;

        public MoveOriginAction(InnerPanel innerPanel) {
            this._parent = innerPanel;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._parent._selectedConnectionComponent != null) {
                AbstractGrabHandle abstractGrabHandle = (AbstractGrabHandle)this._parent._connectionGrabHandles.get(0);
                abstractGrabHandle.startKeybMoving(this._parent._selectedConnectionComponent);
            }
        }
    }

    private static final class EditAction
    implements ActionListener {
        private InnerPanel _parent;

        public EditAction(InnerPanel innerPanel) {
            this._parent = innerPanel;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._parent._editable && this._parent._selectedConnectionComponent != null) {
                this._parent.startEditing(this._parent._mouseHandler, this._parent._selectedConnectionComponent.getJComponent().getBounds(), this._parent._selectedConnectionComponent.getAssociatedConnection().getUserObject());
            }
        }
    }

    private static final class GrabHandle {
        static GrabHandle NORTH_WEST = new GrabHandle();
        static GrabHandle NORTH_EAST = new GrabHandle();
        static GrabHandle SOUTH_WEST = new GrabHandle();
        static GrabHandle SOUTH_EAST = new GrabHandle();
        static GrabHandle WEST = new GrabHandle();
        static GrabHandle EAST = new GrabHandle();
        static GrabHandle NORTH = new GrabHandle();
        static GrabHandle SOUTH = new GrabHandle();

        private GrabHandle() {
        }
    }

    private final class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            NodeComponent nodeComponent = null;
            ConnectionComponent connectionComponent = null;
            if (InnerPanel.this._movingNodeComponent != null) {
                Rectangle rectangle = InnerPanel.this._movingNodeComponent.getJComponent().getBounds();
                int n = (int)rectangle.getX();
                int n2 = (int)rectangle.getY();
                int n3 = (int)rectangle.getWidth();
                int n4 = (int)rectangle.getHeight();
                Rectangle rectangle2 = null;
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        InnerPanel.this.cancelKeybMoving();
                        break;
                    }
                    case 10: {
                        InnerPanel.this.stopKeybMoving();
                        break;
                    }
                    case 37: {
                        rectangle2 = new Rectangle(n -= keyEvent.isShiftDown() ? MOVE_INCREMENT * 4 : MOVE_INCREMENT, n2, n3, n4);
                        break;
                    }
                    case 39: {
                        rectangle2 = new Rectangle(n += keyEvent.isShiftDown() ? MOVE_INCREMENT * 4 : MOVE_INCREMENT, n2, n3, n4);
                        break;
                    }
                    case 38: {
                        rectangle2 = new Rectangle(n, n2 -= keyEvent.isShiftDown() ? MOVE_INCREMENT * 4 : MOVE_INCREMENT, n3, n4);
                        break;
                    }
                    case 40: {
                        rectangle2 = new Rectangle(n, n2 += keyEvent.isShiftDown() ? MOVE_INCREMENT * 4 : MOVE_INCREMENT, n3, n4);
                    }
                }
                if (rectangle2 != null) {
                    InnerPanel.this.setNodeBounds(InnerPanel.this._movingNodeComponent, rectangle2, true);
                    InnerPanel.this.scrollRectToVisible(rectangle2);
                    keyEvent.consume();
                }
            } else if (InnerPanel.this._resizingNodeComponent != null) {
                Rectangle rectangle = InnerPanel.this._resizingNodeComponent.getJComponent().getBounds();
                int n = (int)rectangle.getX();
                int n5 = (int)rectangle.getY();
                int n6 = (int)rectangle.getWidth();
                int n7 = (int)rectangle.getHeight();
                Rectangle rectangle3 = null;
                switch (keyEvent.getKeyCode()) {
                    case 27: {
                        InnerPanel.this.cancelKeybResizing();
                        break;
                    }
                    case 10: {
                        InnerPanel.this.stopKeybResizing();
                        break;
                    }
                    case 37: {
                        rectangle3 = new Rectangle(n, n5, n6 -= keyEvent.isShiftDown() ? RESIZE_INCREMENT * 4 : RESIZE_INCREMENT, n7);
                        break;
                    }
                    case 39: {
                        rectangle3 = new Rectangle(n, n5, n6 += keyEvent.isShiftDown() ? RESIZE_INCREMENT * 4 : RESIZE_INCREMENT, n7);
                        break;
                    }
                    case 38: {
                        rectangle3 = new Rectangle(n, n5, n6, n7 -= keyEvent.isShiftDown() ? RESIZE_INCREMENT * 4 : RESIZE_INCREMENT);
                        break;
                    }
                    case 40: {
                        rectangle3 = new Rectangle(n, n5, n6, n7 += keyEvent.isShiftDown() ? RESIZE_INCREMENT * 4 : RESIZE_INCREMENT);
                    }
                }
                if (rectangle3 != null) {
                    InnerPanel.this.setNodeBounds(InnerPanel.this._resizingNodeComponent, rectangle3, true);
                    InnerPanel.this.scrollRectToVisible(rectangle3);
                    keyEvent.consume();
                }
            } else if (InnerPanel.this._selectedConnectionComponent == null && InnerPanel.this._selectedNodeComponent == null && (keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40)) {
                nodeComponent = InnerPanel.this.getDefaultNodeComp();
            } else if (InnerPanel.this._selectedNodeComponent != null) {
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        if (!keyEvent.isShiftDown()) {
                            nodeComponent = InnerPanel.this._layout.getLeftNode(InnerPanel.this._selectedNodeComponent);
                            break;
                        }
                        connectionComponent = InnerPanel.this._layout.getLeftConnection(InnerPanel.this._selectedNodeComponent);
                        break;
                    }
                    case 39: {
                        if (!keyEvent.isShiftDown()) {
                            nodeComponent = InnerPanel.this._layout.getRightNode(InnerPanel.this._selectedNodeComponent, InnerPanel.this.getBounds());
                            break;
                        }
                        connectionComponent = InnerPanel.this._layout.getRightConnection(InnerPanel.this._selectedNodeComponent);
                        break;
                    }
                    case 38: {
                        if (!keyEvent.isShiftDown()) {
                            nodeComponent = InnerPanel.this._layout.getUpNode(InnerPanel.this._selectedNodeComponent);
                            break;
                        }
                        connectionComponent = InnerPanel.this._layout.getUpConnection(InnerPanel.this._selectedNodeComponent);
                        break;
                    }
                    case 40: {
                        if (!keyEvent.isShiftDown()) {
                            nodeComponent = InnerPanel.this._layout.getDownNode(InnerPanel.this._selectedNodeComponent, InnerPanel.this.getBounds());
                            break;
                        }
                        connectionComponent = InnerPanel.this._layout.getDownConnection(InnerPanel.this._selectedNodeComponent);
                        break;
                    }
                    case 10: {
                        InnerPanel.this._selectedNodeComponent.open();
                    }
                }
            } else if (InnerPanel.this._selectedConnectionComponent != null) {
                switch (keyEvent.getKeyCode()) {
                    case 36: {
                        nodeComponent = InnerPanel.this._layout.getOrigin(InnerPanel.this._selectedConnectionComponent);
                        break;
                    }
                    case 35: {
                        nodeComponent = InnerPanel.this._layout.getDestination(InnerPanel.this._selectedConnectionComponent);
                        break;
                    }
                    case 80: {
                        connectionComponent = InnerPanel.this._layout.getPreviousConnection();
                        break;
                    }
                    case 78: {
                        connectionComponent = InnerPanel.this._layout.getNextConnection();
                        break;
                    }
                    case 10: {
                        InnerPanel.this._selectedConnectionComponent.open();
                    }
                }
            }
            if (nodeComponent != null) {
                nodeComponent.getJComponent().requestFocus();
                keyEvent.consume();
            } else if (connectionComponent != null) {
                connectionComponent.getJComponent().requestFocus();
                keyEvent.consume();
            }
        }
    }

    private final class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    NodeComponentListener,
    CellEditorListener {
        private Rectangle _upperLeftGH;
        private Rectangle _upperRightGH;
        private Rectangle _middleLeftGH;
        private Rectangle _middleRightGH;
        private Rectangle _lowerLeftGH;
        private Rectangle _lowerRightGH;
        private Rectangle _upperMiddleGH;
        private Rectangle _lowerMiddleGH;
        private GrabHandle _currentGH;
        private Point _initialPosition;
        private boolean _enabled;
        private Rectangle _newBounds;

        private MouseHandler() {
        }

        private MouseEvent createMouseEventForInnerPanel(MouseEvent mouseEvent) {
            if (mouseEvent.getSource() instanceof GrabHandleComponent) {
                Point point = SwingUtilities.convertPoint((GrabHandleComponent)mouseEvent.getSource(), mouseEvent.getPoint().x, mouseEvent.getPoint().y, InnerPanel.this);
                return new MouseEvent(InnerPanel.this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
            return mouseEvent;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            mouseEvent = this.createMouseEventForInnerPanel(mouseEvent);
            if (this._initialPosition != null) {
                InnerPanel.this.setCursor(this.getCursor());
                JComponent jComponent = InnerPanel.this._selectedNodeComponent.getJComponent();
                Rectangle rectangle = jComponent.getBounds();
                int n = (int)rectangle.getX();
                int n2 = (int)rectangle.getY();
                int n3 = (int)rectangle.getWidth();
                int n4 = (int)rectangle.getHeight();
                if (this._currentGH == GrabHandle.SOUTH_WEST) {
                    n3 = (int)rectangle.getWidth() + (int)this._initialPosition.getX() - mouseEvent.getX();
                    n -= (int)this._initialPosition.getX() - mouseEvent.getX();
                    n4 = (int)rectangle.getHeight() + mouseEvent.getY() - (int)this._initialPosition.getY();
                } else if (this._currentGH == GrabHandle.SOUTH_EAST) {
                    n3 = (int)rectangle.getWidth() + mouseEvent.getX() - (int)this._initialPosition.getX();
                    n4 = (int)rectangle.getHeight() + mouseEvent.getY() - (int)this._initialPosition.getY();
                } else if (this._currentGH == GrabHandle.NORTH_WEST) {
                    n3 = (int)rectangle.getWidth() + (int)this._initialPosition.getX() - mouseEvent.getX();
                    n -= (int)this._initialPosition.getX() - mouseEvent.getX();
                    n4 = (int)rectangle.getHeight() + (int)this._initialPosition.getY() - mouseEvent.getY();
                    n2 -= (int)this._initialPosition.getY() - mouseEvent.getY();
                } else if (this._currentGH == GrabHandle.NORTH_EAST) {
                    n3 = (int)rectangle.getWidth() + mouseEvent.getX() - (int)this._initialPosition.getX();
                    n4 = (int)rectangle.getHeight() + (int)this._initialPosition.getY() - mouseEvent.getY();
                    n2 -= (int)this._initialPosition.getY() - mouseEvent.getY();
                } else if (this._currentGH == GrabHandle.WEST) {
                    n3 = (int)rectangle.getWidth() + (int)this._initialPosition.getX() - mouseEvent.getX();
                    n -= (int)this._initialPosition.getX() - mouseEvent.getX();
                } else if (this._currentGH == GrabHandle.EAST) {
                    n3 = (int)rectangle.getWidth() + mouseEvent.getX() - (int)this._initialPosition.getX();
                } else if (this._currentGH == GrabHandle.SOUTH) {
                    n4 = (int)rectangle.getHeight() + mouseEvent.getY() - (int)this._initialPosition.getY();
                } else if (this._currentGH == GrabHandle.NORTH) {
                    n4 = (int)rectangle.getHeight() + (int)this._initialPosition.getY() - mouseEvent.getY();
                    n2 -= (int)this._initialPosition.getY() - mouseEvent.getY();
                }
                Rectangle rectangle2 = new Rectangle(n, n2, n3, n4);
                if (InnerPanel.this.setNodeBounds(InnerPanel.this._selectedNodeComponent, rectangle2, false)) {
                    this._initialPosition = mouseEvent.getPoint();
                    this._newBounds = rectangle2;
                }
                InnerPanel.this.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            mouseEvent = this.createMouseEventForInnerPanel(mouseEvent);
            this.setGrabHandle(mouseEvent.getPoint());
            if (this.isIdle()) {
                InnerPanel.this.setCursor(this.getCursor());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent = this.createMouseEventForInnerPanel(mouseEvent)).getButton() == 1 && this._currentGH != null) {
                this.startResizing(mouseEvent);
            } else {
                InnerPanel.this.maybeChangeSelectedConnectionComponent(mouseEvent.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent = this.createMouseEventForInnerPanel(mouseEvent)).isPopupTrigger()) {
                InnerPanel.this.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (mouseEvent.getButton() == 1) {
                this.stopResizing(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((mouseEvent = this.createMouseEventForInnerPanel(mouseEvent)).getClickCount() > 1 && InnerPanel.this._selectedConnectionComponent != null) {
                if (InnerPanel.this._editable) {
                    InnerPanel.this.startEditing(InnerPanel.this._mouseHandler, InnerPanel.this._selectedConnectionComponent.getJComponent().getBounds(), InnerPanel.this._selectedConnectionComponent.getAssociatedConnection().getUserObject());
                } else {
                    InnerPanel.this._selectedConnectionComponent.open();
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            mouseEvent = this.createMouseEventForInnerPanel(mouseEvent);
            if (this.isIdle()) {
                InnerPanel.this.setCursor(null);
            }
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            InnerPanel.this.removeEditor();
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            InnerPanel.this._editingConnection.setUserObject(InnerPanel.this._editor.getCellEditorValue());
            InnerPanel.this.removeEditor();
        }

        @Override
        public void boundsChanged(EventObject eventObject) {
            if (eventObject.getSource() == InnerPanel.this._selectedNodeComponent) {
                this.setComponentBounds();
                InnerPanel.this.repaint();
            }
        }

        @Override
        public void focusGained(EventObject eventObject) {
            if (!InnerPanel.this._ignoreFocusChanges) {
                Object object = eventObject.getSource();
                NodeComponent nodeComponent = InnerPanel.this.getSelectedNodeComponent();
                if (object instanceof NodeComponent && (nodeComponent == null || nodeComponent.getAssociatedNode().getUserObject() != ((NodeComponent)object).getAssociatedNode().getUserObject())) {
                    InnerPanel.this.setSelectedNodeComponent((NodeComponent)object);
                }
            }
        }

        @Override
        public void focusLost(EventObject eventObject) {
        }

        public void setComponentBounds() {
            block5: {
                Rectangle rectangle = null;
                GrabHandleComponent grabHandleComponent = null;
                if (InnerPanel.this._selectedNodeComponent != null) {
                    rectangle = InnerPanel.this._selectedNodeComponent.getJComponent().getBounds();
                }
                boolean bl = this._enabled = rectangle != null;
                if (!this._enabled) break block5;
                int n = (int)rectangle.getX();
                int n2 = (int)rectangle.getY();
                int n3 = (int)rectangle.getWidth() - 1;
                int n4 = (int)rectangle.getHeight() - 1;
                int n5 = SELECTION_GRAB_HANDLE_WIDTH;
                this._upperLeftGH = new Rectangle(n - n5, n2 - n5, n5, n5);
                this._upperRightGH = new Rectangle(n + n3 + 1, n2 - n5, n5, n5);
                this._lowerLeftGH = new Rectangle(n - n5, n2 + n4 + 1, n5, n5);
                this._lowerRightGH = new Rectangle(n + n3 + 1, n2 + n4 + 1, n5, n5);
                int n6 = (int)Math.ceil((double)n3 / 2.0);
                int n7 = (int)Math.floor((double)n5 / 2.0);
                this._upperMiddleGH = new Rectangle(n + n6 - n7, n2 - n5, n5, n5);
                this._lowerMiddleGH = new Rectangle(n + n6 - n7, n2 + n4 + 1, n5, n5);
                int n8 = (int)Math.ceil((double)n4 / 2.0);
                this._middleLeftGH = new Rectangle(n - n5, n2 + n8 - n7, n5, n5);
                this._middleRightGH = new Rectangle(n + n3 + 1, n2 + n8 - n7, n5, n5);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(0);
                grabHandleComponent.setBounds(this._upperLeftGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(1);
                grabHandleComponent.setBounds(this._upperMiddleGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(2);
                grabHandleComponent.setBounds(this._upperRightGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(3);
                grabHandleComponent.setBounds(this._middleLeftGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(4);
                grabHandleComponent.setBounds(this._middleRightGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(5);
                grabHandleComponent.setBounds(this._lowerLeftGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(6);
                grabHandleComponent.setBounds(this._lowerMiddleGH);
                grabHandleComponent = InnerPanel.this._grabHandleComponents.get(7);
                grabHandleComponent.setBounds(this._lowerRightGH);
                if (!InnerPanel.this._hideGrabHandles) {
                    for (int i = 0; i < 8; ++i) {
                        grabHandleComponent = InnerPanel.this._grabHandleComponents.get(i);
                        grabHandleComponent.setVisible(true);
                    }
                } else {
                    for (int i = 0; i < 8; ++i) {
                        grabHandleComponent = InnerPanel.this._grabHandleComponents.get(i);
                        grabHandleComponent.setVisible(false);
                    }
                }
            }
        }

        private void startResizing(MouseEvent mouseEvent) {
            this._initialPosition = mouseEvent.getPoint();
            for (int i = 0; i < InnerPanel.this.getComponentCount(); ++i) {
                if (!(InnerPanel.this.getComponent(i) instanceof NodeComponent)) continue;
                NodeComponent nodeComponent = (NodeComponent)((Object)InnerPanel.this.getComponent(i));
                nodeComponent.disableMouseListeners();
            }
        }

        private void stopResizing(MouseEvent mouseEvent) {
            this._initialPosition = null;
            if (this._newBounds != null) {
                InnerPanel.this.setNodeBounds(InnerPanel.this._selectedNodeComponent, this._newBounds, true);
                this._newBounds = null;
            }
            for (int i = 0; i < InnerPanel.this.getComponentCount(); ++i) {
                if (!(InnerPanel.this.getComponent(i) instanceof NodeComponent)) continue;
                NodeComponent nodeComponent = (NodeComponent)((Object)InnerPanel.this.getComponent(i));
                nodeComponent.reenableMouseListeners();
            }
        }

        private void setGrabHandle(Point point) {
            this._currentGH = !this._enabled ? null : (this.isWithinRect(point, this._lowerLeftGH) ? GrabHandle.SOUTH_WEST : (this.isWithinRect(point, this._lowerRightGH) ? GrabHandle.SOUTH_EAST : (this.isWithinRect(point, this._upperLeftGH) ? GrabHandle.NORTH_WEST : (this.isWithinRect(point, this._upperRightGH) ? GrabHandle.NORTH_EAST : (this.isWithinRect(point, this._middleLeftGH) ? GrabHandle.WEST : (this.isWithinRect(point, this._middleRightGH) ? GrabHandle.EAST : (this.isWithinRect(point, this._lowerMiddleGH) ? GrabHandle.SOUTH : (this.isWithinRect(point, this._upperMiddleGH) ? GrabHandle.NORTH : null))))))));
        }

        private Cursor getCursor() {
            if (this._currentGH == GrabHandle.SOUTH_WEST) {
                return new Cursor(4);
            }
            if (this._currentGH == GrabHandle.SOUTH_EAST) {
                return new Cursor(5);
            }
            if (this._currentGH == GrabHandle.NORTH_WEST) {
                return new Cursor(6);
            }
            if (this._currentGH == GrabHandle.NORTH_EAST) {
                return new Cursor(7);
            }
            if (this._currentGH == GrabHandle.WEST) {
                return new Cursor(10);
            }
            if (this._currentGH == GrabHandle.EAST) {
                return new Cursor(11);
            }
            if (this._currentGH == GrabHandle.SOUTH) {
                return new Cursor(9);
            }
            if (this._currentGH == GrabHandle.NORTH) {
                return new Cursor(8);
            }
            return null;
        }

        private boolean isWithinRect(Point point, Rectangle rectangle) {
            if (rectangle == null) {
                return false;
            }
            int n = (int)rectangle.getX();
            int n2 = (int)rectangle.getX() + (int)rectangle.getWidth() - 1;
            int n3 = (int)rectangle.getY();
            int n4 = (int)rectangle.getY() + (int)rectangle.getHeight() - 1;
            int n5 = (int)point.getX();
            int n6 = (int)point.getY();
            return n5 >= n && n5 <= n2 && n6 >= n3 && n6 <= n4;
        }

        private boolean isIdle() {
            return this._initialPosition == null && InnerPanel.this._movingNodeComponent == null && InnerPanel.this._resizingNodeComponent == null && !InnerPanel.this._anchorMoving;
        }
    }
}

