/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ConnectionComponent;
import com.sybase.JGraph.ConnectionRenderer;
import com.sybase.JGraph.DefaultConnectionRenderer;
import com.sybase.JGraph.DefaultModel;
import com.sybase.JGraph.DefaultNodeRenderer;
import com.sybase.JGraph.GraphProperties;
import com.sybase.JGraph.InnerPanel;
import com.sybase.JGraph.JGraphCustomizationPage;
import com.sybase.JGraph.JGraphImageLoader;
import com.sybase.JGraph.JGraphResourceConstants;
import com.sybase.JGraph.Layout;
import com.sybase.JGraph.Model;
import com.sybase.JGraph.ModelEvent;
import com.sybase.JGraph.ModelListener;
import com.sybase.JGraph.Node;
import com.sybase.JGraph.NodeComponent;
import com.sybase.JGraph.NodeRenderer;
import com.sybase.JGraph.NodeSelection;
import com.sybase.JGraph.SerializableNode;
import com.sybase.JGraph.XMLMemento;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.PrintDialog;
import com.sybase.util.PrintJobListener;
import com.sybase.util.PrintJobThread;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.RGBImageFilter;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class JGraph
extends JComponent
implements Printable,
Customizable,
CustomizerHost,
JGraphResourceConstants {
    private static HashMap<String, String> _i18nCache = new HashMap();
    protected InnerPanel _contents;
    protected JScrollPane _scrollPane;
    Layout _layout = new Layout();
    protected Model _model = new DefaultModel();
    protected NodeRenderer _nodeRenderer = new DefaultNodeRenderer();
    protected ConnectionRenderer _connectionRenderer = new DefaultConnectionRenderer();
    private JPopupMenu _nodePopup;
    protected HashMap<Node, NodeComponent> _componentForNode = new HashMap();
    protected HashMap<Connection, ConnectionComponent> _componentForConnection = new HashMap();
    protected XMLMemento _xmlMemento = new XMLMemento(this._layout);
    private ModelListener _modelListener;
    private ResizeHandler _resizeHandler;
    CustomizerHost _customizerHost = null;
    CustomizeDialog _customizeDialog = null;
    protected final Clipboard _clipboard = this.getToolkit().getSystemClipboard();
    protected boolean _fitToPage;
    protected boolean _editable;
    protected boolean _isDestroyed;
    private FunctionKeyHandler _functionKeyHandler;
    private final NodeMouseHandler _nodeMouseHandler;
    private CustomizeAction _customizeAction = new CustomizeAction(this);
    private MoveAction _moveAction = new MoveAction(this);
    private ResizeAction _resizeAction = new ResizeAction(this);
    private SybMenuItem _itemCustomize;
    private SybMenuItem _itemMove;
    private SybMenuItem _itemResize;
    private PrintJobThread _printJobThread = null;
    static boolean customizable = true;
    private JGraphCustomizationPage _customizationPage = new JGraphCustomizationPage();
    protected Timer _walkTimer = null;
    private WalkNodeAction _walkNodeAction = null;
    private static Dimension DEFAULT_SIZE = new Dimension(800, 800);

    public JGraph() {
        this(true);
    }

    public JGraph(boolean bl) {
        this(null, DEFAULT_SIZE, bl);
    }

    public JGraph(Model model, Dimension dimension) {
        this(model, dimension, true);
    }

    public JGraph(Model model, Dimension dimension, boolean bl) {
        if (dimension == null) {
            dimension = DEFAULT_SIZE;
        }
        customizable = bl;
        GraphProperties.load();
        this._contents = new InnerPanel(dimension, this._layout, model, this);
        this._scrollPane = new JScrollPane(this._contents);
        this._scrollPane.getHorizontalScrollBar().setUnitIncrement(16);
        this._scrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.setModel(model);
        this.setBorder(null);
        this.setLayout(new GridLayout(1, 1));
        this.add(this._scrollPane);
        this._resizeHandler = new ResizeHandler(this);
        this.addComponentListener(this._resizeHandler);
        this._contents.popupMenuSetup();
        this.setPreferredSize(dimension);
        this.revalidate();
        this.setEditable(true);
        this._nodeMouseHandler = new NodeMouseHandler(this);
        this._functionKeyHandler = new FunctionKeyHandler(this);
        this._walkNodeAction = new WalkNodeAction(this);
        this._walkTimer = new Timer(250, this._walkNodeAction);
    }

    public void destroy() {
        if (!this._isDestroyed) {
            this._walkTimer.stop();
            this._walkTimer = null;
            this._walkNodeAction.destroy();
            this._walkNodeAction = null;
            this._isDestroyed = true;
            this.removeAll();
            this._model.removeModelListener(this._modelListener);
            this.removeComponentListener(this._resizeHandler);
            this._scrollPane.getViewport().remove(this._contents);
            if (customizable && this._itemCustomize != null) {
                this._itemCustomize.removeActionListener((ActionListener)this._customizeAction);
            }
            if (this._itemMove != null) {
                this._itemMove.removeActionListener((ActionListener)this._moveAction);
            }
            if (this._itemResize != null) {
                this._itemResize.removeActionListener((ActionListener)this._resizeAction);
            }
            this._contents.destroy();
            this._layout.destroy();
            this._xmlMemento.destroy();
            this._nodeMouseHandler.destroy();
            this._resizeHandler.destroy();
            this._functionKeyHandler.destroy();
            this._customizeAction.destroy();
            this._moveAction.destroy();
            this._resizeAction.destroy();
            this._customizationPage.destroy();
            this._model = null;
            this._nodePopup = null;
            this._functionKeyHandler = null;
            this._resizeHandler = null;
            this._nodeRenderer = null;
            this._connectionRenderer = null;
            this._customizeAction = null;
            this._moveAction = null;
            this._resizeAction = null;
            this._itemCustomize = null;
            this._itemMove = null;
            this._itemResize = null;
            this._modelListener = null;
            this._xmlMemento = null;
            this._layout = null;
            this._contents = null;
            this._customizationPage = null;
            this._printJobThread = null;
            for (NodeComponent eventListener : this._componentForNode.values()) {
                eventListener.destroy();
            }
            for (ConnectionComponent connectionComponent : this._componentForConnection.values()) {
                connectionComponent.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public Model getModel() {
        return this._model;
    }

    public void setBoundPopupMenuItems(SybMenuItem[] sybMenuItemArray) {
        this._contents.setBoundPopupMenuItems(sybMenuItemArray);
    }

    public void setLayoutDefaults(int n, int n2, int n3) {
        this._layout._freeList.setDefaultCellWidth(n);
        this._layout._freeList.setDefaultCellHeight(n2);
        this._layout._freeList.setDefaultCellBorder(n3);
    }

    public CustomizeDialog getCustomizeDialog(Window window) {
        if (this.getCustomizerHost() != null) {
            return this.getCustomizerHost().getCustomizeDialog(window);
        }
        if (this._customizeDialog == null) {
            this._customizeDialog = window instanceof Dialog ? new CustomizeDialog((Dialog)window) : new CustomizeDialog((Frame)window);
            this._customizeDialog.addCustomizationPages((Customizable)this);
        }
        return this._customizeDialog;
    }

    public CustomizationPage[] getCustomizationPages() {
        CustomizationPage[] customizationPageArray = new CustomizationPage[]{this._customizationPage};
        return customizationPageArray;
    }

    public Icon getCustomizationGroupIcon() {
        return JGraphImageLoader.getImageIcon("jgraph", 1001);
    }

    public String getCustomizationGroupTitle() {
        return JGraph.getI18NMessage("customizer.title");
    }

    public void acceptChanges() {
        this._customizationPage.deployColors();
    }

    public void rejectChanges() {
    }

    public CustomizerHost getCustomizerHost() {
        return this._customizerHost;
    }

    public void setCustomizerHost(CustomizerHost customizerHost) {
        this._customizerHost = customizerHost;
    }

    public String getNodeLayout() throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        return this._xmlMemento.getLayout();
    }

    public void setNodeLayout(String string) throws SAXException, ParserConfigurationException, IOException {
        if (string != null) {
            this._xmlMemento.setLayout(string);
            this._contents.scrollRectToVisible(new Rectangle(1, 1));
            this._contents.repaint();
        }
    }

    public Rectangle getNodeBounds(Node node) {
        NodeComponent nodeComponent = this._componentForNode.get(node);
        if (nodeComponent != null) {
            return ((Component)((Object)nodeComponent)).getBounds();
        }
        return null;
    }

    public void setNodeBounds(Node node, Rectangle rectangle) {
        NodeComponent nodeComponent = this._componentForNode.get(node);
        if (nodeComponent != null) {
            ((Component)((Object)nodeComponent)).setBounds(rectangle);
        }
    }

    public Point getOriginPosition(Connection connection) {
        ConnectionComponent connectionComponent = this._componentForConnection.get(connection);
        if (connectionComponent != null) {
            return connectionComponent.getRelOriginPosition();
        }
        return null;
    }

    public void setOriginPosition(Connection connection, Point point) {
        ConnectionComponent connectionComponent = this._componentForConnection.get(connection);
        if (connectionComponent != null) {
            connectionComponent.setRelOriginPosition(point);
        }
        this._contents.updateGrabHandles();
    }

    public Point getDestPosition(Connection connection) {
        ConnectionComponent connectionComponent = this._componentForConnection.get(connection);
        if (connectionComponent != null) {
            return connectionComponent.getRelDestPosition();
        }
        return null;
    }

    public void setDestPosition(Connection connection, Point point) {
        ConnectionComponent connectionComponent = this._componentForConnection.get(connection);
        if (connectionComponent != null) {
            connectionComponent.setRelDestPosition(point);
        }
        this._contents.updateGrabHandles();
    }

    private void setupNodePopup() {
        this._nodePopup = new JPopupMenu();
        this._itemMove = new SybMenuItem(JGraph.getI18NMessage("node_popup.move_caption"));
        this._itemMove.addActionListener((ActionListener)this._moveAction);
        this._itemResize = new SybMenuItem(JGraph.getI18NMessage("node_popup.resize_caption"));
        this._itemResize.addActionListener((ActionListener)this._resizeAction);
        if (customizable) {
            this._itemCustomize = new SybMenuItem(JGraph.getI18NMessage("global_popup.customize_caption"));
            this._itemCustomize.addActionListener((ActionListener)this._customizeAction);
        }
        this._nodePopup.add((JMenuItem)this._itemMove);
        this._nodePopup.add((JMenuItem)this._itemResize);
        if (customizable) {
            this._nodePopup.add(new JPopupMenu.Separator());
            this._nodePopup.add((JMenuItem)this._itemCustomize);
        }
    }

    private final NodeComponent getComponent() {
        return this._contents.getSelectedNodeComponent();
    }

    private final Node getNode() {
        return this._contents.getSelectedNodeComponent().getAssociatedNode();
    }

    @Override
    public void requestFocus() {
        this._contents.requestFocus();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this._contents.setBackground(color);
        GraphProperties.setColor(GraphProperties.ColorName.BG, color);
    }

    public boolean isCopyEnabled() {
        NodeComponent nodeComponent = this._contents.getSelectedNodeComponent();
        return nodeComponent != null && nodeComponent instanceof Serializable;
    }

    public void copySelectedNode() {
        NodeComponent nodeComponent = this._contents.getSelectedNodeComponent();
        if (this.isCopyEnabled()) {
            SerializableNode serializableNode = new SerializableNode(nodeComponent.getAssociatedNode());
            NodeSelection nodeSelection = new NodeSelection(serializableNode);
            this._clipboard.setContents(nodeSelection, new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
        }
    }

    public boolean isCutEnabled() {
        NodeComponent nodeComponent = this._contents.getSelectedNodeComponent();
        return this._editable && nodeComponent != null && nodeComponent instanceof Serializable;
    }

    public void cutSelectedNode() {
        NodeComponent nodeComponent = this._contents.getSelectedNodeComponent();
        if (this.isCutEnabled()) {
            SerializableNode serializableNode = new SerializableNode(nodeComponent.getAssociatedNode());
            NodeSelection nodeSelection = new NodeSelection(serializableNode);
            this._clipboard.setContents(nodeSelection, new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
            this._model.removeNode(nodeComponent.getAssociatedNode());
        }
    }

    public boolean isPasteEnabled() {
        Transferable transferable = this._clipboard.getContents(this);
        return this._editable && transferable != null && transferable.isDataFlavorSupported(NodeSelection.FLAVOR);
    }

    public void paste() {
        if (this.isPasteEnabled()) {
            Transferable transferable = this._clipboard.getContents(this);
            try {
                Object object = transferable.getTransferData(NodeSelection.FLAVOR);
                SerializableNode serializableNode = (SerializableNode)object;
                Node node = this._model.addNode();
                node.setUserObject(serializableNode.getUserObject());
                Iterator iterator = serializableNode.getLoops();
                while (iterator.hasNext()) {
                    Connection connection = this._model.addConnection(node, node);
                    connection.setUserObject(iterator.next());
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setModel(Model model) {
        Object object;
        int n;
        if (model == null) {
            model = new DefaultModel();
        }
        this.discardModel();
        this._model = model;
        this._modelListener = new ModelListener(){

            @Override
            public void nodeAdded(ModelEvent modelEvent) {
                JGraph.this.addNodeImpl((Node)modelEvent.getSource());
            }

            @Override
            public void nodeRemoved(ModelEvent modelEvent) {
                JGraph.this.removeNodeImpl((Node)modelEvent.getSource());
            }

            @Override
            public void connectionAdded(ModelEvent modelEvent) {
                JGraph.this.addConnectionImpl((Connection)modelEvent.getSource());
            }

            @Override
            public void connectionRemoved(ModelEvent modelEvent) {
                JGraph.this.removeConnectionImpl((Connection)modelEvent.getSource());
            }
        };
        this._model.addModelListener(this._modelListener);
        for (n = 0; n < this._model.getNodeCount(); ++n) {
            object = this._model.getNode(n);
            this.addNodeImpl((Node)object);
        }
        for (n = 0; n < this._model.getConnectionCount(); ++n) {
            object = this._model.getConnection(n);
            this.addConnectionImpl((Connection)object);
        }
    }

    private void discardModel() {
        if (this._model instanceof DefaultModel) {
            ((DefaultModel)this._model).destroy();
        } else {
            this._model.clear();
            this._model.removeModelListener(this._modelListener);
        }
        this._model = null;
        this._modelListener = null;
        for (NodeComponent eventListener : this._componentForNode.values()) {
            this._contents.removeNode(eventListener);
        }
        for (ConnectionComponent connectionComponent : this._componentForConnection.values()) {
            this._contents.removeConnection(connectionComponent);
        }
        this._componentForNode = new HashMap();
        this._componentForConnection = new HashMap();
    }

    public NodeRenderer getNodeRenderer() {
        return this._nodeRenderer;
    }

    public void setNodeRenderer(NodeRenderer nodeRenderer) {
        this._nodeRenderer = nodeRenderer;
    }

    public ConnectionRenderer getConnectionRenderer() {
        return this._connectionRenderer;
    }

    public void setConnectionRenderer(ConnectionRenderer connectionRenderer) {
        this._connectionRenderer = connectionRenderer;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
        this._contents.setEditable(bl);
    }

    public void print(JDialog jDialog, String string, PrintJobListener printJobListener) {
        this.print((Window)jDialog, string, printJobListener);
    }

    public void print(JFrame jFrame, String string, PrintJobListener printJobListener) {
        this.print((Window)jFrame, string, printJobListener);
    }

    private void print(Window window, String string, PrintJobListener printJobListener) {
        PageFormat pageFormat;
        PrinterJob printerJob;
        PrintDialog printDialog = null;
        if (this._printJobThread != null) {
            while (this._printJobThread.isBusy()) {
                try {
                    this.wait(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
        }
        if ((printDialog = window instanceof JDialog ? new PrintDialog((Dialog)((JDialog)window)) : new PrintDialog((Frame)((JFrame)window))).showDialog(2, printerJob = PrinterJob.getPrinterJob(), pageFormat = printerJob.defaultPage())) {
            this._fitToPage = printDialog.getScaleToFit();
            this._printJobThread = new PrintJobThread((Printable)this, printerJob, pageFormat, printJobListener);
            this._printJobThread.start();
        }
    }

    public boolean isPrinting() {
        return this._printJobThread != null && this._printJobThread.isBusy();
    }

    public void cancelPrint() {
        if (this._printJobThread != null) {
            this._printJobThread.cancel();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        this._contents.setSelectedNodeComponent(null);
        this._contents.setSelectedConnectionComponent(null);
        int n2 = (int)pageFormat.getImageableX();
        int n3 = (int)pageFormat.getImageableY();
        if (!this._fitToPage) {
            int n4;
            int n5 = (int)Math.ceil((double)this._contents.getWidth() / pageFormat.getImageableWidth());
            if (n >= n5 * (n4 = (int)Math.ceil((double)this._contents.getHeight() / pageFormat.getImageableHeight()))) {
                return 1;
            }
            int n6 = n / n5;
            int n7 = n % n5;
            graphics.translate(n2 -= n7 * (int)pageFormat.getImageableWidth(), n3 -= n6 * (int)pageFormat.getImageableHeight());
        } else {
            if (n >= 1) {
                return 1;
            }
            graphics.translate(n2, n3);
            double d = pageFormat.getImageableHeight() / (double)this._contents.getHeight();
            double d2 = pageFormat.getImageableWidth() / (double)this._contents.getWidth();
            double d3 = Math.min(d, d2);
            if (d3 < 1.0 && graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).scale(d3, d3);
            }
        }
        this._contents.print(graphics);
        return 0;
    }

    protected void addConnectionImpl(Connection connection) {
        Component component = (Component)((Object)this._componentForNode.get(connection.getOrigin()));
        Component component2 = (Component)((Object)this._componentForNode.get(connection.getDestination()));
        ConnectionComponent connectionComponent = this._connectionRenderer.getConnectionRendererComponent(connection, component, component2);
        this._componentForConnection.put(connection, connectionComponent);
        this._contents.addConnection(connectionComponent);
        this.resetCommonNodeConnections(connection.getOrigin(), connection.getDestination());
        connectionComponent.getJComponent().addKeyListener(this._contents._keyHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNodeImpl(Node node) {
        block4: {
            try {
                this._contents.setCursor(new Cursor(3));
                Component component = this._nodeRenderer.getNodeRendererComponent(this, node);
                if (component instanceof NodeComponent) {
                    NodeComponent nodeComponent = (NodeComponent)((Object)component);
                    this._componentForNode.put(node, nodeComponent);
                    this._contents.addNode(nodeComponent);
                    component.addMouseListener(this._nodeMouseHandler);
                    component.addMouseMotionListener(this._nodeMouseHandler);
                    component.addKeyListener(this._functionKeyHandler);
                    component.addKeyListener(this._contents._keyHandler);
                    break block4;
                }
                throw new IllegalArgumentException("The Component returned by a node renderer must support the NodeComponent interface.");
            }
            finally {
                this._contents.setCursor(null);
            }
        }
    }

    protected void removeConnectionImpl(Connection connection) {
        this.resetCommonNodeConnections(connection.getOrigin(), connection.getDestination());
        ConnectionComponent connectionComponent = this._componentForConnection.get(connection);
        this._componentForConnection.remove(connection);
        if (connectionComponent != null) {
            connectionComponent.getJComponent().removeKeyListener(this._contents._keyHandler);
            this._contents.removeConnection(connectionComponent);
        }
    }

    private void resetCommonNodeConnections(Node node, Node node2) {
        Iterator<Connection> iterator = null;
        Connection connection2 = null;
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        int n = 0;
        Rectangle rectangle = null;
        int n2 = 0;
        for (Connection connection2 : this._componentForConnection.keySet()) {
            if ((connection2.getOrigin() != node || connection2.getDestination() != node2) && (connection2.getOrigin() != node2 || connection2.getDestination() != node)) continue;
            arrayList.add(connection2);
            ++n;
        }
        if (n > 1) {
            for (Connection connection2 : arrayList) {
                rectangle = this.getNodeBounds(connection2.getOrigin());
                this.setOriginPosition(connection2, new Point((int)rectangle.getWidth() / (n + 1) * ++n2, (int)rectangle.getHeight() / (n + 1) * n2));
                rectangle = this.getNodeBounds(connection2.getDestination());
                this.setDestPosition(connection2, new Point((int)rectangle.getWidth() / (n + 1) * n2, (int)rectangle.getHeight() / (n + 1) * n2));
            }
        }
    }

    protected void removeNodeImpl(Node node) {
        Component component = (Component)((Object)this._componentForNode.get(node));
        if (component != null) {
            component.removeMouseListener(this._nodeMouseHandler);
            component.removeMouseMotionListener(this._nodeMouseHandler);
            component.removeKeyListener(this._functionKeyHandler);
            component.removeKeyListener(this._contents._keyHandler);
            this._contents.removeNode((NodeComponent)((Object)component));
        }
    }

    static String getI18NMessage(String string) {
        String string2 = _i18nCache.get(string);
        if (string2 != null) {
            return string2;
        }
        ResourceBundle resourceBundle = null;
        String string3 = "com.sybase.JGraph.JGraphResourceBundle";
        String string4 = System.getProperty("language", System.getProperty("user.language", null));
        String string5 = System.getProperty("country", System.getProperty("user.region", null));
        if (string4 != null && string5 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string3, new Locale(string4, string5));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string3, Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name " + string3, "", "");
        }
        try {
            String string6 = resourceBundle.getString(string);
            _i18nCache.put(string, string6);
            return string6;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    void showCustomizeDialog(JGraph jGraph) {
        CustomizeDialog customizeDialog = this.getCustomizeDialog(SwingUtilities.getWindowAncestor(jGraph));
        customizeDialog.selectComponent((Customizable)this);
        UIUtils.ensureWindowIsVisible((Window)customizeDialog);
        customizeDialog.setVisible(true);
    }

    static class BackgroundSwapFilter
    extends RGBImageFilter {
        private int _bcRGB = GraphProperties.getColor(GraphProperties.ColorName.BG).getRGB();

        public BackgroundSwapFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._bcRGB) {
                return Color.WHITE.getRGB();
            }
            return n3;
        }
    }

    private static final class WalkNodeAction
    implements ActionListener {
        private JGraph _parent;
        private Component _nodeComponent = null;
        private int _horizontalWalkValue;
        private int _verticalWalkValue;

        public WalkNodeAction(JGraph jGraph) {
            this._parent = jGraph;
        }

        public void destroy() {
            this._parent = null;
            this._nodeComponent = null;
        }

        public void setNodeComponent(Component component) {
            this._nodeComponent = component;
        }

        public void setHorizontalWalkValue(int n) {
            this._horizontalWalkValue = n;
        }

        public void setVerticalWalkValue(int n) {
            this._verticalWalkValue = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = null;
            rectangle = this._nodeComponent.getBounds();
            rectangle.setLocation(rectangle.x + this._horizontalWalkValue, rectangle.y + this._verticalWalkValue);
            if (rectangle.x < 0 && rectangle.y < 0) {
                this._parent._walkTimer.stop();
            }
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            this._nodeComponent.setCursor(this._parent._contents._movingCursor);
            this._parent._contents.setGrabHandlesVisible(false);
            this._nodeComponent.setBounds(rectangle);
            this._parent._contents.scrollRectToVisible(rectangle);
            this._parent._contents.repaint();
        }
    }

    private static final class ResizeAction
    implements ActionListener {
        private JGraph _parent;

        public ResizeAction(JGraph jGraph) {
            this._parent = jGraph;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._parent._contents.startKeybResizing(this._parent.getComponent());
        }
    }

    private static final class MoveAction
    implements ActionListener {
        private JGraph _parent;

        public MoveAction(JGraph jGraph) {
            this._parent = jGraph;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._parent._contents.startKeybMoving(this._parent.getComponent());
        }
    }

    private static final class CustomizeAction
    implements ActionListener {
        private JGraph _parent;

        public CustomizeAction(JGraph jGraph) {
            this._parent = jGraph;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this._parent.showCustomizeDialog(this._parent);
        }
    }

    private static final class FunctionKeyHandler
    extends KeyAdapter {
        private JGraph _parent;

        public FunctionKeyHandler(JGraph jGraph) {
            this._parent = jGraph;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            NodeComponent nodeComponent = this._parent._contents.getSelectedNodeComponent();
            if (nodeComponent != null) {
                Component component = (Component)((Object)nodeComponent);
                Node node = ((NodeComponent)((Object)component)).getAssociatedNode();
                if (keyEvent.getKeyCode() == 113 && this._parent._editable) {
                    this._parent._contents.startEditing(this._parent._nodeMouseHandler, component.getBounds(), node.getUserObject());
                } else if (keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
                    keyEvent.consume();
                }
            }
        }
    }

    private static final class ResizeHandler
    extends ComponentAdapter {
        private JGraph _parent;

        public ResizeHandler(JGraph jGraph) {
            this._parent = jGraph;
        }

        public void destroy() {
            this._parent = null;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Dimension dimension = this._parent._scrollPane.getViewport().getSize();
            if (dimension.getWidth() > this._parent._contents.getSize().getWidth()) {
                int n = (int)dimension.getWidth();
                int n2 = (int)this._parent._contents.getPreferredSize().getHeight();
                this._parent._contents.setPreferredSize(new Dimension(n, n2));
                this._parent._contents.revalidate();
            }
            this._parent._layout.setSize(dimension);
        }
    }

    private final class NodeMouseHandler
    extends MouseAdapter
    implements MouseMotionListener,
    CellEditorListener {
        private JGraph _parent;
        private InnerPanel _contents;
        private Point _initialPosition;
        private Rectangle _newBounds;
        protected static final int DEFAULT_WALK_INCREMENT = 50;

        public NodeMouseHandler(JGraph jGraph2) {
            this._parent = jGraph2;
            this._contents = this._parent._contents;
        }

        public void destroy() {
            this._parent = null;
            this._contents = null;
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            this._contents.removeEditor();
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            this._parent.getNode().setUserObject(this._contents._editor.getCellEditorValue());
            this._contents.removeEditor();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() > 1) {
                Component component = (Component)mouseEvent.getSource();
                if (this._parent._editable) {
                    this._contents.startEditing(this, component.getBounds(), ((NodeComponent)((Object)component)).getAssociatedNode().getUserObject());
                } else {
                    ((NodeComponent)((Object)component)).open();
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            this._contents.setSelectedNodeComponent((NodeComponent)((Object)component));
            if (mouseEvent.getButton() == 1) {
                this._initialPosition = mouseEvent.getPoint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            JGraph.this._walkTimer.stop();
            if (mouseEvent.isPopupTrigger()) {
                this.showPopup(mouseEvent);
            } else if (mouseEvent.getButton() == 1) {
                Component component = (Component)mouseEvent.getSource();
                this._initialPosition = null;
                component.setCursor(null);
                this._contents.setGrabHandlesVisible(true);
                if (this._newBounds != null) {
                    this._parent._layout.setNodeBounds((NodeComponent)((Object)component), this._newBounds);
                    this._newBounds = null;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle = null;
            Component component = null;
            Point point = null;
            Dimension dimension = null;
            boolean bl = false;
            if (this._initialPosition != null) {
                rectangle = this._parent._scrollPane.getViewport().getViewRect();
                component = (Component)mouseEvent.getSource();
                point = component.getLocation();
                dimension = component.getSize();
                int n = (int)point.getX() + mouseEvent.getX() - (int)this._initialPosition.getX();
                int n2 = (int)point.getY() + mouseEvent.getY() - (int)this._initialPosition.getY();
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                JGraph.this._walkTimer.stop();
                JGraph.this._walkNodeAction.setHorizontalWalkValue(0);
                JGraph.this._walkNodeAction.setVerticalWalkValue(0);
                if (n - rectangle.x + dimension.width > rectangle.width || n < rectangle.x) {
                    if (n < rectangle.x) {
                        JGraph.this._walkNodeAction.setHorizontalWalkValue(-50);
                        n = rectangle.x;
                    } else {
                        JGraph.this._walkNodeAction.setHorizontalWalkValue(50);
                        n = rectangle.x + rectangle.width - dimension.width;
                    }
                    JGraph.this._walkNodeAction.setNodeComponent((Component)mouseEvent.getSource());
                    bl = true;
                }
                if (n2 - rectangle.y + dimension.height > rectangle.height || n2 < rectangle.y) {
                    if (n2 < rectangle.y) {
                        JGraph.this._walkNodeAction.setVerticalWalkValue(-50);
                        n2 = rectangle.y;
                    } else {
                        JGraph.this._walkNodeAction.setVerticalWalkValue(50);
                        n2 = rectangle.y + rectangle.height - dimension.height;
                    }
                    JGraph.this._walkNodeAction.setNodeComponent((Component)mouseEvent.getSource());
                    bl = true;
                }
                component.setCursor(this._contents._movingCursor);
                this._contents.setGrabHandlesVisible(false);
                this._newBounds = new Rectangle(n, n2, (int)dimension.getWidth(), (int)dimension.getHeight());
                component.setBounds(this._newBounds);
                this._contents.repaint();
                if (bl) {
                    this._newBounds = null;
                    JGraph.this._walkTimer.restart();
                }
            } else {
                JGraph.this._walkTimer.stop();
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            JGraph.this.setupNodePopup();
            ((NodeComponent)mouseEvent.getSource()).setPopup(JGraph.this._nodePopup);
            ((NodeComponent)mouseEvent.getSource()).showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

