/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ConnectionComponent;
import com.sybase.JGraph.FreeList;
import com.sybase.JGraph.Node;
import com.sybase.JGraph.NodeComponent;
import com.sybase.JGraph.Side;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;

class Layout {
    protected FreeList _freeList = new FreeList();
    HashMap<Node, Rectangle> _nodeBounds = new HashMap();
    HashMap<Node, ArrayList<ConnectionComponent>> _connectionsForNode = new HashMap();
    private ArrayList<ConnectionComponent> _connectionComponents = new ArrayList();
    private ConnectionComponent _previousConnection;
    private ConnectionComponent _nextConnection;
    protected HashMap<Node, NodeComponent> _nodeComponents = new HashMap();

    public Layout() {
    }

    public Layout(Dimension dimension) {
        this.setSize(dimension);
    }

    public void destroy() {
        this._nodeBounds.clear();
        this._connectionsForNode.clear();
        this._connectionComponents.clear();
        this._nodeComponents.clear();
        this._freeList = null;
        this._nodeBounds = null;
        this._connectionsForNode = null;
        this._connectionComponents = null;
        this._previousConnection = null;
        this._nextConnection = null;
    }

    public void setSize(Dimension dimension) {
        int n = Math.max((int)dimension.getWidth(), this._freeList._gridWidth);
        int n2 = Math.max((int)dimension.getHeight(), this._freeList._gridHeight);
        this._freeList.setSize(new Dimension(n, n2));
    }

    public void addConnection(ConnectionComponent connectionComponent) {
        Connection connection = connectionComponent.getAssociatedConnection();
        this.insertConnectionForNode(connection.getOrigin(), connectionComponent);
        if (!connection.isLoop()) {
            this.insertConnectionForNode(connection.getDestination(), connectionComponent);
        }
        this._connectionComponents.add(connectionComponent);
    }

    public void removeConnection(ConnectionComponent connectionComponent) {
        Connection connection = connectionComponent.getAssociatedConnection();
        this.deleteConnectionForNode(connection.getOrigin(), connectionComponent);
        this.deleteConnectionForNode(connection.getDestination(), connectionComponent);
        this._connectionComponents.remove(connectionComponent);
    }

    public Rectangle addNode(NodeComponent nodeComponent) {
        Node node = nodeComponent.getAssociatedNode();
        Rectangle rectangle = this._freeList.add(nodeComponent);
        this._nodeBounds.put(node, rectangle);
        this._nodeComponents.put(node, nodeComponent);
        return rectangle;
    }

    public void setNodeBounds(NodeComponent nodeComponent, Rectangle rectangle) {
        Node node = nodeComponent.getAssociatedNode();
        if (rectangle.getX() >= 0.0 && rectangle.getY() >= 0.0) {
            Rectangle rectangle2 = this._nodeBounds.get(node);
            if (rectangle2 != null) {
                this._freeList.remove(nodeComponent, rectangle2);
            }
            this._nodeBounds.put(node, rectangle);
            this._freeList.add(nodeComponent, rectangle);
            ((Component)((Object)nodeComponent)).setBounds(rectangle);
        }
    }

    public void removeNode(Node node) {
        Rectangle rectangle = this._nodeBounds.get(node);
        NodeComponent nodeComponent = this._nodeComponents.get(node);
        this._nodeBounds.remove(node);
        this._nodeComponents.remove(node);
        this._connectionsForNode.remove(node);
        if (rectangle != null && nodeComponent != null) {
            this._freeList.remove(nodeComponent, rectangle);
        }
    }

    public NodeComponent getLeftNode(NodeComponent nodeComponent) {
        int n;
        int n2;
        int n3;
        if (nodeComponent == null) {
            return null;
        }
        NodeComponent nodeComponent2 = null;
        int n4 = ((Component)((Object)nodeComponent)).getX();
        int n5 = ((Component)((Object)nodeComponent)).getHeight();
        int n6 = ((Component)((Object)nodeComponent)).getY() + n5 / 2;
        for (n3 = 0; n3 <= n4; n3 += this._freeList.getDefaultCellWidth()) {
            for (n2 = 0; n2 <= n5 / 2; n2 += this._freeList.getDefaultCellHeight()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 - n3, n6 - n2));
                if (nodeComponent2 != null && nodeComponent2 != nodeComponent) {
                    return nodeComponent2;
                }
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 - n3, n6 + n2));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getY();
        for (n2 = 0; n2 <= n4; n2 += this._freeList.getDefaultCellWidth()) {
            for (n = 0; n <= n2 && n <= n3; n += this._freeList.getDefaultCellHeight()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 - n2, n3 - n));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getY() + ((Component)((Object)nodeComponent)).getHeight() - 1;
        for (n2 = 0; n2 <= n4; n2 += this._freeList.getDefaultCellWidth()) {
            for (n = 0; n <= n2; n += this._freeList.getDefaultCellHeight()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 - n2, n3 + n));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        return null;
    }

    public NodeComponent getRightNode(NodeComponent nodeComponent, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        if (nodeComponent == null) {
            return null;
        }
        NodeComponent nodeComponent2 = null;
        int n4 = ((Component)((Object)nodeComponent)).getX() + ((Component)((Object)nodeComponent)).getWidth() - 1;
        int n5 = (int)rectangle.getWidth() - n4;
        int n6 = ((Component)((Object)nodeComponent)).getHeight();
        int n7 = ((Component)((Object)nodeComponent)).getY() + n6 / 2;
        for (n3 = 0; n3 <= n5; n3 += this._freeList.getDefaultCellWidth()) {
            for (n2 = 0; n2 <= n6 / 2; n2 += this._freeList.getDefaultCellHeight()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 + n3, n7 - n2));
                if (nodeComponent2 != null && nodeComponent2 != nodeComponent) {
                    return nodeComponent2;
                }
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 + n3, n7 + n2));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getY();
        for (n2 = 0; n2 <= n5; n2 += this._freeList.getDefaultCellWidth()) {
            for (n = 0; n <= n2 && n <= n3; n += this._freeList.getDefaultCellHeight()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 + n2, n3 - n));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getY() + ((Component)((Object)nodeComponent)).getHeight() - 1;
        for (n2 = 0; n2 <= n5; n2 += this._freeList.getDefaultCellWidth()) {
            for (n = 0; n <= n2; n += this._freeList.getDefaultCellHeight()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n4 + n2, n3 + n));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        return null;
    }

    public NodeComponent getUpNode(NodeComponent nodeComponent) {
        int n;
        int n2;
        int n3;
        if (nodeComponent == null) {
            return null;
        }
        NodeComponent nodeComponent2 = null;
        int n4 = ((Component)((Object)nodeComponent)).getY();
        int n5 = ((Component)((Object)nodeComponent)).getWidth();
        int n6 = ((Component)((Object)nodeComponent)).getX() + n5 / 2;
        for (n3 = 0; n3 <= n4; n3 += this._freeList.getDefaultCellHeight()) {
            for (n2 = 0; n2 <= n5 / 2; n2 += this._freeList.getDefaultCellWidth()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n6 - n2, n4 - n3));
                if (nodeComponent2 != null && nodeComponent2 != nodeComponent) {
                    return nodeComponent2;
                }
                nodeComponent2 = this._freeList.getNodeAt(new Point(n6 + n2, n4 - n3));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getX();
        for (n2 = 0; n2 <= n4; n2 += this._freeList.getDefaultCellHeight()) {
            for (n = 0; n <= n2 && n <= n3; n += this._freeList.getDefaultCellWidth()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n3 - n, n4 - n2));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getX() + ((Component)((Object)nodeComponent)).getWidth() - 1;
        for (n2 = 0; n2 <= n4; n2 += this._freeList.getDefaultCellHeight()) {
            for (n = 0; n <= n2 && n <= n3; n += this._freeList.getDefaultCellWidth()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n3 + n, n4 - n2));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        return null;
    }

    public NodeComponent getDownNode(NodeComponent nodeComponent, Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        if (nodeComponent == null) {
            return null;
        }
        NodeComponent nodeComponent2 = null;
        int n4 = ((Component)((Object)nodeComponent)).getY() + ((Component)((Object)nodeComponent)).getHeight();
        int n5 = (int)rectangle.getHeight() - n4;
        int n6 = ((Component)((Object)nodeComponent)).getWidth();
        int n7 = ((Component)((Object)nodeComponent)).getX() + n6 / 2;
        for (n3 = 0; n3 <= n5; n3 += this._freeList.getDefaultCellHeight()) {
            for (n2 = 0; n2 <= n6 / 2; n2 += this._freeList.getDefaultCellWidth()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n7 - n2, n4 + n3));
                if (nodeComponent2 != null && nodeComponent2 != nodeComponent) {
                    return nodeComponent2;
                }
                nodeComponent2 = this._freeList.getNodeAt(new Point(n7 + n2, n4 + n3));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getX();
        for (n2 = 0; n2 <= n5; n2 += this._freeList.getDefaultCellHeight()) {
            for (n = 0; n <= n2 && n <= n3; n += this._freeList.getDefaultCellWidth()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n3 - n, n4 + n2));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        n3 = ((Component)((Object)nodeComponent)).getX() + ((Component)((Object)nodeComponent)).getWidth() - 1;
        for (n2 = 0; n2 <= n5; n2 += this._freeList.getDefaultCellHeight()) {
            for (n = 0; n <= n2 && n <= n3; n += this._freeList.getDefaultCellWidth()) {
                nodeComponent2 = this._freeList.getNodeAt(new Point(n3 + n, n4 + n2));
                if (nodeComponent2 == null || nodeComponent2 == nodeComponent) continue;
                return nodeComponent2;
            }
        }
        return null;
    }

    public ConnectionComponent getLeftConnection(NodeComponent nodeComponent) {
        ArrayList<ConnectionComponent> arrayList = this.getSibblingConnections(nodeComponent, Side.WEST);
        return arrayList.size() > 0 ? arrayList.get(0) : null;
    }

    public ConnectionComponent getRightConnection(NodeComponent nodeComponent) {
        ArrayList<ConnectionComponent> arrayList = this.getSibblingConnections(nodeComponent, Side.EAST);
        return arrayList.size() > 0 ? arrayList.get(0) : null;
    }

    public ConnectionComponent getUpConnection(NodeComponent nodeComponent) {
        ArrayList<ConnectionComponent> arrayList = this.getSibblingConnections(nodeComponent, Side.NORTH);
        return arrayList.size() > 0 ? arrayList.get(0) : null;
    }

    public ConnectionComponent getDownConnection(NodeComponent nodeComponent) {
        ArrayList<ConnectionComponent> arrayList = this.getSibblingConnections(nodeComponent, Side.SOUTH);
        return arrayList.size() > 0 ? arrayList.get(0) : null;
    }

    public ConnectionComponent getPreviousConnection() {
        return this._previousConnection;
    }

    public ConnectionComponent getNextConnection() {
        return this._nextConnection;
    }

    public void setSibblingConnections(ConnectionComponent connectionComponent) {
        int n;
        ConnectionComponent connectionComponent2;
        int n2;
        Connection connection = connectionComponent.getAssociatedConnection();
        NodeComponent nodeComponent = this._nodeComponents.get(connection.getOrigin());
        NodeComponent nodeComponent2 = this._nodeComponents.get(connection.getDestination());
        Side side = this.getConnectionSide(nodeComponent, connectionComponent);
        Side side2 = this.getConnectionSide(nodeComponent2, connectionComponent);
        this._nextConnection = null;
        this._previousConnection = null;
        ArrayList<ConnectionComponent> arrayList = this.getSibblingConnections(nodeComponent, side);
        ArrayList<ConnectionComponent> arrayList2 = this.getSibblingConnections(nodeComponent2, side2);
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            connectionComponent2 = arrayList.get(n2);
            n = this.getDifference(connectionComponent, connectionComponent2, side);
            if (n < 0 && (n > n4 || n4 == 0)) {
                this._nextConnection = connectionComponent2;
                n4 = n;
                continue;
            }
            if (n <= 0 || n >= n3 && n3 != 0) continue;
            this._previousConnection = connectionComponent2;
            n3 = n;
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            connectionComponent2 = arrayList2.get(n2);
            n = this.getDifference(connectionComponent, connectionComponent2, side2);
            if (n < 0 && (n > n4 || n4 == 0)) {
                this._nextConnection = connectionComponent2;
                n4 = n;
                continue;
            }
            if (n <= 0 || n >= n3 && n3 != 0) continue;
            this._previousConnection = connectionComponent2;
            n3 = n;
        }
    }

    public NodeComponent getOrigin(ConnectionComponent connectionComponent) {
        Connection connection = connectionComponent.getAssociatedConnection();
        Node node = connection.getOrigin();
        return this._nodeComponents.get(node);
    }

    public NodeComponent getDestination(ConnectionComponent connectionComponent) {
        Connection connection = connectionComponent.getAssociatedConnection();
        Node node = connection.getDestination();
        return this._nodeComponents.get(node);
    }

    ArrayList<ConnectionComponent> getConnectionComponents() {
        return this._connectionComponents;
    }

    private Side getConnectionSide(NodeComponent nodeComponent, ConnectionComponent connectionComponent) {
        if (this.getSibblingConnections(nodeComponent, Side.WEST).contains(connectionComponent)) {
            return Side.WEST;
        }
        if (this.getSibblingConnections(nodeComponent, Side.EAST).contains(connectionComponent)) {
            return Side.EAST;
        }
        if (this.getSibblingConnections(nodeComponent, Side.NORTH).contains(connectionComponent)) {
            return Side.NORTH;
        }
        return Side.SOUTH;
    }

    private int getDifference(ConnectionComponent connectionComponent, ConnectionComponent connectionComponent2, Side side) {
        Connection connection = connectionComponent.getAssociatedConnection();
        Connection connection2 = connectionComponent2.getAssociatedConnection();
        Point2D point2D = null;
        Point2D point2D2 = null;
        if (connection.isLoop()) {
            point2D = connectionComponent.getArrowTip1();
        }
        if (connection2.isLoop()) {
            point2D2 = connectionComponent2.getArrowTip1();
        }
        if (connection.getOrigin() == connection2.getOrigin()) {
            if (point2D == null) {
                point2D = connectionComponent.getLine().getP1();
            }
            if (point2D2 == null) {
                point2D2 = connectionComponent2.getLine().getP1();
            }
        } else if (connection.getOrigin() == connection2.getDestination()) {
            if (point2D == null) {
                point2D = connectionComponent.getLine().getP1();
            }
            if (point2D2 == null) {
                point2D2 = connectionComponent2.getLine().getP2();
            }
        } else if (connection.getDestination() == connection2.getOrigin()) {
            if (point2D == null) {
                point2D = connectionComponent.getLine().getP2();
            }
            if (point2D2 == null) {
                point2D2 = connectionComponent2.getLine().getP1();
            }
        } else {
            if (point2D == null) {
                point2D = connectionComponent.getLine().getP2();
            }
            if (point2D2 == null) {
                point2D2 = connectionComponent2.getLine().getP2();
            }
        }
        if (side == Side.WEST || side == Side.EAST) {
            return (int)(point2D.getY() - point2D2.getY());
        }
        return (int)(point2D.getX() - point2D2.getX());
    }

    private ArrayList<ConnectionComponent> getSibblingConnections(NodeComponent nodeComponent, Side side) {
        ArrayList<ConnectionComponent> arrayList = new ArrayList<ConnectionComponent>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (side == Side.WEST) {
            n = ((Component)((Object)nodeComponent)).getX() - 2;
            n2 = ((Component)((Object)nodeComponent)).getY();
            n3 = 3;
            n4 = ((Component)((Object)nodeComponent)).getHeight();
        } else if (side == Side.EAST) {
            n = ((Component)((Object)nodeComponent)).getX() + ((Component)((Object)nodeComponent)).getWidth() - 1;
            n2 = ((Component)((Object)nodeComponent)).getY();
            n3 = 3;
            n4 = ((Component)((Object)nodeComponent)).getHeight();
        } else if (side == Side.NORTH) {
            n = ((Component)((Object)nodeComponent)).getX();
            n2 = ((Component)((Object)nodeComponent)).getY() - 2;
            n3 = ((Component)((Object)nodeComponent)).getWidth();
            n4 = 3;
        } else {
            n = ((Component)((Object)nodeComponent)).getX();
            n2 = ((Component)((Object)nodeComponent)).getY() + ((Component)((Object)nodeComponent)).getHeight() - 1;
            n3 = ((Component)((Object)nodeComponent)).getWidth();
            n4 = 3;
        }
        Node node = nodeComponent.getAssociatedNode();
        ArrayList<ConnectionComponent> arrayList2 = this._connectionsForNode.get(node);
        for (int i = 0; i < arrayList2.size(); ++i) {
            Cloneable cloneable;
            ConnectionComponent connectionComponent = arrayList2.get(i);
            if (!connectionComponent.getAssociatedConnection().isLoop()) {
                cloneable = connectionComponent.getLine();
                if (cloneable == null || !((Line2D)cloneable).intersects(n, n2, n3, n4)) continue;
                arrayList.add(connectionComponent);
                continue;
            }
            cloneable = connectionComponent.getArrowTip1();
            if (cloneable == null || !(((Point2D)cloneable).getX() >= (double)n) || !(((Point2D)cloneable).getX() <= (double)(n + n3)) || !(((Point2D)cloneable).getY() >= (double)n2) || !(((Point2D)cloneable).getY() <= (double)(n2 + n4))) continue;
            arrayList.add(connectionComponent);
        }
        return arrayList;
    }

    private Point getCenter(Rectangle rectangle) {
        return new Point((int)(rectangle.getX() + rectangle.getWidth() / 2.0 - 1.0), (int)(rectangle.getY() + rectangle.getHeight() / 2.0 - 1.0));
    }

    private void insertConnectionForNode(Node node, ConnectionComponent connectionComponent) {
        ArrayList<ConnectionComponent> arrayList = this._connectionsForNode.get(node);
        if (arrayList == null) {
            arrayList = new ArrayList(2);
            this._connectionsForNode.put(node, arrayList);
        }
        arrayList.add(connectionComponent);
    }

    private void deleteConnectionForNode(Node node, ConnectionComponent connectionComponent) {
        ArrayList<ConnectionComponent> arrayList = this._connectionsForNode.get(node);
        if (arrayList != null) {
            arrayList.remove(connectionComponent);
            if (arrayList.size() <= 0) {
                this._connectionsForNode.remove(node);
            }
        }
    }
}

