/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.JGraph;

import com.sybase.JGraph.Connection;
import com.sybase.JGraph.ConnectionComponent;
import com.sybase.JGraph.Layout;
import com.sybase.JGraph.Node;
import com.sybase.JGraph.NodeComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XMLMemento {
    static final Rectangle EMPTY_RECTANGLE = new Rectangle(0, 0, 0, 0);
    private String TAG_ROOT = "graphLayout";
    private String TAG_NODE = "node";
    private String TAG_CONNECTION = "connection";
    private String TAG_POSITION = "position";
    private String TAG_SIZE = "size";
    private String TAG_ORIGIN_POSITION = "originPosition";
    private String TAG_DESTINATION_POSITION = "destinationPosition";
    private String ATTRIBUTE_UID = "uid";
    private String ATTRIBUTE_X = "x";
    private String ATTRIBUTE_Y = "y";
    private String ATTRIBUTE_WIDTH = "width";
    private String ATTRIBUTE_HEIGHT = "height";
    private Layout _layout;

    public XMLMemento(Layout layout) {
        this._layout = layout;
    }

    public void destroy() {
        this._layout = null;
    }

    public String getLayout() throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Cloneable cloneable;
        Object object;
        StringWriter stringWriter = new StringWriter();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element element = document.createElement(this.TAG_ROOT);
        document.appendChild(element);
        for (Map.Entry<Node, Rectangle> object2 : this._layout._nodeBounds.entrySet()) {
            object = object2.getKey();
            cloneable = object2.getValue();
            element.appendChild(this.writeNodeBounds(document, (Node)object, (Rectangle)cloneable));
        }
        for (ConnectionComponent connectionComponent : this._layout.getConnectionComponents()) {
            object = connectionComponent.getAssociatedConnection();
            cloneable = connectionComponent.getRelOriginPosition();
            Point point = connectionComponent.getRelDestPosition();
            element.appendChild(this.writeConnectionPositions(document, (Connection)object, (Point)cloneable, point));
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public void setLayout(String string) throws SAXException, ParserConfigurationException, IOException {
        Cloneable cloneable;
        Object object;
        Object object2;
        Object object3;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        StringReader stringReader = new StringReader(string);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(stringReader));
        HashMap<String, ArrayList<NodeComponent>> hashMap = this.createNodeCompUIDMap();
        NodeList nodeList = document.getElementsByTagName(this.TAG_NODE);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object3 = (Element)nodeList.item(i);
            String string2 = object3.getAttribute(this.ATTRIBUTE_UID);
            object2 = hashMap.get(string2);
            if (object2 == null) continue;
            object = ((ArrayList)object2).get(0);
            cloneable = this.readNodeBounds((Element)object3);
            this._layout.setNodeBounds((NodeComponent)object, (Rectangle)cloneable);
            ((ArrayList)object2).remove(0);
            if (((ArrayList)object2).size() > 0) continue;
            hashMap.remove(string2);
        }
        HashMap<String, ArrayList<ConnectionComponent>> hashMap2 = this.createConnectionUIDMap();
        object3 = document.getElementsByTagName(this.TAG_CONNECTION);
        for (int i = 0; i < object3.getLength(); ++i) {
            object2 = (Element)object3.item(i);
            object = object2.getAttribute(this.ATTRIBUTE_UID);
            cloneable = hashMap2.get(object);
            if (cloneable == null) continue;
            ConnectionComponent connectionComponent = (ConnectionComponent)((ArrayList)cloneable).get(0);
            Point point = this.readOriginPos((Element)object2);
            Point point2 = this.readDestPos((Element)object2);
            connectionComponent.setRelOriginPosition(point);
            connectionComponent.setRelDestPosition(point2);
            ((ArrayList)cloneable).remove(0);
            if (((ArrayList)cloneable).size() > 0) continue;
            hashMap2.remove(object);
        }
    }

    private HashMap<String, ArrayList<NodeComponent>> createNodeCompUIDMap() {
        HashMap<String, ArrayList<NodeComponent>> hashMap = new HashMap<String, ArrayList<NodeComponent>>(this._layout._nodeBounds.size());
        Iterator<Map.Entry<Node, Rectangle>> iterator = this._layout._nodeBounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next().getKey();
            String string = node.getUniqueID();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList(1));
            }
            ArrayList<NodeComponent> arrayList = hashMap.get(string);
            arrayList.add(this._layout._nodeComponents.get(node));
        }
        return hashMap;
    }

    private HashMap<String, ArrayList<ConnectionComponent>> createConnectionUIDMap() {
        HashMap<String, ArrayList<ConnectionComponent>> hashMap = new HashMap<String, ArrayList<ConnectionComponent>>(this._layout.getConnectionComponents().size());
        for (ConnectionComponent connectionComponent : this._layout.getConnectionComponents()) {
            String string = connectionComponent.getAssociatedConnection().getUniqueID();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new ArrayList(1));
            }
            ArrayList<ConnectionComponent> arrayList = hashMap.get(string);
            arrayList.add(connectionComponent);
        }
        return hashMap;
    }

    private Rectangle readNodeBounds(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName(this.TAG_POSITION);
        if (nodeList.getLength() <= 0) {
            throw new SAXException("Invalid XML string.");
        }
        Element element2 = (Element)nodeList.item(0);
        nodeList = element.getElementsByTagName(this.TAG_SIZE);
        if (nodeList.getLength() <= 0) {
            throw new SAXException("Invalid XML string.");
        }
        Element element3 = (Element)nodeList.item(0);
        Integer n = Integer.valueOf(element2.getAttribute(this.ATTRIBUTE_X));
        Integer n2 = Integer.valueOf(element2.getAttribute(this.ATTRIBUTE_Y));
        Integer n3 = Integer.valueOf(element3.getAttribute(this.ATTRIBUTE_WIDTH));
        Integer n4 = Integer.valueOf(element3.getAttribute(this.ATTRIBUTE_HEIGHT));
        return new Rectangle(n, n2, n3, n4);
    }

    private Point readOriginPos(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName(this.TAG_ORIGIN_POSITION);
        if (nodeList.getLength() <= 0) {
            throw new SAXException("Invalid XML string.");
        }
        Element element2 = (Element)nodeList.item(0);
        Integer n = Integer.valueOf(element2.getAttribute(this.ATTRIBUTE_X));
        Integer n2 = Integer.valueOf(element2.getAttribute(this.ATTRIBUTE_Y));
        return new Point(n, n2);
    }

    private Point readDestPos(Element element) throws SAXException {
        NodeList nodeList = element.getElementsByTagName(this.TAG_DESTINATION_POSITION);
        if (nodeList.getLength() <= 0) {
            throw new SAXException("Invalid XML string.");
        }
        Element element2 = (Element)nodeList.item(0);
        Integer n = Integer.valueOf(element2.getAttribute(this.ATTRIBUTE_X));
        Integer n2 = Integer.valueOf(element2.getAttribute(this.ATTRIBUTE_Y));
        return new Point(n, n2);
    }

    private Element writeConnectionPositions(Document document, Connection connection, Point point, Point point2) {
        Element element = document.createElement(this.TAG_CONNECTION);
        element.setAttribute(this.ATTRIBUTE_UID, connection.getUniqueID());
        Element element2 = document.createElement(this.TAG_ORIGIN_POSITION);
        element2.setAttribute(this.ATTRIBUTE_X, (int)point.getX() + "");
        element2.setAttribute(this.ATTRIBUTE_Y, (int)point.getY() + "");
        element.appendChild(element2);
        element2 = document.createElement(this.TAG_DESTINATION_POSITION);
        element2.setAttribute(this.ATTRIBUTE_X, (int)point2.getX() + "");
        element2.setAttribute(this.ATTRIBUTE_Y, (int)point2.getY() + "");
        element.appendChild(element2);
        return element;
    }

    private Element writeNodeBounds(Document document, Node node, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = EMPTY_RECTANGLE;
        }
        Element element = document.createElement(this.TAG_NODE);
        element.setAttribute(this.ATTRIBUTE_UID, node.getUniqueID());
        Element element2 = document.createElement(this.TAG_POSITION);
        element2.setAttribute(this.ATTRIBUTE_X, (int)rectangle.getX() + "");
        element2.setAttribute(this.ATTRIBUTE_Y, (int)rectangle.getY() + "");
        element.appendChild(element2);
        Element element3 = document.createElement(this.TAG_SIZE);
        element3.setAttribute(this.ATTRIBUTE_WIDTH, (int)rectangle.getWidth() + "");
        element3.setAttribute(this.ATTRIBUTE_HEIGHT, (int)rectangle.getHeight() + "");
        element.appendChild(element3);
        return element;
    }
}

