/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.DefaultColumnModel;
import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.TableModel;
import com.sybase.asa.common.IntegerTextField;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class ColumnPage
extends JPanel
implements MouseListener,
KeyListener,
ActionListener,
TableModelListener {
    private QueryEditor __parentForm = null;
    private JScrollPane _availableColumnsScrollPane = new JScrollPane();
    JTree _availableColumns = new JTree();
    private SybButton _addButton = new SybButton((Icon)QueryEditor.ADD_ICON);
    private SybButton _deleteButton = new SybButton((Icon)QueryEditor.DELETE_ICON);
    private SybButton _moveUpButton = new SybButton((Icon)QueryEditor.MOVE_UP_ICON);
    private SybButton _moveDownButton = new SybButton((Icon)QueryEditor.MOVE_DOWN_ICON);
    private SybButton _computeColumnButton = new SybButton((Icon)QueryEditor.COMPUTED_ICON);
    private SybLabel _selectedColumnsLabel = new SybLabel();
    private JScrollPane _selectedColumnsScrollPane = new JScrollPane();
    JTable _selectedColumns = new JTable();
    SybCheckBox _distinct = new SybCheckBox();
    SybCheckBox _limitRows = new SybCheckBox();
    SybRadioButton _first = new SybRadioButton();
    SybRadioButton _top = new SybRadioButton();
    IntegerTextField _topRows = new IntegerTextField(1, 5);
    IntegerTextField _startAtRow = new IntegerTextField(1, 5);
    SybLabel _startAtRowLabel = new SybLabel();
    SybLabel _rowsLabel = new SybLabel();

    ColumnPage() {
    }

    void create(QueryEditor queryEditor) {
        this.__parentForm = queryEditor;
        this._availableColumnsScrollPane.getViewport().add(this._availableColumns);
        this._availableColumnsScrollPane.getViewport().setBackground(this._availableColumns.getBackground());
        this._selectedColumnsScrollPane.getViewport().add(this._selectedColumns);
        this._selectedColumnsScrollPane.getViewport().setBackground(this._selectedColumns.getBackground());
        if (Platform.isMacOS()) {
            this._availableColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._availableColumnsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._availableColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._availableColumnsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._availableColumns.addMouseListener(this);
        this._availableColumns.setShowsRootHandles(true);
        this._availableColumns.setCellRenderer(this.__parentForm._queryEditorTreeCellRenderer);
        this._addButton.addActionListener((ActionListener)this);
        this._addButton.setMnemonic(QueryEditor.getI18NMessage("columnpage.add_>>_mnemonic").charAt(0));
        this._addButton.setRolloverIcon((Icon)QueryEditor.ADD_ROLLOVER_ICON);
        this._addButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("columnpage.add_the_selected_column_to_the_list")));
        this._addButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.add_the_selected_column_to_the_list"));
        this._deleteButton.addActionListener((ActionListener)this);
        this._deleteButton.setMnemonic(QueryEditor.getI18NMessage("columnpage.<<_delete_mnemonic").charAt(0));
        this._deleteButton.setRolloverIcon((Icon)QueryEditor.DELETE_ROLLOVER_ICON);
        this._deleteButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("columnpage.delete_the_selected_column_from_the_list")));
        this._deleteButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.delete_the_selected_column_from_the_list"));
        this._moveUpButton.addActionListener((ActionListener)this);
        this._moveUpButton.setMnemonic(QueryEditor.getI18NMessage("columnpage.move_up_mnemonic").charAt(0));
        this._moveUpButton.setRolloverIcon((Icon)QueryEditor.MOVE_UP_ROLLOVER_ICON);
        this._moveUpButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("columnpage.move_the_selected_column_up_one_in_the_list")));
        this._moveUpButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.move_the_selected_column_up_one_in_the_list"));
        this._moveDownButton.addActionListener((ActionListener)this);
        this._moveDownButton.setMnemonic(QueryEditor.getI18NMessage("columnpage.move_down_mnemonic").charAt(0));
        this._moveDownButton.setRolloverIcon((Icon)QueryEditor.MOVE_DOWN_ROLLOVER_ICON);
        this._moveDownButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("columnpage.move_the_selected_column_down_one")));
        this._moveDownButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.move_the_selected_column_down_one"));
        this._computeColumnButton.addActionListener((ActionListener)this);
        this._computeColumnButton.setMnemonic(QueryEditor.getI18NMessage("columnpage.compute_column_mnemonic").charAt(0));
        this._computeColumnButton.setRolloverIcon((Icon)QueryEditor.COMPUTED_ROLLOVER_ICON);
        this._computeColumnButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("columnpage.add_a_computed_column")));
        this._computeColumnButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.add_a_computed_column"));
        this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("columnpage.selected_columns"));
        this._selectedColumnsLabel.setLabelFor((Component)this._selectedColumns);
        if (Platform.isMacOS()) {
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._selectedColumns.setShowHorizontalLines(false);
        this._selectedColumns.setShowVerticalLines(false);
        this._selectedColumns.setAutoResizeMode(0);
        this._selectedColumns.getTableHeader().setReorderingAllowed(false);
        this._selectedColumns.setSelectionMode(0);
        this._selectedColumns.getModel().addTableModelListener(this);
        this._selectedColumns.addKeyListener(this);
        this._distinct.setText(QueryEditor.getI18NMessage("columnpage.distinct"));
        this._distinct.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.distinct_accessible"));
        String string = QueryEditor.getI18NMessage("columnpage.distinctTip");
        if (string != null && string.length() > 0) {
            this._distinct.setToolTipText(QueryEditor.toHTML(string));
        }
        this._limitRows.setText(QueryEditor.getI18NMessage("columnpage.limit"));
        this._limitRows.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.limit"));
        String string2 = QueryEditor.getI18NMessage("columnpage.limitTip");
        if (string2 != null && string2.length() > 0) {
            this._limitRows.setToolTipText(QueryEditor.toHTML(string2));
        }
        this._first.setText(QueryEditor.getI18NMessage("columnpage.first"));
        this._first.setSelected(true);
        this._first.setEnabled(false);
        String string3 = QueryEditor.getI18NMessage("columnpage.firstTip");
        if (string3 != null && string3.length() > 0) {
            this._first.setToolTipText(QueryEditor.toHTML(string3));
        }
        this._top.setText(QueryEditor.getI18NMessage("columnpage.top"));
        String string4 = QueryEditor.getI18NMessage("columnpage.topTip");
        if (string4 != null && string4.length() > 0) {
            this._top.setToolTipText(QueryEditor.toHTML(string4));
        }
        this._top.setEnabled(false);
        this._topRows.setEnabled(false);
        this._topRows.setToolTipText(QueryEditor.getI18NMessage("columnpage.topRowsTip"));
        this._topRows.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("columnpage.rows"));
        this._startAtRow.setEnabled(false);
        this._startAtRow.setToolTipText(QueryEditor.getI18NMessage("columnpage.startAtRowFieldTip"));
        this._rowsLabel.setText(QueryEditor.getI18NMessage("columnpage.rows"));
        this._rowsLabel.setEnabled(false);
        this._rowsLabel.setLabelFor((Component)this._topRows);
        String string5 = QueryEditor.getI18NMessage("columnpage.rowsTip");
        if (string5 != null && string5.length() > 0) {
            this._rowsLabel.setToolTipText(QueryEditor.toHTML(string5));
        }
        this._startAtRowLabel.setText(QueryEditor.getI18NMessage("columnpage.startAtRow"));
        this._startAtRowLabel.setEnabled(false);
        this._startAtRowLabel.setLabelFor((Component)this._startAtRow);
        String string6 = QueryEditor.getI18NMessage("columnpage.startAtRowTip");
        if (string6 != null && string6.length() > 0) {
            this._startAtRowLabel.setToolTipText(QueryEditor.toHTML(string6));
        }
        this.layoutPage();
    }

    void layoutPage() {
        Serializable serializable;
        if (this.__parentForm == null) {
            return;
        }
        this.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout2);
        this.add(jPanel);
        SybLabel sybLabel = new SybLabel();
        jPanel.add((Component)sybLabel);
        jPanel.add(this._availableColumnsScrollPane);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout3);
        this.add(jPanel2);
        jPanel2.add((Component)this._addButton);
        jPanel2.add((Component)this._deleteButton);
        jPanel2.add((Component)this._moveUpButton);
        jPanel2.add((Component)this._moveDownButton);
        JLabel jLabel = new JLabel(" ");
        jPanel2.add(jLabel);
        jPanel2.add((Component)this._computeColumnButton);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout4);
        this.add(jPanel3);
        jPanel3.add((Component)this._selectedColumnsLabel);
        jPanel3.add(this._selectedColumnsScrollPane);
        jPanel3.add((Component)this._distinct);
        JPanel jPanel4 = new JPanel();
        jPanel3.add(jPanel4);
        sybLabel.setText(QueryEditor.getI18NMessage("columnpage.available_columns"));
        sybLabel.setLabelFor((Component)this._availableColumns);
        if (this.__parentForm.showRowLimitation()) {
            jPanel3.add((Component)this._limitRows);
            serializable = new ButtonGroup();
            ((ButtonGroup)serializable).add((AbstractButton)this._first);
            ((ButtonGroup)serializable).add((AbstractButton)this._top);
            jPanel4.add((Component)this._first);
            jPanel4.add((Component)this._top);
            jPanel4.add(this._topRows);
            jPanel4.add((Component)this._rowsLabel);
            if (this.__parentForm.showStartAtRow()) {
                jPanel4.add(this._startAtRow);
                jPanel4.add((Component)this._startAtRowLabel);
            }
        }
        serializable = new Dimension(jPanel.getPreferredSize().width, jPanel2.getPreferredSize().height);
        jPanel.setPreferredSize((Dimension)serializable);
        jPanel3.setPreferredSize((Dimension)serializable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints((Component)sybLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout2.setConstraints(this._availableColumnsScrollPane, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = QueryEditor._insets_0_5_5_5;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout3.setConstraints((Component)this._addButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout3.setConstraints((Component)this._computeColumnButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 3;
        gridBagLayout3.setConstraints((Component)this._deleteButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 4;
        gridBagLayout3.setConstraints((Component)this._moveUpButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 15;
        gridBagConstraints3.gridy = 5;
        gridBagLayout3.setConstraints((Component)this._moveDownButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = QueryEditor._insets_0_0_0_0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints(jLabel, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagLayout4.setConstraints((Component)this._selectedColumnsLabel, gridBagConstraints4);
        gridBagConstraints4.gridwidth = 1;
        gridBagConstraints4.gridy = 2;
        gridBagLayout4.setConstraints((Component)this._distinct, gridBagConstraints4);
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 2;
        gridBagLayout4.setConstraints((Component)this._limitRows, gridBagConstraints4);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 3;
        gridBagLayout4.setConstraints(jPanel4, gridBagConstraints4);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagLayout4.setConstraints(this._selectedColumnsScrollPane, gridBagConstraints4);
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout5);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = QueryEditor._insets_0_10_0_0;
        gridBagConstraints5.gridwidth = 5;
        gridBagLayout5.setConstraints((Component)this._first, gridBagConstraints5);
        gridBagConstraints5.gridy = 1;
        gridBagConstraints5.gridwidth = 1;
        gridBagLayout5.setConstraints((Component)this._top, gridBagConstraints5);
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.ipadx = 40;
        gridBagConstraints5.insets = QueryEditor._insets_0_0_0_5;
        gridBagLayout5.setConstraints(this._topRows, gridBagConstraints5);
        gridBagConstraints5.ipadx = 0;
        gridBagConstraints5.gridx = 2;
        gridBagLayout5.setConstraints((Component)this._rowsLabel, gridBagConstraints5);
        gridBagConstraints5.insets = QueryEditor._insets_0_10_0_0;
        gridBagConstraints5.gridx = 3;
        gridBagLayout5.setConstraints((Component)this._startAtRowLabel, gridBagConstraints5);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.insets = QueryEditor._insets_0_5_0_5;
        gridBagConstraints5.gridx = 4;
        gridBagConstraints5.ipadx = 40;
        gridBagConstraints5.weightx = 1.0;
        gridBagLayout5.setConstraints(this._startAtRow, gridBagConstraints5);
    }

    void destroy() {
        this._availableColumns.removeMouseListener(this);
        this._addButton.removeActionListener((ActionListener)this);
        this._deleteButton.removeActionListener((ActionListener)this);
        this._moveUpButton.removeActionListener((ActionListener)this);
        this._moveDownButton.removeActionListener((ActionListener)this);
        this._computeColumnButton.removeActionListener((ActionListener)this);
        this._selectedColumns.getModel().removeTableModelListener(this);
        this._selectedColumns.removeKeyListener(this);
        DialogUtils.removeComponents((Container)this);
        this.__parentForm = null;
        this._availableColumnsScrollPane = null;
        this._availableColumns = null;
        this._addButton = null;
        this._deleteButton = null;
        this._moveUpButton = null;
        this._moveDownButton = null;
        this._computeColumnButton = null;
        this._selectedColumnsLabel = null;
        this._selectedColumnsScrollPane = null;
        this._selectedColumns = null;
        this._distinct = null;
        this._limitRows = null;
        this._first = null;
        this._top = null;
        this._topRows = null;
        this._startAtRow = null;
        this._startAtRowLabel = null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._availableColumns) {
            int n = this._availableColumns.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = this._availableColumns.getSelectionPath();
            if (n != -1 && mouseEvent.getClickCount() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (this._availableColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    this.addSelectedColumns();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this._selectedColumns) {
            int n = keyEvent.getKeyCode();
            if (n != 113 && n != 10 && n != 32) {
                return;
            }
            int n2 = this._selectedColumns.getSelectedRow();
            int n3 = this._selectedColumns.getSelectedColumn();
            if (n2 != -1 && n3 == 0) {
                ColumnModel columnModel = (ColumnModel)this._selectedColumns.getModel().getValueAt(n2, 0);
                if (columnModel.isComputed()) {
                    this.__parentForm.editComputedColumn(columnModel);
                }
                keyEvent.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        int n;
        Object object = actionEvent.getSource();
        if (object == this._addButton) {
            this.addSelectedColumns();
        } else if (object == this._deleteButton) {
            int n2 = this._selectedColumns.getSelectedRow();
            this.removeSelectedColumn();
            DefaultTableModel defaultTableModel = (DefaultTableModel)this._selectedColumns.getModel();
            if (defaultTableModel.getRowCount() == n2) {
                --n2;
            }
            if (n2 > -1) {
                this._selectedColumns.setRowSelectionInterval(n2, n2);
            }
        } else if (object == this._moveUpButton) {
            int n3 = this._selectedColumns.getSelectedRow();
            if (n3 > 0) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)this._selectedColumns.getModel();
                ColumnModel columnModel = (ColumnModel)defaultTableModel.getValueAt(n3, 0);
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                ColumnModel columnModel2 = (ColumnModel)defaultTableModel.getValueAt(n3 - 1, 0);
                defaultTableModel.moveRow(n3, n3--, n3);
                this.selectRow(n3);
                this.__parentForm._model.moveColumnUp(++n3);
                if (columnModel.isComputed() || !columnModel.getName().equals("*")) {
                    if (columnModel2.isComputed() || !columnModel2.getName().equals("*")) {
                        this.__parentForm._intoPage.moveColumnUp(columnModel);
                    } else {
                        this.__parentForm._intoPage.moveColumnUp(columnModel, columnModel2.getTableModel());
                    }
                } else if (columnModel2.isComputed() || !columnModel2.getName().equals("*")) {
                    this.__parentForm._intoPage.moveColumnsUp(columnModel.getTableModel());
                } else {
                    this.__parentForm._intoPage.moveColumnsUp(columnModel.getTableModel(), columnModel2.getTableModel());
                }
            }
        } else if (object == this._moveDownButton) {
            int n4 = this._selectedColumns.getSelectedRow();
            if (n4 > -1 && n4 < this._selectedColumns.getRowCount() - 1) {
                DefaultTableModel defaultTableModel = (DefaultTableModel)this._selectedColumns.getModel();
                ColumnModel columnModel = (ColumnModel)defaultTableModel.getValueAt(n4, 0);
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                ColumnModel columnModel3 = (ColumnModel)defaultTableModel.getValueAt(n4 + 1, 0);
                defaultTableModel.moveRow(n4, n4++, n4);
                this.selectRow(n4);
                this.__parentForm._model.moveColumnDown(--n4);
                if (columnModel.isComputed() || !columnModel.getName().equals("*")) {
                    if (columnModel3.isComputed() || !columnModel3.getName().equals("*")) {
                        this.__parentForm._intoPage.moveColumnDown(columnModel);
                    } else {
                        this.__parentForm._intoPage.moveColumnDown(columnModel, columnModel3.getTableModel());
                    }
                } else if (columnModel3.isComputed() || !columnModel3.getName().equals("*")) {
                    this.__parentForm._intoPage.moveColumnsDown(columnModel.getTableModel());
                } else {
                    this.__parentForm._intoPage.moveColumnsDown(columnModel.getTableModel(), columnModel3.getTableModel());
                }
            }
        } else if (object == this._computeColumnButton && (n = this.__parentForm.getExpressionEditor().showExpressionEditor(QueryEditor.getI18NMessage("queryeditor.columns"))) == 1 && (string = this.__parentForm.getExpressionEditor().getExpression()) != null && string.length() > 0) {
            DefaultColumnModel defaultColumnModel = new DefaultColumnModel(null, string, true);
            this.__parentForm.addColumn(this, defaultColumnModel);
        }
        this.__parentForm._intoPage.updateIntoList();
    }

    private void addSelectedColumns() {
        TreePath[] treePathArray;
        if (this._availableColumns.getSelectionCount() > 0 && (treePathArray = this._availableColumns.getSelectionPaths()) != null) {
            int n = treePathArray.length;
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!this._availableColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    this.__parentForm.selectAllColumns((TableModel)defaultMutableTreeNode.getUserObject());
                    continue;
                }
                this.__parentForm.addColumn((JPanel)this, treePathArray[i].getPathComponent(2).toString(), (TableModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(1)).getUserObject());
            }
        }
    }

    void removeSelectedColumn() {
        int n = this._selectedColumns.getSelectedRow();
        if (n != -1) {
            ColumnModel columnModel = (ColumnModel)this._selectedColumns.getValueAt(n, 0);
            DefaultTableModel defaultTableModel = (DefaultTableModel)this._selectedColumns.getModel();
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            defaultTableModel.removeRow(n);
            this.__parentForm.removeColumn(columnModel);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n;
        if (tableModelEvent.getType() == 0 && this._selectedColumns.isEditing() && (n = tableModelEvent.getColumn()) == 1) {
            int n2 = tableModelEvent.getFirstRow();
            String string = this._selectedColumns.getModel().getValueAt(n2, n).toString();
            ColumnModel columnModel = (ColumnModel)this._selectedColumns.getModel().getValueAt(n2, 0);
            if (!columnModel.getAlias().equals(string)) {
                if (this.__parentForm._model.isAliasInUse(string) && !columnModel.getAlias().trim().equals(string.trim())) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)(string + QueryEditor.getI18NMessage("columnpage.aliasErrorMessage")), (String)QueryEditor.getI18NMessage("columnpage.aliasErrorTitle"), (int)0);
                    this._selectedColumns.setValueAt(columnModel.getAlias(), n2, n);
                } else {
                    String string2 = columnModel.getAlias();
                    columnModel.setAlias(string);
                    if (string2.length() == 0) {
                        string2 = columnModel.getName();
                        if (!columnModel.isComputed()) {
                            this.__parentForm.addColumnToTrees(columnModel);
                        }
                    }
                    this.__parentForm.renameColumn(string2, string);
                }
            }
        }
    }

    void selectRow(int n) {
        if (this._selectedColumns.isEditing()) {
            try {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._selectedColumns.setRowSelectionInterval(n, n);
        Rectangle rectangle = this._selectedColumns.getCellRect(n, 0, false);
        ++rectangle.y;
        this._selectedColumns.scrollRectToVisible(rectangle);
    }
}

