/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.DefaultTableModel;
import com.sybase.asa.QueryEditor.QueryEditorProperties;
import com.sybase.asa.QueryEditor.TableModel;
import java.util.List;

public class DefaultColumnModel
implements ColumnModel {
    protected String _columnName;
    protected boolean _computed = false;
    protected String _alias = "";
    protected TableModel _tableModel;
    protected String _prefixTableName = null;
    protected String _prefixOwnerName = null;
    protected String _prefixDatabaseName = null;

    public DefaultColumnModel(TableModel tableModel, String string, boolean bl) {
        if (bl) {
            this._tableModel = new DefaultTableModel("");
            this._columnName = string;
            this._computed = true;
        } else {
            this._tableModel = tableModel == null ? new DefaultTableModel("") : tableModel;
            string = this.stripParentheses(string);
            String[] stringArray = this.stripPrefixAndQuotes(string);
            String string2 = stringArray[0];
            this._columnName = stringArray[1];
            if (string2 != null) {
                stringArray = this.stripPrefixAndQuotes(string2);
                this._prefixOwnerName = stringArray[0];
                this._prefixTableName = stringArray[1];
                stringArray = this.stripPrefixAndQuotes(this._prefixOwnerName);
                this._prefixDatabaseName = stringArray[0];
                this._prefixOwnerName = stringArray[1];
            }
        }
    }

    DefaultColumnModel(TableModel tableModel, String string) {
        this(tableModel, string, false);
    }

    DefaultColumnModel(TableModel tableModel, String string, List list, boolean bl) {
        this._tableModel = tableModel == null ? new DefaultTableModel("") : tableModel;
        string = string.trim();
        this._computed = bl;
        if (this._computed) {
            this._columnName = string;
        } else {
            switch (list.size()) {
                case 2: {
                    this._prefixTableName = (String)list.get(0);
                    this._columnName = (String)list.get(1);
                    break;
                }
                case 3: {
                    this._prefixOwnerName = (String)list.get(0);
                    this._prefixTableName = (String)list.get(1);
                    this._columnName = (String)list.get(2);
                    break;
                }
                case 4: {
                    this._prefixDatabaseName = (String)list.get(0);
                    this._prefixOwnerName = (String)list.get(1);
                    this._prefixTableName = (String)list.get(2);
                    this._columnName = (String)list.get(3);
                    break;
                }
                default: {
                    this._columnName = string;
                }
            }
        }
    }

    private String stripParentheses(String string) {
        if (string.indexOf("(") != -1) {
            string = string.trim();
            while (string.startsWith("(") && string.endsWith(")")) {
                string = string.substring(1, string.length() - 1);
                string = string.trim();
            }
        }
        return string;
    }

    @Override
    public String[] stripPrefixAndQuotes(String string) {
        String[] stringArray = new String[2];
        if (string.endsWith("\"")) {
            int n = string.substring(0, string.length() - 1).lastIndexOf("\"");
            if (n == -1) {
                stringArray[0] = null;
                stringArray[1] = string;
            } else if (n == 0) {
                stringArray[0] = null;
                stringArray[1] = string.substring(n + 1, string.length() - 1);
            } else {
                String string2 = string.substring(0, n);
                int n2 = string2.lastIndexOf(".");
                stringArray[0] = string.substring(0, n - 1);
                stringArray[1] = string.substring(n2 + 1, string.length());
            }
        } else if (string.lastIndexOf(" ") != -1) {
            stringArray[0] = null;
            stringArray[1] = string;
        } else if (string.endsWith(")")) {
            stringArray[0] = null;
            stringArray[1] = string;
        } else {
            int n = string.lastIndexOf(".");
            if (n != -1) {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
            } else {
                stringArray[0] = null;
                stringArray[1] = string;
            }
        }
        return stringArray;
    }

    @Override
    public String getName() {
        return this._columnName;
    }

    @Override
    public void setName(String string) {
        this._columnName = string;
        this._tableModel.fireTableChanged(this, 27);
    }

    @Override
    public TableModel getTableModel() {
        return this._tableModel;
    }

    @Override
    public void setTableModel(TableModel tableModel) {
        this._tableModel = tableModel;
    }

    @Override
    public String getTableName() {
        return this._tableModel.toString();
    }

    public String toString() {
        String string;
        String string2 = this.getTableName();
        String string3 = string = this._alias.length() == 0 ? this._columnName : this._alias;
        if (string2 != null && string2.length() > 0) {
            return string2 + "." + string;
        }
        return string;
    }

    @Override
    public String getQuotedName() {
        if (this._computed) {
            if (this._alias.length() > 0) {
                if (this._alias.startsWith("\"") && this._alias.endsWith("\"")) {
                    return this._alias;
                }
                return "\"" + this._alias + "\"";
            }
            return this._columnName;
        }
        String string = this._columnName.equals("*") || !this.getQuoteNames() ? this._columnName : (this._columnName.startsWith("\"") && this._columnName.endsWith("\"") ? this._columnName : "\"" + this._columnName + "\"");
        String string2 = this._tableModel != null && this._tableModel.getName().length() > 0 && this.getFullyQualifyNames() ? this._tableModel.getTableAsPrefix() + "." + string : string;
        return string2;
    }

    @Override
    public String getPrefixTableName() {
        return this._prefixTableName;
    }

    @Override
    public String getPrefixOwnerName() {
        return this._prefixOwnerName;
    }

    @Override
    public String getPrefixDatabaseName() {
        return this._prefixDatabaseName;
    }

    @Override
    public String getPrefix() {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this._prefixDatabaseName != null) {
            stringBuffer.append(this._prefixDatabaseName).append(".");
        }
        if (this._prefixOwnerName != null) {
            stringBuffer.append(this._prefixOwnerName).append(".");
        }
        stringBuffer.append(this._prefixTableName);
        return stringBuffer.toString();
    }

    @Override
    public void setPrefix(String string, String string2) {
        this._prefixOwnerName = string;
        this._prefixTableName = string2;
    }

    @Override
    public void setPrefix(String string, String string2, String string3) {
        this._prefixOwnerName = string;
        this._prefixTableName = string2;
        this._prefixDatabaseName = string3;
    }

    @Override
    public void setComputed(boolean bl) {
        this._computed = bl;
    }

    @Override
    public boolean isComputed() {
        return this._computed;
    }

    @Override
    public String getAlias() {
        return this._alias;
    }

    @Override
    public void setAlias(String string) {
        if (string != null) {
            this._alias = string;
            this._tableModel.fireTableChanged(this, 26);
        }
    }

    protected boolean getQuoteNames() {
        return QueryEditorProperties.getQuoteNames();
    }

    protected boolean getFullyQualifyNames() {
        return QueryEditorProperties.getFullyQualifyNames();
    }
}

