/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.DefaultTableModel;
import com.sybase.asa.QueryEditor.JoinModel;
import com.sybase.asa.QueryEditor.JoinNode;
import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.QueryEditorImageLoader;
import com.sybase.asa.QueryEditor.QueryModel;
import com.sybase.asa.QueryEditor.TableModel;
import com.sybase.treeTable.AbstractTreeTableModel;
import com.sybase.treeTable.TreeTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class DefaultJoinModel
extends AbstractTreeTableModel
implements JoinModel {
    protected static String[] cNames = new String[]{" ", QueryEditor.getI18NMessage("joinpage.leftTableExpression"), QueryEditor.getI18NMessage("joinpage.joinType"), QueryEditor.getI18NMessage("joinpage.rightTableExpression"), QueryEditor.getI18NMessage("joinpage.condition")};
    protected static Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class, DefaultTableModel.class, String.class};
    protected static final ImageIcon TABLE_JOIN_TABLE = QueryEditorImageLoader.getImageIcon("table_join_table", 1001);
    protected boolean _nested = false;
    protected boolean _ignoreSetValue = false;
    protected QueryModel _queryModel = null;

    public DefaultJoinModel(QueryModel queryModel) {
        this(false, queryModel);
    }

    DefaultJoinModel(boolean bl, QueryModel queryModel) {
        super(null);
        this._nested = bl;
        this._queryModel = queryModel;
        this.root = new JoinNode(this, this._queryModel.newTableModel(bl ? "" : "FROM"), -1, this._queryModel.newTableModel(""), -1, "", "", true);
    }

    @Override
    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object)[n];
    }

    @Override
    public int getColumnCount() {
        return cNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return cNames[n];
    }

    @Override
    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    @Override
    public Object getValueAt(Object object, int n) {
        JoinNode joinNode = (JoinNode)object;
        switch (n) {
            case 0: {
                if (joinNode.isRoot()) {
                    return joinNode.getLeftTable();
                }
                return "";
            }
            case 1: {
                if (joinNode.isRoot()) {
                    return null;
                }
                if (!joinNode.isRoot() && joinNode.getParent().isRoot()) {
                    return joinNode.getLeftTable();
                }
                return TABLE_JOIN_TABLE;
            }
            case 2: {
                return joinNode.getJoinType();
            }
            case 3: {
                return joinNode.getRightTable();
            }
            case 4: {
                return joinNode.getCondition();
            }
        }
        return null;
    }

    void setIgnoreValue(boolean bl) {
        this._ignoreSetValue = bl;
    }

    @Override
    public void setValueAt(Object object, Object object2, int n) {
        if (this._ignoreSetValue) {
            this._ignoreSetValue = false;
            return;
        }
        JoinNode joinNode = (JoinNode)object2;
        switch (n) {
            case 1: {
                joinNode.setLeftTable(object);
                break;
            }
            case 2: {
                if (object == null) break;
                joinNode.setJoinType(object.toString());
                break;
            }
            case 3: {
                joinNode.setRightTable(object);
                break;
            }
            case 4: {
                if (object == null) break;
                joinNode.setCondition(object.toString());
            }
        }
    }

    protected Object[] getChildren(Object object) {
        JoinNode joinNode = (JoinNode)object;
        return joinNode.getChildren();
    }

    @Override
    public void insertNodeInto(JoinNode joinNode, JoinNode joinNode2, int n) {
        if (joinNode2 == null) {
            joinNode2 = (JoinNode)this.root;
        }
        joinNode.setParent(joinNode2);
        joinNode2.insert(joinNode, n);
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        nArray[0] = n;
        objectArray[0] = joinNode;
        this.fireTreeNodesInserted(this, joinNode2.getPath(), nArray, objectArray);
    }

    @Override
    public void appendTable(TableModel tableModel, int n, String string, String string2) {
        this.appendTable(this.getLastNode(), tableModel, n, string, string2);
    }

    @Override
    public void appendTable(TableModel tableModel) {
        this.appendTable(this.getLastNode(), tableModel);
    }

    @Override
    public JoinNode appendTable(JoinNode joinNode, TableModel tableModel) {
        List<TableModel> list = this.getTableList();
        int n = list.size();
        String string = "";
        String string2 = "";
        if (n > 0) {
            string = "CROSS JOIN";
            for (int i = 0; i < n; ++i) {
                TableModel tableModel2 = list.get(i);
                if (tableModel == tableModel2 || (string2 = tableModel.getJoinCondition(tableModel2)).length() <= 0) continue;
                string = "JOIN";
                break;
            }
        }
        return this.appendTable(joinNode, tableModel, 0, string, string2);
    }

    private JoinNode appendTable(JoinNode joinNode, Object object, int n, String string, String string2) {
        if (joinNode != null) {
            if (joinNode.getParent() == this.root && joinNode.getLeftTable().toString().length() == 0) {
                joinNode.setLeftTable(object);
                joinNode.setLeftTableType(n);
                joinNode.setJoinType("");
                joinNode.setCondition("");
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                nArray[0] = this.getIndexOfChild(this.root, joinNode);
                objectArray[0] = joinNode;
                this.fireTreeNodesChanged(this, joinNode.getPath(), nArray, objectArray);
                return joinNode;
            }
            if (joinNode.getRightTable().toString().length() == 0) {
                joinNode.setRightTable(object);
                joinNode.setRightTableType(n);
                joinNode.setJoinType(string);
                joinNode.setCondition(string2);
                int[] nArray = new int[1];
                Object[] objectArray = new Object[1];
                nArray[0] = this.getIndexOfChild(this.root, joinNode);
                objectArray[0] = joinNode;
                this.fireTreeNodesChanged(this, joinNode.getPath(), nArray, objectArray);
                return joinNode;
            }
            JoinNode joinNode2 = new JoinNode(this, this._queryModel.newTableModel(""), 0, object, 0, string, string2);
            this.insertNodeInto(joinNode2, joinNode, 0);
            return joinNode2;
        }
        JoinNode joinNode3 = new JoinNode(this, object, 0, this._queryModel.newTableModel(""), 0, string, string2);
        this.insertNodeInto(joinNode3, joinNode, 0);
        return joinNode3;
    }

    @Override
    public void appendCondition(String string) {
        JoinNode joinNode = this.getLastNode();
        if (joinNode != null) {
            joinNode.setCondition(string);
        }
    }

    @Override
    public void makeLastNodeNested(String string) {
        JoinNode joinNode = this.getLastNode();
        if (joinNode != null) {
            Object object = joinNode.getLeftTable();
            boolean bl = false;
            boolean bl2 = false;
            JoinNode joinNode2 = joinNode;
            if (object instanceof TableModel) {
                if (object.toString().length() == 0) {
                    bl = true;
                    joinNode2 = joinNode.getParent();
                    object = joinNode2.getRightTable();
                } else if (joinNode.getParent() != this.root) {
                    bl2 = true;
                    joinNode2 = joinNode.getParent();
                }
            }
            JoinNode joinNode3 = new JoinNode(this, object, 0, joinNode.getRightTable(), 0, joinNode.getJoinType(), joinNode.getCondition());
            JoinModel joinModel = this._queryModel.newJoinModel(true, this._queryModel);
            joinModel.insertNodeInto(joinNode3, null, 0);
            if (bl) {
                joinNode2.remove(0);
                joinNode2.setRightTable(joinModel);
                joinNode2.setRightTableType(1);
            } else if (bl2) {
                joinNode.setLeftTable(this._queryModel.newTableModel(""));
                joinNode.setLeftTableType(0);
                joinNode.setJoinType(string);
                joinNode.setRightTable(joinModel);
                joinNode.setRightTableType(1);
                joinNode.setCondition("");
            }
        }
    }

    @Override
    public JoinNode getLastNode() {
        JoinNode joinNode = (JoinNode)this.root;
        int n = joinNode.getChildCount();
        if (n > 0) {
            JoinNode joinNode2 = (JoinNode)joinNode.getChildren()[n - 1];
            while (joinNode2.getChildren().length > 0) {
                joinNode2 = (JoinNode)joinNode2.getChildren()[0];
            }
            return joinNode2;
        }
        return null;
    }

    @Override
    public void removeNodeFromParent(JoinNode joinNode) {
        JoinNode joinNode2 = joinNode.getParent();
        if (joinNode2 == null) {
            throw new IllegalArgumentException("Node does not have a parent.");
        }
        int[] nArray = new int[1];
        Object[] objectArray = new Object[1];
        nArray[0] = joinNode2.getIndex(joinNode);
        joinNode2.remove(nArray[0]);
        objectArray[0] = joinNode;
        this.fireTreeNodesRemoved(this, joinNode2.getPath(), nArray, objectArray);
    }

    @Override
    public void removeTable(TableModel tableModel) {
        Object[] objectArray = ((JoinNode)this.root).getChildren();
        for (int i = ((JoinNode)this.root).getChildCount() - 1; i > -1; --i) {
            JoinNode joinNode = (JoinNode)objectArray[i];
            boolean bl = false;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            do {
                JoinNode joinNode2;
                Object object;
                if (!bl) {
                    object = joinNode.getLeftTable();
                    if (object instanceof TableModel) {
                        if (object == tableModel) {
                            bl = true;
                            if (joinNode.getChildCount() == 0 && joinNode.getRightTable().toString().length() > 0 && joinNode.getRightTable() != tableModel) {
                                arrayList.add(joinNode.getRightTable());
                            }
                            if (joinNode.getChildCount() > 0) {
                                joinNode2 = joinNode;
                                while (joinNode2 != null) {
                                    Object[] objectArray2;
                                    if (joinNode2.getLeftTable().toString().length() > 0 && joinNode2.getLeftTable() != tableModel) {
                                        arrayList.add(joinNode2.getLeftTable());
                                    }
                                    if (joinNode2.getRightTable().toString().length() > 0 && joinNode2.getRightTable() != tableModel) {
                                        arrayList.add(joinNode2.getRightTable());
                                    }
                                    if ((objectArray2 = joinNode2.getChildren()) != null && objectArray2.length > 0) {
                                        joinNode2 = (JoinNode)objectArray2[0];
                                        continue;
                                    }
                                    joinNode2 = null;
                                }
                            }
                        }
                    } else if (object instanceof JoinModel) {
                        ((JoinModel)object).removeTable(tableModel);
                    }
                }
                if (!bl) {
                    object = joinNode.getRightTable();
                    if (object instanceof TableModel) {
                        if (object == tableModel) {
                            bl = true;
                            if (joinNode.getChildCount() == 0 && joinNode.getLeftTable().toString().length() > 0 && joinNode.getLeftTable() != tableModel) {
                                arrayList.add(joinNode.getLeftTable());
                            }
                            if (joinNode.getChildCount() > 0) {
                                joinNode2 = joinNode;
                                while (joinNode2 != null) {
                                    Object[] objectArray3;
                                    if (joinNode2.getLeftTable().toString().length() > 0 && joinNode2.getLeftTable() != tableModel) {
                                        arrayList.add(joinNode2.getLeftTable());
                                    }
                                    if (joinNode2.getRightTable().toString().length() > 0 && joinNode2.getRightTable() != tableModel) {
                                        arrayList.add(joinNode2.getRightTable());
                                    }
                                    if ((objectArray3 = joinNode2.getChildren()) != null && objectArray3.length > 0) {
                                        joinNode2 = (JoinNode)objectArray3[0];
                                        continue;
                                    }
                                    joinNode2 = null;
                                }
                            }
                        }
                    } else if (object instanceof JoinModel) {
                        ((JoinModel)object).removeTable(tableModel);
                    }
                }
                if (!bl && joinNode.getCondition().indexOf(tableModel.toString()) != -1) {
                    joinNode.setCondition("");
                }
                if (bl) {
                    object = joinNode.getParent();
                    this.removeNodeFromParent(joinNode);
                    if (((JoinNode)object).isRoot()) {
                        object = null;
                    }
                    int n = arrayList.size();
                    for (int j = 0; j < n; ++j) {
                        object = arrayList.get(j) instanceof TableModel ? this.appendTable((JoinNode)object, (TableModel)arrayList.get(j)) : this.appendTable((JoinNode)object, arrayList.get(j), 1, "CROSS JOIN", "");
                    }
                } else {
                    if (joinNode.getChildren().length > 0) {
                        joinNode = (JoinNode)joinNode.getChildren()[0];
                        continue;
                    }
                    bl = true;
                }
            } while (!bl);
        }
    }

    @Override
    public void clear() {
        Object[] objectArray = ((JoinNode)this.root).getChildren();
        for (int i = ((JoinNode)this.root).getChildCount() - 1; i > -1; --i) {
            JoinNode joinNode = (JoinNode)objectArray[i];
            do {
                Object object;
                Object object2;
                if ((object2 = joinNode.getLeftTable()) instanceof JoinModel) {
                    ((JoinModel)object2).clear();
                }
                if ((object = joinNode.getRightTable()) instanceof JoinModel) {
                    ((JoinModel)object).clear();
                }
                if (joinNode.getParent() == this.root) {
                    joinNode.getParent().remove(i);
                    joinNode.setParent(null);
                } else {
                    JoinNode joinNode2 = joinNode.getParent();
                    joinNode2.remove(0);
                    joinNode.setParent(null);
                }
                if (joinNode.getChildren().length <= 0) continue;
                joinNode = (JoinNode)joinNode.getChildren()[0];
            } while (joinNode.getChildren().length > 0);
        }
    }

    public String toString() {
        if (this.isNested() && ((JoinNode)this.root).getChildCount() == 0) {
            return "Nested Join";
        }
        return this.getJoinStatement();
    }

    @Override
    public String getJoinStatement() {
        StringBuffer stringBuffer = new StringBuffer(200);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringBuffer stringBuffer3 = new StringBuffer();
        int n = ((JoinNode)this.root).getChildCount();
        if (n == 0) {
            return "";
        }
        if (!this.isNested()) {
            stringBuffer.append("FROM ");
        } else {
            stringBuffer.append("( ");
        }
        Object[] objectArray = ((JoinNode)this.root).getChildren();
        for (int i = 0; i < n; ++i) {
            JoinNode joinNode = (JoinNode)objectArray[i];
            while (joinNode.getChildren().length > 0) {
                stringBuffer2.append(joinNode.toJoin(true));
                stringBuffer2.append(" )");
                stringBuffer3.append("( ");
                joinNode = (JoinNode)joinNode.getChildren()[0];
            }
            stringBuffer2.append(joinNode.toJoin(true));
            if (i < ((JoinNode)this.root).getChildCount() - 1) {
                stringBuffer.append(stringBuffer3).append(stringBuffer2).append(",\n");
                stringBuffer2 = new StringBuffer(100);
                stringBuffer3 = new StringBuffer();
                continue;
            }
            stringBuffer.append(stringBuffer3).append(stringBuffer2);
        }
        if (this.isNested()) {
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    String getJoinStatement(JoinNode[] joinNodeArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringBuffer stringBuffer3 = new StringBuffer();
        for (int i = 1; i < joinNodeArray.length; ++i) {
            stringBuffer3.append("( ");
            stringBuffer2.append(joinNodeArray[i].toJoin(true));
            stringBuffer2.append(" )");
        }
        stringBuffer.append(stringBuffer3).append(stringBuffer2);
        return stringBuffer.toString();
    }

    @Override
    public boolean isCellEditable(Object object, int n) {
        JoinNode joinNode = (JoinNode)object;
        if (joinNode.isRoot()) {
            return false;
        }
        if (this.getColumnClass(n) == TreeTableModel.class) {
            return false;
        }
        return n != 1 || joinNode.getParent().isRoot();
    }

    public List<TableModel> getTableList() {
        return this.getTableList(this.getLastNode());
    }

    protected List<TableModel> getTableList(JoinNode joinNode) {
        ArrayList<TableModel> arrayList = new ArrayList<TableModel>();
        while (joinNode != null && joinNode != this.root) {
            if (joinNode.getRightTable().toString().length() > 0) {
                if (joinNode.getRightTable() instanceof TableModel) {
                    arrayList.add((TableModel)joinNode.getRightTable());
                } else {
                    arrayList.addAll(this.getTableList(((JoinModel)joinNode.getRightTable()).getLastNode()));
                }
            }
            if (joinNode.getLeftTable().toString().length() > 0) {
                if (joinNode.getLeftTable() instanceof TableModel) {
                    arrayList.add((TableModel)joinNode.getLeftTable());
                } else {
                    arrayList.addAll(this.getTableList(((JoinModel)joinNode.getLeftTable()).getLastNode()));
                }
            }
            joinNode = joinNode.getParent();
        }
        return arrayList;
    }

    public static void copy(JoinModel joinModel, JoinModel joinModel2) {
        joinModel2.setNested(joinModel.isNested());
        JoinNode joinNode = (JoinNode)joinModel.getRoot();
        joinModel2.setRoot(new JoinNode(joinModel2, joinNode.getLeftTable(), joinNode.getLeftTableType(), joinNode.getRightTable(), joinNode.getRightTableType(), joinNode.getJoinType(), joinNode.getCondition(), true));
        Object[] objectArray = joinNode.getChildren();
        int n = joinNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            JoinNode joinNode2 = (JoinNode)objectArray[i];
            JoinNode joinNode3 = new JoinNode(joinModel2, joinNode2.getLeftTable(), joinNode2.getLeftTableType(), joinNode2.getRightTable(), joinNode2.getRightTableType(), joinNode2.getJoinType(), joinNode2.getCondition());
            joinModel2.insertNodeInto(joinNode3, null, i);
            while (joinNode2.getChildren().length > 0) {
                joinNode2 = (JoinNode)joinNode2.getChildren()[0];
                JoinNode joinNode4 = new JoinNode(joinModel2, joinNode2.getLeftTable(), joinNode2.getLeftTableType(), joinNode2.getRightTable(), joinNode2.getRightTableType(), joinNode2.getJoinType(), joinNode2.getCondition());
                joinModel2.insertNodeInto(joinNode4, joinNode3, 0);
                joinNode3 = joinNode4;
            }
        }
    }

    @Override
    public void changeTableNameInOnCondition(String string, String string2) {
        JoinNode joinNode = (JoinNode)this.root;
        int n = joinNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            JoinNode joinNode2 = (JoinNode)joinNode.getChildren()[n - 1];
            if (joinNode2.getCondition().length() > 0) {
                joinNode2.setCondition(QueryEditor.replaceString(joinNode2.getCondition(), string, string2));
            }
            while (joinNode2.getChildren().length > 0) {
                if ((joinNode2 = (JoinNode)joinNode2.getChildren()[0]).getCondition().length() <= 0) continue;
                joinNode2.setCondition(QueryEditor.replaceString(joinNode2.getCondition(), string, string2));
            }
        }
    }

    @Override
    public boolean isNested() {
        return this._nested;
    }

    @Override
    public void setNested(boolean bl) {
        this._nested = bl;
    }

    @Override
    public void setRoot(Object object) {
        this.root = object;
    }
}

