/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.CubeGroupByModel;
import com.sybase.asa.QueryEditor.DefaultColumnModel;
import com.sybase.asa.QueryEditor.DefaultJoinModel;
import com.sybase.asa.QueryEditor.DefaultOrderModel;
import com.sybase.asa.QueryEditor.DefaultTableModel;
import com.sybase.asa.QueryEditor.GroupByModel;
import com.sybase.asa.QueryEditor.JoinModel;
import com.sybase.asa.QueryEditor.OrderModel;
import com.sybase.asa.QueryEditor.ParseException;
import com.sybase.asa.QueryEditor.QueryModel;
import com.sybase.asa.QueryEditor.QueryModelEvent;
import com.sybase.asa.QueryEditor.QueryModelListener;
import com.sybase.asa.QueryEditor.RollupGroupByModel;
import com.sybase.asa.QueryEditor.SelectParser;
import com.sybase.asa.QueryEditor.SetGroupByModel;
import com.sybase.asa.QueryEditor.SimpleGroupByModel;
import com.sybase.asa.QueryEditor.TableModel;
import com.sybase.asa.QueryEditor.TableModelEvent;
import com.sybase.asa.QueryEditor.TableModelListener;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class DefaultQueryModel
implements QueryModel,
TableModelListener,
TreeModelListener {
    String _sqlQuery = "";
    String _comments = "";
    boolean _distinct = false;
    boolean _allColumns = false;
    int _topRows = -1;
    int _startAtRow = -1;
    String _havingClause = "";
    List<String> _intoList = new ArrayList<String>();
    List<GroupByModel> _groupByList = new ArrayList<GroupByModel>();
    boolean _groupingSets = false;
    boolean _groupByAll = false;
    List<OrderModel> _orderList = new ArrayList<OrderModel>();
    List<TableModel> _tableList = new ArrayList<TableModel>();
    List<ColumnModel> _columnList = new ArrayList<ColumnModel>();
    String _whereClause = "";
    EventListenerList _listenerList = new EventListenerList();
    boolean _quietMode = false;
    boolean _ignoreQueryChanged = false;
    boolean _cancelled = false;
    JoinModel _joinModel = null;
    boolean _appendSemicolon = false;

    public DefaultQueryModel(String string) throws ParseException {
        this.init(string);
    }

    public DefaultQueryModel() {
        try {
            this.init(null);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void init(String string) throws ParseException {
        this._joinModel = new DefaultJoinModel(this);
        if (string != null) {
            string = string.trim() + "\n";
            StringReader stringReader = new StringReader(string + " ");
            SelectParser selectParser = new SelectParser(stringReader);
            try {
                this.parse(selectParser);
            }
            catch (ParseException parseException) {
                throw new ParseException(parseException.getMessage());
            }
        }
        this._joinModel.addTreeModelListener(this);
    }

    protected void parse(SelectParser selectParser) throws ParseException {
        try {
            selectParser.input(this);
            this.linkColumns(this._columnList);
            this.linkGroupByColumns();
            this.linkOrderColumns(this._orderList);
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage());
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Throwable)exception);
        }
    }

    private void linkGroupByColumns() {
        int n = this._groupByList.size();
        for (int i = 0; i < n; ++i) {
            ColumnModel columnModel;
            int n2;
            int n3;
            List<ColumnModel> list;
            Object object;
            GroupByModel groupByModel = this._groupByList.get(i);
            if (groupByModel instanceof SimpleGroupByModel) {
                object = ((SimpleGroupByModel)groupByModel).getColumnModel();
                this.linkColumn((ColumnModel)object);
                continue;
            }
            if (groupByModel instanceof CubeGroupByModel) {
                object = (CubeGroupByModel)groupByModel;
                list = ((CubeGroupByModel)object).getColumns();
                n3 = list.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    columnModel = list.get(n2);
                    this.linkColumn(columnModel);
                }
                continue;
            }
            if (groupByModel instanceof RollupGroupByModel) {
                object = (RollupGroupByModel)groupByModel;
                list = ((RollupGroupByModel)object).getColumns();
                n3 = list.size();
                for (n2 = 0; n2 < n3; ++n2) {
                    columnModel = list.get(n2);
                    this.linkColumn(columnModel);
                }
                continue;
            }
            if (!(groupByModel instanceof SetGroupByModel)) continue;
            object = (SetGroupByModel)groupByModel;
            list = ((SetGroupByModel)object).getColumns();
            n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                columnModel = list.get(n2);
                this.linkColumn(columnModel);
            }
        }
    }

    private void linkColumns(List<ColumnModel> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof DefaultOrderModel)) continue;
            ColumnModel columnModel = list.get(i);
            this.linkColumn(columnModel);
        }
    }

    private void linkOrderColumns(List<OrderModel> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (!(list.get(i) instanceof DefaultOrderModel)) continue;
            ColumnModel columnModel = list.get(i).getColumnModel();
            this.linkColumn(columnModel);
        }
    }

    private void linkColumn(ColumnModel columnModel) {
        String string;
        if (columnModel != null && !columnModel.isComputed() && columnModel.getTableModel().getName().length() == 0 && (string = columnModel.getPrefixTableName()) != null && string.length() > 0) {
            String string2 = columnModel.getPrefixOwnerName();
            boolean bl = false;
            if (string2 != null && string2.length() > 0) {
                bl = true;
            }
            int n = this._tableList.size();
            for (int i = 0; i < n; ++i) {
                TableModel tableModel = this._tableList.get(i);
                if (bl && !string2.equals(tableModel.getOwner())) break;
                if (string.equals(tableModel.getName())) {
                    columnModel.setTableModel(tableModel);
                    break;
                }
                if (!string.equals(tableModel.getAlias())) continue;
                columnModel.setTableModel(tableModel);
                break;
            }
        }
    }

    @Override
    public void setAppendSemicolon(boolean bl) {
        this._appendSemicolon = bl;
    }

    @Override
    public String getSQLQuery() {
        if (this._cancelled) {
            return this._sqlQuery;
        }
        return this.calculateQuery() + (this._appendSemicolon ? ";" : "");
    }

    @Override
    public void setSQLQuery(String string) {
        if (string.length() > 0) {
            this._sqlQuery = string;
            this.fireQueryChanged(this, 7, null);
        }
    }

    @Override
    public boolean isGroupingSets() {
        return this._groupingSets;
    }

    @Override
    public void setGroupingSets(boolean bl) {
        this._groupingSets = bl;
        this.fireQueryChanged(this, 13, null);
    }

    @Override
    public boolean isDistinct() {
        return this._distinct;
    }

    @Override
    public void setDistinct(boolean bl) {
        this._distinct = bl;
        this.fireQueryChanged(this, 8, null);
    }

    @Override
    public int getTopRows() {
        return this._topRows;
    }

    @Override
    public void setTopRows(int n) {
        this._topRows = n;
        this.fireQueryChanged(this, 9, null);
    }

    @Override
    public int getStartAtRow() {
        return this._startAtRow;
    }

    @Override
    public void setStartAtRow(int n) {
        this._startAtRow = n;
        this.fireQueryChanged(this, 29, null);
    }

    @Override
    public List<String> getIntoList() {
        return this._intoList;
    }

    @Override
    public void setIntoList(List<String> list) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        this._intoList = list;
        this.fireQueryChanged(this, 10, null);
    }

    @Override
    public void changeIntoVariable(String string, int n) {
        if (n < this._intoList.size() && n > -1) {
            this._intoList.remove(n);
            this._intoList.add(n, string);
        }
        this.fireQueryChanged(this, 10, null);
    }

    @Override
    public void removeIntoVariable(String string) {
        this._intoList.remove(string);
        this.fireQueryChanged(this, 10, null);
    }

    @Override
    public List<GroupByModel> getGroupBy() {
        return this._groupByList;
    }

    @Override
    public void setGroupBy(List<GroupByModel> list) {
        if (list == null) {
            list = new ArrayList<GroupByModel>();
        }
        this._groupByList = list;
        this.fireQueryChanged(this, 11, null);
    }

    @Override
    public void addGroupBy(GroupByModel groupByModel) {
        if (!this.groupByExists(groupByModel)) {
            this._groupByList.add(groupByModel);
            this.fireQueryChanged(this, 11, null);
        }
    }

    @Override
    public void updateGroupBy(GroupByModel groupByModel) {
        this.fireQueryChanged(this, 13, null);
    }

    @Override
    public boolean groupByExists(GroupByModel groupByModel) {
        if (groupByModel != null && groupByModel instanceof SimpleGroupByModel) {
            ColumnModel columnModel = ((SimpleGroupByModel)groupByModel).getColumnModel();
            int n = this._groupByList.size();
            for (int i = 0; i < n; ++i) {
                GroupByModel groupByModel2 = this._groupByList.get(i);
                if (!(groupByModel2 instanceof SimpleGroupByModel)) continue;
                ColumnModel columnModel2 = ((SimpleGroupByModel)groupByModel2).getColumnModel();
                if (!columnModel.getName().equals(columnModel2.getName()) || !columnModel.getTableName().equals(columnModel2.getTableName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeGroupBy(GroupByModel groupByModel) {
        this._groupByList.remove(groupByModel);
        if (!this._ignoreQueryChanged) {
            this.fireQueryChanged(this, 12, null);
        }
    }

    @Override
    public boolean isGroupByAll() {
        return this._groupByAll;
    }

    @Override
    public void setGroupByAll(boolean bl) {
        this._groupByAll = bl;
        this.fireQueryChanged(this, 13, null);
    }

    @Override
    public String getHavingClause() {
        if (this._havingClause == null) {
            return "";
        }
        return this._havingClause;
    }

    @Override
    public void setHavingClause(String string) {
        this._havingClause = string == null ? "" : string;
        this.fireQueryChanged(this, 14, null);
    }

    @Override
    public String getWhereClause() {
        if (this._whereClause == null) {
            return "";
        }
        return this._whereClause;
    }

    @Override
    public void setWhereClause(String string) {
        this._whereClause = string == null ? "" : string;
        this.fireQueryChanged(this, 4, null);
    }

    @Override
    public List<OrderModel> getOrderColumns() {
        return this._orderList;
    }

    @Override
    public void setOrderColumns(List<OrderModel> list) {
        if (list == null) {
            list = new ArrayList<OrderModel>();
        }
        this._orderList = list;
        this.fireQueryChanged(this, 15, null);
    }

    @Override
    public void selectAllColumns(boolean bl) {
        this._allColumns = bl;
        this.fireQueryChanged(this, 18, null);
    }

    @Override
    public boolean isSelectAllColumnsSet() {
        return this._allColumns;
    }

    @Override
    public TableModel getTable(String string) {
        TableModel tableModel;
        int n;
        int n2 = this._tableList.size();
        for (n = 0; n < n2; ++n) {
            tableModel = this._tableList.get(n);
            if (!tableModel.getFullName().equalsIgnoreCase(string)) continue;
            return tableModel;
        }
        for (n = 0; n < n2; ++n) {
            tableModel = this._tableList.get(n);
            if (!tableModel.getName().equalsIgnoreCase(string)) continue;
            return tableModel;
        }
        return this.getTableFromAlias(string);
    }

    @Override
    public List<TableModel> getTables() {
        return this._tableList;
    }

    @Override
    public void setTables(List<TableModel> list) {
        TableModel tableModel;
        int n;
        if (list == null) {
            list = new ArrayList<TableModel>();
        }
        int n2 = this._tableList.size();
        for (n = 0; n < n2; ++n) {
            tableModel = this._tableList.get(n);
            tableModel.removeTableModelListener(this);
        }
        this._tableList = list;
        n2 = this._tableList.size();
        for (n = 0; n < n2; ++n) {
            tableModel = this._tableList.get(n);
            tableModel.addTableModelListener(this);
        }
        this.fireQueryChanged(this, 2, null);
    }

    @Override
    public void addTable(TableModel tableModel) {
        if (!this.tableExists(tableModel)) {
            this._tableList.add(tableModel);
            tableModel.addTableModelListener(this);
            this.fireQueryChanged(this, 2, null);
        }
    }

    @Override
    public boolean tableExists(TableModel tableModel) {
        if (tableModel != null) {
            int n = this._tableList.size();
            for (int i = 0; i < n; ++i) {
                TableModel tableModel2 = this._tableList.get(i);
                if (!tableModel.getFullName().equals(tableModel2.getFullName()) || !tableModel.getAlias().equals(tableModel2.getAlias())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeTable(TableModel tableModel) {
        if (tableModel != null) {
            Object object;
            int n;
            this._ignoreQueryChanged = true;
            this._joinModel.removeTable(tableModel);
            for (n = this._columnList.size() - 1; n > -1; --n) {
                object = this._columnList.get(n);
                if (object.getTableModel() != tableModel) continue;
                this.removeColumn((ColumnModel)object);
            }
            for (n = this._groupByList.size() - 1; n > -1; --n) {
                ColumnModel columnModel;
                object = this._groupByList.get(n);
                if (!(object instanceof SimpleGroupByModel) || (columnModel = ((SimpleGroupByModel)object).getColumnModel()).getTableModel() != tableModel) continue;
                this.removeGroupBy((GroupByModel)object);
            }
            for (n = this._orderList.size() - 1; n > -1; --n) {
                object = this._orderList.get(n);
                if (object.getTableModel() != tableModel) continue;
                this.removeOrderColumn((OrderModel)object);
            }
            this._ignoreQueryChanged = false;
            this._tableList.remove(tableModel);
            tableModel.removeTableModelListener(this);
            this.fireQueryChanged(this, 3, null);
        }
    }

    @Override
    public void removeTable(String string) {
        TableModel tableModel = this.getTable(string);
        if (tableModel != null) {
            this.removeTable(tableModel);
        }
    }

    @Override
    public ColumnModel getColumn(String string, String string2) {
        int n = this._columnList.size();
        for (int i = 0; i < n; ++i) {
            ColumnModel columnModel = this._columnList.get(i);
            if (!columnModel.getName().equals(string)) continue;
            if (columnModel.getTableName().equals(string2)) {
                return columnModel;
            }
            if (string2.length() <= 0 || !string2.equals(columnModel.getTableModel().getAlias())) continue;
            return columnModel;
        }
        return null;
    }

    @Override
    public List<ColumnModel> getColumns() {
        return this._columnList;
    }

    @Override
    public void setColumns(List<ColumnModel> list) {
        if (list == null) {
            list = new ArrayList<ColumnModel>();
        }
        this._columnList = list;
        this.fireQueryChanged(this, 0, null);
    }

    @Override
    public void addColumn(ColumnModel columnModel) {
        if (!this.columnExists(columnModel)) {
            this._columnList.add(columnModel);
            this.fireQueryChanged(this, 0, null);
        }
    }

    @Override
    public void addColumns(List<ColumnModel> list) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.addColumn(list.get(i));
        }
    }

    @Override
    public boolean columnExists(ColumnModel columnModel) {
        if (columnModel != null) {
            int n = this._columnList.size();
            for (int i = 0; i < n; ++i) {
                ColumnModel columnModel2 = this._columnList.get(i);
                if (!columnModel.getName().equals(columnModel2.getName()) || !columnModel.getTableName().equals(columnModel2.getTableName()) || !columnModel.getAlias().equals(columnModel2.getAlias())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeColumn(ColumnModel columnModel) {
        boolean bl = this._columnList.remove(columnModel);
        if (!this._ignoreQueryChanged) {
            this.fireQueryChanged(this, 1, null);
        }
        return bl;
    }

    @Override
    public boolean removeColumn(String string, String string2) {
        ColumnModel columnModel = this.getColumn(string, string2);
        boolean bl = false;
        if (columnModel != null) {
            this.removeColumn(columnModel);
        }
        return bl;
    }

    @Override
    public void moveColumnUp(int n) {
        ColumnModel columnModel = this._columnList.get(n);
        this._columnList.remove(n);
        this._columnList.add(n - 1, columnModel);
        this.fireQueryChanged(this, 28, null);
    }

    @Override
    public void moveColumnDown(int n) {
        ColumnModel columnModel = this._columnList.get(n);
        this._columnList.remove(n);
        this._columnList.add(n + 1, columnModel);
        this.fireQueryChanged(this, 28, null);
    }

    @Override
    public ColumnModel matchColumnAlias(String string) {
        int n = this._columnList.size();
        for (int i = 0; i < n; ++i) {
            ColumnModel columnModel = this._columnList.get(i);
            if (!string.equals(columnModel.getAlias())) continue;
            return columnModel;
        }
        return null;
    }

    @Override
    public TableModel getTableFromAlias(String string) {
        String string2 = string.trim();
        if (!string2.startsWith("\"") || !string2.endsWith("\"")) {
            string2 = "\"" + string + "\"";
        }
        int n = this._tableList.size();
        for (int i = 0; i < n; ++i) {
            TableModel tableModel = this._tableList.get(i);
            if (!string.equals(tableModel.getAlias()) && !string2.equals(tableModel.getAlias())) continue;
            return tableModel;
        }
        return null;
    }

    @Override
    public void addOrderColumn(OrderModel orderModel) {
        if (!this.orderColumnExists(orderModel)) {
            this._orderList.add(orderModel);
            this.fireQueryChanged(this, 15, null);
        }
    }

    @Override
    public boolean orderColumnExists(OrderModel orderModel) {
        if (orderModel != null) {
            int n = this._orderList.size();
            for (int i = 0; i < n; ++i) {
                OrderModel orderModel2 = this._orderList.get(i);
                if (!orderModel.getName().equals(orderModel2.getName()) || !orderModel.getColumnModel().getAlias().equals(orderModel2.getColumnModel().getAlias()) || !orderModel.getTableName().equals(orderModel2.getTableName()) || !orderModel.getTableModel().getAlias().equals(orderModel2.getTableModel().getAlias())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removeOrderColumn(OrderModel orderModel) {
        this._orderList.remove(orderModel);
        if (!this._ignoreQueryChanged) {
            this.fireQueryChanged(this, 16, null);
        }
    }

    @Override
    public void removeOrderColumn(String string, String string2) {
        OrderModel orderModel = this.getOrderModel(string, string2);
        if (orderModel != null) {
            this.removeOrderColumn(orderModel);
        }
    }

    @Override
    public OrderModel getOrderModel(ColumnModel columnModel) {
        int n = this._orderList.size();
        for (int i = 0; i < n; ++i) {
            OrderModel orderModel = this._orderList.get(i);
            if (columnModel != orderModel.getColumnModel()) continue;
            return orderModel;
        }
        return null;
    }

    @Override
    public void invertOrderDirection(OrderModel orderModel) {
        orderModel.setDirection(!orderModel.getDirection());
        this.fireQueryChanged(this, 17, null);
    }

    public OrderModel getOrderModel(String string, String string2) {
        int n = this._orderList.size();
        for (int i = 0; i < n; ++i) {
            OrderModel orderModel = this._orderList.get(i);
            if (!string.equals(orderModel.getName()) || !string2.equals(orderModel.getTableName())) continue;
            return orderModel;
        }
        return null;
    }

    public void setComments(String string) {
        this._comments = string;
    }

    public String getComments() {
        return this._comments;
    }

    @Override
    public void addQueryModelListener(QueryModelListener queryModelListener) {
        this._listenerList.add(QueryModelListener.class, queryModelListener);
    }

    @Override
    public void removeQueryModelListener(QueryModelListener queryModelListener) {
        this._listenerList.remove(QueryModelListener.class, queryModelListener);
    }

    @Override
    public void fireQueryChanged(Object object, int n, EventObject eventObject) {
        if (!this._quietMode) {
            Object[] objectArray = this._listenerList.getListenerList();
            QueryModelEvent queryModelEvent = null;
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != QueryModelListener.class) continue;
                if (queryModelEvent == null) {
                    queryModelEvent = new QueryModelEvent(object, n, eventObject);
                }
                ((QueryModelListener)objectArray[i + 1]).queryChanged(queryModelEvent);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fireQueryChanged(this, tableModelEvent.getType(), tableModelEvent);
    }

    @Override
    public void setQuietMode(boolean bl) {
        this._quietMode = bl;
    }

    public boolean isQuietMode() {
        return this._quietMode;
    }

    private String calculateQuery() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._columnList.size() > 0) {
            Object object;
            int n;
            String string;
            Object object2;
            int n2;
            stringBuffer.append("SELECT ");
            if (this._distinct) {
                stringBuffer.append("DISTINCT ");
            }
            if (this._topRows == 0) {
                stringBuffer.append("FIRST ");
            } else if (this._topRows > 0) {
                stringBuffer.append("TOP ").append(this._topRows).append(" ");
                if (this._startAtRow > 1) {
                    stringBuffer.append("START AT ").append(this._startAtRow).append(" ");
                }
            }
            boolean bl = true;
            int n3 = this._columnList.size();
            for (n2 = 0; n2 < n3 && bl; ++n2) {
                object2 = this._columnList.get(n2);
                if (object2.getName().endsWith("*")) continue;
                bl = false;
            }
            if (bl && this._columnList.size() >= this._tableList.size()) {
                stringBuffer.append("*");
            } else {
                n2 = this._columnList.size();
                if (n2 > 0) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        object2 = this._columnList.get(n3);
                        stringBuffer.append(object2.isComputed() ? object2.getName() : object2.getQuotedName());
                        String string2 = object2.getAlias();
                        if (string2 != null && string2.length() > 0) {
                            stringBuffer.append(" AS \"").append(string2).append("\"");
                        }
                        if (n3 >= n2 - 1) continue;
                        stringBuffer.append(",\n");
                    }
                }
            }
            n2 = this._intoList.size();
            if (n2 > 0) {
                stringBuffer.append("\nINTO ");
                for (n3 = 0; n3 < n2; ++n3) {
                    object2 = this._intoList.get(n3);
                    stringBuffer.append((String)object2);
                    if (n3 >= n2 - 1) continue;
                    stringBuffer.append(", ");
                }
            }
            if ((string = this._joinModel.getJoinStatement().trim()).length() > 0) {
                stringBuffer.append("\n").append(string);
            }
            if (this._whereClause.length() > 0) {
                stringBuffer.append("\nWHERE ").append(this._whereClause);
            }
            if ((n = this._groupByList.size()) > 0) {
                stringBuffer.append("\nGROUP BY ");
                if (this._groupByAll) {
                    stringBuffer.append("ALL ");
                }
                if (this._groupingSets) {
                    stringBuffer.append("GROUPING SETS (");
                }
                for (int i = 0; i < n; ++i) {
                    object = this._groupByList.get(i);
                    stringBuffer.append(object.getQuotedName());
                    if (i >= n - 1) continue;
                    stringBuffer.append(",\n");
                }
                if (this._groupingSets) {
                    stringBuffer.append(")");
                }
            }
            if (this._havingClause.length() > 0) {
                stringBuffer.append("\nHAVING ").append(this._havingClause);
            }
            if ((n = this._orderList.size()) > 0) {
                stringBuffer.append("\nORDER BY ");
                for (int i = 0; i < n; ++i) {
                    object = this._orderList.get(i);
                    stringBuffer.append(object.getQuotedName()).append(" ");
                    if (object.getDirection()) {
                        stringBuffer.append("ASC ");
                    } else {
                        stringBuffer.append("DESC ");
                    }
                    if (i >= n - 1) continue;
                    stringBuffer.append(",\n");
                }
            }
        }
        if (this._comments.length() > 0) {
            stringBuffer.append("\n").append(this._comments);
        }
        return stringBuffer.toString();
    }

    @Override
    public boolean isAliasInUse(String string) {
        String string2;
        Object object;
        int n;
        if ((string = string.trim()).startsWith("\"") && string.endsWith("\"") || string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.length() == 0) {
            return false;
        }
        boolean bl = false;
        int n2 = this._tableList.size();
        for (n = 0; n < n2; ++n) {
            object = this._tableList.get(n);
            string2 = object.getAlias();
            if (string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("[") && string2.endsWith("]")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!object.getName().equals(string) && !string2.equals(string)) continue;
            bl = true;
            break;
        }
        n2 = this._columnList.size();
        for (n = 0; n < n2; ++n) {
            object = this._columnList.get(n);
            string2 = object.getAlias();
            if (string2.startsWith("\"") && string2.endsWith("\"") || string2.startsWith("[") && string2.endsWith("]")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            if (!object.getName().equals(string) && !string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public String generateTableAlias(String string) {
        int n = 0;
        String string2 = "";
        boolean bl = false;
        while (!bl) {
            string2 = string + String.valueOf(n++);
            if (this.isAliasInUse(string2)) continue;
            bl = true;
        }
        return "\"" + string2 + "\"";
    }

    @Override
    public String generateColumnAlias(String string) {
        int n = 0;
        String string2 = "";
        boolean bl = false;
        while (!bl) {
            string2 = string + String.valueOf(n++);
            if (this.isAliasInUse(string2)) continue;
            bl = true;
        }
        return string2;
    }

    @Override
    public JoinModel getJoinModel() {
        return this._joinModel;
    }

    @Override
    public void setJoinModel(JoinModel joinModel) {
        if (this._joinModel != null) {
            this._joinModel.removeTreeModelListener(this);
        }
        this._joinModel = joinModel;
        this._joinModel.addTreeModelListener(this);
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.fireQueryChanged(this, 22, treeModelEvent);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.fireQueryChanged(this, 19, treeModelEvent);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.fireQueryChanged(this, 20, treeModelEvent);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.fireQueryChanged(this, 22, treeModelEvent);
    }

    @Override
    public TableModel newTableModel(String string) {
        return new DefaultTableModel(string);
    }

    @Override
    public TableModel newTableModel(String string, String string2, String string3) {
        return new DefaultTableModel(string, string2, string3);
    }

    @Override
    public TableModel newTableModel(String string, List<String> list) {
        return new DefaultTableModel(string, list);
    }

    @Override
    public JoinModel newJoinModel(boolean bl, QueryModel queryModel) {
        return new DefaultJoinModel(bl, queryModel);
    }

    @Override
    public ColumnModel newColumnModel(TableModel tableModel, String string, List<String> list, boolean bl) {
        return new DefaultColumnModel(tableModel, string, list, bl);
    }

    @Override
    public ColumnModel newColumnModel(TableModel tableModel, String string, boolean bl) {
        return new DefaultColumnModel(tableModel, string, bl);
    }

    @Override
    public ColumnModel newColumnModel(TableModel tableModel, String string) {
        return new DefaultColumnModel(tableModel, string);
    }

    @Override
    public OrderModel newOrderModel(ColumnModel columnModel, boolean bl) {
        return new DefaultOrderModel(columnModel, bl);
    }

    @Override
    public OrderModel newOrderModel(int n, boolean bl) {
        return new DefaultOrderModel(n, bl);
    }
}

