/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.QueryEditorProperties;
import com.sybase.asa.QueryEditor.TableModel;
import com.sybase.asa.QueryEditor.TableModelEvent;
import com.sybase.asa.QueryEditor.TableModelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class DefaultTableModel
implements TableModel {
    protected boolean _computed = false;
    protected String _tableName;
    protected String _ownerName = null;
    protected String _databaseName = null;
    protected String _tableAlias = "";
    protected List<String> _columnAliases = new ArrayList<String>();
    protected List<Key> _importedKeys = new ArrayList<Key>();
    protected List<Key> _exportedKeys = new ArrayList<Key>();
    protected EventListenerList _listenerList = new EventListenerList();
    protected static int _incremental = 0;

    public DefaultTableModel(String string, boolean bl) {
        this._tableName = string;
        this.setAlias("");
        this._computed = bl;
        if (this._computed) {
            this.setAlias("derived" + _incremental++);
        }
        this._ownerName = "";
        this._databaseName = "";
    }

    public DefaultTableModel(String string) {
        this._tableName = string;
        this.setAlias("");
        if (string.length() > 0) {
            this._computed = true;
        }
        this._ownerName = "";
        this._databaseName = "";
    }

    public DefaultTableModel(String string, String string2) {
        this._ownerName = string2;
        this._tableName = string;
        this.setAlias("");
    }

    public DefaultTableModel(String string, String string2, String string3) {
        this._databaseName = string3;
        this._ownerName = string2;
        this._tableName = string;
        this.setAlias("");
    }

    public DefaultTableModel(String string, List<String> list) {
        if (list.size() == 3) {
            this._databaseName = list.get(0);
            this._ownerName = list.get(1);
            this._tableName = list.get(2);
        } else if (list.size() == 2) {
            this._ownerName = list.get(0);
            this._tableName = list.get(1);
        } else {
            this._tableName = string;
        }
        if (this._ownerName == null) {
            this._ownerName = "";
        }
        this.setAlias("");
    }

    public TableModel copy() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(this._tableName, this._ownerName, this._databaseName);
        defaultTableModel.setAlias(this._tableAlias);
        return defaultTableModel;
    }

    @Override
    public String getName() {
        return this._tableName;
    }

    @Override
    public void setName(String string) {
        this._tableName = string;
        this.fireTableChanged(this, 24);
    }

    @Override
    public String getFullName() {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this._databaseName != null && this._databaseName.length() > 0) {
            stringBuffer.append(this._databaseName).append(".");
        }
        if (this._ownerName != null && this._ownerName.length() > 0) {
            stringBuffer.append(this._ownerName).append(".");
        }
        stringBuffer.append(this._tableName);
        return stringBuffer.toString();
    }

    @Override
    public String getQuotedName() {
        if (this._computed) {
            return this._tableName;
        }
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.getQuoteNames()) {
            if (this.getFullyQualifyNames()) {
                if (this._databaseName != null && this._databaseName.length() > 0) {
                    stringBuffer.append(this._databaseName).append(".");
                }
                if (this._ownerName != null && this._ownerName.length() > 0) {
                    stringBuffer.append("\"").append(this._ownerName).append("\"").append(".");
                }
            }
            stringBuffer.append("\"").append(this._tableName).append("\"");
        } else {
            if (this.getFullyQualifyNames()) {
                if (this._databaseName != null && this._databaseName.length() > 0) {
                    stringBuffer.append(this._databaseName).append(".");
                }
                if (this._ownerName != null && this._ownerName.length() > 0) {
                    stringBuffer.append(this._ownerName).append(".");
                }
            }
            stringBuffer.append(this._tableName);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getTableAsPrefix() {
        if (this._tableAlias != null && this._tableAlias.length() > 0) {
            if (this.getQuoteNames()) {
                if (this._tableAlias.startsWith("\"") && this._tableAlias.endsWith("\"")) {
                    return this._tableAlias;
                }
                return "\"" + this._tableAlias + "\"";
            }
            return this._tableAlias;
        }
        return this.getQuotedName();
    }

    @Override
    public String getOwner() {
        return this._ownerName;
    }

    @Override
    public void setOwner(String string) {
        this._ownerName = string;
        this.fireTableChanged(this, 24);
    }

    @Override
    public String getDatabase() {
        return this._databaseName;
    }

    @Override
    public void setDatabase(String string) {
        this._databaseName = string;
        this.fireTableChanged(this, 24);
    }

    @Override
    public void setComputed(boolean bl) {
        this._computed = bl;
    }

    @Override
    public boolean isComputed() {
        return this._computed;
    }

    @Override
    public void setAlias(String string) {
        this._tableAlias = string;
        if (!(this._tableAlias.indexOf(32) == -1 || this._tableAlias.startsWith("\"") && this._tableAlias.endsWith("\""))) {
            this._tableAlias = "\"" + this._tableAlias + "\"";
        }
        this.fireTableChanged(this, 25);
    }

    @Override
    public String getAlias() {
        return this._tableAlias;
    }

    @Override
    public void setColumnAliases(List<String> list) {
        this._columnAliases = new ArrayList<String>();
        if (list != null) {
            for (String string : list) {
                this._columnAliases.add(string);
            }
        }
    }

    @Override
    public List<String> getColumnAliases() {
        return this._columnAliases;
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this._listenerList.add(TableModelListener.class, tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this._listenerList.remove(TableModelListener.class, tableModelListener);
    }

    @Override
    public void fireTableChanged(Object object, int n) {
        Object[] objectArray = this._listenerList.getListenerList();
        TableModelEvent tableModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TableModelListener.class) continue;
            if (tableModelEvent == null) {
                tableModelEvent = new TableModelEvent(object, n);
            }
            ((TableModelListener)objectArray[i + 1]).tableChanged(tableModelEvent);
        }
    }

    public String toString() {
        if (this._tableAlias.length() == 0) {
            return this.getFullName();
        }
        return this._tableAlias;
    }

    @Override
    public void addImportedKey(String string, String string2, String string3, String string4, String string5) {
        this._importedKeys.add(new Key(string, string2, string4, string3, this._tableName, string5));
    }

    @Override
    public void addExportedKey(String string, String string2, String string3, String string4, String string5) {
        this._exportedKeys.add(new Key(string, string2, string5, string3, this._tableName, string4));
    }

    @Override
    public String getJoinCondition(TableModel tableModel) {
        Key key;
        int n;
        int n2 = this._exportedKeys.size();
        for (n = 0; n < n2; ++n) {
            key = this._exportedKeys.get(n);
            if (!key.getOwner().equalsIgnoreCase(tableModel.getOwner()) || !key.getTableName().equalsIgnoreCase(tableModel.getName())) continue;
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.getQuoteNames()) {
                stringBuffer.append(tableModel.getTableAsPrefix()).append(".\"").append(key.getColumnName()).append("\" = ");
                stringBuffer.append(this.getTableAsPrefix()).append(".\"").append(key.getThisTablesColumnName()).append("\"");
            } else {
                stringBuffer.append(tableModel.getTableAsPrefix()).append(".").append(key.getColumnName()).append(" = ");
                stringBuffer.append(this.getTableAsPrefix()).append(".").append(key.getThisTablesColumnName());
            }
            return stringBuffer.toString();
        }
        n2 = this._importedKeys.size();
        for (n = 0; n < n2; ++n) {
            key = this._importedKeys.get(n);
            if (!key.getOwner().equalsIgnoreCase(tableModel.getOwner()) || !key.getTableName().equalsIgnoreCase(tableModel.getName())) continue;
            StringBuffer stringBuffer = new StringBuffer(100);
            if (this.getQuoteNames()) {
                stringBuffer.append(tableModel.getTableAsPrefix()).append(".\"").append(key.getColumnName()).append("\" = ");
                stringBuffer.append(this.getTableAsPrefix()).append(".\"").append(key.getThisTablesColumnName()).append("\"");
            } else {
                stringBuffer.append(tableModel.getTableAsPrefix()).append(".").append(key.getColumnName()).append(" = ");
                stringBuffer.append(this.getTableAsPrefix()).append(".").append(key.getThisTablesColumnName());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    @Override
    public void destroy() {
        this._tableName = null;
        this._ownerName = null;
        this._databaseName = null;
        this._tableAlias = null;
        this._columnAliases = null;
        this._importedKeys = null;
        this._exportedKeys = null;
        this._listenerList = null;
    }

    protected boolean getQuoteNames() {
        return QueryEditorProperties.getQuoteNames();
    }

    protected boolean getFullyQualifyNames() {
        return QueryEditorProperties.getFullyQualifyNames();
    }

    static class Key {
        private String _owner;
        private String _tableName;
        private String _columnName;
        private String _keyName;
        private boolean _keyMatchesTable = false;
        private boolean _keyMatchesThisTable = false;
        private String _thisColumnName;

        Key(String string, String string2, String string3, String string4, String string5, String string6) {
            this._owner = string;
            this._tableName = string2;
            this._columnName = string3;
            this._keyName = string4;
            if (string4 != null) {
                this._keyMatchesTable = string4.equalsIgnoreCase(this._tableName);
                this._keyMatchesThisTable = string4.equalsIgnoreCase(string5);
            }
            this._thisColumnName = string6;
        }

        String getOwner() {
            return this._owner;
        }

        String getTableName() {
            return this._tableName;
        }

        String getColumnName() {
            return this._columnName;
        }

        String getKeyName() {
            return this._keyName;
        }

        boolean keyMatchesTable() {
            return this._keyMatchesTable;
        }

        boolean keyMatchesThisTable() {
            return this._keyMatchesThisTable;
        }

        String getThisTablesColumnName() {
            return this._thisColumnName;
        }
    }
}

