/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.CubeGroupByModel;
import com.sybase.asa.QueryEditor.DefaultColumnModel;
import com.sybase.asa.QueryEditor.GroupByModel;
import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.QueryEditorTableModel;
import com.sybase.asa.QueryEditor.QueryEditorTreeCellRenderer;
import com.sybase.asa.QueryEditor.RollupGroupByModel;
import com.sybase.asa.QueryEditor.SetGroupByModel;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class GroupDialog
extends JDialog
implements MouseListener,
KeyListener,
ActionListener,
WindowListener {
    private QueryEditor __parentForm = null;
    private Dimension _preferredSize;
    private SybButton _addButton = new SybButton((Icon)QueryEditor.ADD_ICON);
    private SybButton _deleteButton = new SybButton((Icon)QueryEditor.DELETE_ICON);
    private SybButton _moveUpButton = new SybButton((Icon)QueryEditor.MOVE_UP_ICON);
    private SybButton _moveDownButton = new SybButton((Icon)QueryEditor.MOVE_DOWN_ICON);
    private SybButton _computeColumnButton = new SybButton((Icon)QueryEditor.COMPUTED_ICON);
    private SybLabel _selectedColumnsLabel = new SybLabel();
    private JTable _selectedColumns = new JTable(new QueryEditorTableModel(new Vector(), new Vector(2)));
    private String _title = "";
    private SybButton _okButton = new SybButton();
    private SybButton _cancelButton = new SybButton();
    static final int CANCEL = 0;
    static final int OK = 1;
    private int _returnValue = 0;
    private boolean _newGroupElement = false;
    private GroupByModel _groupByModel = null;
    private int _type = 0;
    static final int CUBE = 0;
    static final int ROLLUP = 1;
    static final int SET = 2;
    private QueryEditorTreeCellRenderer _queryEditorTreeCellRenderer;

    GroupDialog(Frame frame, QueryEditor queryEditor) {
        super((Window)frame, Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(frame, queryEditor);
    }

    GroupDialog(Dialog dialog, QueryEditor queryEditor) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(dialog, queryEditor);
    }

    private void init(Window window, QueryEditor queryEditor) {
        this.__parentForm = queryEditor;
        this.setType(this._type);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupDialog.this.__parentForm.showContextHelp();
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(112, 0);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "help");
            actionMap.put("help", abstractAction);
        }
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupDialog.this._returnValue = 0;
                GroupDialog.this.setVisible(false);
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout2);
        container.add(jPanel);
        SybLabel sybLabel = new SybLabel();
        jPanel.add((Component)sybLabel);
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add(jScrollPane);
        jScrollPane.getViewport().add(this.__parentForm._groupDialogColumns);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout3);
        container.add(jPanel2);
        jPanel2.add((Component)this._addButton);
        jPanel2.add((Component)this._deleteButton);
        jPanel2.add((Component)this._moveUpButton);
        jPanel2.add((Component)this._moveDownButton);
        JLabel jLabel = new JLabel(" ");
        jPanel2.add(jLabel);
        jPanel2.add((Component)this._computeColumnButton);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(gridBagLayout4);
        container.add(jPanel3);
        jPanel3.add((Component)this._selectedColumnsLabel);
        JScrollPane jScrollPane2 = new JScrollPane();
        jPanel3.add(jScrollPane2);
        jScrollPane2.getViewport().add(this._selectedColumns);
        jScrollPane2.getViewport().setBackground(this._selectedColumns.getBackground());
        sybLabel.setText(QueryEditor.getI18NMessage("grouppage.available_columns"));
        sybLabel.setLabelFor((Component)this.__parentForm._groupDialogColumns);
        if (Platform.isMacOS()) {
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._queryEditorTreeCellRenderer = new QueryEditorTreeCellRenderer(this.__parentForm);
        this._queryEditorTreeCellRenderer.setClosedIcon(QueryEditor.TABLE_ICON);
        this._queryEditorTreeCellRenderer.setLeafIcon(QueryEditor.COLUMN_ICON);
        this._queryEditorTreeCellRenderer.setOpenIcon(QueryEditor.TABLE_ICON);
        this.__parentForm._groupDialogColumns.addMouseListener(this);
        this.__parentForm._groupDialogColumns.setShowsRootHandles(true);
        this.__parentForm._groupDialogColumns.setCellRenderer(this._queryEditorTreeCellRenderer);
        this._addButton.addActionListener((ActionListener)this);
        this._addButton.setRolloverIcon((Icon)QueryEditor.ADD_ROLLOVER_ICON);
        this._addButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.add_>>_mnemonic").charAt(0));
        this._addButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.add_the_selected_column_to_the_list")));
        this._addButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.add_the_selected_column_to_the_list"));
        this._deleteButton.addActionListener((ActionListener)this);
        this._deleteButton.setRolloverIcon((Icon)QueryEditor.DELETE_ROLLOVER_ICON);
        this._deleteButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.<<_delete_mnemonic").charAt(0));
        this._deleteButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.delete_the_selected_column_from_the_list")));
        this._deleteButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.delete_the_selected_column_from_the_list"));
        this._moveUpButton.addActionListener((ActionListener)this);
        this._moveUpButton.setRolloverIcon((Icon)QueryEditor.MOVE_UP_ROLLOVER_ICON);
        this._moveUpButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.move_up_mnemonic").charAt(0));
        this._moveUpButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_up_one_in_the_list")));
        this._moveUpButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_up_one_in_the_list"));
        this._moveDownButton.addActionListener((ActionListener)this);
        this._moveDownButton.setRolloverIcon((Icon)QueryEditor.MOVE_DOWN_ROLLOVER_ICON);
        this._moveDownButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.move_down_mnemonic").charAt(0));
        this._moveDownButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_down_one")));
        this._moveDownButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_down_one"));
        this._computeColumnButton.addActionListener((ActionListener)this);
        this._computeColumnButton.setRolloverIcon((Icon)QueryEditor.COMPUTED_ROLLOVER_ICON);
        this._computeColumnButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.compute_column_mnemonic").charAt(0));
        this._computeColumnButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.add_a_computed_column")));
        this._computeColumnButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.add_a_computed_column"));
        this._selectedColumnsLabel.setLabelFor((Component)this._selectedColumns);
        if (Platform.isMacOS()) {
            jScrollPane2.setVerticalScrollBarPolicy(22);
            jScrollPane2.setHorizontalScrollBarPolicy(32);
        } else {
            jScrollPane2.setVerticalScrollBarPolicy(20);
            jScrollPane2.setHorizontalScrollBarPolicy(30);
        }
        this._selectedColumns.setShowHorizontalLines(false);
        this._selectedColumns.setShowVerticalLines(false);
        this._selectedColumns.setAutoResizeMode(4);
        this._selectedColumns.setSelectionMode(0);
        this._selectedColumns.addKeyListener(this);
        this._selectedColumns.setModel(new QueryEditorTableModel(0, 1));
        this._selectedColumns.getColumnModel().getColumn(0).setCellRenderer(this.__parentForm._editorPanelCellRendererGroupDialog);
        this._selectedColumns.getColumnModel().getColumn(0).setCellEditor(this.__parentForm._editorPanelCellEditorGroupDialog);
        this._selectedColumns.setRowSelectionAllowed(true);
        this._selectedColumns.setTableHeader(null);
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout5);
        container.add(jPanel4);
        jPanel4.add((Component)this._okButton);
        jPanel4.add((Component)this._cancelButton);
        SybLabel sybLabel2 = new SybLabel(" ");
        jPanel4.add((Component)sybLabel2);
        this._okButton.addActionListener((ActionListener)this);
        this._okButton.setText(QueryEditor.getI18NMessage("groupdialog.ok"));
        this._okButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("groupdialog.ok_description"));
        this._cancelButton.addActionListener((ActionListener)this);
        this._cancelButton.setText(QueryEditor.getI18NMessage("groupdialog.cancel"));
        InputMap inputMap2 = this._cancelButton.getInputMap(2);
        ActionMap actionMap2 = this._cancelButton.getActionMap();
        if (inputMap2 != null && actionMap2 != null) {
            inputMap2.put(keyStroke2, "cancel");
            actionMap2.put("cancel", abstractAction2);
        }
        this._cancelButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("groupdialog.cancel_description"));
        Dimension dimension = new Dimension(jPanel3.getPreferredSize().width, jPanel2.getPreferredSize().height);
        jPanel.setPreferredSize(dimension);
        jPanel3.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = QueryEditor._insets_5_5_5_5;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints((Component)sybLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = QueryEditor._insets_0_5_5_5;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout3.setConstraints((Component)this._addButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout3.setConstraints((Component)this._computeColumnButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 3;
        gridBagLayout3.setConstraints((Component)this._deleteButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 4;
        gridBagLayout3.setConstraints((Component)this._moveUpButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 15;
        gridBagConstraints3.gridy = 5;
        gridBagLayout3.setConstraints((Component)this._moveDownButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = QueryEditor._insets_0_0_0_0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints(jLabel, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagLayout4.setConstraints((Component)this._selectedColumnsLabel, gridBagConstraints4);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagLayout4.setConstraints(jScrollPane2, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = QueryEditor._insets_5_5_5_5;
        gridBagConstraints5.ipadx = 25;
        gridBagLayout5.setConstraints((Component)this._okButton, gridBagConstraints5);
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.gridx = 2;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout5.setConstraints((Component)this._cancelButton, gridBagConstraints5);
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.weightx = 1.0;
        gridBagLayout5.setConstraints((Component)sybLabel2, gridBagConstraints5);
        this._preferredSize = new Dimension(this.__parentForm.getPreferredSize().width, jPanel2.getPreferredSize().height + jPanel4.getPreferredSize().height + 50);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(window);
    }

    void setType(int n) {
        this._type = n;
        switch (this._type) {
            case 0: {
                this._title = QueryEditor.getI18NMessage("groupdialog.cube_title");
                break;
            }
            case 1: {
                this._title = QueryEditor.getI18NMessage("groupdialog.rollup_title");
                break;
            }
            case 2: {
                this._title = QueryEditor.getI18NMessage("groupdialog.set_title");
                break;
            }
            default: {
                this._title = QueryEditor.getI18NMessage("groupdialog.cube_title");
            }
        }
        this.setTitle(this._title);
        switch (this._type) {
            case 0: {
                this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("groupdialog.group_by_cube_columns"));
                break;
            }
            case 1: {
                this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("groupdialog.group_by_rollup_columns"));
                break;
            }
            case 2: {
                this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("groupdialog.group_by_set_columns"));
            }
        }
    }

    int showGroupDialog(int n) {
        this._newGroupElement = true;
        this._groupByModel = null;
        this.setType(n);
        this.clearSelectedTable();
        this.pack();
        this.setVisible(true);
        return this._returnValue;
    }

    int showGroupDialog(GroupByModel groupByModel) {
        this._newGroupElement = false;
        this._groupByModel = groupByModel;
        if (groupByModel instanceof CubeGroupByModel) {
            this.setType(0);
            CubeGroupByModel cubeGroupByModel = (CubeGroupByModel)groupByModel;
            QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
            this.clearSelectedTable();
            List<ColumnModel> list = cubeGroupByModel.getColumns();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[]{list.get(i)};
                queryEditorTableModel.addRow(objectArray);
            }
        } else if (groupByModel instanceof RollupGroupByModel) {
            this.setType(1);
            RollupGroupByModel rollupGroupByModel = (RollupGroupByModel)groupByModel;
            QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
            this.clearSelectedTable();
            List<ColumnModel> list = rollupGroupByModel.getColumns();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[]{list.get(i)};
                queryEditorTableModel.addRow(objectArray);
            }
        } else if (groupByModel instanceof SetGroupByModel) {
            this.setType(2);
            SetGroupByModel setGroupByModel = (SetGroupByModel)groupByModel;
            QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
            this.clearSelectedTable();
            List<ColumnModel> list = setGroupByModel.getColumns();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = new Object[]{list.get(i)};
                queryEditorTableModel.addRow(objectArray);
            }
        }
        this.pack();
        this.setVisible(true);
        return this._returnValue;
    }

    private void clearSelectedTable() {
        QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
        for (int i = queryEditorTableModel.getRowCount() - 1; i > -1; --i) {
            queryEditorTableModel.removeRow(i);
        }
    }

    void destroy() {
        this._addButton.removeActionListener((ActionListener)this);
        this._deleteButton.removeActionListener((ActionListener)this);
        this._moveUpButton.removeActionListener((ActionListener)this);
        this._moveDownButton.removeActionListener((ActionListener)this);
        this._computeColumnButton.removeActionListener((ActionListener)this);
        this._selectedColumns.removeMouseListener(this);
        this._selectedColumns.removeKeyListener(this);
        this.__parentForm._groupDialogColumns.removeMouseListener(this);
        this.__parentForm._groupDialogColumns.setCellRenderer(null);
        this._queryEditorTreeCellRenderer.destroy();
        this._queryEditorTreeCellRenderer = null;
        this.__parentForm = null;
        this._addButton = null;
        this._deleteButton = null;
        this._moveUpButton = null;
        this._moveDownButton = null;
        this._computeColumnButton = null;
        this._selectedColumnsLabel = null;
        this._selectedColumns = null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this.__parentForm._groupDialogColumns) {
            int n = this.__parentForm._groupDialogColumns.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = this.__parentForm._groupDialogColumns.getSelectionPath();
            if (n != -1 && mouseEvent.getClickCount() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (this.__parentForm._groupDialogColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    this.addSelectedColumns();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this._selectedColumns) {
            int n = keyEvent.getKeyCode();
            if (n == 27) {
                this._returnValue = 0;
                this.setVisible(false);
                keyEvent.consume();
            }
            if (n != 113 && n != 10 && n != 32) {
                return;
            }
            int n2 = this._selectedColumns.getSelectedRow();
            int n3 = this._selectedColumns.getSelectedColumn();
            if (n2 != -1 && n3 == 0) {
                ColumnModel columnModel = (ColumnModel)this._selectedColumns.getModel().getValueAt(n2, 0);
                if (columnModel.isComputed()) {
                    this.__parentForm.editComputedColumn(columnModel);
                }
                keyEvent.consume();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._addButton) {
            this.addSelectedColumns();
        } else if (object == this._deleteButton) {
            int n = this._selectedColumns.getSelectedRow();
            this.removeGroupColumn(n);
        } else if (object == this._moveUpButton) {
            int n = this._selectedColumns.getSelectedRow();
            if (n > 0) {
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
                queryEditorTableModel.moveRow(n, n--, n);
                this.selectRow(n);
            }
        } else if (object == this._moveDownButton) {
            int n = this._selectedColumns.getSelectedRow();
            if (n > -1 && n < this._selectedColumns.getRowCount() - 1) {
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
                queryEditorTableModel.moveRow(n, n++, n);
                this.selectRow(n);
            }
        } else if (object == this._computeColumnButton) {
            String string;
            int n = this.__parentForm.getExpressionEditor().showExpressionEditor(this._title);
            if (n == 1 && (string = this.__parentForm.getExpressionEditor().getExpression()) != null && string.length() > 0) {
                DefaultColumnModel defaultColumnModel = new DefaultColumnModel(null, string, true);
                this.addColumn(defaultColumnModel);
            }
        } else if (object == this._okButton) {
            GroupByModel groupByModel = null;
            QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
            int n = queryEditorTableModel.getRowCount();
            if (n == 0 && (this._type == 0 || this._type == 1)) {
                int n2 = -1;
                n2 = this._type == 0 ? SybOptionPane.showConfirmDialog((Component)this, (Object)QueryEditor.getI18NMessage("groupdialog.CUBE_error"), (String)this.getTitle(), (int)0, (int)0) : SybOptionPane.showConfirmDialog((Component)this, (Object)QueryEditor.getI18NMessage("groupdialog.ROLLUP_error"), (String)this.getTitle(), (int)0, (int)0);
                if (n2 == 0) {
                    return;
                }
                this._returnValue = 0;
                this.setVisible(false);
                return;
            }
            ArrayList<ColumnModel> arrayList = new ArrayList<ColumnModel>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add((ColumnModel)queryEditorTableModel.getValueAt(i, 0));
            }
            switch (this._type) {
                case 0: {
                    CubeGroupByModel cubeGroupByModel = this._newGroupElement ? new CubeGroupByModel() : (CubeGroupByModel)this._groupByModel;
                    cubeGroupByModel.setColumns(arrayList);
                    groupByModel = cubeGroupByModel;
                    break;
                }
                case 1: {
                    RollupGroupByModel rollupGroupByModel = this._newGroupElement ? new RollupGroupByModel() : (RollupGroupByModel)this._groupByModel;
                    rollupGroupByModel.setColumns(arrayList);
                    groupByModel = rollupGroupByModel;
                    break;
                }
                case 2: {
                    SetGroupByModel setGroupByModel = this._newGroupElement ? new SetGroupByModel() : (SetGroupByModel)this._groupByModel;
                    setGroupByModel.setColumns(arrayList);
                    groupByModel = setGroupByModel;
                }
            }
            if (this._newGroupElement) {
                this.__parentForm.addGroupByColumn(groupByModel);
            } else {
                this.__parentForm._model.updateGroupBy(groupByModel);
            }
            this._returnValue = 1;
            this.setVisible(false);
        } else if (object == this._cancelButton) {
            this._returnValue = 0;
            this.setVisible(false);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this._returnValue = 0;
            this.setVisible(false);
        }
    }

    void removeGroupColumn(int n) {
        if (n != -1) {
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
            queryEditorTableModel.removeRow(n);
            if (n >= queryEditorTableModel.getRowCount()) {
                n = queryEditorTableModel.getRowCount() - 1;
            }
            if (n > -1) {
                this.selectRow(n);
            }
        }
    }

    private void addSelectedColumns() {
        TreePath[] treePathArray;
        if (this.__parentForm._groupDialogColumns.getSelectionCount() > 0 && (treePathArray = this.__parentForm._groupDialogColumns.getSelectionPaths()) != null) {
            int n = treePathArray.length;
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!this.__parentForm._groupDialogColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    int n2 = defaultMutableTreeNode.getChildCount();
                    for (int j = 0; j < n2; ++j) {
                        this.addColumn((ColumnModel)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j)).getUserObject());
                    }
                    continue;
                }
                if (treePathArray[i].getPathCount() == 2) {
                    this.addColumn((ColumnModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(1)).getUserObject());
                    continue;
                }
                this.addColumn((ColumnModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(2)).getUserObject());
            }
        }
    }

    private void addColumn(ColumnModel columnModel) {
        int n;
        QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
        if (!queryEditorTableModel.contains(columnModel)) {
            Vector<ColumnModel> vector = new Vector<ColumnModel>(1);
            vector.add(columnModel);
            queryEditorTableModel.addRow(vector);
        }
        if ((n = queryEditorTableModel.getRowCount() - 1) > -1) {
            this.selectRow(n);
        }
    }

    void selectRow(int n) {
        try {
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            this._selectedColumns.setRowSelectionInterval(n, n);
            Rectangle rectangle = this._selectedColumns.getCellRect(n, 0, false);
            ++rectangle.y;
            this._selectedColumns.scrollRectToVisible(rectangle);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._preferredSize == null) {
            return this.__parentForm.getPreferredSize();
        }
        return this._preferredSize;
    }
}

