/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.DefaultColumnModel;
import com.sybase.asa.QueryEditor.GroupByModel;
import com.sybase.asa.QueryEditor.GroupDialog;
import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.QueryEditorTableModel;
import com.sybase.asa.QueryEditor.SimpleGroupByModel;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class GroupPage
extends JPanel
implements MouseListener,
KeyListener,
ActionListener {
    private QueryEditor __parentForm = null;
    private SybLabel _availableColumnsLabel = new SybLabel();
    private JScrollPane _availableColumnsScrollPane = new JScrollPane();
    JTree _availableColumns = new JTree();
    private SybButton _addButton = new SybButton((Icon)QueryEditor.ADD_ICON);
    private SybButton _deleteButton = new SybButton((Icon)QueryEditor.DELETE_ICON);
    private SybButton _moveUpButton = new SybButton((Icon)QueryEditor.MOVE_UP_ICON);
    private SybButton _moveDownButton = new SybButton((Icon)QueryEditor.MOVE_DOWN_ICON);
    private SybButton _computeColumnButton = new SybButton((Icon)QueryEditor.COMPUTED_ICON);
    private SybLabel _selectedColumnsLabel = new SybLabel();
    private JScrollPane _selectedColumnsScrollPane = new JScrollPane();
    JTable _selectedColumns = new JTable(new QueryEditorTableModel(new Vector(), new Vector(2)));
    private SybButton _cubeButton = new SybButton((Icon)QueryEditor.CUBE_ICON);
    private SybButton _rollupButton = new SybButton((Icon)QueryEditor.ROLLUP_ICON);
    private SybButton _setButton = new SybButton((Icon)QueryEditor.SET_ICON);
    SybCheckBox _groupingSets = new SybCheckBox();
    SybCheckBox _groupByAll = new SybCheckBox();

    GroupPage() {
    }

    void create(QueryEditor queryEditor) {
        this.__parentForm = queryEditor;
        this._selectedColumnsScrollPane.getViewport().add(this._selectedColumns);
        this._selectedColumnsScrollPane.getViewport().setBackground(this._selectedColumns.getBackground());
        this._availableColumnsLabel.setText(QueryEditor.getI18NMessage("grouppage.available_columns"));
        this._availableColumnsLabel.setLabelFor((Component)this._availableColumns);
        if (Platform.isMacOS()) {
            this._availableColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._availableColumnsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._availableColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._availableColumnsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._availableColumns.addMouseListener(this);
        this._availableColumns.setShowsRootHandles(true);
        this._availableColumns.setCellRenderer(this.__parentForm._queryEditorTreeCellRenderer);
        this._availableColumnsScrollPane.getViewport().add(this._availableColumns);
        this._addButton.addActionListener((ActionListener)this);
        this._addButton.setRolloverIcon((Icon)QueryEditor.ADD_ROLLOVER_ICON);
        this._addButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.add_>>_mnemonic").charAt(0));
        this._addButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.add_the_selected_column_to_the_list")));
        this._addButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.add_the_selected_column_to_the_list"));
        this._deleteButton.addActionListener((ActionListener)this);
        this._deleteButton.setRolloverIcon((Icon)QueryEditor.DELETE_ROLLOVER_ICON);
        this._deleteButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.<<_delete_mnemonic").charAt(0));
        this._deleteButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.delete_the_selected_column_from_the_list")));
        this._deleteButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.delete_the_selected_column_from_the_list"));
        this._moveUpButton.addActionListener((ActionListener)this);
        this._moveUpButton.setRolloverIcon((Icon)QueryEditor.MOVE_UP_ROLLOVER_ICON);
        this._moveUpButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.move_up_mnemonic").charAt(0));
        this._moveUpButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_up_one_in_the_list")));
        this._moveUpButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_up_one_in_the_list"));
        this._moveDownButton.addActionListener((ActionListener)this);
        this._moveDownButton.setRolloverIcon((Icon)QueryEditor.MOVE_DOWN_ROLLOVER_ICON);
        this._moveDownButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.move_down_mnemonic").charAt(0));
        this._moveDownButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_down_one")));
        this._moveDownButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.move_the_selected_column_down_one"));
        this._computeColumnButton.addActionListener((ActionListener)this);
        this._computeColumnButton.setRolloverIcon((Icon)QueryEditor.COMPUTED_ROLLOVER_ICON);
        this._computeColumnButton.setMnemonic(QueryEditor.getI18NMessage("grouppage.compute_column_mnemonic").charAt(0));
        this._computeColumnButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.add_a_computed_column")));
        this._computeColumnButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.add_a_computed_column"));
        this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("grouppage.group_by_columns"));
        this._selectedColumnsLabel.setLabelFor((Component)this._selectedColumns);
        if (Platform.isMacOS()) {
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._selectedColumns.setShowHorizontalLines(false);
        this._selectedColumns.setShowVerticalLines(false);
        this._selectedColumns.setAutoResizeMode(4);
        this._selectedColumns.setSelectionMode(0);
        this._selectedColumns.addKeyListener(this);
        this._rollupButton.addActionListener((ActionListener)this);
        this._rollupButton.setRolloverIcon((Icon)QueryEditor.ROLLUP_ROLLOVER_ICON);
        this._rollupButton.setText(QueryEditor.getI18NMessage("grouppage.rollup"));
        this._rollupButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.rollup_accessible"));
        this._rollupButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.rollup_accessible")));
        this._cubeButton.addActionListener((ActionListener)this);
        this._cubeButton.setRolloverIcon((Icon)QueryEditor.CUBE_ROLLOVER_ICON);
        this._cubeButton.setText(QueryEditor.getI18NMessage("grouppage.cube"));
        this._cubeButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.cube_accessible"));
        this._cubeButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.cube_accessible")));
        this._setButton.addActionListener((ActionListener)this);
        this._setButton.setRolloverIcon((Icon)QueryEditor.SET_ROLLOVER_ICON);
        this._setButton.setText(QueryEditor.getI18NMessage("grouppage.set"));
        this._setButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.add_a_set_of_columns_to_the_GROUP_BY"));
        this._setButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.add_a_set_of_columns_to_the_GROUP_BY")));
        this._groupingSets.setText(QueryEditor.getI18NMessage("grouppage.grouping_sets"));
        this._groupingSets.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("grouppage.grouping_sets_accessible"));
        this._groupingSets.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("grouppage.grouping_sets_accessible")));
        this._groupByAll.setText(QueryEditor.getI18NMessage("grouppage.all"));
        this.layoutPage();
    }

    void layoutPage() {
        if (this.__parentForm == null) {
            return;
        }
        this.removeAll();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout2);
        this.add(jPanel);
        jPanel.add((Component)this._availableColumnsLabel);
        jPanel.add(this._availableColumnsScrollPane);
        JLabel jLabel = new JLabel(" ");
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout3);
        this.add(jPanel2);
        jPanel2.add((Component)this._addButton);
        jPanel2.add((Component)this._deleteButton);
        jPanel2.add((Component)this._moveUpButton);
        jPanel2.add((Component)this._moveDownButton);
        jPanel2.add(jLabel);
        jPanel2.add((Component)this._computeColumnButton);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout4);
        jPanel4.add((Component)this._cubeButton);
        jPanel4.add((Component)this._rollupButton);
        jPanel4.add((Component)this._setButton);
        jPanel4.add(jPanel3);
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(gridBagLayout5);
        this.add(jPanel5);
        jPanel5.add((Component)this._selectedColumnsLabel);
        jPanel5.add(this._selectedColumnsScrollPane);
        if (this.__parentForm.showCubeRollupSet()) {
            jPanel5.add(jPanel4);
            jPanel5.add((Component)this._groupingSets);
        }
        if (this.__parentForm.showGroupByAll()) {
            jPanel5.add((Component)this._groupByAll);
        }
        Dimension dimension = new Dimension(jPanel.getPreferredSize().width, jPanel2.getPreferredSize().height);
        jPanel.setPreferredSize(dimension);
        jPanel5.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints((Component)this._availableColumnsLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout2.setConstraints(this._availableColumnsScrollPane, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = QueryEditor._insets_0_5_5_5;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout3.setConstraints((Component)this._addButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout3.setConstraints((Component)this._computeColumnButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 3;
        gridBagLayout3.setConstraints((Component)this._deleteButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 4;
        gridBagLayout3.setConstraints((Component)this._moveUpButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 15;
        gridBagConstraints3.gridy = 5;
        gridBagLayout3.setConstraints((Component)this._moveDownButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = QueryEditor._insets_0_0_0_0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints(jLabel, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagLayout5.setConstraints((Component)this._selectedColumnsLabel, gridBagConstraints4);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagLayout5.setConstraints(this._selectedColumnsScrollPane, gridBagConstraints4);
        if (this.__parentForm.showCubeRollupSet()) {
            Locale locale = Locale.getDefault();
            if (!locale.getLanguage().equals(new Locale("en", "", "").getLanguage())) {
                Insets insets = this._cubeButton.getMargin();
                insets.left = 2;
                insets.right = 2;
                this._cubeButton.setHorizontalAlignment(10);
                this._cubeButton.setMargin(insets);
                this._cubeButton.setIconTextGap(1);
                this._rollupButton.setIconTextGap(1);
                this._rollupButton.setMargin(insets);
                this._setButton.setIconTextGap(1);
                this._setButton.setMargin(insets);
            }
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagLayout5.setConstraints(jPanel4, gridBagConstraints4);
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagLayout5.setConstraints((Component)this._groupingSets, gridBagConstraints4);
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = QueryEditor._insets_5_0_5_5;
            gridBagConstraints5.weighty = 1.0;
            gridBagLayout4.setConstraints((Component)this._cubeButton, gridBagConstraints5);
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.insets = QueryEditor._insets_5_5_5_5;
            gridBagLayout4.setConstraints((Component)this._rollupButton, gridBagConstraints5);
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.insets = QueryEditor._insets_5_5_5_0;
            gridBagLayout4.setConstraints((Component)this._setButton, gridBagConstraints5);
            gridBagConstraints5.gridx = 3;
            gridBagConstraints5.insets = QueryEditor._insets_0_0_0_0;
            gridBagConstraints5.weightx = 1.0;
            gridBagLayout4.setConstraints(jPanel3, gridBagConstraints5);
        }
        if (this.__parentForm.showGroupByAll()) {
            gridBagConstraints4.gridy = 4;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagLayout5.setConstraints((Component)this._groupByAll, gridBagConstraints4);
        }
    }

    void destroy() {
        this._availableColumns.removeMouseListener(this);
        this._addButton.removeActionListener((ActionListener)this);
        this._deleteButton.removeActionListener((ActionListener)this);
        this._moveUpButton.removeActionListener((ActionListener)this);
        this._moveDownButton.removeActionListener((ActionListener)this);
        this._computeColumnButton.removeActionListener((ActionListener)this);
        this._selectedColumns.removeMouseListener(this);
        this._selectedColumns.removeKeyListener(this);
        this._cubeButton.removeActionListener((ActionListener)this);
        this._rollupButton.removeActionListener((ActionListener)this);
        this._setButton.removeActionListener((ActionListener)this);
        this.__parentForm = null;
        this._availableColumnsLabel = null;
        this._availableColumnsScrollPane = null;
        this._availableColumns = null;
        this._addButton = null;
        this._deleteButton = null;
        this._moveUpButton = null;
        this._moveDownButton = null;
        this._computeColumnButton = null;
        this._selectedColumnsLabel = null;
        this._selectedColumnsScrollPane = null;
        this._selectedColumns = null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._availableColumns) {
            int n = this._availableColumns.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = this._availableColumns.getSelectionPath();
            if (n != -1 && mouseEvent.getClickCount() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (this._availableColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    this.addSelectedColumns();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this._selectedColumns) {
            SimpleGroupByModel simpleGroupByModel;
            ColumnModel columnModel;
            Object object2;
            int n = keyEvent.getKeyCode();
            if (n != 113 && n != 10 && n != 32) {
                return;
            }
            int n2 = this._selectedColumns.getSelectedRow();
            int n3 = this._selectedColumns.getSelectedColumn();
            if (n2 != -1 && n3 == 0 && (object2 = this._selectedColumns.getModel().getValueAt(n2, 0)) instanceof SimpleGroupByModel && (columnModel = (simpleGroupByModel = (SimpleGroupByModel)object2).getColumnModel()).isComputed()) {
                this.__parentForm.editComputedColumn(columnModel);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._addButton) {
            this.addSelectedColumns();
        } else if (object == this._deleteButton) {
            int n = this._selectedColumns.getSelectedRow();
            this.removeGroupColumn(n);
        } else if (object == this._moveUpButton) {
            int n = this._selectedColumns.getSelectedRow();
            if (n > 0) {
                List<GroupByModel> list = this.__parentForm._model.getGroupBy();
                GroupByModel groupByModel = list.get(n);
                list.remove(n);
                list.add(n - 1, groupByModel);
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
                queryEditorTableModel.moveRow(n, n--, n);
                this.selectRow(n);
                this.__parentForm._model.setGroupBy(list);
            }
        } else if (object == this._moveDownButton) {
            int n = this._selectedColumns.getSelectedRow();
            if (n > -1 && n < this._selectedColumns.getRowCount() - 1) {
                List<GroupByModel> list = this.__parentForm._model.getGroupBy();
                GroupByModel groupByModel = list.get(n);
                list.remove(n);
                list.add(n + 1, groupByModel);
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
                queryEditorTableModel.moveRow(n, n++, n);
                this.selectRow(n);
                this.__parentForm._model.setGroupBy(list);
            }
        } else if (object == this._computeColumnButton) {
            String string;
            int n = this.__parentForm.getExpressionEditor().showExpressionEditor(QueryEditor.getI18NMessage("queryeditor.group_by"));
            if (n == 1 && (string = this.__parentForm.getExpressionEditor().getExpression()) != null && string.length() > 0) {
                DefaultColumnModel defaultColumnModel = new DefaultColumnModel(null, string, true);
                this.__parentForm.addGroupByColumn(new SimpleGroupByModel(defaultColumnModel));
            }
        } else if (object == this._cubeButton) {
            GroupDialog groupDialog = this.__parentForm.getGroupDialog();
            groupDialog.showGroupDialog(0);
        } else if (object == this._rollupButton) {
            GroupDialog groupDialog = this.__parentForm.getGroupDialog();
            groupDialog.showGroupDialog(1);
        } else if (object == this._setButton) {
            GroupDialog groupDialog = this.__parentForm.getGroupDialog();
            groupDialog.showGroupDialog(2);
        }
    }

    void removeGroupColumn(int n) {
        if (n != -1) {
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            QueryEditorTableModel queryEditorTableModel = (QueryEditorTableModel)this._selectedColumns.getModel();
            GroupByModel groupByModel = (GroupByModel)queryEditorTableModel.getValueAt(n, 0);
            queryEditorTableModel.removeRow(n);
            if (n >= queryEditorTableModel.getRowCount()) {
                n = queryEditorTableModel.getRowCount() - 1;
            }
            if (n > -1) {
                this.selectRow(n);
            }
            this.__parentForm._model.removeGroupBy(groupByModel);
        }
    }

    private void addSelectedColumns() {
        TreePath[] treePathArray;
        if (this._availableColumns.getSelectionCount() > 0 && (treePathArray = this._availableColumns.getSelectionPaths()) != null) {
            int n = treePathArray.length;
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!this._availableColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    int n2 = defaultMutableTreeNode.getChildCount();
                    for (int j = 0; j < n2; ++j) {
                        this.__parentForm.addGroupByColumn(new SimpleGroupByModel((ColumnModel)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j)).getUserObject()));
                    }
                    continue;
                }
                if (treePathArray[i].getPathCount() == 2) {
                    this.__parentForm.addGroupByColumn(new SimpleGroupByModel((ColumnModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(1)).getUserObject()));
                    continue;
                }
                this.__parentForm.addGroupByColumn(new SimpleGroupByModel((ColumnModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(2)).getUserObject()));
            }
        }
    }

    void selectRow(int n) {
        try {
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            this._selectedColumns.setRowSelectionInterval(n, n);
            Rectangle rectangle = this._selectedColumns.getCellRect(n, 0, false);
            ++rectangle.y;
            this._selectedColumns.scrollRectToVisible(rectangle);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

