/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.IntoTableModel;
import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.TableModel;
import com.sybase.util.FontHelper;
import com.sybase.util.Platform;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class IntoPage
extends JPanel {
    private QueryEditor __parentForm = null;
    SybCheckBox _includeIntoVariables = new SybCheckBox();
    SybLabel _selectedColumnsLabel = new SybLabel();
    JTable _selectedColumns = new JTable(new IntoTableModel());
    JScrollPane _selectedColumnsScrollPane = new JScrollPane();
    JTextField _intoText = new JTextField();
    TableCellTipRenderer _tipRenderer = new TableCellTipRenderer();

    IntoPage() {
    }

    void create(QueryEditor queryEditor) {
        this.__parentForm = queryEditor;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this._includeIntoVariables.setText(QueryEditor.getI18NMessage("intopage.include_into_variables"));
        this._includeIntoVariables.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("intopage.include_into_variables"));
        this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("intopage.selected_columns"));
        this._selectedColumnsLabel.setLabelFor((Component)this._selectedColumns);
        if (Platform.isMacOS()) {
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._selectedColumns.setShowHorizontalLines(true);
        this._selectedColumns.setShowVerticalLines(true);
        this._selectedColumns.setAutoResizeMode(0);
        this._selectedColumns.setSelectionMode(0);
        this._selectedColumns.getTableHeader().setReorderingAllowed(false);
        this.add((Component)this._includeIntoVariables);
        this.add(this._selectedColumnsScrollPane);
        this.add((Component)this._selectedColumnsLabel);
        this._selectedColumnsScrollPane.getViewport().add(this._selectedColumns);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = QueryEditor._insets_5_5_0_5;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints((Component)this._includeIntoVariables, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout.setConstraints((Component)this._selectedColumnsLabel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = QueryEditor._insets_0_5_5_5;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 100;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._selectedColumnsScrollPane, gridBagConstraints);
        this._selectedColumnsLabel.setEnabled(false);
        this._selectedColumns.setEnabled(false);
        this._selectedColumnsScrollPane.setEnabled(false);
    }

    void setUpColumns() {
        TableColumnModel tableColumnModel = this._selectedColumns.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(this._intoText));
    }

    void removeColumn(ColumnModel columnModel) {
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        for (int i = intoTableModel.getRowCount() - 1; i > -1; --i) {
            if (columnModel != intoTableModel.getValueAt(i, 0)) continue;
            intoTableModel.removeRow(i);
        }
    }

    void removeColumns(TableModel tableModel) {
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        for (int i = intoTableModel.getRowCount() - 1; i > -1; --i) {
            if (tableModel != ((ColumnModel)intoTableModel.getValueAt(i, 0)).getTableModel()) continue;
            intoTableModel.removeRow(i);
        }
    }

    void moveColumnUp(ColumnModel columnModel) {
        int n;
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n2 = this.columnIndex(intoTableModel, n = intoTableModel.getRowCount(), columnModel);
        if (n2 > 0) {
            intoTableModel.moveRow(n2, n2--, n2);
        }
    }

    void moveColumnUp(ColumnModel columnModel, TableModel tableModel) {
        int n;
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n2 = this.columnIndex(intoTableModel, n = intoTableModel.getRowCount(), columnModel);
        if (n2 > 0) {
            intoTableModel.moveRow(n2, n2, this.tableStart(intoTableModel, n, tableModel));
        }
    }

    void moveColumnsUp(TableModel tableModel) {
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n = intoTableModel.getRowCount();
        int n2 = this.tableStart(intoTableModel, n, tableModel);
        intoTableModel.moveRow(n2--, this.tableEnd(intoTableModel, n, tableModel), n2);
    }

    void moveColumnsUp(TableModel tableModel, TableModel tableModel2) {
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n = intoTableModel.getRowCount();
        intoTableModel.moveRow(this.tableStart(intoTableModel, n, tableModel), this.tableEnd(intoTableModel, n, tableModel), this.tableStart(intoTableModel, n, tableModel2));
    }

    void moveColumnDown(ColumnModel columnModel) {
        int n;
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n2 = this.columnIndex(intoTableModel, n = intoTableModel.getRowCount(), columnModel);
        if (n2 > 0) {
            intoTableModel.moveRow(n2, n2++, n2);
        }
    }

    void moveColumnDown(ColumnModel columnModel, TableModel tableModel) {
        int n;
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n2 = this.columnIndex(intoTableModel, n = intoTableModel.getRowCount(), columnModel);
        if (n2 > 0) {
            intoTableModel.moveRow(n2, n2, this.tableEnd(intoTableModel, n, tableModel));
        }
    }

    void moveColumnsDown(TableModel tableModel) {
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n = intoTableModel.getRowCount();
        int n2 = this.tableEnd(intoTableModel, n, tableModel) + 1;
        intoTableModel.moveRow(n2, n2, this.tableStart(intoTableModel, n, tableModel));
    }

    void moveColumnsDown(TableModel tableModel, TableModel tableModel2) {
        IntoTableModel intoTableModel = (IntoTableModel)this._selectedColumns.getModel();
        int n = intoTableModel.getRowCount();
        intoTableModel.moveRow(this.tableStart(intoTableModel, n, tableModel2), this.tableEnd(intoTableModel, n, tableModel2), this.tableStart(intoTableModel, n, tableModel));
    }

    private int columnIndex(IntoTableModel intoTableModel, int n, ColumnModel columnModel) {
        int n2 = -1;
        for (int i = n - 1; i > -1; --i) {
            if (columnModel != intoTableModel.getValueAt(i, 0)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private int tableStart(IntoTableModel intoTableModel, int n, TableModel tableModel) {
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (tableModel != ((ColumnModel)intoTableModel.getValueAt(i, 0)).getTableModel()) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    private int tableEnd(IntoTableModel intoTableModel, int n, TableModel tableModel) {
        int n2 = -1;
        for (int i = n - 1; i > -1; --i) {
            if (tableModel != ((ColumnModel)intoTableModel.getValueAt(i, 0)).getTableModel()) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    void updateIntoList() {
        if (this._includeIntoVariables.isSelected()) {
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = this._selectedColumns.getModel().getRowCount();
            for (int i = 0; i < n; ++i) {
                arrayList.add(this._selectedColumns.getValueAt(i, 1).toString());
            }
            this.__parentForm._model.setIntoList(arrayList);
        }
    }

    void updateIntoDisplay() {
        List list = this.__parentForm._model.getIntoList();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this._selectedColumns.setValueAt(list.get(i), i, 1);
        }
        if (list.size() > 0) {
            this._includeIntoVariables.setSelected(true);
        } else {
            this._includeIntoVariables.setSelected(false);
        }
    }

    void destroy() {
        this.__parentForm = null;
        this._includeIntoVariables = null;
        this._selectedColumnsLabel = null;
        this._selectedColumns = null;
        this._selectedColumnsScrollPane = null;
        this._intoText = null;
    }

    static class TableCellTipRenderer
    extends DefaultTableCellRenderer {
        private Font _defaultFont = null;

        TableCellTipRenderer() {
            this.setBorder(QueryEditor.NO_FOCUS_BORDER);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string;
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                this.setToolTipText(object.toString());
            }
            if ((string = this.getText()) != null && string.length() > 0) {
                if (this._defaultFont == null) {
                    this._defaultFont = this.getFont();
                }
                if (this._defaultFont.canDisplayUpTo(string) == -1) {
                    this.setFont(this._defaultFont);
                } else {
                    FontHelper.setFontForString((Component)this, (Font)this._defaultFont, (String)string);
                }
            }
            return this;
        }
    }
}

