/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.JoinModel;
import com.sybase.asa.QueryEditor.TableModel;
import java.util.ArrayList;
import java.util.List;

public class JoinNode {
    static final int TABLE = 0;
    static final int NESTED_JOIN = 1;
    JoinModel _joinModel;
    Object _leftTable;
    int _leftTableType;
    Object _rightTable;
    int _rightTableType;
    String _joinType;
    String _condition;
    List<JoinNode> _children = new ArrayList<JoinNode>(1);
    JoinNode _parent = null;
    boolean _root = false;

    JoinNode(JoinModel joinModel, Object object, int n, Object object2, int n2, String string, String string2) {
        this(joinModel, object, n, object2, n2, string, string2, false);
    }

    JoinNode(JoinModel joinModel, Object object, int n, Object object2, int n2, String string, String string2, boolean bl) {
        this._joinModel = joinModel;
        this._leftTable = object;
        this._leftTableType = n;
        this._rightTable = object2;
        this._rightTableType = n2;
        this.setJoinType(string);
        this._condition = string2;
        this._root = bl;
    }

    public String toString() {
        if (this.isRoot()) {
            return this._leftTable.toString();
        }
        return "";
    }

    public String toJoin(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        JoinNode.toJoin(this._leftTable, stringBuffer, bl);
        JoinNode.toJoin(this._rightTable, stringBuffer2, bl);
        String string = this._joinType.equals("CROSS JOIN") || this._joinType.equals(",") ? "" : (this._condition != null && this._condition.length() > 0 ? " ON " + this._condition : "");
        return stringBuffer.toString() + " " + this._joinType + " " + stringBuffer2.toString() + string;
    }

    private static void toJoin(Object object, StringBuffer stringBuffer, boolean bl) {
        if (object instanceof TableModel) {
            List<String> list;
            String string = ((TableModel)object).getName();
            String string2 = ((TableModel)object).getAlias();
            if (string != null && string.length() > 0) {
                if (string2 != null && string2.length() > 0) {
                    stringBuffer.append(((TableModel)object).getQuotedName()).append(" AS ").append(string2);
                } else {
                    stringBuffer.append(((TableModel)object).getQuotedName());
                }
            }
            if (((TableModel)object).isComputed() && (list = ((TableModel)object).getColumnAliases()).size() > 0) {
                if (bl) {
                    stringBuffer.append("( ");
                }
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append((Object)list.get(i));
                }
                if (bl) {
                    stringBuffer.append(" )");
                }
            }
        } else if (object instanceof JoinModel) {
            stringBuffer.append(((JoinModel)object).getJoinStatement());
        }
    }

    public JoinNode getParent() {
        return this._parent;
    }

    protected Object[] getChildren() {
        return this._children.toArray();
    }

    public JoinNode[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected JoinNode[] getPathToRoot(JoinNode joinNode, int n) {
        JoinNode[] joinNodeArray;
        if (joinNode == null) {
            if (n == 0) {
                return null;
            }
            joinNodeArray = new JoinNode[n];
        } else {
            joinNodeArray = this.getPathToRoot(joinNode.getParent(), ++n);
            joinNodeArray[joinNodeArray.length - n] = joinNode;
        }
        return joinNodeArray;
    }

    protected void nodeChanged() {
        JoinNode joinNode = this.getParent();
        if (joinNode != null) {
            Object[] objectArray = joinNode.getPath();
            int[] nArray = new int[]{this._joinModel.getIndexOfChild(joinNode, this)};
            Object[] objectArray2 = new Object[]{this};
            this._joinModel.fireTreeNodesChanged(this._joinModel, objectArray, nArray, objectArray2);
        }
    }

    void insert(JoinNode joinNode, int n) {
        this._children.add(n, joinNode);
        joinNode.setParent(this);
        this.nodeChanged();
    }

    void setParent(JoinNode joinNode) {
        this._parent = joinNode;
    }

    int getChildCount() {
        return this._children.size();
    }

    int getIndex(JoinNode joinNode) {
        return this._children.indexOf(joinNode);
    }

    void remove(int n) {
        this._children.remove(n);
    }

    boolean isRoot() {
        return this._root;
    }

    void setLeftTable(Object object) {
        this._leftTable = object;
        this.nodeChanged();
    }

    Object getLeftTable() {
        return this._leftTable;
    }

    void setRightTable(Object object) {
        this._rightTable = object;
        this.nodeChanged();
    }

    Object getRightTable() {
        return this._rightTable;
    }

    void setJoinType(String string) {
        this._joinType = string;
        this.nodeChanged();
    }

    String getJoinType() {
        return this._joinType;
    }

    void setLeftTableType(int n) {
        this._leftTableType = n;
    }

    int getLeftTableType() {
        return this._leftTableType;
    }

    void setRightTableType(int n) {
        this._rightTableType = n;
    }

    int getRightTableType() {
        return this._rightTableType;
    }

    void setCondition(String string) {
        this._condition = string;
    }

    String getCondition() {
        return this._condition;
    }
}

