/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.ColumnModel;
import com.sybase.asa.QueryEditor.DefaultColumnModel;
import com.sybase.asa.QueryEditor.OrderModel;
import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.QueryEditorImageLoader;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class OrderPage
extends JPanel
implements MouseListener,
KeyListener,
ActionListener {
    private QueryEditor __parentForm = null;
    private JPanel _availableColumnsPanel = new JPanel();
    private SybLabel _availableColumnsLabel = new SybLabel();
    private JScrollPane _availableColumnsScrollPane = new JScrollPane();
    JTree _availableColumns = new JTree();
    private JPanel _columnButtonPanel = new JPanel();
    private SybButton _addButton = new SybButton((Icon)QueryEditor.ADD_ICON);
    private SybButton _deleteButton = new SybButton((Icon)QueryEditor.DELETE_ICON);
    private SybButton _moveUpButton = new SybButton((Icon)QueryEditor.MOVE_UP_ICON);
    private SybButton _moveDownButton = new SybButton((Icon)QueryEditor.MOVE_DOWN_ICON);
    private SybButton _computeColumnButton = new SybButton((Icon)QueryEditor.COMPUTED_ICON);
    private JLabel _columnDummyLabel = new JLabel(" ");
    private JPanel _selectedColumnsPanel = new JPanel();
    private SybLabel _selectedColumnsLabel = new SybLabel();
    private JScrollPane _selectedColumnsScrollPane = new JScrollPane();
    JTable _selectedColumns = new JTable(new OrderTableModel(0, 2));
    static final ImageIcon ASCENDING_ICON = QueryEditorImageLoader.getImageIcon("up", 1001);
    static final ImageIcon DESCENDING_ICON = QueryEditorImageLoader.getImageIcon("down", 1001);
    DirectionButtonTableCellRenderer _directionButtonCellRenderer = new DirectionButtonTableCellRenderer();

    OrderPage() {
    }

    void create(QueryEditor queryEditor) {
        this.__parentForm = queryEditor;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this._availableColumnsPanel.setLayout(gridBagLayout2);
        this.add(this._availableColumnsPanel);
        this._availableColumnsPanel.add((Component)this._availableColumnsLabel);
        this._availableColumnsPanel.add(this._availableColumnsScrollPane);
        this._availableColumnsScrollPane.getViewport().add(this._availableColumns);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        this._columnButtonPanel.setLayout(gridBagLayout3);
        this.add(this._columnButtonPanel);
        this._columnButtonPanel.add((Component)this._addButton);
        this._columnButtonPanel.add((Component)this._deleteButton);
        this._columnButtonPanel.add((Component)this._moveUpButton);
        this._columnButtonPanel.add((Component)this._moveDownButton);
        this._columnButtonPanel.add(this._columnDummyLabel);
        this._columnButtonPanel.add((Component)this._computeColumnButton);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        this._selectedColumnsPanel.setLayout(gridBagLayout4);
        this.add(this._selectedColumnsPanel);
        this._selectedColumnsPanel.add((Component)this._selectedColumnsLabel);
        this._selectedColumnsPanel.add(this._selectedColumnsScrollPane);
        this._selectedColumnsScrollPane.getViewport().add(this._selectedColumns);
        this._selectedColumnsScrollPane.getViewport().setBackground(this._selectedColumns.getBackground());
        this._availableColumnsLabel.setText(QueryEditor.getI18NMessage("orderpage.available_columns"));
        this._availableColumnsLabel.setLabelFor((Component)this._availableColumns);
        this._availableColumns.addMouseListener(this);
        this._availableColumns.setShowsRootHandles(true);
        this._availableColumns.setCellRenderer(this.__parentForm._queryEditorTreeCellRenderer);
        this._addButton.addActionListener((ActionListener)this);
        this._addButton.setRolloverIcon((Icon)QueryEditor.ADD_ROLLOVER_ICON);
        this._addButton.setMnemonic(QueryEditor.getI18NMessage("orderpage.add_>>_mnemonic").charAt(0));
        this._addButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("orderpage.add_the_selected_column_to_the_list")));
        this._addButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("orderpage.add_the_selected_column_to_the_list"));
        this._deleteButton.addActionListener((ActionListener)this);
        this._deleteButton.setRolloverIcon((Icon)QueryEditor.DELETE_ROLLOVER_ICON);
        this._deleteButton.setMnemonic(QueryEditor.getI18NMessage("orderpage.<<_delete_mnemonic").charAt(0));
        this._deleteButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("orderpage.delete_the_selected_column_from_the_list")));
        this._deleteButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("orderpage.delete_the_selected_column_from_the_list"));
        this._moveUpButton.addActionListener((ActionListener)this);
        this._moveUpButton.setRolloverIcon((Icon)QueryEditor.MOVE_UP_ROLLOVER_ICON);
        this._moveUpButton.setMnemonic(QueryEditor.getI18NMessage("orderpage.move_up_mnemonic").charAt(0));
        this._moveUpButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("orderpage.move_the_selected_column_up_one_in_the_list")));
        this._moveUpButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("orderpage.move_the_selected_column_up_one_in_the_list"));
        this._moveDownButton.addActionListener((ActionListener)this);
        this._moveDownButton.setRolloverIcon((Icon)QueryEditor.MOVE_DOWN_ROLLOVER_ICON);
        this._moveDownButton.setMnemonic(QueryEditor.getI18NMessage("orderpage.move_down_mnemonic").charAt(0));
        this._moveDownButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("orderpage.move_the_selected_column_down_one")));
        this._moveDownButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("orderpage.move_the_selected_column_down_one"));
        this._computeColumnButton.addActionListener((ActionListener)this);
        this._computeColumnButton.setRolloverIcon((Icon)QueryEditor.COMPUTED_ROLLOVER_ICON);
        this._computeColumnButton.setMnemonic(QueryEditor.getI18NMessage("orderpage.compute_column_mnemonic").charAt(0));
        this._computeColumnButton.setToolTipText(QueryEditor.toHTML(QueryEditor.getI18NMessage("orderpage.add_a_computed_column")));
        this._computeColumnButton.getAccessibleContext().setAccessibleDescription(QueryEditor.getI18NMessage("orderpage.add_a_computed_column"));
        this._selectedColumnsLabel.setText(QueryEditor.getI18NMessage("orderpage.order_by_columns"));
        this._selectedColumnsLabel.setLabelFor((Component)this._selectedColumns);
        if (Platform.isMacOS()) {
            this._availableColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._availableColumnsScrollPane.setHorizontalScrollBarPolicy(32);
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(22);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._availableColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._availableColumnsScrollPane.setHorizontalScrollBarPolicy(30);
            this._selectedColumnsScrollPane.setVerticalScrollBarPolicy(20);
            this._selectedColumnsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._selectedColumns.addMouseListener(this);
        this._selectedColumns.addKeyListener(this);
        this._selectedColumns.setCellSelectionEnabled(true);
        this._selectedColumns.setSelectionMode(0);
        this._selectedColumns.setShowHorizontalLines(false);
        this._selectedColumns.setShowVerticalLines(false);
        Dimension dimension = new Dimension(this._availableColumnsPanel.getPreferredSize().width, this._columnButtonPanel.getPreferredSize().height);
        this._availableColumnsPanel.setPreferredSize(dimension);
        this._selectedColumnsPanel.setPreferredSize(dimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout.setConstraints(this._columnButtonPanel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this._availableColumnsPanel, gridBagConstraints);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this._selectedColumnsPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagLayout2.setConstraints((Component)this._availableColumnsLabel, gridBagConstraints2);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout2.setConstraints(this._availableColumnsScrollPane, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.insets = QueryEditor._insets_0_5_5_5;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout3.setConstraints((Component)this._addButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.insets = QueryEditor._insets_5_5_5_5;
        gridBagLayout3.setConstraints((Component)this._computeColumnButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 3;
        gridBagLayout3.setConstraints((Component)this._deleteButton, gridBagConstraints3);
        gridBagConstraints3.gridy = 4;
        gridBagLayout3.setConstraints((Component)this._moveUpButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 15;
        gridBagConstraints3.gridy = 5;
        gridBagLayout3.setConstraints((Component)this._moveDownButton, gridBagConstraints3);
        gridBagConstraints3.anchor = 10;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = QueryEditor._insets_0_0_0_0;
        gridBagConstraints3.weighty = 1.0;
        gridBagLayout3.setConstraints(this._columnDummyLabel, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagLayout4.setConstraints((Component)this._selectedColumnsLabel, gridBagConstraints4);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.weighty = 1.0;
        gridBagLayout4.setConstraints(this._selectedColumnsScrollPane, gridBagConstraints4);
    }

    void destroy() {
        this._availableColumns.removeMouseListener(this);
        this._addButton.removeActionListener((ActionListener)this);
        this._deleteButton.removeActionListener((ActionListener)this);
        this._moveUpButton.removeActionListener((ActionListener)this);
        this._moveDownButton.removeActionListener((ActionListener)this);
        this._computeColumnButton.removeActionListener((ActionListener)this);
        this._selectedColumns.removeMouseListener(this);
        this._selectedColumns.removeKeyListener(this);
        DialogUtils.removeComponents((Container)this);
        this.__parentForm = null;
        this._availableColumnsPanel = null;
        this._availableColumnsLabel = null;
        this._availableColumnsScrollPane = null;
        this._availableColumns = null;
        this._columnButtonPanel = null;
        this._addButton = null;
        this._deleteButton = null;
        this._moveUpButton = null;
        this._moveDownButton = null;
        this._computeColumnButton = null;
        this._columnDummyLabel = null;
        this._selectedColumnsPanel = null;
        this._selectedColumnsLabel = null;
        this._selectedColumnsScrollPane = null;
        this._selectedColumns = null;
        this.transferFocus();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._availableColumns) {
            int n = this._availableColumns.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = this._availableColumns.getSelectionPath();
            if (n != -1 && mouseEvent.getClickCount() == 2) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                if (this._availableColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    this.addSelectedColumns();
                }
            }
        } else if (object == this._selectedColumns) {
            int n = this._selectedColumns.rowAtPoint(mouseEvent.getPoint());
            int n2 = this._selectedColumns.columnAtPoint(mouseEvent.getPoint());
            if (n != -1 && n2 == 0) {
                this.__parentForm._model.invertOrderDirection((OrderModel)this._selectedColumns.getModel().getValueAt(n, 1));
                this.updateUI();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (object == this._selectedColumns) {
            int n = keyEvent.getKeyCode();
            if (n != 113 && n != 10 && n != 32) {
                return;
            }
            int n2 = this._selectedColumns.getSelectedRow();
            int n3 = this._selectedColumns.getSelectedColumn();
            if (n2 != -1) {
                OrderModel orderModel;
                ColumnModel columnModel;
                if (n3 == 0) {
                    this.__parentForm._model.invertOrderDirection((OrderModel)this._selectedColumns.getModel().getValueAt(n2, 1));
                    this.updateUI();
                } else if (n3 == 1 && (columnModel = (orderModel = (OrderModel)this._selectedColumns.getModel().getValueAt(n2, 1)).getColumnModel()).isComputed()) {
                    this.__parentForm.editComputedColumn(columnModel);
                }
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        int n;
        Object object = actionEvent.getSource();
        if (object == this._addButton) {
            this.addSelectedColumns();
        } else if (object == this._deleteButton) {
            int n2 = this._selectedColumns.getSelectedRow();
            this.removeOrderColumn(n2);
        } else if (object == this._moveUpButton) {
            int n3 = this._selectedColumns.getSelectedRow();
            if (n3 > 0) {
                List<OrderModel> list = this.__parentForm._model.getOrderColumns();
                OrderModel orderModel = list.get(n3);
                list.remove(n3);
                list.add(n3 - 1, orderModel);
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                OrderTableModel orderTableModel = (OrderTableModel)this._selectedColumns.getModel();
                orderTableModel.moveRow(n3, n3--, n3);
                this.selectRow(n3);
                this.__parentForm._model.setOrderColumns(list);
            }
        } else if (object == this._moveDownButton) {
            int n4 = this._selectedColumns.getSelectedRow();
            if (n4 > -1 && n4 < this._selectedColumns.getRowCount() - 1) {
                List<OrderModel> list = this.__parentForm._model.getOrderColumns();
                OrderModel orderModel = list.get(n4);
                list.remove(n4);
                list.add(n4 + 1, orderModel);
                if (this._selectedColumns.isEditing()) {
                    this._selectedColumns.getCellEditor().stopCellEditing();
                }
                OrderTableModel orderTableModel = (OrderTableModel)this._selectedColumns.getModel();
                orderTableModel.moveRow(n4, n4++, n4);
                this.selectRow(n4);
                this.__parentForm._model.setOrderColumns(list);
            }
        } else if (object == this._computeColumnButton && (n = this.__parentForm.getExpressionEditor().showExpressionEditor(QueryEditor.getI18NMessage("queryeditor.order_by"))) == 1 && (string = this.__parentForm.getExpressionEditor().getExpression()) != null && string.length() > 0) {
            DefaultColumnModel defaultColumnModel = new DefaultColumnModel(null, string, true);
            this.__parentForm.addColumn(this, defaultColumnModel);
        }
    }

    void removeOrderColumn(int n) {
        if (n != -1) {
            OrderTableModel orderTableModel = (OrderTableModel)this._selectedColumns.getModel();
            OrderModel orderModel = (OrderModel)orderTableModel.getValueAt(n, 0);
            orderTableModel.removeRow(n);
            if (orderTableModel.getRowCount() == n) {
                --n;
            }
            if (n > -1) {
                this._selectedColumns.setRowSelectionInterval(n, n);
            }
            this.__parentForm._model.removeOrderColumn(orderModel);
        }
    }

    private void addSelectedColumns() {
        TreePath[] treePathArray;
        if (this._availableColumns.getSelectionCount() > 0 && (treePathArray = this._availableColumns.getSelectionPaths()) != null) {
            int n = treePathArray.length;
            for (int i = 0; i < n; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePathArray[i].getLastPathComponent();
                if (!this._availableColumns.getModel().isLeaf(defaultMutableTreeNode)) {
                    int n2 = defaultMutableTreeNode.getChildCount();
                    for (int j = 0; j < n2; ++j) {
                        this.__parentForm.addColumn(this, (ColumnModel)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(j)).getUserObject());
                    }
                    continue;
                }
                if (treePathArray[i].getPathCount() == 2) {
                    this.__parentForm.addColumn(this, (ColumnModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(1)).getUserObject());
                    continue;
                }
                this.__parentForm.addColumn(this, (ColumnModel)((DefaultMutableTreeNode)treePathArray[i].getPathComponent(2)).getUserObject());
            }
        }
    }

    void selectRow(int n) {
        try {
            if (this._selectedColumns.isEditing()) {
                this._selectedColumns.getCellEditor().stopCellEditing();
            }
            this._selectedColumns.setRowSelectionInterval(n, n);
            this._selectedColumns.changeSelection(n, 1, false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class DirectionButtonTableCellRenderer
    extends SybButton
    implements TableCellRenderer {
        Border noFocusBorder = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), this.getBorder());
        Border focusBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("Table.focusCellHighlightBorder"), this.getBorder());

        DirectionButtonTableCellRenderer() {
            this.setBorder(this.noFocusBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setIcon(((OrderModel)object).getDirection() ? QueryEditor.MOVE_UP_ICON : QueryEditor.MOVE_DOWN_ICON);
            this.setToolTipText(((OrderModel)object).getDirection() ? QueryEditor.getI18NMessage("orderpage.orderAscending") : QueryEditor.getI18NMessage("orderpage.orderDescending"));
            this.setText("");
            this.setForeground(SystemColor.controlText);
            this.setBackground(SystemColor.control);
            if (bl2) {
                this.setBorder(this.focusBorder);
            } else {
                this.setBorder(this.noFocusBorder);
            }
            return this;
        }

        public void validate() {
        }

        public void revalidate() {
        }

        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        public void repaint(Rectangle rectangle) {
        }

        protected void firePropertyChange(String string, Object object, Object object2) {
            if (string.equals("text")) {
                super.firePropertyChange(string, object, object2);
            }
        }

        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }
    }

    static class OrderTableModel
    extends DefaultTableModel {
        OrderTableModel(int n, int n2) {
            super(n, n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            ColumnModel columnModel = ((OrderModel)this.getValueAt(n, 0)).getColumnModel();
            return columnModel.isComputed();
        }

        public boolean contains(ColumnModel columnModel) {
            int n = this.dataVector.size();
            for (int i = 0; i < n; ++i) {
                Vector vector = (Vector)this.dataVector.get(i);
                if (((OrderModel)vector.get(0)).getColumnModel() != columnModel) continue;
                return true;
            }
            return false;
        }
    }
}

