/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.util.Platform;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class QueryEditorProperties {
    private static String _propertyFileName = Platform.getUserConfigurationDirectory() + ".QueryEditor" + Integer.toString(11);
    private static boolean _dirty = false;
    private static boolean _loaded = false;
    private static boolean _fullyQualifyNames = true;
    private static boolean _quoteNames = true;
    private static boolean _getListOfTablesOnStartup = true;
    private static int _frameX = -1;
    private static int _frameY = -1;
    private static int _frameWidth = -1;
    private static int _frameHeight = -1;
    private static int _dividerLocation = -1;
    private static final String FULLY_QUALIFY_NAMES = "QueryEditor.fullyQualifyNames";
    private static final String QUOTE_NAMES = "QueryEditor.quoteNames";
    private static final String GET_LIST_OF_TABLE_NAMES_ON_STARTUP = "QueryEditor.getListOfTableNamesOnStartup";
    private static final String FRAME_X = "QueryEditor.Frame.x";
    private static final String FRAME_Y = "QueryEditor.Frame.y";
    private static final String FRAME_WIDTH = "QueryEditor.Frame.width";
    private static final String FRAME_HEIGHT = "QueryEditor.Frame.height";
    private static final String DIVIDER_LOCATION = "QueryEditor.dividerLocation";

    QueryEditorProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        BufferedInputStream bufferedInputStream = null;
        if (_loaded) {
            return;
        }
        _loaded = true;
        Properties properties = new Properties(System.getProperties());
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(_propertyFileName));
            properties.load(bufferedInputStream);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
                bufferedInputStream = null;
            }
        }
        System.setProperties(properties);
        QueryEditorProperties.reset();
    }

    static void store() {
        if (_dirty) {
            _dirty = false;
            try {
                System.setProperty(FULLY_QUALIFY_NAMES, String.valueOf(_fullyQualifyNames));
                System.setProperty(QUOTE_NAMES, String.valueOf(_quoteNames));
                System.setProperty(GET_LIST_OF_TABLE_NAMES_ON_STARTUP, String.valueOf(_getListOfTablesOnStartup));
                System.setProperty(FRAME_X, String.valueOf(_frameX));
                System.setProperty(FRAME_Y, String.valueOf(_frameY));
                System.setProperty(FRAME_WIDTH, String.valueOf(_frameWidth));
                System.setProperty(FRAME_HEIGHT, String.valueOf(_frameHeight));
                System.setProperty(DIVIDER_LOCATION, String.valueOf(_dividerLocation));
                Properties properties = new Properties(System.getProperties());
                properties.setProperty(FULLY_QUALIFY_NAMES, System.getProperty(FULLY_QUALIFY_NAMES));
                properties.setProperty(QUOTE_NAMES, System.getProperty(QUOTE_NAMES));
                properties.setProperty(GET_LIST_OF_TABLE_NAMES_ON_STARTUP, System.getProperty(GET_LIST_OF_TABLE_NAMES_ON_STARTUP));
                properties.setProperty(FRAME_X, System.getProperty(FRAME_X));
                properties.setProperty(FRAME_Y, System.getProperty(FRAME_Y));
                properties.setProperty(FRAME_WIDTH, System.getProperty(FRAME_WIDTH));
                properties.setProperty(FRAME_HEIGHT, System.getProperty(FRAME_HEIGHT));
                properties.setProperty(DIVIDER_LOCATION, System.getProperty(DIVIDER_LOCATION));
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFileName);
                properties.store(fileOutputStream, "Query Editor user prefrerences");
                fileOutputStream.close();
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
    }

    static void reset() {
        _fullyQualifyNames = Boolean.valueOf(System.getProperty(FULLY_QUALIFY_NAMES, "true"));
        _quoteNames = Boolean.valueOf(System.getProperty(QUOTE_NAMES, "true"));
        _getListOfTablesOnStartup = Boolean.valueOf(System.getProperty(GET_LIST_OF_TABLE_NAMES_ON_STARTUP, "true"));
        _frameX = Integer.getInteger(FRAME_X, -1);
        _frameY = Integer.getInteger(FRAME_Y, -1);
        _frameWidth = Integer.getInteger(FRAME_WIDTH, -1);
        _frameHeight = Integer.getInteger(FRAME_HEIGHT, -1);
        _dividerLocation = Integer.getInteger(DIVIDER_LOCATION, -1);
        _dirty = false;
    }

    static boolean getFullyQualifyNames() {
        QueryEditorProperties.load();
        return _fullyQualifyNames;
    }

    static void setFullyQualifyNames(boolean bl) {
        _fullyQualifyNames = bl;
        _dirty = true;
    }

    static boolean getQuoteNames() {
        QueryEditorProperties.load();
        return _quoteNames;
    }

    static void setQuoteNames(boolean bl) {
        _quoteNames = bl;
        _dirty = true;
    }

    static boolean getListOfTablesOnStartup() {
        QueryEditorProperties.load();
        return _getListOfTablesOnStartup;
    }

    static void setListOfTablesOnStartup(boolean bl) {
        _getListOfTablesOnStartup = bl;
        _dirty = true;
    }

    static void setFormatValuesToDefault() {
        _fullyQualifyNames = true;
        _quoteNames = true;
        _getListOfTablesOnStartup = true;
        _dirty = true;
    }

    static int getFrameX() {
        return _frameX;
    }

    static void setFrameX(int n) {
        _frameX = n;
        _dirty = true;
    }

    static int getFrameY() {
        QueryEditorProperties.load();
        return _frameY;
    }

    static void setFrameY(int n) {
        _frameY = n;
        _dirty = true;
    }

    static int getFrameWidth() {
        QueryEditorProperties.load();
        return _frameWidth;
    }

    static void setFrameWidth(int n) {
        _frameWidth = n;
        _dirty = true;
    }

    static int getFrameHeight() {
        QueryEditorProperties.load();
        return _frameHeight;
    }

    static void setFrameHeight(int n) {
        _frameHeight = n;
        _dirty = true;
    }

    static int getDividerLocation() {
        QueryEditorProperties.load();
        return _dividerLocation;
    }

    static void setDividerLocation(int n) {
        _dividerLocation = n;
        _dirty = true;
    }
}

