/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.QueryEditor;

import com.sybase.asa.QueryEditor.QueryEditor;
import com.sybase.asa.QueryEditor.QueryEditorImageLoader;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.SQLWarning;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

class WarningDialog
extends JDialog
implements ActionListener,
WindowListener {
    private SybButton _okButton;
    private SybButton _helpButton;
    private SQLWarning _warning;
    private QueryEditor _queryEditor;

    static WarningDialog create(Window window, QueryEditor queryEditor, SQLWarning sQLWarning) {
        if (window instanceof Dialog) {
            return new WarningDialog((Dialog)window, queryEditor, sQLWarning);
        }
        return new WarningDialog((Frame)window, queryEditor, sQLWarning);
    }

    private WarningDialog(Frame frame, QueryEditor queryEditor, SQLWarning sQLWarning) {
        super((Window)frame, Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(frame, queryEditor, sQLWarning);
    }

    private WarningDialog(Dialog dialog, QueryEditor queryEditor, SQLWarning sQLWarning) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this.init(dialog, queryEditor, sQLWarning);
    }

    private void init(Window window, QueryEditor queryEditor, SQLWarning sQLWarning) {
        this._queryEditor = queryEditor;
        this._warning = sQLWarning;
        this.setTitle(QueryEditor.getI18NMessage("warningdialog.title"));
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        SybLabel sybLabel = new SybLabel((Icon)QueryEditorImageLoader.getImageIcon("warn", 1003));
        container.add((Component)sybLabel);
        Object[] objectArray = new Object[]{sQLWarning.getErrorCode(), sQLWarning.getSQLState()};
        String string = SybMessageFormat.format((String)QueryEditor.getI18NMessage("warningdialog.sqlcode"), (Object[])objectArray);
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(sQLWarning.getLocalizedMessage()).append("\n").append(string);
        SybTextArea sybTextArea = new SybTextArea(stringBuffer.toString());
        sybTextArea.setColumns(40);
        sybTextArea.setFont((Font)UIManager.get("Label.font"));
        sybTextArea.setEditable(false);
        sybTextArea.setEnabled(false);
        sybTextArea.setDisabledTextColor((Color)UIManager.get("Label.foreground"));
        sybTextArea.setBackground((Color)UIManager.get("Label.background"));
        sybTextArea.setWrapStyleWord(true);
        sybTextArea.setLineWrap(true);
        container.add((Component)sybTextArea);
        this._okButton = new SybButton(QueryEditor.getI18NMessage("warningdialog.ok"));
        this._okButton.addActionListener((ActionListener)this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.add((Component)this._okButton);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout2.setConstraints((Component)this._okButton, gridBagConstraints);
        if (queryEditor.isShowingHelp()) {
            this._helpButton = new SybButton(QueryEditor.getI18NMessage("warningdialog.warning_help"));
            this._helpButton.addActionListener((ActionListener)this);
            jPanel.add((Component)this._helpButton);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagLayout2.setConstraints((Component)this._helpButton, gridBagConstraints);
        }
        container.add(jPanel);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints2);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)sybTextArea, gridBagConstraints2);
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints2);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WarningDialog.this.setVisible(false);
            }
        };
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        InputMap inputMap = this._okButton.getInputMap(2);
        ActionMap actionMap = this._okButton.getActionMap();
        if (inputMap != null && actionMap != null) {
            inputMap.put(keyStroke, "cancel");
            actionMap.put("cancel", abstractAction);
        }
        this.pack();
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(window);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._okButton) {
            this.destroy();
        } else if (object == this._helpButton) {
            this._queryEditor.showHelp(String.valueOf(this._warning.getErrorCode()), this);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.destroy();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void destroy() {
        this._queryEditor = null;
        this._okButton.removeActionListener((ActionListener)this);
        this._okButton = null;
        this._helpButton.removeActionListener((ActionListener)this);
        this._helpButton = null;
        this.setVisible(false);
    }
}

