/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.common;

import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ArrayListTableModel
extends AbstractTableModel {
    protected ArrayList<ArrayList<Object>> dataArrayList;
    protected ArrayList<Object> columnIdentifiers;

    public ArrayListTableModel() {
        this(0, 0);
    }

    private static ArrayList<Object> newArrayList(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        ArrayListTableModel.setSize(arrayList, n);
        return arrayList;
    }

    private static ArrayList<ArrayList<Object>> newDataArrayList(int n) {
        ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>(n);
        ArrayListTableModel.setSize(arrayList, n);
        return arrayList;
    }

    public ArrayListTableModel(int n, int n2) {
        this(ArrayListTableModel.newArrayList(n2), n);
    }

    public ArrayListTableModel(ArrayList<Object> arrayList, int n) {
        this.setDataArrayList(ArrayListTableModel.newDataArrayList(n), arrayList);
    }

    public ArrayListTableModel(Object[] objectArray, int n) {
        this(ArrayListTableModel.convertToArrayList(objectArray), n);
    }

    public ArrayListTableModel(ArrayList<ArrayList<Object>> arrayList, ArrayList<Object> arrayList2) {
        this.setDataArrayList(arrayList, arrayList2);
    }

    public ArrayListTableModel(Object[][] objectArray, Object[] objectArray2) {
        this.setDataArrayList(objectArray, objectArray2);
    }

    public ArrayList getDataArrayList() {
        return this.dataArrayList;
    }

    private static <T> ArrayList<T> nonNullArrayList(ArrayList<T> arrayList) {
        return arrayList != null ? arrayList : new ArrayList();
    }

    public void setDataArrayList(ArrayList<ArrayList<Object>> arrayList, ArrayList<Object> arrayList2) {
        this.dataArrayList = ArrayListTableModel.nonNullArrayList(arrayList);
        this.columnIdentifiers = ArrayListTableModel.nonNullArrayList(arrayList2);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setDataArrayList(Object[][] objectArray, Object[] objectArray2) {
        this.setDataArrayList(ArrayListTableModel.convertToArrayList(objectArray), ArrayListTableModel.convertToArrayList(objectArray2));
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    private void justifyRows(int n, int n2) {
        ArrayListTableModel.setSize(this.dataArrayList, this.getRowCount());
        for (int i = n; i < n2; ++i) {
            if (this.dataArrayList.get(i) == null) {
                this.dataArrayList.set(i, new ArrayList());
            }
            ArrayListTableModel.setSize(this.dataArrayList.get(i), this.getColumnCount());
        }
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        this.justifyRows(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow() + 1);
        this.fireTableChanged(tableModelEvent);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void setNumRows(int n) {
        int n2 = this.getRowCount();
        if (n2 == n) {
            return;
        }
        ArrayListTableModel.setSize(this.dataArrayList, n);
        if (n <= n2) {
            this.fireTableRowsDeleted(n, n2 - 1);
        } else {
            this.justifyRows(n2, n);
            this.fireTableRowsInserted(n2, n - 1);
        }
    }

    public void setRowCount(int n) {
        this.setNumRows(n);
    }

    public void addRow(ArrayList<Object> arrayList) {
        this.insertRow(this.getRowCount(), arrayList);
    }

    public void addRow(Object[] objectArray) {
        this.addRow(ArrayListTableModel.convertToArrayList(objectArray));
    }

    public void insertRow(int n, ArrayList<Object> arrayList) {
        this.dataArrayList.add(n, arrayList);
        this.justifyRows(n, n + 1);
        this.fireTableRowsInserted(n, n);
    }

    public void insertRow(int n, Object[] objectArray) {
        this.insertRow(n, ArrayListTableModel.convertToArrayList(objectArray));
    }

    private static int gcd(int n, int n2) {
        return n2 == 0 ? n : ArrayListTableModel.gcd(n2, n % n2);
    }

    private static void rotate(ArrayList<ArrayList<Object>> arrayList, int n, int n2, int n3) {
        int n4 = n2 - n;
        int n5 = n4 - n3;
        int n6 = ArrayListTableModel.gcd(n4, n5);
        for (int i = 0; i < n6; ++i) {
            int n7 = i;
            ArrayList<Object> arrayList2 = arrayList.get(n + n7);
            int n8 = (n7 + n5) % n4;
            while (n8 != i) {
                arrayList.set(n + n7, arrayList.get(n + n8));
                n7 = n8;
                n8 = (n7 + n5) % n4;
            }
            arrayList.set(n + n7, arrayList2);
        }
    }

    public void moveRow(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n3 - n;
        if (n6 < 0) {
            n5 = n3;
            n4 = n2;
        } else {
            n5 = n;
            n4 = n3 + n2 - n;
        }
        ArrayListTableModel.rotate(this.dataArrayList, n5, n4 + 1, n6);
        this.fireTableRowsUpdated(n5, n4);
    }

    public void removeRow(int n) {
        this.dataArrayList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void setColumnIdentifiers(ArrayList<Object> arrayList) {
        this.setDataArrayList(this.dataArrayList, arrayList);
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(ArrayListTableModel.convertToArrayList(objectArray));
    }

    public void setColumnCount(int n) {
        ArrayListTableModel.setSize(this.columnIdentifiers, n);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object) {
        this.addColumn(object, (ArrayList)null);
    }

    public void addColumn(Object object, ArrayList arrayList) {
        this.columnIdentifiers.add(object);
        if (arrayList != null) {
            int n = arrayList.size();
            if (n > this.getRowCount()) {
                ArrayListTableModel.setSize(this.dataArrayList, n);
            }
            this.justifyRows(0, this.getRowCount());
            int n2 = this.getColumnCount() - 1;
            for (int i = 0; i < n; ++i) {
                ArrayList<Object> arrayList2 = this.dataArrayList.get(i);
                arrayList2.set(n2, arrayList.get(i));
            }
        } else {
            this.justifyRows(0, this.getRowCount());
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object, Object[] objectArray) {
        this.addColumn(object, ArrayListTableModel.convertToArrayList(objectArray));
    }

    @Override
    public int getRowCount() {
        return this.dataArrayList.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int n) {
        Object object = null;
        if (n < this.columnIdentifiers.size()) {
            object = this.columnIdentifiers.get(n);
        }
        return object == null ? super.getColumnName(n) : object.toString();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ArrayList<Object> arrayList = this.dataArrayList.get(n);
        return arrayList.get(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ArrayList<Object> arrayList = this.dataArrayList.get(n);
        arrayList.set(n2, object);
        this.fireTableCellUpdated(n, n2);
    }

    protected static <T> ArrayList<T> convertToArrayList(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (T t : TArray) {
            arrayList.add(t);
        }
        return arrayList;
    }

    protected static ArrayList<ArrayList<Object>> convertToArrayList(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>(objectArray.length);
        for (Object[] objectArray2 : objectArray) {
            arrayList.add(ArrayListTableModel.convertToArrayList(objectArray2));
        }
        return arrayList;
    }

    private static <T> void setSize(ArrayList<T> arrayList, int n) {
        int n2 = arrayList.size();
        if (n < n2) {
            for (int i = n; i < n2; ++i) {
                arrayList.add(null);
            }
        }
    }
}

