/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.common;

import com.sybase.asa.common.CommonResourceBundle;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybPasswordField;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ChangePasswordDialog
extends JDialog
implements ActionListener {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(CommonResourceBundle.class.getName());
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    public static final int DBTYPE_ASA = 0;
    public static final int DBTYPE_IQ = 1;
    private String _title;
    private int _dbType;
    private SybButton _ok;
    private SybButton _cancel;
    private SybPasswordField _oldPasswordField;
    private SybPasswordField _newPasswordField;
    private SybPasswordField _confirmField;
    private char[] _oldPassword = null;
    private String _newPassword = null;

    public boolean open() {
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setVisible(true);
        this.destroyGUI();
        return this._newPassword != null;
    }

    public String getChangePasswordStatement(String string) {
        String string2 = null;
        if (this._dbType == 0) {
            string2 = this.getGrantStatement(string);
        } else if (this._dbType == 1) {
            string2 = this.getIQPasswordStatement();
        }
        return string2;
    }

    private String getGrantStatement(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("grant connect to [");
        stringBuilder.append(string);
        stringBuilder.append("] identified by ");
        this.quoteString(stringBuilder, this._newPassword);
        return stringBuilder.toString();
    }

    private String getIQPasswordStatement() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("call sp_iqpassword( ");
        this.quoteString(stringBuilder, new String(this._oldPassword));
        stringBuilder.append(",");
        this.quoteString(stringBuilder, this._newPassword);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getNewPassword() {
        return this._newPassword;
    }

    public char[] getOldPassword() {
        return this._oldPassword;
    }

    private void quoteString(StringBuilder stringBuilder, String string) {
        stringBuilder.append("'");
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            stringBuilder.append(c);
            if (c != '\'') continue;
            stringBuilder.append(c);
        }
        stringBuilder.append("'");
    }

    @Deprecated
    public ChangePasswordDialog(JFrame jFrame, String string, int n, String string2) {
        this(jFrame, string, n, string2, null);
    }

    public ChangePasswordDialog(JFrame jFrame, String string, int n, String string2, String string3) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported database type " + n);
        }
        this._title = string;
        this._dbType = n;
        this.createGUI(jFrame, string2, string3);
    }

    @Deprecated
    public ChangePasswordDialog(JDialog jDialog, String string, int n, String string2) {
        this(jDialog, string, n, string2, null);
    }

    public ChangePasswordDialog(JDialog jDialog, String string, int n, String string2, String string3) {
        super((Window)jDialog, Dialog.ModalityType.DOCUMENT_MODAL);
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Unsupported database type " + n);
        }
        this._title = string;
        this._dbType = n;
        this.createGUI(jDialog, string2, string3);
    }

    private void createGUI(Window window, String string, String string2) {
        SybLabel sybLabel;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 5;
        if (string != null) {
            SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(string);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)sybMultiLineLabel, gridBagConstraints);
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            ++gridBagConstraints.gridy;
        }
        if (string2 != null && !string2.isEmpty()) {
            sybLabel = new SybLabel(BUNDLE.getString("USERID_LABEL"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets.left = 0;
            jPanel.add((Component)sybLabel, gridBagConstraints);
            sybLabel = new SybLabel(string2);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.left = 5;
            jPanel.add((Component)sybLabel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this._oldPasswordField = new SybPasswordField(20);
        sybLabel = new SybLabel(BUNDLE.getString("OLD_PWD_LABEL"));
        sybLabel.setLabelFor((Component)this._oldPasswordField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)sybLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this._oldPasswordField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this._newPasswordField = new SybPasswordField(20);
        sybLabel = new SybLabel(BUNDLE.getString("NEW_PWD_LABEL"));
        sybLabel.setLabelFor((Component)this._newPasswordField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)sybLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this._newPasswordField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this._confirmField = new SybPasswordField(20);
        sybLabel = new SybLabel(BUNDLE.getString("CONFIRM_PWD_LABEL"));
        sybLabel.setLabelFor((Component)this._confirmField);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)sybLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this._confirmField, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this._ok = new SybButton(BUNDLE.getString("BTTN_OK"));
        this._ok.addActionListener((ActionListener)this);
        this._cancel = new SybButton(BUNDLE.getString("BTTN_CANCEL"));
        this._cancel.addActionListener((ActionListener)this);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._cancel);
        jPanel2.add(Box.createHorizontalGlue());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._ok.requestFocusInWindow();
        this.getContentPane().add(jPanel);
        this.setTitle(this._title);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(window);
    }

    private void destroyGUI() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().setDefaultButton(null);
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        DialogUtils.removeComponents((Container)this);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            char[] cArray;
            this._oldPassword = this._oldPasswordField.getPassword();
            char[] cArray2 = this._newPasswordField.getPassword();
            if (Arrays.equals(cArray2, cArray = this._confirmField.getPassword())) {
                this._newPassword = new String(cArray2);
                this.setVisible(false);
            } else {
                SybOptionPane.showMessageDialog((Component)this, (Object)BUNDLE.getString("PASSWORDS_DONT_MATCH"), (String)this.getTitle(), (int)0);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ChangePasswordDialog.this._newPasswordField.requestFocusInWindow();
                    }
                });
            }
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this._newPassword = null;
            this.setVisible(false);
        }
    }
}

