/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.common;

import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseVersion {
    private int _majorVersion = 0;
    private int _minorVersion = 0;
    private int _patchVersion = 0;
    private int _buildVersion = 0;
    private boolean _isBeta = false;

    private DatabaseVersion() {
    }

    public static DatabaseVersion getDatabaseVersion(String string) throws NumberFormatException {
        DatabaseVersion databaseVersion = new DatabaseVersion();
        String string2 = "([0-9]+)[.]([0-9]+)[.]([0-9]+)(?:[.]|\\s*[(])([0-9]+)(.*$)";
        Pattern pattern = Pattern.compile(string2, 32);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            databaseVersion._majorVersion = Integer.parseInt(matcher.group(1));
            databaseVersion._minorVersion = Integer.parseInt(matcher.group(2));
            databaseVersion._patchVersion = Integer.parseInt(matcher.group(3));
            databaseVersion._buildVersion = Integer.parseInt(matcher.group(4));
            databaseVersion._isBeta = matcher.group(5).toLowerCase().indexOf("beta") > -1;
        } else {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " .()");
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    switch (n) {
                        case 0: {
                            databaseVersion._majorVersion = Integer.parseInt(stringTokenizer.nextToken());
                            break;
                        }
                        case 1: {
                            databaseVersion._minorVersion = Integer.parseInt(stringTokenizer.nextToken());
                            break;
                        }
                        case 2: {
                            databaseVersion._patchVersion = Integer.parseInt(stringTokenizer.nextToken());
                            break;
                        }
                        case 3: {
                            databaseVersion._buildVersion = Integer.parseInt(stringTokenizer.nextToken());
                            break;
                        }
                        default: {
                            stringTokenizer.nextToken();
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            databaseVersion._isBeta = string.toLowerCase().indexOf("beta") > -1;
        }
        return databaseVersion;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public int getPatchVersion() {
        return this._patchVersion;
    }

    public int getBuildVersion() {
        return this._buildVersion;
    }

    public boolean isBeta() {
        return this._isBeta;
    }
}

