/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.connectionViewer;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.common.FastCellRenderer;
import com.sybase.asa.common.event.DatabaseErrorEvent;
import com.sybase.asa.common.event.DatabaseErrorListener;
import com.sybase.asa.connectionViewer.DBConnectionViewerCustomizationPage;
import com.sybase.asa.connectionViewer.DBConnectionViewerProperties;
import com.sybase.asa.connectionViewer.ReflectiveAction;
import com.sybase.asa.connectionViewer.ViewerTableModel;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.DBConnectionAgent;
import com.sybase.util.Platform;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DBConnectionViewer
extends JPanel
implements MouseListener,
MouseMotionListener,
TableColumnModelListener,
PropertyChangeListener,
Customizable {
    static final String PER_SECOND = DBConnectionViewer.getI18NMessage("dbconnectionviewer.propPerSecond");
    static final String TOTAL = DBConnectionViewer.getI18NMessage("dbconnectionviewer.propTotal");
    DBConnectionAgent _connectionAgent = null;
    int _refreshRate;
    private ConnectionsTable _connections;
    JScrollPane _connectionsScrollPane;
    ArrayList<Object> _connectionsTableColumnNames;
    ArrayList<Boolean> _connectionsTableColumnIsNumeric;
    ArrayList<Boolean> _connectionsTableColumnIsCumulative;
    HashMap<String, HashMap<String, Number>> _cumulativeCache = new HashMap();
    long _lastCachedTime;
    ArrayList<String> _connectionIDs = new ArrayList();
    HashMap<String, String> _propertyDescriptions = new HashMap();
    boolean _supportsNumericAndCumulative = false;
    HashMap<String, Boolean> _propertyIsNumeric = new HashMap();
    HashMap<String, Boolean> _propertyIsCumulative = new HashMap();
    private JPopupMenu _popupMenu;
    int _selRow;
    Hashtable<Object, Object> _columnWidths = new Hashtable();
    FontMetrics _fontMetrics;
    int _arrowWidth;
    int _connectionPropertyHashCode = -1;
    ArrayList<String> _propertyList;
    String _propertiesSelect = null;
    CustomizeDialog _customizeDialog = null;
    CustomizerHost _customizerHost = null;
    Timer _timer;
    boolean _headerBeingMoved = false;
    SwingWorker _refreshWorker = null;
    boolean _workerBusy = false;
    private boolean _hasDbaAuthority = false;
    Action _disconnectSelectedConnectionAction;
    private Action _customizeAction;
    private EventListenerList _listenerList = new EventListenerList();
    static final Cursor WAIT_CURSOR = new Cursor(3);
    static final Cursor DEFAULT_CURSOR = new Cursor(0);
    static String _helpFolder;
    static String _helpPrefix;
    static String _helpSuffix;
    static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    static final String CUSTOMIZER_DISPLAY = "customizer.display";
    static final String CUSTOMIZER_PROPERTY_NAME = "customizer.propertyName";
    static final String CUSTOMIZER_PROPERTY_DESCRIPTION = "customizer.propertyDescription";
    static final String CUSTOMIZER_SELECT = "customizer.select";
    static final String CUSTOMIZER_REFRESH_RATE = "customizer.refreshRate";
    static final String CUSTOMIZER_REFRESH_RATE_TIP = "customizer.refreshRateTip";
    static final String CUSTOMIZER_SECONDS = "customizer.seconds";
    static final String CUSTOMIZER_PROPERTY_ERROR = "customizer.property.error";
    static final String CUSTOMIZER_PROPERTY_ERROR_TITLE = "customizer.property.error.title";
    static final String DISCONNECT_SELECTED_CONNECTION_MENUITEM = "dbconnectionviewer.disconnectSelectedConnectionMenuItem";
    static final String CUSTOMIZE_MENUITEM = "dbconnectionviewer.customizeMenuItem";
    static final String CUSTOMIZE_MENUITEM_MAC = "dbconnectionviewer.customizeMenuItem_Mac";
    static final String CONNECTION_VIEWER = "dbconnectionviewer.connectionViewer";
    static final String DATABASE_NAME = "dbconnectionviewer.databaseName";
    static final String PROP_PERSECOND = "dbconnectionviewer.propPerSecond";
    static final String PROP_TOTAL = "dbconnectionviewer.propTotal";

    public DBConnectionViewer(DBConnectionAgent dBConnectionAgent) {
        this(dBConnectionAgent, DBConnectionViewerProperties.getRefreshRate());
    }

    public DBConnectionViewer(DBConnectionAgent dBConnectionAgent, int n) {
        Object object;
        DBConnectionViewerProperties.load();
        if (dBConnectionAgent != null) {
            object = new ConnectionWorker(dBConnectionAgent);
            object.start();
        }
        this._timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBConnectionViewer.this.refresh();
            }
        });
        this._timer.setInitialDelay(0);
        this._disconnectSelectedConnectionAction = new ReflectiveAction(this, "disconnectSelectedConnectionActionPerformed", DBConnectionViewer.getI18NMessage(DISCONNECT_SELECTED_CONNECTION_MENUITEM));
        this._customizeAction = new ReflectiveAction(this, "customizeActionPerformed", Platform.isMacOS() ? DBConnectionViewer.getI18NMessage(CUSTOMIZE_MENUITEM_MAC) : DBConnectionViewer.getI18NMessage(CUSTOMIZE_MENUITEM));
        this._customizeAction.setEnabled(false);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.add((JMenuItem)new SybMenuItem(this._disconnectSelectedConnectionAction));
        this._popupMenu.add((JMenuItem)new SybMenuItem(this._customizeAction));
        this._connectionsScrollPane = new JScrollPane();
        if (Platform.isMacOS()) {
            this._connectionsScrollPane.setVerticalScrollBarPolicy(22);
            this._connectionsScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._connectionsScrollPane.setVerticalScrollBarPolicy(20);
            this._connectionsScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._connectionsScrollPane.setOpaque(true);
        this._connectionsScrollPane.addMouseListener(this);
        this._connections = new ConnectionsTable();
        this._connections.setAutoCreateRowSorter(true);
        this._connections.setModel(new ViewerTableModel(new ArrayList<ArrayList<Object>>(), this._connectionsTableColumnNames));
        this._connections.setOpaque(true);
        this._connections.setShowHorizontalLines(false);
        this._connections.setShowVerticalLines(false);
        this._connections.setAutoResizeMode(0);
        this._connections.setSelectionMode(0);
        this._connections.addMouseListener(this);
        this._connections.getTableHeader().addMouseListener(this);
        this._connections.getTableHeader().addMouseMotionListener(this);
        this._connections.getColumnModel().addColumnModelListener(this);
        this._connections.setDoubleBuffered(false);
        this._connections.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this._connectionsScrollPane.getViewport().setBackground(this._connections.getBackground());
        this._fontMetrics = this._connections.getFontMetrics(this._connections.getFont());
        this._arrowWidth = this._fontMetrics.getAscent() - 2;
        object = new GridBagLayout();
        this.setLayout((LayoutManager)object);
        this.add(this._connectionsScrollPane);
        this._connectionsScrollPane.getViewport().add(this._connections);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        ((GridBagLayout)object).setConstraints(this._connectionsScrollPane, gridBagConstraints);
        this._lastCachedTime = System.currentTimeMillis();
        this.setRefreshRate(n);
    }

    public void setConnectionAgent(DBConnectionAgent dBConnectionAgent) {
        this._connectionAgent = dBConnectionAgent;
        if (this._connectionAgent != null) {
            this._propertyList = DBConnectionViewerProperties.getConnectionPropertyList();
            this.collectPropertyDescriptions();
            this.checkPropertyList();
            this._hasDbaAuthority = this.hasDbaAuthority();
            this._customizeAction.setEnabled(true);
        } else {
            this.stopRefreshing();
            this.clearDisplay();
            this._hasDbaAuthority = false;
            this._customizeAction.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDbaAuthority() {
        Connection connection = this._connectionAgent.getConnection();
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT ucase( sys.sysuserperms.dbaauth )\nFROM sys.sysuserperms\nWHERE sys.sysuserperms.user_id = user_id()");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            bl = resultSet.getString(1).equals("Y");
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this._connectionAgent.freeConnection(connection);
            this.fireDatabaseError(this, sQLException);
        }
        finally {
            this._connectionAgent.freeConnection(connection);
        }
        return bl;
    }

    void collectPropertyDescriptions() {
        String string;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block17: {
            connection = this._connectionAgent.getConnection();
            this._supportsNumericAndCumulative = false;
            try {
                int n;
                preparedStatement = connection.prepareCall("SELECT property( 'ProductVersion' )");
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next() || (string = resultSet.getString(1)) == null || (n = string.indexOf(46)) <= 0) break block17;
                try {
                    int n2 = Integer.parseInt(string.substring(0, n));
                    if (n2 > 9) {
                        this._supportsNumericAndCumulative = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            catch (SQLException sQLException) {
                this._connectionAgent.freeConnection(connection);
                this.fireDatabaseError(this, sQLException);
                return;
            }
        }
        if (this._supportsNumericAndCumulative) {
            try {
                preparedStatement = connection.prepareStatement("select property_name( row_num ) as prop, property_description( row_num ), property_is_numeric( row_num ), property_is_cumulative( row_num )  from  sa_rowgenerator(0,500)  where connection_property( prop ) is not null  order by prop ");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    String string2;
                    string = resultSet.getString(1);
                    String string3 = resultSet.getString(2);
                    Boolean bl = resultSet.getInt(3) == 1;
                    Boolean bl2 = resultSet.getInt(4) == 1;
                    if (bl2.booleanValue()) {
                        string2 = string.toLowerCase() + PER_SECOND;
                        this._propertyDescriptions.put(string2, string3 + PER_SECOND);
                        this._propertyIsNumeric.put(string2, bl);
                        this._propertyIsCumulative.put(string2, bl2);
                        String string4 = string.toLowerCase() + TOTAL;
                        this._propertyDescriptions.put(string4, string3 + TOTAL);
                        this._propertyIsNumeric.put(string4, bl);
                        this._propertyIsCumulative.put(string4, Boolean.FALSE);
                        continue;
                    }
                    string2 = string.toLowerCase();
                    this._propertyDescriptions.put(string2, string3);
                    this._propertyIsNumeric.put(string2, bl);
                    this._propertyIsCumulative.put(string2, Boolean.FALSE);
                }
                preparedStatement.close();
                string = "DBName";
                String string5 = DBConnectionViewer.getI18NMessage(DATABASE_NAME);
                if (string5 == null || string5.trim().length() == 0) {
                    string5 = string;
                }
                this._propertyDescriptions.put("dbname", string5);
                this._propertyIsNumeric.put("dbname", Boolean.FALSE);
                this._propertyIsCumulative.put("dbname", Boolean.FALSE);
            }
            catch (SQLException sQLException) {
                this._connectionAgent.freeConnection(connection);
                this._supportsNumericAndCumulative = false;
            }
        } else {
            try {
                preparedStatement = connection.prepareStatement("select property_name( i ) as prop, property_description( i ) from ( select row_num from dbo.RowGenerator union all select row_num +255 from dbo.RowGenerator ) as r( i ) where connection_property( prop ) is not null       and not exists (select * from SYS.SYSOPTION where \"option\"=prop and user_id=2) order by prop");
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string = resultSet.getString(1);
                    String string6 = resultSet.getString(2);
                    if (string6 == null || string6.trim().length() == 0) {
                        string6 = string;
                    }
                    String string7 = string.toLowerCase();
                    this._propertyDescriptions.put(string7, string6);
                    this._propertyIsNumeric.put(string7, Boolean.FALSE);
                    this._propertyIsCumulative.put(string7, Boolean.FALSE);
                }
                preparedStatement.close();
                string = "DBName";
                String string8 = DBConnectionViewer.getI18NMessage(DATABASE_NAME);
                if (string8 == null || string8.trim().length() == 0) {
                    string8 = string;
                }
                this._propertyDescriptions.put("dbname", string8);
                this._propertyIsNumeric.put("dbname", Boolean.FALSE);
                this._propertyIsCumulative.put("dbname", Boolean.FALSE);
            }
            catch (SQLException sQLException) {
                this._connectionAgent.freeConnection(connection);
                this.fireDatabaseError(this, sQLException);
            }
        }
        this._connectionAgent.freeConnection(connection);
    }

    public DBConnectionAgent getConnectionAgent() {
        return this._connectionAgent;
    }

    public void setRefreshRate(int n) {
        this._refreshRate = n;
        this._timer.stop();
        if (this._refreshRate > 0) {
            this._timer.setDelay(this._refreshRate);
            this._timer.start();
        }
    }

    public int getRefreshRate() {
        return this._refreshRate;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._connections) {
            int n = this._connections.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                this._selRow = n;
                this._disconnectSelectedConnectionAction.setEnabled(this._hasDbaAuthority);
                if (mouseEvent.isPopupTrigger()) {
                    this._popupMenu.show(this._connections, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        } else if (object == this._connectionsScrollPane) {
            this._disconnectSelectedConnectionAction.setEnabled(false);
            if (mouseEvent.isPopupTrigger()) {
                this._popupMenu.show(this._connectionsScrollPane, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (object == this._connections.getTableHeader()) {
            this._headerBeingMoved = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object == this._connections) {
            int n = this._connections.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                this._selRow = n;
                this._disconnectSelectedConnectionAction.setEnabled(this._hasDbaAuthority);
            } else {
                this._disconnectSelectedConnectionAction.setEnabled(false);
            }
            if (mouseEvent.isPopupTrigger()) {
                this._popupMenu.show(this._connections, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (object == this._connectionsScrollPane) {
            this._disconnectSelectedConnectionAction.setEnabled(false);
            if (mouseEvent.isPopupTrigger()) {
                this._popupMenu.show(this._connectionsScrollPane, mouseEvent.getX(), mouseEvent.getY());
            }
        } else if (object == this._connections.getTableHeader()) {
            this._headerBeingMoved = false;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this._headerBeingMoved = true;
    }

    void disconnectSelectedConnectionActionPerformed() {
        DisconnectSelectedConnectionWorker disconnectSelectedConnectionWorker = new DisconnectSelectedConnectionWorker();
        disconnectSelectedConnectionWorker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnectSelectedConnection() {
        if (this._selRow != -1) {
            Connection connection = this._connectionAgent.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement("DROP CONNECTION " + this._connectionIDs.get(this._selRow));
                preparedStatement.execute();
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                this._connectionAgent.freeConnection(connection);
                this.fireDatabaseError(this, sQLException);
            }
            finally {
                this._connectionAgent.freeConnection(connection);
            }
        }
    }

    void customizeActionPerformed() {
        CustomizeDialog customizeDialog = this.getCustomizeDialog(SwingUtilities.windowForComponent(this));
        customizeDialog.selectComponent((Customizable)this);
        UIUtils.ensureWindowIsVisible((Window)customizeDialog);
        customizeDialog.setVisible(true);
    }

    public void refresh() {
        if (this._connectionAgent == null) {
            return;
        }
        if (this._timer != null && !this._timer.isRunning()) {
            this._timer.restart();
        }
        this.refreshConnections();
    }

    public void stopRefreshing() {
        this._timer.stop();
        if (this._refreshWorker != null) {
            this._refreshWorker.interrupt();
        }
    }

    void clearDisplay() {
        this._connectionsTableColumnNames = new ArrayList();
        this._connectionsTableColumnIsNumeric = new ArrayList();
        this._connectionsTableColumnIsCumulative = new ArrayList();
        this._cumulativeCache = new HashMap();
        this._connectionIDs = new ArrayList();
        this._propertyDescriptions = new HashMap();
        this._columnWidths = new Hashtable();
        this._connectionPropertyHashCode = -1;
        ((ViewerTableModel)this._connections.getModel()).setDataArrayList(new ArrayList<ArrayList<Object>>(), this._connectionsTableColumnNames);
        this._connections.updateUI();
    }

    void checkPropertyList() {
        if (this._propertyList == null) {
            return;
        }
        int n = this._propertyList.hashCode();
        if (n != this._connectionPropertyHashCode) {
            this._connectionPropertyHashCode = n;
            this._propertiesSelect = null;
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    DBConnectionViewer.this.validateColumnListAndBuildQuery();
                    return null;
                }
            };
            swingWorker.start();
        }
    }

    void validateColumnListAndBuildQuery() {
        CharSequence charSequence;
        for (int i = this._propertyList.size() - 1; i > -1; --i) {
            charSequence = this._propertyList.get(i);
            if (((String)charSequence).equals("dbname") || ((String)charSequence).endsWith(PER_SECOND) || ((String)charSequence).endsWith(TOTAL) || this._propertyDescriptions.get(charSequence) != null) continue;
            this._propertyList.remove(i);
        }
        this._connectionsTableColumnNames = new ArrayList(this._propertyList.size());
        this._connectionsTableColumnIsNumeric = new ArrayList(this._propertyList.size());
        this._connectionsTableColumnIsCumulative = new ArrayList(this._propertyList.size());
        StringBuffer stringBuffer = new StringBuffer(1000).append("begin\ndeclare curr_cid int;\ndeclare cid int;\ndeclare local temporary table t_conn_dbconsole(\n_Userid varchar(255),\n_Name varchar(255) null");
        charSequence = new StringBuffer(1000);
        int n = this._propertyList.size();
        for (int i = 0; i < n; ++i) {
            String string = this._propertyList.get(i);
            stringBuffer.append(",\n\"").append(string).append("\" varchar(255) null");
            if (string.equals("dbname")) {
                ((StringBuffer)charSequence).append(",\nDB_NAME( connection_property( 'DBNumber', cid ) )");
            } else if (string.endsWith(PER_SECOND)) {
                ((StringBuffer)charSequence).append(",\nconnection_property( '").append(string.substring(0, string.indexOf(PER_SECOND))).append("', cid )");
            } else if (string.endsWith(TOTAL)) {
                ((StringBuffer)charSequence).append(",\nconnection_property( '").append(string.substring(0, string.indexOf(TOTAL))).append("', cid )");
            } else {
                ((StringBuffer)charSequence).append(",\nconnection_property( '").append(string).append("', cid )");
            }
            String string2 = this._propertyDescriptions.get(this._propertyList.get(i).toLowerCase());
            if (string2 == null) {
                string2 = this._propertyList.get(i);
            }
            this._connectionsTableColumnNames.add(string2);
            if (!this._supportsNumericAndCumulative) continue;
            this._connectionsTableColumnIsNumeric.add(this._propertyIsNumeric.get(this._propertyList.get(i)));
            this._connectionsTableColumnIsCumulative.add(this._propertyIsCumulative.get(this._propertyList.get(i)));
        }
        stringBuffer.append(") in SYSTEM not transactional;\nset curr_cid = connection_property( 'number' );\nset cid = next_connection( NULL, NULL );\nloop_label:\nloop\nif cid is NULL then\nleave loop_label\nend if;\nif cid <> curr_cid then\ninsert into t_conn_dbconsole values (\ncid,\nconnection_property( 'Userid', cid )");
        stringBuffer.append((StringBuffer)charSequence).append(");\nend if;\nset cid = next_connection( cid, NULL );\nend loop loop_label;\nselect * from t_conn_dbconsole;\nend\n");
        this._propertiesSelect = stringBuffer.toString();
    }

    private void refreshConnections() {
        if (this._headerBeingMoved) {
            return;
        }
        this.checkPropertyList();
        if (this._propertiesSelect != null && !this._workerBusy) {
            this._workerBusy = true;
            this._refreshWorker = new RefreshWorker();
            this._refreshWorker.start();
        }
    }

    void updateDisplay(PropertySet propertySet) {
        if (!propertySet.success) {
            this.stopRefreshing();
            return;
        }
        if (this._headerBeingMoved) {
            return;
        }
        this.setCursor(WAIT_CURSOR);
        this._connectionIDs = propertySet.connectionIDs;
        int n = this._connections.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this._connections.getColumnModel().getColumn(i).removePropertyChangeListener(this);
        }
        int n2 = this._connections.getSelectedRow();
        List<RowSorter.SortKey> list = this._connections.getRowSorter().getSortKeys();
        ViewerTableModel viewerTableModel = (ViewerTableModel)this._connections.getModel();
        viewerTableModel.setDataArrayList(propertySet.data, this._connectionsTableColumnNames);
        viewerTableModel.setColumnClasses(propertySet.columnClasses);
        if (n2 > -1) {
            try {
                this._connections.setRowSelectionInterval(n2, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this._connections.getRowSorter().setSortKeys(list);
        TableColumnModel tableColumnModel = this._connections.getColumnModel();
        n = Math.min(this._connections.getRowCount(), 10);
        int n3 = this._connections.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Object object = this._columnWidths.get(this._connections.getColumnName(i));
            int n4 = object != null ? (Integer)object : this._fontMetrics.stringWidth(this._connections.getColumnName(i)) + this._arrowWidth + 15;
            for (int j = 0; j < n; ++j) {
                String string;
                int n5;
                Object object2 = this._connections.getValueAt(j, i);
                if (object2 == null || (n5 = this._fontMetrics.stringWidth(string = object2.toString()) + 4) <= n4) continue;
                n4 = n5;
            }
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setPreferredWidth(n4);
            tableColumn.setCellRenderer(new FastCellRenderer());
            tableColumn.addPropertyChangeListener(this);
        }
        this.setCursor(DEFAULT_CURSOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertySet getProperties() {
        long l = System.currentTimeMillis();
        double d = 1.0E-4 + (double)(l - this._lastCachedTime) / 1000.0;
        this._lastCachedTime = l;
        PropertySet propertySet = new PropertySet();
        propertySet.success = true;
        propertySet.data = new ArrayList();
        Connection connection = this._connectionAgent.getConnection();
        try {
            propertySet.connectionIDs = new ArrayList(this._connectionIDs.size());
            propertySet.columnClasses = new Class[this._propertyList.size()];
            Statement statement = connection.createStatement(1003, 1007);
            ResultSet resultSet = statement.executeQuery(this._propertiesSelect);
            while (resultSet.next()) {
                String string = resultSet.getString(1);
                String string2 = resultSet.getString(2);
                if (string2 == null || string2.trim().length() <= 0) continue;
                ArrayList<Object> arrayList = new ArrayList<Object>(this._propertyList.size());
                int n = this._connectionsTableColumnNames.size() + 1;
                for (int i = 1; i < n; ++i) {
                    String string3 = resultSet.getString(i + 2);
                    String string4 = this._propertyList.get(i - 1);
                    if (string3 == null) {
                        arrayList.add(string3);
                        continue;
                    }
                    if (this._supportsNumericAndCumulative) {
                        if (this._propertyIsNumeric.get(string4).booleanValue()) {
                            Serializable serializable;
                            Serializable serializable2;
                            Number number;
                            try {
                                Long l2 = new Long(string3);
                                if (this._propertyIsCumulative.get(string4).booleanValue()) {
                                    number = 0L;
                                    serializable2 = this._cumulativeCache.get(string);
                                    if (serializable2 != null) {
                                        serializable = (Number)((HashMap)serializable2).get(string4);
                                        if (serializable != null) {
                                            number = ((Number)serializable).longValue();
                                        }
                                    } else {
                                        this._cumulativeCache.put(string, new HashMap());
                                        number = l2;
                                    }
                                    this._cumulativeCache.get(string).put(string4, l2);
                                    serializable = Double.valueOf((double)(l2 - (Long)number) / d);
                                    arrayList.add(serializable);
                                } else {
                                    arrayList.add(l2);
                                }
                                propertySet.columnClasses[i - 1] = Number.class;
                            }
                            catch (NumberFormatException numberFormatException) {
                                try {
                                    number = new Double(string3);
                                    if (this._propertyIsCumulative.get(string4).booleanValue()) {
                                        Number number2;
                                        serializable2 = Double.valueOf(0.0);
                                        serializable = this._cumulativeCache.get(string);
                                        if (serializable != null) {
                                            number2 = ((HashMap)serializable).get(string4);
                                            if (number2 != null) {
                                                serializable2 = Double.valueOf(number2.doubleValue());
                                            }
                                        } else {
                                            this._cumulativeCache.put(string, new HashMap());
                                            serializable2 = number;
                                        }
                                        this._cumulativeCache.get(string).put(string4, number);
                                        number2 = ((Double)number - (Double)serializable2) / d;
                                        arrayList.add(number2);
                                    } else {
                                        arrayList.add(number);
                                    }
                                    propertySet.columnClasses[i - 1] = Number.class;
                                }
                                catch (NumberFormatException numberFormatException2) {
                                    arrayList.add(string3);
                                    propertySet.columnClasses[i - 1] = String.class;
                                }
                            }
                            continue;
                        }
                        arrayList.add(string3);
                        propertySet.columnClasses[i - 1] = String.class;
                        continue;
                    }
                    try {
                        arrayList.add(new Long(string3));
                        propertySet.columnClasses[i - 1] = Number.class;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        try {
                            arrayList.add(new Double(string3));
                            propertySet.columnClasses[i - 1] = Number.class;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException3) {
                            arrayList.add(string3);
                            propertySet.columnClasses[i - 1] = String.class;
                        }
                    }
                }
                propertySet.data.add(arrayList);
                propertySet.connectionIDs.add(string);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            this._connectionAgent.freeConnection(connection);
            this.fireDatabaseError(this, sQLException);
            propertySet.success = false;
        }
        finally {
            this._connectionAgent.freeConnection(connection);
        }
        return propertySet;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("width") && propertyChangeEvent.getSource() instanceof TableColumn) {
            this._columnWidths.put(((TableColumn)propertyChangeEvent.getSource()).getHeaderValue(), propertyChangeEvent.getNewValue());
        }
    }

    public void addDatabaseErrorListener(DatabaseErrorListener databaseErrorListener) {
        this._listenerList.add(DatabaseErrorListener.class, databaseErrorListener);
    }

    public void removeDatabaseErrorListener(DatabaseErrorListener databaseErrorListener) {
        this._listenerList.remove(DatabaseErrorListener.class, databaseErrorListener);
    }

    protected void fireDatabaseError(Object object, Exception exception) {
        if (this._timer != null && !this._timer.isRunning()) {
            Object[] objectArray = this._listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DatabaseErrorListener.class) continue;
                ((DatabaseErrorListener)objectArray[i + 1]).databaseError(new DatabaseErrorEvent(object, exception));
            }
        }
    }

    private static ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.asa.connectionViewer.DBConnectionViewerResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.asa.connectionViewer.DBConnectionViewerResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.asa.connectionViewer.DBConnectionViewerResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name com.sybase.asa.connectionViewer.DBConnectionViewerResourceBundle", "", "");
        }
        return resourceBundle;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)DBConnectionViewer.getResourceBundle().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public CustomizationPage[] getCustomizationPages() {
        return new CustomizationPage[]{new DBConnectionViewerCustomizationPage(this)};
    }

    public Icon getCustomizationGroupIcon() {
        return ASAComponentsImageLoader.getImageIcon("connection_viewer", 1001);
    }

    public String getCustomizationGroupTitle() {
        return DBConnectionViewer.getI18NMessage(CONNECTION_VIEWER);
    }

    public void acceptChanges() {
        DBConnectionViewerProperties.store();
        this._propertyList = DBConnectionViewerProperties.getConnectionPropertyList();
        this.refreshConnections();
    }

    public void rejectChanges() {
    }

    public CustomizerHost getCustomizerHost() {
        return this._customizerHost;
    }

    public void setCustomizerHost(CustomizerHost customizerHost) {
        this._customizerHost = customizerHost;
    }

    CustomizeDialog getCustomizeDialog(Window window) {
        if (this.getCustomizerHost() != null) {
            return this.getCustomizerHost().getCustomizeDialog(window);
        }
        if (this._customizeDialog == null) {
            this._customizeDialog = window instanceof Dialog ? new CustomizeDialog((Dialog)window) : new CustomizeDialog((Frame)window);
            this._customizeDialog.addCustomizationPages((Customizable)this);
        }
        return this._customizeDialog;
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        int n;
        int n2 = tableColumnModelEvent.getFromIndex();
        if (n2 != (n = tableColumnModelEvent.getToIndex())) {
            DBConnectionViewerProperties.moveConnectionProperty(n2, n);
            DBConnectionViewerProperties.store();
            this._propertyList = DBConnectionViewerProperties.getConnectionPropertyList();
        }
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void destroy() {
        if (this._timer != null) {
            this._timer.stop();
        }
        this._connectionsScrollPane.removeMouseListener(this);
        this._connections.removeMouseListener(this);
        this._connections.getTableHeader().removeMouseListener(this);
        this._connections.getTableHeader().removeMouseMotionListener(this);
        this._connections.getColumnModel().removeColumnModelListener(this);
        if (this._customizeDialog != null) {
            this._customizeDialog.destroy();
            this._customizeDialog = null;
        }
    }

    public static void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpPrefix = string2;
        _helpSuffix = string3;
    }

    private class RefreshWorker
    extends SwingWorker {
        private RefreshWorker() {
        }

        public Object construct() {
            return DBConnectionViewer.this.getProperties();
        }

        public void finished() {
            DBConnectionViewer.this._workerBusy = false;
            DBConnectionViewer.this.updateDisplay((PropertySet)this.getValue());
        }
    }

    private class DisconnectSelectedConnectionWorker
    extends SwingWorker {
        private DisconnectSelectedConnectionWorker() {
        }

        public Object construct() {
            DBConnectionViewer.this.disconnectSelectedConnection();
            return null;
        }

        public void finished() {
            DBConnectionViewer.this.refresh();
        }
    }

    static class PropertySet {
        boolean success = false;
        ArrayList<ArrayList<Object>> data = null;
        ArrayList<String> connectionIDs = null;
        Class[] columnClasses = null;

        PropertySet() {
        }
    }

    class ConnectionWorker
    extends SwingWorker {
        ConnectionWorker(DBConnectionAgent dBConnectionAgent) {
            DBConnectionViewer.this._connectionAgent = dBConnectionAgent;
        }

        public Object construct() {
            DBConnectionViewer.this.setConnectionAgent(DBConnectionViewer.this._connectionAgent);
            return null;
        }
    }

    static class ConnectionsTable
    extends JTable {
        ConnectionsTable() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            try {
                super.paintComponent(graphics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

